<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<jsp:scriptlet>
	request.setCharacterEncoding("UTF-8"); 
</jsp:scriptlet>
<jsp:directive.include file="sqlValues.jsp" />
<!-- イベント処理用のJSP内では、以下のパラメーターを使用することができます -->
<!-- *************************************************************************
	 * {@EC_CNAME}		子カラム名(一覧表示の場合でも行番号__nは付加されません)
	 * {@EC_RENDERER}	子カラムのレンデラー
	 * {@EC_EDITOR}		子カラムのエディター
	 * {@EC_SQL}		子カラムのプルダウン、または値を出力するためのSQL文({@xxx}をカラムのvalue値で置き換えたもの)
	 * {@EC_WRITABLE}	子カラムが編集可能などうか
	 * {@EC_CVALUE}		子カラムの現在の値
	 * {@EC_NOVALUE}	子カラムの最上部Option値が空ならtrue。その他false(addNoValue属性値と同じです) 
	 * {@EC_CLASS}		子カラムのCLASS属性
	 * {@EC_SIZE}		子カラムのSIZE属性
	 * {@EC_MAXLENGTH}	子カラムのMAXLENGTH属性
	 * {@EC_OPTATTRS}	子カラムのその他OPTION属性
	 * {@EC_PNAMEE}		親カラム名(一覧表示の場合でも行番号__nは付加されません)
	 * {@EC_PVALUE}		親カラムの現在の値
	 * ※なお、現時点ではINMENU,INDBMENUについては使用できません
	 ************************************************************************* -->
<!-- ここから -->
	<og:select name="{@EC_CNAME}" multiple="ALL" td="false" clazz="{@EC_CLASS}">
		<og:queryOption quotCheck="false">
			<!-- PostgreSQL 版 -->
			<og:equals val1="{@DBF.TYPE}" val2="POSTGRES" ignoreCase="true">
				select	COLUMN_NAME
				from	INFORMATION_SCHEMA.COLUMNS
				where	TABLE_NAME		= '{@EC_PVALUE}'
				and		TABLE_SCHEMA	= 'public'
				and		data_type		in ('smallint','integer','bigint','decimal','numeric','real','double precision','serial','bigserial')
				order by ORDINAL_POSITION
			</og:equals>
			<!-- ORACLE 版 -->
			<og:equals val1="{@DBF.TYPE}" val2="ORACLE" ignoreCase="true">
				select	COLUMN_NAME
				from	USER_TAB_COLUMNS A
				where	A.TABLE_NAME	= '{@EC_PVALUE}'
				and		A.DATA_TYPE		in ('NUMBER','BINARY_FLOAT','BINARY_DOUBLE')
				order by COLUMN_ID
			</og:equals>
			<!-- FIREBIRD版 -->
			<og:equals val1="{@DBF.TYPE}" val2="FIREBIRD" ignoreCase="true">
				select	trim(A.RDB$FIELD_NAME)
				from	RDB$RELATION_FIELDS A
				inner join RDB$FIELDS B
				on		B.RDB$FIELD_NAME	= A.RDB$FIELD_SOURCE
				inner join RDB$TYPES C
				on		C.RDB$TYPE			= B.RDB$FIELD_TYPE
				AND		C.RDB$FIELD_NAME	= 'RDB$FIELD_TYPE'
				AND		C.RDB$TYPE_NAME		in ('INT64','DOUBLE','FLOAT','SHORT','LONG')
				where	A.RDB$SYSTEM_FLAG	= 0
				and		A.RDB$RELATION_NAME	= '{@EC_PVALUE}'
				order by A.RDB$FIELD_POSITION
			</og:equals>
			<!-- SQLServer版 -->
			<og:equals val1="{@DBF.TYPE}" val2="SQLSERVER" ignoreCase="true">
				select		B.NAME	as COLUMN_NAME
				from		SYS.TABLES A
				inner join	SYS.COLUMNS B
				on			A.OBJECT_ID	= B.OBJECT_ID
				inner join	SYS.TYPES C
				on			B.SYSTEM_TYPE_ID	= C.SYSTEM_TYPE_ID
				and			B.USER_TYPE_ID		= C.USER_TYPE_ID
				where		A.NAME		= '{@EC_PVALUE}'
				and			C.NAME		in ('int','decimal','money','float')
				order by B.NAME,B.COLUMN_ID
			</og:equals>
		</og:queryOption>
	</og:select>
</jsp:root>