package org.opengion.hayabusa.io;

import org.opengion.hayabusa.common.HybsSystem;

/**
 * JsChartData は、JsChartData の個別属性を管理しているデータ管理クラスです。
 * 
 * @version	5.9.17.2		2017/02/08
 * @author	T.OTA
 * @sinse	JDK7.0
 *
 */
public class JsChartData {
	private String	chartColumn			= null; // ﾁｬｰﾄｶﾗﾑ
	private String	label				= null; // ﾗﾍﾞﾙ
	private String	fill				= null; // ﾌｨﾙ
	private String	tension				= null; // 伸張
	private String	borderColor			= null; // 線の色
	private String	borderWidth			= null; // 線の幅
	private String	backgroundColor		= null; // 背景色
	private String	optionAttributes	= null; // オプション

	/**
	 * チャートカラムを設定します。
	 * 
	 * @param chartColumn チャートカラム
	 */
	public void setChartColumn( String chartColumn ) {
		this.chartColumn = chartColumn;
	}

	/**
	 * JsChartData オブジェクトを作成する時のチャートカラムを取得します。
	 * 
	 * @return チャートカラム
	 */
	public String getChartColumn() {
		return chartColumn;
	}

	/**
	 * ラベルを設定します。
	 * 
	 * @param label ラベル
	 */
	public void setLabel( String label ) {
		this.label = label;
	}

	/**
	 * ラベルを取得します。
	 * 
	 * @return ラベル
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * フィル を設定します。
	 * @param fill
	 */
	public void setFill( String fill ) {
		this.fill = fill;
	}

	/**
	 * 線の伸張 を設定します。
	 * 
	 * @param tension
	 */
	public void setTension( String tension ) {
		this.tension = tension;
	}

	/**
	 * 線の色 を設定します。
	 * 
	 * @param borderColor
	 */
	public void setBorderColor( String borderColor ) {
		this.borderColor = borderColor;
	}

	/**
	 * 線の幅 を設定します。
	 * 
	 * @param borderWidth
	 */
	public void setBorderWidth( String borderWidth ) {
		this.borderWidth = borderWidth;
	}

	/**
	 * 背景色 を設定します。
	 * 
	 * @param backgroundColor
	 */
	public void setBackgroundColor( String backgroundColor ) {
		this.backgroundColor = backgroundColor;
	}

	/**
	 * オプション情報 を設定します。
	 * 
	 * @param optionAttributes オプション情報
	 */
	public void setOptionAttributes( String optionAttributes ) {
		this.optionAttributes = optionAttributes;
	}

	/**
	 * JsChartData オブジェクトを作成する時のオプション情報を取得します。
	 * 
	 * @return オプション情報
	 */
	public String getOptionAttributes() {
		return optionAttributes;
	}

	/**
	 * JsChartData オブジェクトを作成するときのパラメータ情報を取得します。
	 * chartColumnとoptionAttributesを使用して、
	 * パラメータ情報を作成します。 
	 * 
	 * @return ﾊﾟﾗﾒｰﾀ文字列
	 */
	public String getParameter() {
		StringBuilder rtn = new StringBuilder( HybsSystem.BUFFER_SMALL );
		rtn.append( "{" );
		if( label != null && label.length() > 0 ) {
			rtn.append( "label:'" ).append( label ).append( "'," );
		}
		rtn.append( "data:" ).append( chartColumn );
		setProp( rtn, ",fill:", fill );
		setProp( rtn, ",tension:", tension );
		setProp( rtn, ",borderColor:", setParaOrArray( borderColor ) );
		setProp( rtn, ",borderWidth:", borderWidth );
		setProp( rtn, ",backgroundColor:", setParaOrArray( backgroundColor ) );
		setProp( rtn, ",", optionAttributes );
		rtn.append( "}" );

		return rtn.toString();
	}

	/**
	 * 配列が指定される事がある場合の、値設定
	 * 
	 * @param str
	 * @return ﾊﾟﾗﾒｰﾀ文字
	 */
	private String setParaOrArray( String str ) {
		StringBuilder sb = new StringBuilder( HybsSystem.BUFFER_MIDDLE );

		// 引数が配列形式の記載であるかを判定。(頭文字が「[」であるかどうか)
		if( str != null && str.length() > 0 && !"[".equals( str.substring( 0, 1 ) )) {
			// 配列でない場合は、ｼﾝｸﾞﾙｸｫﾃｰｼｮﾝを付与
			sb.append( "'" ).append( str ).append( "'" );
		}else{
			// 配列の場合はそのまま
			sb.append( str );
		}

		return sb.toString();
	}

	/**
	 * ﾌﾟﾛﾊﾟﾃｨ設定用ﾒｿｯﾄﾞ
	 * 
	 * setに値が存在する場合,
	 * sbにstr + setの形で値を追加する。
	 * 
	 * @param sb
	 * @param str
	 * @param set
	 */
	private void setProp( StringBuilder sb, String str, String set ) {
		if( set != null && set.length() > 0 ) {
			sb.append( str ).append( set );
		}
	}
}
