/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

/**
 * NOTAG レンデラーは、LABEL レンデラーの値からタグ情報のみ削除するレンデラーです。
 * ファイル出力対象で、データそのものにタグ情報を埋め込んでいる場合は、このレンデラーが使えます。
 * 処理は、&lt;xxxx ･･･&gt;YYYY&lt;/xxxx&gt;形式の場合、YYYY のみ出力します。
 * &lt;xxxx/&gt; の様な、BODY要素を持たない場合は、ゼロ文字列になります。
 * 
 * Ver6からの逆移植です。
 *
 * このクラスは、不変オブジェクトとして、共有されます。
 *
 * @og.group データ表示
 * 
 * @og.rev 5.10.4.1 (2018/10/12) 新規追加
 *
 * @version  5.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Renderer_NOTAG extends AbstractRenderer {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.10.4.1 (2018/10/12)" ;

	private static final CellRenderer DB_CELL = new Renderer_NOTAG() ;

	/**
	 * デフォルトコンストラクター
	 *
	 */
	public Renderer_NOTAG() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * 
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellRendererオブジェクト
	 * @og.rtnNotNull
	 */
	public CellRenderer newInstance( final DBColumn clm ) {
		return DB_CELL;
	}

	/**
	 * データ出力用の文字列を作成します。
	 * ファイル等に出力する形式を想定しますので、HTMLタグを含まない
	 * データを返します。
	 * 基本は、#getValue( String ) をそのまま返します。
	 *
	 *
	 * @param   value 入力値
	 *
	 * @return  データ出力用の文字列
	 * @og.rtnNotNull
	 * @see		#getValue( String )
	 */
	@Override
	public String getValue( final String value ) {
		return StringUtil.tagCut( ( value == null ) ? "" : value );
	}
}
