/* version: 0.0.1 
 * author : Sen Li
 * date   : 2012/05/10
 *
 * 5.6.2.1 (2013/03/08) firefox対応。(独自タグ.xxxのgetAttribute化、innerTextのjQuery利用、insertRowの引数追加、widthに"px"追加)
 *
 */

// メイン処理（画面から呼び出す）
function adjustField(){
	var cols 		= 1 ;
	var colsWidth;
	var cellHeight	= 20 ;
	var tables		= 1 ;
	var tableMargin	= 5 ;
	var tableBorder	= 5 ;
	var useTitle	= "false";

	// viewTableのオブジェクトの取得
	var objViewTable = document.getElementById( "viewTable" );
	// viewTableが存在しなければ終了
	if( objViewTable == null ){ return false; } 
	//
	var parentNode	 = objViewTable.parentNode;					// viewTableの親ノード
	var viewRowCount = objViewTable.rows.length;				// viewTableの行数
	var viewColCount = objViewTable.rows[0].cells.length;		// viewTableの列数
	var titles		 = new Array( viewColCount );

	// iFieldオブジェクト取得
	var objField = document.getElementsByTagName( "iField" );
	// iFieldが存在しなければ終了
	if( objField == null || objField.length == 0 ){ return false; }

	// 分割後、行毎のセル数【必須】
	if( objField[0].getAttribute('cols') == null ){ return false; }
    cols 		= parseInt( objField[0].getAttribute('cols') , 10);

	// セル幅
	if( objField[0].getAttribute('colsWidth') != null ){ 
	    colsWidth	= objField[0].getAttribute('colsWidth').split(",");
		//
		if( colsWidth.length != cols ){ 
			alert("colsWidthの設定値の数はcolsと一致しません。"); 
			return false; 
		}
	}
	// セル高さ
	if( objField[0].getAttribute('cellHeight') != null ){ 
	    cellHeight	= parseInt( objField[0].getAttribute('cellHeight') ,10 );
	}

	// 横一行に並ぶテーブルの数
	if( objField[0].getAttribute('tables') != null ){ 
	    tables		= parseInt( objField[0].getAttribute('tables') ,10 );
	}
	// テーブル周りの空スペース
	if( objField[0].getAttribute('tableMargin') != null ){ 
	    tableMargin	= parseInt( objField[0].getAttribute('tableMargin') ,10 );
	}
	// テーブル周りの空スペース
	if( objField[0].getAttribute('tableBorder') != null ){ 
	    tableBorder	= parseInt( objField[0].getAttribute('tableBorder') , 10 );
	}
	// 各カラムのタイトルを出力する(true)／出力しない(false)
	if( objField[0].getAttribute('useTitle') != null ){ 
	    useTitle	= objField[0].getAttribute('useTitle');
	}
	// タイトルの取得
	if( useTitle == "true" ){
		for( i = 0 ;i < viewColCount ;i++){
			titles[i] = $(objViewTable.rows[0].cells[i]).text();
		}
	}
	// viewTableよりデータノードを作成する。
	var pageTable = document.createElement( "table" );
	var rowWidth  	= 0;
	var maxRowWidth = 0;

	pageTable.cellPadding = tableMargin;
	parentNode.insertBefore( pageTable, objViewTable )
	pageTable.style.width = "10000px";

	//
	var rowCount = 0; // 5.6.2.1 (2013/03/08)
	for( i = 1; i < viewRowCount; i++ ){
		if((i-1) % tables == 0 ){
			pageTr  = pageTable.insertRow(rowCount);							// 行要素作成
			rowCount++;
		}
		pageTd 			 = pageTr.insertCell((i-1) % tables);					// 新規セル作成
		pageTd.align="left";
		pageTd.vAlign="top";
		//
		
		var lineTable = document.createElement( "table" );
		lineTable.border = tableBorder;
		lineTable.cellSpacing = "0";
		lineTable.style.emptycells = "show";
		pageTd.appendChild( lineTable );
		//
		var indexDada 	 = 0;
		var rowCount2 = 0; // 5.6.2.1 (2013/03/05)
		for( j = 0; j < viewColCount; j ++ ){
			var lineTr;
			if( j % cols == 0 ){
				lineTr  		 = lineTable.insertRow(rowCount2);				// 行要素作成
				rowCount2++;
				lineTr.className = objViewTable.rows[i].className;		//
				if( i == 1 ){
					maxRowWidth = maxRowWidth < rowWidth ? rowWidth : maxRowWidth;
					rowWidth = 0;
				}
			}
			//
			var oriCell    = objViewTable.rows[i].cells[j];
			var childNodes = oriCell.childNodes;
			var titleTd = null;
			if( useTitle == "true" ){
				titleTd		= lineTr.insertCell(2*(j % cols));					// 新規セル作成
				$(titleTd).text(titles[j] + ":");
				titleTd.className = "label";
				if( i == 1 ){ rowWidth += titleTd.offsetWidth; }
				lineTd			= lineTr.insertCell(2*(j % cols)+1);
			}
			else{
				lineTd			= lineTr.insertCell(j % cols);					// 新規セル作成
			}
			
			if( colsWidth != null ){
				lineTd.style.width  = colsWidth[j % cols];				// セル幅
			}
			lineTd.style.height = cellHeight + "px";
			lineTd.className 	= oriCell.className;
			if( childNodes.length == 0 ) $(lineTd).text(" ");
			while( childNodes.length > 0 ){
				lineTd.appendChild( childNodes[0] );
			}
			if( i == 1 ){ rowWidth += lineTd.offsetWidth; }
		}
		//
		maxRowWidth = maxRowWidth < rowWidth ? rowWidth : maxRowWidth;
	}
	var rowTables = ( viewRowCount - 1 ) > tables ? tables : ( viewRowCount - 1 );
	pageTable.style.width = (maxRowWidth * rowTables + tables * tableMargin * 2) + "px";
	parentNode.removeChild( objViewTable );								// viewTableの削除
};
