/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.taglet2;

import com.sun.source.doctree.DocTree;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;

public final class DocTreeWriter
implements AutoCloseable {
    private static final String OG_VALUE = "{@og.value";
    private static final String OG_DOCLNK = "{@og.doc03Link";
    private static final String TAG_LNK = "{@link";
    private static final String CLS = "org.opengion.fukurou.system.BuildNumber";
    private static final String FLD = "VERSION_NO";
    private static final String VERSION_NO = DocTreeWriter.getStaticField("org.opengion.fukurou.system.BuildNumber", "VERSION_NO");
    private String clsName;
    private final PrintWriter outFile;

    public DocTreeWriter(String string, String string2) throws IOException {
        this.outFile = FileUtil.getPrintWriter(new File(string), string2);
    }

    @Override
    public void close() {
        if (this.outFile != null) {
            this.outFile.close();
        }
    }

    public void setClassName(String string) {
        this.clsName = string;
    }

    public void printTag(String ... stringArray) {
        if (stringArray.length == 3) {
            StringBuilder stringBuilder = new StringBuilder(stringArray[1]);
            this.valueTag(stringBuilder);
            this.doc03LinkTag(stringBuilder);
            this.linkTag(stringBuilder);
            this.outFile.print(stringArray[0]);
            this.outFile.print(this.convertToOiginal(stringBuilder.toString()));
            this.outFile.println(stringArray[2]);
        } else {
            this.outFile.println(String.join((CharSequence)"", stringArray));
        }
    }

    public void printTag(String string, List<? extends DocTree> list, String string2) {
        StringBuilder stringBuilder = new StringBuilder(1000);
        for (DocTree docTree : list) {
            StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(docTree));
            this.valueTag(stringBuilder2);
            this.doc03LinkTag(stringBuilder2);
            this.linkTag(stringBuilder2);
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        this.outFile.print(string);
        this.outFile.print(this.convertToOiginal(stringBuilder.toString()));
        this.outFile.println(string2);
    }

    String convertToOiginal(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = stringBuilder.indexOf("\\u");
        while (n >= 0) {
            int n2 = Integer.parseInt(stringBuilder.substring(n + 2, n + 6), 16);
            stringBuilder.replace(n, n + 6, Character.toString((char)n2));
            n = stringBuilder.indexOf("\\u", n + 1);
        }
        return StringUtil.htmlFilter(stringBuilder.toString()).trim();
    }

    private StringBuilder valueTag(StringBuilder stringBuilder) {
        int n = stringBuilder.indexOf(OG_VALUE);
        while (n >= 0) {
            Object object;
            Object object2;
            int n2 = stringBuilder.indexOf("}", n + OG_VALUE.length());
            if (n2 < 0) {
                object2 = "\u8b66\u544a:{@og.value package.class#field} \u5f62\u5f0f\u306e\u7d42\u4e86\u30de\u30fc\u30ab\u30fc'}'\u304c\u3042\u308a\u307e\u305b\u3093\u3002" + HybsConst.CR + "[" + this.clsName + "],[" + stringBuilder + "]";
                System.err.println((String)object2);
                break;
            }
            object2 = stringBuilder.substring(n + OG_VALUE.length(), n2).trim();
            Object object3 = null;
            Object object4 = null;
            int n3 = ((String)object2).indexOf(35);
            if (n3 > 0) {
                object3 = ((String)object2).substring(0, n3);
                object4 = ((String)object2).substring(n3 + 1);
                if (((String)object3).indexOf(46) < 0) {
                    if ("HybsSystem".equals(object3) || "SystemData".equals(object3)) {
                        object3 = "org.opengion.hayabusa.common." + (String)object3;
                    } else if ("HybsConst".equals(object3)) {
                        object3 = "org.opengion.fukurou.system." + (String)object3;
                    } else {
                        int n4 = this.clsName.lastIndexOf(46);
                        if (n4 > 0) {
                            object3 = this.clsName.substring(0, n4 + 1) + (String)object3;
                        }
                    }
                }
            } else if (n3 == 0) {
                object3 = this.clsName;
                object4 = ((String)object2).substring(1);
            } else {
                object = "\u8b66\u544a:{@og.value package.class#field} \u5f62\u5f0f\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u540d #field \u304c\u3042\u308a\u307e\u305b\u3093\u3002" + HybsConst.CR + "[" + this.clsName + "],[" + (String)object2 + "]";
                System.err.println((String)object);
                object3 = this.clsName;
                object4 = object2;
            }
            object = DocTreeWriter.getStaticField((String)object3, (String)object4);
            stringBuilder.replace(n, n2 + 1, (String)object);
            n = stringBuilder.indexOf(OG_VALUE, n + ((String)object).length());
        }
        return stringBuilder;
    }

    private StringBuilder doc03LinkTag(StringBuilder stringBuilder) {
        int n = stringBuilder.indexOf(OG_DOCLNK);
        while (n >= 0) {
            Object object;
            Object object2;
            int n2 = stringBuilder.indexOf("}", n + OG_DOCLNK.length());
            if (n2 < 0) {
                object2 = "\u8b66\u544a:{@og.doc03Link queryType Query_****\u30af\u30e9\u30b9} \u5f62\u5f0f\u306e\u7d42\u4e86\u30de\u30fc\u30ab\u30fc'}'\u304c\u3042\u308a\u307e\u305b\u3093\u3002" + HybsConst.CR + "[" + this.clsName + "],[" + stringBuilder + "]";
                System.err.println((String)object2);
                break;
            }
            object2 = stringBuilder.substring(n + OG_DOCLNK.length(), n2).trim();
            Object object3 = "";
            int n3 = ((String)object2).indexOf(32);
            if (n3 > 0) {
                object = ((String)object2).substring(0, n3).trim();
                String string = ((String)object2).substring(n3 + 1).trim();
                object3 = "&lt;a href=\"/gf/jsp/DOC03/index.jsp?command=NEW&amp;GAMENID=DOC03&amp;VERNO=" + VERSION_NO + "&amp;VALUENAME=" + (String)object + "\" target=\"CONTENTS\"&gt;" + string + "&lt;/a&gt;";
            } else {
                object3 = "{@og.doc03Link \u3010\u4e0d\u660e\u3011:" + (String)object2;
                object = "[" + this.clsName + "],[" + (String)object3 + "]";
                System.err.println((String)object);
            }
            stringBuilder.replace(n, n2 + 1, (String)object3);
            n = stringBuilder.indexOf(OG_DOCLNK, n + ((String)object3).length());
        }
        return stringBuilder;
    }

    private StringBuilder linkTag(StringBuilder stringBuilder) {
        int n = stringBuilder.indexOf(TAG_LNK);
        while (n >= 0) {
            Object object;
            int n2 = stringBuilder.indexOf("}", n + TAG_LNK.length());
            if (n2 < 0) {
                object = "\u8b66\u544a:{@link XXXX YYYY} \u5f62\u5f0f\u306e\u7d42\u4e86\u30de\u30fc\u30ab\u30fc'}'\u304c\u3042\u308a\u307e\u305b\u3093\u3002" + HybsConst.CR + "[" + this.clsName + "],[" + stringBuilder + "]";
                System.err.println((String)object);
                break;
            }
            object = stringBuilder.substring(n + TAG_LNK.length(), n2).trim();
            Object object2 = "";
            int n3 = ((String)object).indexOf(32);
            if (n3 > 0) {
                String string = ((String)object).substring(0, n3).trim();
                String string2 = ((String)object).substring(n3).trim();
                String string3 = string.replace('.', '/');
                object2 = "<a href=\"../../../../" + string3 + ".html\" title=\"" + string + "\">" + string2 + "</a>";
            } else {
                object2 = "{@link " + (String)object;
            }
            stringBuilder.replace(n, n2 + 1, (String)object2);
            n = stringBuilder.indexOf(TAG_LNK, n + ((String)object2).length());
        }
        return stringBuilder;
    }

    private static String getStaticField(String string, String string2) {
        String string3 = "";
        try {
            final Field field = Class.forName(string).getDeclaredField(string2);
            if (!field.canAccess(null)) {
                AccessController.doPrivileged(new PrivilegedAction<DocTreeWriter>(){

                    @Override
                    public DocTreeWriter run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
            }
            string3 = String.valueOf(field.get(null));
        }
        catch (Throwable throwable) {
            String string4 = "package.class=[" + string + "],field=[" + string2 + "] \u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + throwable;
            System.err.println(string4);
        }
        return string3;
    }
}

