/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.request.processor;

import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.auth.IAuthRequestBuilder;
import oracle.cloudstorage.api.copy.CopyRequestBuilder;
import oracle.cloudstorage.api.copy.ICopyRequestBuilder;
import oracle.cloudstorage.api.copy.ICopyRequestProcessor;
import oracle.cloudstorage.api.delete.DeleteRequestBuilder;
import oracle.cloudstorage.api.delete.IDeleteRequestBuilder;
import oracle.cloudstorage.api.delete.IDeleteRequestProcessor;
import oracle.cloudstorage.api.get.GetRequestBuilder;
import oracle.cloudstorage.api.get.IGetRequestBuilder;
import oracle.cloudstorage.api.get.IGetRequestProcessor;
import oracle.cloudstorage.api.head.HeadRequestBuilder;
import oracle.cloudstorage.api.head.IHeadRequestBuilder;
import oracle.cloudstorage.api.head.IHeadRequestProcessor;
import oracle.cloudstorage.api.post.IPostRequestBuilder;
import oracle.cloudstorage.api.post.IPostRequestProcessor;
import oracle.cloudstorage.api.post.PostRequestBuilder;
import oracle.cloudstorage.api.put.IPutRequestBuilder;
import oracle.cloudstorage.api.put.IPutRequestProcessor;
import oracle.cloudstorage.api.put.PutRequestBuilder;
import oracle.cloudstorage.api.request.RequestContext;
import oracle.cloudstorage.api.request.Scope;
import oracle.cloudstorage.api.request.processor.IProcessorFactory;
import oracle.cloudstorage.api.request.processor.IRequestBuilderRoot;
import oracle.cloudstorage.api.request.processor.IRequestProcessor;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.api.request.processor.ISendable;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class AbstractRequestProcessor<B extends IRequestBuilder, P extends IRequestProcessor<B, P>>
implements IRequestProcessor<B, P> {
    private RequestContext<B, ? extends P> context;
    private final IProcessorFactory factory;
    private volatile IRequestBuilderRoot internalRequestBuilderRoot = null;

    protected AbstractRequestProcessor(IProcessorFactory factory) {
        this.factory = factory;
    }

    protected final IResponse send(Logger logger, Marker marker, ISendable sendable) {
        IResponse response = this.getSession().send(logger, marker, sendable);
        return response;
    }

    public IProcessorFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setContext(RequestContext<B, ? extends P> context) {
        this.context = context;
    }

    @Override
    public RequestContext<B, ? extends P> getContext() {
        return this.context;
    }

    public ISession getSession() {
        return this.context == null ? null : this.context.getSession();
    }

    @Override
    public B getBuilder() {
        return this.getContext().getBuilder();
    }

    protected String getStorageToken() {
        String token = this.getSession().getStorageToken();
        return token;
    }

    protected String getAccountUrl() {
        String url = this.getSession().getStorageUrl();
        String accountId = this.getBuilder().getAccountId();
        if (accountId == null || accountId.isEmpty() || url == null) {
            return url;
        }
        int end = Math.min(url.length(), url.indexOf("v1/") + "v1/".length());
        url = url.substring(0, end) + accountId;
        return url;
    }

    protected Scope getScope() {
        if (this.getBuilder().getObjectId() != null) {
            return Scope.object;
        }
        if (this.getBuilder().getContainerId() != null) {
            return Scope.container;
        }
        return Scope.account;
    }

    protected String getScopedUrl() {
        switch (this.getScope()) {
            case account: {
                return this.getAccountUrl();
            }
            case container: {
                return this.getContainerUrl();
            }
            case object: {
                return this.getObjectUrl();
            }
        }
        return null;
    }

    protected String getContainerUrl() {
        String url = this.getAccountUrl() + "/" + this.getBuilder().getContainerId();
        return url;
    }

    protected String getObjectUrl() {
        String objectId = this.getBuilder().getObjectId();
        String url = this.getObjectUrl(objectId);
        return url;
    }

    protected String getObjectUrl(String objectId) {
        String url = this.getContainerUrl() + "/" + objectId;
        return url;
    }

    IProcessorFactory getProcessorFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRequestBuilderRoot getInternalRequestBuilderRoot() {
        if (this.internalRequestBuilderRoot != null) {
            return this.internalRequestBuilderRoot;
        }
        AbstractRequestProcessor abstractRequestProcessor = this;
        synchronized (abstractRequestProcessor) {
            if (this.internalRequestBuilderRoot != null) {
                return this.internalRequestBuilderRoot;
            }
            this.internalRequestBuilderRoot = new IRequestBuilderRoot(){

                @Override
                public IAuthRequestBuilder.RetryStrategy auth() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public IDeleteRequestBuilder.RetryStrategy delete() throws InterruptedException {
                    DeleteRequestBuilder requestBuilder = new DeleteRequestBuilder((IRequestBuilder)AbstractRequestProcessor.this.getBuilder());
                    IDeleteRequestProcessor processor = AbstractRequestProcessor.this.getProcessorFactory().createDelete();
                    return (IDeleteRequestBuilder.RetryStrategy)requestBuilder.root(AbstractRequestProcessor.this.getSession(), processor);
                }

                @Override
                public IGetRequestBuilder.RetryStrategy get() throws InterruptedException {
                    GetRequestBuilder requestBuilder = new GetRequestBuilder((IRequestBuilder)AbstractRequestProcessor.this.getBuilder());
                    IGetRequestProcessor processor = AbstractRequestProcessor.this.getProcessorFactory().createGet();
                    return (IGetRequestBuilder.RetryStrategy)requestBuilder.root(AbstractRequestProcessor.this.getSession(), processor);
                }

                @Override
                public IHeadRequestBuilder.RetryStrategy head() throws InterruptedException {
                    HeadRequestBuilder requestBuilder = new HeadRequestBuilder((IRequestBuilder)AbstractRequestProcessor.this.getBuilder());
                    IHeadRequestProcessor processor = AbstractRequestProcessor.this.getProcessorFactory().createHead();
                    return (IHeadRequestBuilder.RetryStrategy)requestBuilder.root(AbstractRequestProcessor.this.getSession(), processor);
                }

                @Override
                public IPostRequestBuilder.RetryStrategy post() throws InterruptedException {
                    PostRequestBuilder requestBuilder = new PostRequestBuilder((IRequestBuilder)AbstractRequestProcessor.this.getBuilder());
                    IPostRequestProcessor processor = AbstractRequestProcessor.this.getProcessorFactory().createPost();
                    return (IPostRequestBuilder.RetryStrategy)requestBuilder.root(AbstractRequestProcessor.this.getSession(), processor);
                }

                @Override
                public IPutRequestBuilder.RetryStrategy put() throws InterruptedException {
                    PutRequestBuilder requestBuilder = new PutRequestBuilder((IRequestBuilder)AbstractRequestProcessor.this.getBuilder());
                    IPutRequestProcessor processor = AbstractRequestProcessor.this.getProcessorFactory().createPut();
                    return (IPutRequestBuilder.RetryStrategy)requestBuilder.root(AbstractRequestProcessor.this.getSession(), processor);
                }

                @Override
                public ICopyRequestBuilder.RetryStrategy copy() throws InterruptedException {
                    CopyRequestBuilder requestBuilder = new CopyRequestBuilder((IRequestBuilder)AbstractRequestProcessor.this.getBuilder());
                    ICopyRequestProcessor processor = AbstractRequestProcessor.this.getProcessorFactory().createCopy();
                    return (ICopyRequestBuilder.RetryStrategy)requestBuilder.root(AbstractRequestProcessor.this.getSession(), processor);
                }

                @Override
                public void skipAuth(String url) {
                }
            };
            return this.internalRequestBuilderRoot;
        }
    }
}

