/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.octavia.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.model.octavia.MemberV2;
import org.openstack4j.model.octavia.builder.MemberV2Builder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="member")
@JsonIgnoreProperties(ignoreUnknown=true)
public class OctaviaMemberV2
implements MemberV2 {
    private String id;
    @JsonProperty(value="project_id")
    private String projectId;
    private String address;
    @JsonProperty(value="protocol_port")
    private Integer protocolPort;
    private Integer weight;
    @JsonProperty(value="subnet_id")
    private String subnetId;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp = true;

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public String getSubnetId() {
        return this.subnetId;
    }

    @Override
    public Integer getWeight() {
        return this.weight;
    }

    @Override
    public Integer getProtocolPort() {
        return this.protocolPort;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("projectId", (Object)this.projectId).add("address", (Object)this.address).add("protocolPort", (Object)this.protocolPort).add("adminStateUp", this.adminStateUp).add("weight", (Object)this.weight).add("subnetId", (Object)this.subnetId).toString();
    }

    @Override
    public MemberV2Builder toBuilder() {
        return new MemberV2ConcreteBuilder(this);
    }

    public static MemberV2Builder builder() {
        return new MemberV2ConcreteBuilder();
    }

    public static class MemberV2ConcreteBuilder
    implements MemberV2Builder {
        private OctaviaMemberV2 m;

        public MemberV2ConcreteBuilder() {
            this(new OctaviaMemberV2());
        }

        public MemberV2ConcreteBuilder(OctaviaMemberV2 m) {
            this.m = m;
        }

        @Override
        public MemberV2 build() {
            return this.m;
        }

        @Override
        public MemberV2Builder from(MemberV2 in) {
            this.m = (OctaviaMemberV2)in;
            return this;
        }

        @Override
        public MemberV2Builder projectId(String projectId) {
            this.m.projectId = projectId;
            return this;
        }

        @Override
        public MemberV2Builder address(String address) {
            this.m.address = address;
            return this;
        }

        @Override
        public MemberV2Builder protocolPort(Integer protocolPort) {
            this.m.protocolPort = protocolPort;
            return this;
        }

        @Override
        public MemberV2Builder subnetId(String subnetId) {
            this.m.subnetId = subnetId;
            return this;
        }

        @Override
        public MemberV2Builder weight(Integer weight) {
            this.m.weight = weight;
            return this;
        }

        @Override
        public MemberV2Builder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }
    }

    public static class MembersV2
    extends ListResult<OctaviaMemberV2> {
        @JsonProperty(value="members")
        List<OctaviaMemberV2> members;

        @Override
        protected List<OctaviaMemberV2> value() {
            return this.members;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("members", this.members).toString();
        }
    }
}

