/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opengion.fukurou.model.NativeType;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBRowHeader;
import org.opengion.hayabusa.db.DBTableModel;

public class DBTableModelImpl
implements DBTableModel {
    protected DBColumn[] dbColumns = null;
    protected String[] names = null;
    protected List<String[]> data = null;
    protected List<DBRowHeader> rowHeader = null;
    protected Map<String, Integer> columnMap = null;
    protected boolean overflow = false;
    protected int numberOfColumns = 0;
    protected String consistencyKey = String.valueOf(System.currentTimeMillis());
    private String[] lastData = null;
    private int lastRow = -1;
    private final Map<String, Set<String>> mustMap = new HashMap<String, Set<String>>();

    @Override
    public void init(int n) {
        this.data = new ArrayList<String[]>(200);
        this.rowHeader = new ArrayList<DBRowHeader>(200);
        this.names = new String[n];
        this.dbColumns = new DBColumn[n];
        this.numberOfColumns = n;
        this.columnMap = new HashMap<String, Integer>();
        this.lastRow = -1;
    }

    @Override
    public DBTableModel newModel() {
        DBTableModelImpl dBTableModelImpl = new DBTableModelImpl();
        dBTableModelImpl.data = new ArrayList<String[]>(200);
        dBTableModelImpl.rowHeader = new ArrayList<DBRowHeader>(200);
        dBTableModelImpl.names = this.names;
        dBTableModelImpl.dbColumns = this.dbColumns;
        dBTableModelImpl.numberOfColumns = this.numberOfColumns;
        dBTableModelImpl.columnMap = this.columnMap;
        dBTableModelImpl.lastRow = -1;
        dBTableModelImpl.consistencyKey = this.consistencyKey;
        return dBTableModelImpl;
    }

    public String[] getNames() {
        if (this.names != null) {
            return (String[])this.names.clone();
        }
        String string = "\u30ab\u30e9\u30e0\u540d\u914d\u5217\u304c\u3001\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        throw new HybsSystemException(string);
    }

    @Override
    public void setValue(int n, String string, String string2) {
        int n2 = this.getColumnNo(string);
        int n3 = this.getRowCount();
        if (n3 > n) {
            this.setRowHeader(n, "C");
            this.setValueAt(string2, n, n2);
        } else {
            for (int i = 0; i < n - n3 + 1; ++i) {
                String[] stringArray = new String[this.numberOfColumns];
                for (int j = 0; j < this.numberOfColumns; ++j) {
                    stringArray[j] = "";
                }
                this.addColumnValues(stringArray);
            }
            this.setValueAt(string2, n, n2);
        }
    }

    @Override
    public void rowDelete(int n) {
        this.setRowHeader(n, "D");
    }

    @Override
    public void rowDelete(String[] stringArray, int n) {
        if (this.numberOfColumns != stringArray.length) {
            String string = "\u30ab\u30e9\u30e0\u540d\u306e\u500b\u6570\u304c\u4e0d\u4e00\u81f4\u3067\u3059\u3002 [" + this.numberOfColumns + "] : [" + stringArray.length + "] values=" + StringUtil.array2csv((String[])stringArray);
            throw new HybsSystemException(string);
        }
        this.setRowHeader(n, "D");
        this.data.set(n, stringArray);
        this.lastRow = -1;
    }

    @Override
    public void removeValue(int n) {
        this.data.remove(n);
        this.rowHeader.remove(n);
        this.lastRow = -1;
    }

    @Override
    public String getColumnLabel(int n) {
        return this.dbColumns[n].getLabel();
    }

    public String getValue(int n, int n2) {
        if (n != this.lastRow) {
            this.lastData = this.data.get(n);
            this.lastRow = n;
        }
        return this.lastData[n2];
    }

    @Override
    public String getValue(int n, String string) {
        return this.getValue(n, this.getColumnNo(string));
    }

    @Override
    public void setDBColumn(int n, DBColumn dBColumn) {
        this.dbColumns[n] = dBColumn;
        this.names[n] = dBColumn.getName();
        this.columnMap.put(this.names[n].toUpperCase(Locale.JAPAN), n);
    }

    @Override
    public DBColumn getDBColumn(int n) {
        return this.dbColumns[n];
    }

    @Override
    public DBColumn[] getDBColumns() {
        int n = this.dbColumns.length;
        DBColumn[] dBColumnArray = new DBColumn[n];
        System.arraycopy(this.dbColumns, 0, dBColumnArray, 0, n);
        return dBColumnArray;
    }

    public int getColumnNo(String string) {
        return this.getColumnNo(string, true);
    }

    @Override
    public int getColumnNo(String string, boolean bl) {
        Object object;
        if (string != null && (object = this.columnMap.get(string.toUpperCase(Locale.JAPAN))) != null) {
            return (Integer)object;
        }
        if (bl) {
            object = "\u30ab\u30e9\u30e0\u540d\u304c\u5b58\u5728\u3057\u307e\u305b\u3093:[" + string + "]";
            throw new HybsSystemException((String)object);
        }
        return -1;
    }

    @Override
    public void addValues(String[] stringArray, int n) {
        this.addValues(stringArray, n, true);
    }

    @Override
    public void addValues(String[] stringArray, int n, boolean bl) {
        this.data.add(n, stringArray);
        this.lastRow = -1;
        DBRowHeader dBRowHeader = new DBRowHeader();
        if (bl) {
            dBRowHeader.setType("A");
        } else {
            dBRowHeader.setWritable(false);
            dBRowHeader.setChecked(false);
        }
        this.rowHeader.add(n, dBRowHeader);
    }

    @Override
    public void addColumnValues(String[] stringArray) {
        this.data.add(stringArray);
        this.lastRow = -1;
        this.rowHeader.add(new DBRowHeader());
    }

    @Override
    public String getColumnName(int n) {
        return this.names[n];
    }

    @Override
    public int getColumnCount() {
        return this.numberOfColumns;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public void setValueAt(String string, int n, int n2) {
        String[] stringArray = this.data.get(n);
        stringArray[n2] = string;
        this.data.set(n, stringArray);
        this.lastRow = -1;
    }

    public String[] getValues(int n) {
        return this.data.get(n);
    }

    @Override
    public void setValues(String[] stringArray, int n) {
        if (this.numberOfColumns != stringArray.length) {
            String string = "\u30ab\u30e9\u30e0\u540d\u306e\u500b\u6570\u304c\u4e0d\u4e00\u81f4\u3067\u3059\u3002 [" + this.numberOfColumns + "] : [" + stringArray.length + "] values=" + StringUtil.array2csv((String[])stringArray);
            throw new HybsSystemException(string);
        }
        this.setRowHeader(n, "C");
        this.data.set(n, stringArray);
        this.lastRow = -1;
    }

    @Override
    public void resetModify() {
        int n = this.rowHeader.size();
        for (int i = 0; i < n; ++i) {
            DBRowHeader dBRowHeader = this.rowHeader.get(i);
            dBRowHeader.clear();
        }
    }

    @Override
    public void resetModify(int n) {
        DBRowHeader dBRowHeader = this.rowHeader.get(n);
        dBRowHeader.clear();
    }

    @Override
    public String getModifyType(int n) {
        DBRowHeader dBRowHeader = this.rowHeader.get(n);
        return dBRowHeader.getType();
    }

    @Override
    public void setModifyType(int n, String string) {
        DBRowHeader dBRowHeader = this.rowHeader.get(n);
        dBRowHeader.setType(string);
    }

    protected void setRowHeader(int n, String string) {
        DBRowHeader dBRowHeader = this.rowHeader.get(n);
        dBRowHeader.setBackupData(this.data.get(n));
        dBRowHeader.setType(string);
    }

    @Override
    public void resetRow(int n) {
        String string = this.getModifyType(n);
        if (string.equals("A")) {
            this.data.remove(n);
            this.rowHeader.remove(n);
        } else if (string.equals("C") || string.equals("D")) {
            DBRowHeader dBRowHeader = this.rowHeader.get(n);
            String[] stringArray = dBRowHeader.getBackupData();
            if (stringArray != null) {
                this.data.set(n, stringArray);
            }
            dBRowHeader.clear();
        }
        this.lastRow = -1;
    }

    @Override
    public boolean isRowWritable(int n) {
        DBRowHeader dBRowHeader = this.rowHeader.get(n);
        return dBRowHeader.isWritable();
    }

    @Override
    public void setRowWritable(int n, boolean bl) {
        DBRowHeader dBRowHeader = this.rowHeader.get(n);
        dBRowHeader.setWritable(bl);
    }

    @Override
    public boolean isRowChecked(int n) {
        DBRowHeader dBRowHeader = this.rowHeader.get(n);
        return dBRowHeader.isChecked();
    }

    @Override
    public void setRowChecked(int n, boolean bl) {
        DBRowHeader dBRowHeader = this.rowHeader.get(n);
        dBRowHeader.setChecked(bl);
    }

    @Override
    public void setDefaultRowWritable(boolean bl) {
        int n = this.rowHeader.size();
        for (int i = 0; i < n; ++i) {
            DBRowHeader dBRowHeader = this.rowHeader.get(i);
            dBRowHeader.setWritable(bl);
        }
    }

    @Override
    public void setDefaultRowChecked(boolean bl) {
        int n = this.rowHeader.size();
        for (int i = 0; i < n; ++i) {
            DBRowHeader dBRowHeader = this.rowHeader.get(i);
            dBRowHeader.setChecked(bl);
        }
    }

    @Override
    public boolean isOverflow() {
        return this.overflow;
    }

    @Override
    public void setOverflow(boolean bl) {
        this.overflow = bl;
    }

    @Override
    public String getConsistencyKey() {
        return this.consistencyKey;
    }

    public NativeType getNativeType(int n) {
        return this.dbColumns[n].getNativeType();
    }

    @Override
    public void addMustType(int n, String string) {
        Set<String> set = this.mustMap.get(string);
        if (set == null) {
            set = new HashSet<String>();
        }
        set.add(this.names[n]);
        this.mustMap.put(string, set);
    }

    @Override
    public String[] getMustArray() {
        Object[] objectArray = null;
        Set<String> set = this.mustMap.get("must");
        if (set != null && !set.isEmpty()) {
            objectArray = set.toArray(new String[set.size()]);
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    @Override
    public String[] getMustAnyArray() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.mustMap.keySet().toArray(new String[this.mustMap.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            Set<String> set;
            String string = stringArray[i];
            if ("must".equals(string) || (set = this.mustMap.get(string)) == null || set.isEmpty()) continue;
            String string2 = StringUtil.iterator2line(set.iterator(), (String)"|");
            arrayList.add(string2);
        }
        Object[] objectArray = null;
        if (!arrayList.isEmpty()) {
            objectArray = arrayList.toArray(new String[arrayList.size()]);
            Arrays.sort(objectArray);
        }
        return objectArray;
    }
}

