<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query" >
	<script type="text/javascript" src="{@SYS.JSP}/common/unrecommend/returnFocus.js"><!-- --></script>
	<!-- setChild あらかじめデータを読んでおいて、renewしないタイプの親子プルダウンです -->
	<script type="text/javascript" src="{@SYS.JSP}/common/unrecommend/PCpulldownMenu.js"><!-- --></script>
</og:head>
<jsp:directive.include  file="/jsp/custom/query_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6010"
	title	= "セレクトメニュー"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<form method="GET" action="forward.jsp" target="RESULT" onSubmit="timeSet();">
	<table summary="layout" >
	<tr>
		<og:column name="LANG" defaultVal="{@USER.LANG}" must="true" addKeyLabel="true" />	<!-- MENU -->
		<og:column name="TABLE_CLM2" must="true" />								<!-- INDBMENU -->
			<!-- renewするタイプの親子プルダウンです -->
		<td>
			<strong><og:message lbl="SYSTEM_ID"/>:</strong>
		</td>
		<td colspan="3">
			<!-- DBMENU -->
			<og:select name="SYSTEM_ID" addNoValue="true" onChange="renew('query.jsp','QUERY',this)"  td="false">
				<og:queryOption>
					SELECT SYSTEM_ID FROM GF41
					WHERE	FGJ			= '1'
					AND		LANG		= '{@NVL.LANG ja}'
					GROUP BY SYSTEM_ID
					ORDER BY SYSTEM_ID
				</og:queryOption>
			</og:select>
			<strong>:</strong>
			<og:select name="CLM"  td="false" >
				<og:option lbl=""/>
				<og:queryOption separator=":">
					SELECT CLM,KBSAKU,LABEL_NAME FROM GF41
					WHERE	SYSTEM_ID	= '{@SYSTEM_ID}'
					AND		LANG		= '{@NVL.LANG ja}'
					AND		FGJ			= '1'
					ORDER BY 1,3
				</og:queryOption>
			</og:select>
			<br />
			<og:select name="GUI_Menu" td="false">
				<og:queryOption  groupUseNo="2" classUseNo="3">
					SELECT CLM,LABEL_NAME,KBSAKU,
							case when MOD(UNIQ,3) = 0 then 'row_mark' else '' end
					from GF41
					where SYSTEM_ID	= '{@SYSTEM_ID}'
					AND		LANG	= '{@NVL.LANG ja}'
					AND		FGJ		= '1'
					ORDER BY CLM,KBSAKU
				</og:queryOption>
			</og:select>
		</td>
	</tr>
	<tr>
		<og:select name="EMP_Menu1" >
			<og:queryOption groupUseNo="2" disabledUseNo="3">
					select A.EMPNO,A.ENAME,B.DNAME,
							case when B.DNAME = 'SALES' then 'disabled' else '' end as CLS
					from EMP A left outer join DEPT B
					on   A.DEPTNO = B.DEPTNO
					order by A.DEPTNO,A.EMPNO
			</og:queryOption>
		</og:select>

		<og:select name="EMP_Menu2" >
			<og:queryOption groupUseNo="2" styleUseNo="3">
					select A.EMPNO,A.ENAME,B.DNAME,
							case A.DEPTNO
								when 10 then 'color:green;'
								when 20 then 'color:blue;'
								when 30 then 'color:red;'
								else         'color:yellow;' end as CLS
					from EMP A left outer join DEPT B
					on   A.DEPTNO = B.DEPTNO
					order by A.DEPTNO,A.EMPNO
			</og:queryOption>
		</og:select>

		<og:column name="EMP_Menu3" editor="DBMENU"
			param="select A.EMPNO,A.ENAME,'',B.DNAME,
							case A.DEPTNO
								when 10 then 'style=&quot;color:green;font-size: 0.5em;&quot;'
								when 20 then 'style=&quot;color:blue;font-style: oblique;&quot;'
								when 30 then 'style=&quot;color:red;font-size: 2em;&quot;'
								else         'color:yellow;' end as CLS
					from EMP A left outer join DEPT B
					on   A.DEPTNO = B.DEPTNO
					order by A.DEPTNO,A.EMPNO" />

		<og:select name="EMP_Menu4" multiple="true">
			<og:queryOption groupUseNo="2"  disabledUseNo="3" styleUseNo="4" value="7839|7934">
					select A.EMPNO,A.ENAME || rownum,B.DNAME,
					case mod( rownum , 4 ) when 0 then 'disabled' else '' end as CLS1,
					case mod( rownum , 3 ) when 0 then 'color:yellow;' when 1 then 'color:green;' when 2 then 'color:red;' else 'color:blue;' end as CLS2
					from EMP A left outer join DEPT B
					on   A.DEPTNO = B.DEPTNO
					order by A.DEPTNO,A.EMPNO
			</og:queryOption>
		</og:select>
	</tr>
	<tr>
		<!-- 大項目 -->
		<og:column name="S00" must="false" onChange="setChild(this.form,this,'S00C','S00H')" />
		<!-- 小項目 -->
		<og:column name="S00C"  lbl="" must="false" />
		<!-- 隠し小項目 -->
		<og:column name="S00H"  lbl="" must="false" td="false" style="display:none"/>
	</tr>
	<tr>
		<og:column name="TABLE_CLM2_2"  editor="DATALIST"
			param="SELECT TABLE_NAME,TABLE_NAME || ':' || NAME_JA FROM GF02 WHERE SYSTEM_ID='{@SYS.SYSTEM_ID}' AND TBLSYU='D' ORDER BY TABLE_NAME" />	<!-- DATALIST -->
		<og:column name="RENDERER" codeList="LABEL,MENU,DBMENU"  />
		<!-- clazz="sel2sel" を付けると、検索機能(絞り機能)付きのプルダウンメニューとなる -->
		<og:select name="FILES1" addNoValue="true" clazz="sel2sel" >
				<og:fileOption from="{@SYS.REAL_PATH}jsp/custom" nameOnly="true" />
		</og:select>
		<og:column name="FILES2" editor="FILES" param="{@SYS.REAL_PATH}jsp/custom;nameOnly;glob:*.jsp" />
	</tr>
	</table>

	<table summary="layout" >
		<tr>
			<og:column name="NUM1"	editor="NUMMENU" />
			<og:column name="NUM2"	editor="NUMMENU"	param="-5,5,1" />
			<og:column name="NUM3"	editor="NUMMENU"	param="0,100,10" />
			<og:column name="NUM4"	editor="NUMMENU"	param="10,0,-1" />
			<og:column name="NUM5"	editor="NUMMENU"	param="5,10" />
			<og:column name="NUM6"	editor="NUMMENU"	param="7" />
			<og:column name="NUM7"	editor="NUMMENU"	param="000,020,5" />
			<og:column name="NUM8"	editor="NUMMENU"	param="0.00,1.00,0.2" />
		</tr>
		<tr>
			<og:column name="YMD1"	editor="YMDMENU"	defaultVal="{@DATE.YMD}" />
			<og:column name="YMD2"	editor="YMDMENU"	defaultVal="{@DATE.YMD}"	param="-7,14,1" />
			<og:column name="YMD3"	editor="YMDMENU"	defaultVal="{@DATE.YMD}"	param="SD,ED" />
			<og:column name="YMD4"	editor="YMDMENU"	defaultVal="{@DATE.YMD SW}"	param="SW,M24,7,MM/dd(EEE)" />
			<og:column name="YMD5"	editor="YMDMENU"	defaultVal="{@DATE.YMD}"	param="ED,SD,-1" />
			<og:column name="YMD6"	editor="YMDMENU"	defaultVal="{@DATE.YMD}"	param="0,14,1,MM/dd(EEE),yyyy/MM/dd(E)" optionAttributes="multiple='multiple'" />
		</tr>
		<tr>
			<og:column name="HM1"	editor="HMMENU"		/>
			<og:column name="HM2"	editor="HMMENU"		param="0800,2000,60,0000:△,2400:▽" />
			<og:column name="HM3"	editor="HMMENU"		param="2000,0700,-30" />
			<og:column name="HM4"	editor="HMMENU"		param="0300" />
			<og:column name="HM5"	editor="HMMENU"		param="H-2,H3,15" />
			<og:column name="HM6"	editor="HMMENU"		param="H0,H1,1" />
		</tr>
	</table>
	<table>
		<tr>
			<og:column name="RD1"	editor="RADIO"  	codeName="LANG" />
<!-- 6.4.4.0 (2016/03/11) 廃止
廃止		<og:column name="RD2"	editor="RADIO2" 	codeName="LANG" />
-->
			<og:column name="KV1"	codeKeyVal="1:A 2:B 3:C" />
			<og:column name="KV2"	editor="KVMENU" 	param="1:A 2:B 3:C" />
		</tr>
	</table>
	<table>
		<tr>
			<og:column name="DBR1"	editor="DBRADIO"
				param="SELECT CLM,LABEL_NAME FROM GF41
						WHERE	SYSTEM_ID	= '{@SYSTEM_ID}'
						AND		LANG		= '{@NVL.LANG ja}'
						AND		FGJ			= '1'
						AND		CLM		like  'A%'
						GROUP BY CLM,LABEL_NAME
						ORDER BY CLM"
			/>
		</tr>
	</table>

	<og:queryButton />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
