<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJSV3="true" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

	<!-- ﾁｬｰﾄ情報の取得 -->
	<og:query command="NEW">
		SELECT A.ENAME		as LABELS
				, A.SAL		as VAL1
				, B.SAL		as VAL2
		FROM BONUS A left outer join EMP B
			on A.ENAME = B.ENAME
		order by B.EMPNO
	</og:query>

	<og:columnEditor column="VAL2" className="NUMBER" /> <!-- VAL2を数値で出すため…実際は不要 -->

	<!-- scatter の場合は、x:をchartColumnをつかい、y: を varColumns で指定します。-->
	<og:jsChartV3
		chartType		= "scatter"
		labelColumn		= "LABELS"
		varColumns		= "VAL2"
		optOptions		= "animation:false"
		debug			= "{@debug}"
		plugins			= "chartLabelPlugin"
	>
		<og:jsChartDataV3
			chartColumn		= "VAL1"
			label			= "{@LBL.SAL}"
			borderColor		= "VIVID"
		/>
	</og:jsChartV3>
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
