<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useAjaxSubmit="true" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9350"
	title	= "登録前確認（警告）メッセージ表示(ｴﾝﾄﾘｰ系)"
	date	= "2012/08/27"
	author	= "A.SANPEI"
	text	= ""
	version	= "001"
>
	YYYY/MM/DD	XXXXX
</og:comment>

<!-- command="ENTRY"時は、nullCheckはcolumnEditorでmust指定したカラムをチェックします。-->
<!-- カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck
	command   = "NEW"
	useStrict = "true"
>
	<!-- エラー時の戻るボタン。書き換えないで下さい。-->
	<!-- history.back() で戻るボタンを表示します。	-->
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- 警告ﾁｪｯｸ -->
<!-- stopError属性：PLSQL/SQL処理エラーの時に処理を中止しない(false)設定をし、後続処理で分岐を行う。 -->
<!-- オラクルに対するcommitはかかるので、警告ﾁｪｯｸSPに登録処理は記述しないこと！！必要な場合は注意すること！！ -->
<og:query
	command		= "NEW"
	names		= "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME,KBSAKU,CDTAN,UNIQ,USER.ID"
	queryType	= "JDBCErrMsg"
	displayMsg	= ""
	stopError	= "false"
>
		{call GFP19350A.GF19350A(?,?,?,?)}
</og:query>

<!-- 後続処理では{@DB.ERR_CODE}の値により、PLSQL/SQLの異常/正常終了によって分岐処理が可能です。 -->
<!-- ERRCODE＝1(警告)の時、メッセージ表示 -->
<og:equals val1="{@DB.ERR_CODE}" val2="1" >
	<br/>
	<form method="POST" action="forward.jsp" target="QUERY">
		<!-- 登録/戻るボタンを作成します。 -->
		<og:writeCheck>
			<og:submit action="ENTRY" />
			<jsp:directive.include file="/jsp/common/history_back.jsp" />
			<og:message lbl="GFE0007" />
		</og:writeCheck>

		<!-- 警告ﾒｯｾｰｼﾞ表示 -->
<!--		<og:errorMessage command="{@command}" viewType="BODY" clear="{@clear}" />-->

		<!-- 明細ﾚｲｱｳﾄ(共有) -->
		<jsp:directive.include file="meisai.jsp" />
	</form>
</og:equals>

<!-- ERRCODE≠1(警告)の時、登録処理へ -->
<og:equals val1="{@DB.ERR_CODE}" val2="1" notEquals="true" >
	<og:forward page="entry.jsp" keys="command" vals="ENTRY" />
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
