/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.queue;

import javax.jms.MessageListener;

/**
 * キュー受信クラス用インタフェース
 * キュー受信処理のインタフェースです。
 * MQとSQSのメッセージ受信に対応しています。
 *
 * @og.group メッセージ連携
 *
 * @og.rev 5.10.15.2 (2019/09/20) 新規作成
 *
 * @version 5
 * @author oota
 * @since JDK7
 */
public interface QueueReceive {

	/**
	 * 接続処理
	 * メッセージキューサーバに接続します。
	 *
	 *  @param jmsServer jsmサーバ
	 *  @param sqsAccessKey sqs用awsアクセスキー
	 *  @param sqsSecretKey sqs用awsシークレットキー
	 */
	void connect(final String jmsServer, final String sqsAccessKey, final String sqsSecretKey);

	/**
	 * 受信処理
	 * 受信処理を行います。
	 *
	 * @param queueName キュー名
	 * @return キュー情報格納クラス
	 */
	QueueInfo receive(final String queueName);

	/**
	 * リスナーの設定
	 * 指定キュー名に対して、
	 * メッセージキュー受信時に処理を行う、
	 * メッセージリスナーを設定します。
	 *
	 * @param queueName キュー名
	 * @param listener メッセージリスナー
	 */
	void setListener(final String queueName, MessageListener listener);

	/**
	 * リスナーの終了
	 * リスナーの終了処理を行います。
	 */
	void closeListener();

	/**
	 * クローズ処理
	 * MQ:受信リスナーの解除。
	 * SQS:クローズ処理はありません。
	 */
	void close();

	/**
	 * バッチフラグの設定
	 * バッチ処理として行う用の、
	 * バッチフラグを設定します。
	 *
	 * @param batchFlg バッチフラグ
	 */
	void setBatchFlg(final Boolean batchFlg);
}
