/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.system;

/**
 * 主に文字のエンコード・エラーやデコード・エラーが発生したときにスローされるエクセプションクラスです。
 *
 * OgRuntimeException を継承しているため、try{} catch() {} は不要です。
 * このエクセプションクラスは、java.nio.charset.CharacterCodingException が発生したときに、
 * こちらのExceptionに変換して、再 throw するケースがほとんどです。
 * TableReader系で、AutoReader を使用する場合、複数のエンコードでチャレンジするため、
 * 一般のエラーと、エンコードエラーを分けて捕らえたいのが目的です。
 * 機能的には、拡張されていません。
 *
 * @og.group エラー処理
 * @og.rev 6.5.0.1 (2016/10/21) 新規追加
 *
 * @version  6.5
 * @author   Kazuhiko Hasegawa
 * @since    JDK8.0,
 */
public class OgCharacterException extends OgRuntimeException {
	private static final long serialVersionUID = 650120161014L ;

	/**
	 * 詳細メッセージを指定しないで OgCharacterException を構築します。
	 *
	 * @og.rev 6.5.0.1 (2016/10/21) 新規追加
	 *
	 * @see		org.opengion.fukurou.system.OgRuntimeException#OgRuntimeException()
	 */
	public OgCharacterException() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 *  指定された詳細メッセージを持つ OgCharacterException を構築します。
	 *
	 * @og.rev 6.5.0.1 (2016/10/21) 新規追加
	 *
	 * @param	msg	詳細メッセージ
	 * @see		org.opengion.fukurou.system.OgRuntimeException#OgRuntimeException(String)
	 */
	public OgCharacterException( final String msg ) {
		super( msg );
	}

	/**
	 *  指定された詳細メッセージを持つ OgCharacterException を構築します。
	 *
	 * @og.rev 6.5.0.1 (2016/10/21) 新規追加
	 *
	 * @param	th	例外Throwableオブジェクト
	 * @see		org.opengion.fukurou.system.OgRuntimeException#OgRuntimeException(Throwable)
	 */
	public OgCharacterException( final Throwable th ) {
		super( th );
	}

	/**
	 *  指定されたオブジェクトを受け取る OgCharacterException を構築します。
	 *
	 * @og.rev 6.5.0.1 (2016/10/21) 新規追加
	 *
	 * @param	msg	詳細メッセージ
	 * @param	th	例外Throwableオブジェクト
	 * @see		org.opengion.fukurou.system.OgRuntimeException#OgRuntimeException(String,Throwable)
	 */
	public OgCharacterException( final String msg,final Throwable th ) {
		super( msg,th );
	}
}
