// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ++  Move one list contents to another list                       ++
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

/************************************************************************/
/*	7.3.1.2 (2021/03/02) ほぼ、全面改修									*/
/*		▲、△、▽、▼が動作していない 対応								*/
/*		固定値と文字色を指定可能にする。								*/
/*		og:popup に対応するために、makeRtnCSV メソッド追加				*/
/************************************************************************/

/************************************************************************/
/* switchListOpts 要素リストの左右移動									*/
/*   oListFrom 移動元													*/
/*   oListTo   移動先													*/
/*   bSelectedOnly 移動対象 true:移動のみ(→,←) , false:全件(⇒,×)	*/
/*   inVal     移動させる値												*/
/*   color     固定optionの色(初期設定後、移動しない)					*/
/************************************************************************/
// function switchListOpts(oListFrom, oListTo, bSelectedOnly , inVal ) {
function switchListOpts(oListFrom, oListTo, bSelectedOnly , inVal , color ) {
	var nIndexUp , nLastIdx , bMoveIt , tmpOps , flag ;

//	with ( oListFrom ) {
		for (nIndexUp = 0; nIndexUp < oListFrom.length; nIndexUp++) {
			tmpOps = oListFrom.options[nIndexUp];
			if( inVal ) {
				bMoveIt = ( inVal == tmpOps.value );
			}
			else {
				bMoveIt = ((bSelectedOnly) ?  tmpOps.selected : true);
				if( tmpOps.style.color ) { bMoveIt = false; }				// 固定optionは、対象外
			}

			if (bMoveIt) {
				nLastIdx = nIndexUp;
//				with (options[nIndexUp]) {
					flag = true;
					for( nidx=0; nidx < oListTo.length; nidx++ ) {
						if( oListTo.options[nidx].value == tmpOps.value ) {
							flag = false;
							break;
						}
					}
					// oListTo に存在しなかった場合。
					if( flag ) {
		//				oListTo.options[oListTo.length] = new Option( tmpOps.text, tmpOps.value );
						var opt = new Option( tmpOps.text, tmpOps.value );
						if( color ) { opt.style.color=color; }				// 固定option
						oListTo.options[oListTo.length] = opt;
					}
//				}
				oListFrom.options[nIndexUp] = null;
				nIndexUp--;
			}
		}

	// 7.3.1.2 (2021/03/02) 選択された状態になるので、処理しなくする。
	//	if( inVal ) {
	//		if (oListFrom.options[nLastIdx] != null) {
	//			oListFrom.options[nLastIdx].selected = true;
	//		}
	//		else if( length > 0 && oListFrom.options[length-1] != null) {
	//			oListFrom.options[length-1].selected = true;
	//		}
	//	}
//	}
}

/************************************************************/
/* moveListOpts 要素上下移動処理							*/
/*  oList  処理対象のselectｵﾌﾞｼﾞｪｸﾄ							*/
/*  nCmd   ｺﾏﾝﾄﾞ(1:△ , 2:▽ , 3:▲ , 4:▼)					*/
/************************************************************/
function moveListOpts(oList, nCmd) {
	var nIndexUp, nCountUp, nInc , nTotalLen , oBaseNade;
	switch(nCmd) {
		case 1:
		case 2:
//			with (oList) {
				nInc = ((1 == nCmd) ? -1 : 1);
				// Note : Begin from index 1
				for (nCountUp = 1; nCountUp < oList.options.length; nCountUp++) {
					nIndexUp = ((1 == nCmd) ? nCountUp : (oList.options.length - nCountUp -1));
					// style.color が存在する場合は、固定値なので、移動対象から除外する。
					var isSel = oList.options[nIndexUp].selected && !oList.options[nIndexUp].style.color ;
					var isNsel= !oList.options[nIndexUp + nInc].selected  && !oList.options[nIndexUp + nInc].style.color ;
					if( isSel && isNsel ) {
	//				if(oList.options[nIndexUp].selected) {
	//					if( !oList.options[nIndexUp + nInc].selected) {
						//	oList.options[nIndexUp + nInc].swapNode(oList.options[nIndexUp]);
							oBaseNade = ((nInc > 0) ? oList.options[nIndexUp] : oList.options[nIndexUp].nextSibling);
						//	insertBefore(removeChild(oList.options[nIndexUp + nInc]), oBaseNade);
							oList.insertBefore(oList.options[nIndexUp + nInc], oBaseNade);		// 7.3.1.2
	//					}
					}
				}
//			}
			break;
		case 3:
//			with (oList) {
				// Note : Begin from index 0
				nTotalLen = oList.options.length;			// 7.3.1.2 children→options
				var nCnst = 0;
				for( nCnst = 0; nCnst < nTotalLen; nCnst++ ) {
					if( !oList.options[nCnst].style.color ) { break; }		// 先頭の固定値を探す
				}
				nCountUp = nCnst;
		//		nCountUp = 0;
				nIndexUp = nTotalLen;
				while (nCountUp < nTotalLen) {
					nCountUp++;
					nIndexUp--;
					if(oList.options[nIndexUp].selected) {	// 7.3.1.2 children→options
				//		insertBefore(removeChild(oList.children[nIndexUp]), oList.children[0]);
						oList.insertBefore(oList.options[nIndexUp], oList.options[nCnst]);		// 7.3.1.2
						nIndexUp++;
					}
				}
//			}
			break;
		 case 4:
//			with (oList) {
				// Note : Begin from index 0
				nTotalLen = oList.options.length;			// 7.3.1.2 children→options
				var nCnst = 0;
				for( nCnst = 0; nCnst < nTotalLen; nCnst++ ) {
					if( !oList.options[nCnst].style.color ) { break; }		// 先頭の固定値を探す
				}
				nCountUp = nCnst;
				nIndexUp = nCnst -1 ;
		//		nCountUp = 0;
		//		nIndexUp = -1;
				while (nCountUp < nTotalLen) {
					nCountUp++;
					nIndexUp++;
					if(oList.options[nIndexUp].selected) {	// 7.3.1.2 children→options
				//		appendChild(removeChild(oList.children[nIndexUp]));
						oList.appendChild(oList.options[nIndexUp]);		// 7.3.1.2
						nIndexUp--;
					}
				}
//			}
			break;
		default:
			break;
	 }
}

/************************************************************/
/* 【廃止予定】												*/
/* makeCSV 要素リストからの取り出し(ogOpen JavaScript用)	*/
/*  listTo csv抜出対象のﾘｽﾄ									*/
/*  inText 結果を返す input ｵﾌﾞｼﾞｪｸﾄ						*/
/*  splt   csv結合時の文字列								*/
/*     今後は、og:popup を使ってください。					*/
/*     onClick="makeCSV(listTo,window.opener.document.getElementById( window.name ),'{@separator}'); window.close();"	*/
/************************************************************/
function makeCSV( listTo,inText,splt ) {
	var csvList ;

	if( inText == null ) { return; }

	csvList = "";
	if( listTo.length > 0 ) {
		csvList = listTo.options[0].value;

		// Note : Begin from index 1
		for( nidx=1; nidx < listTo.length; nidx++ ) {
			csvList += splt + listTo.options[nidx].value ;
		}
	}
	inText.value = csvList;
}

/************************************************************/
/* makeRtnCSV 要素リストからの取り出し(og:popup用)			*/
/*  listTo csv抜出対象のﾘｽﾄ									*/
/*  inText 結果を返す input ｵﾌﾞｼﾞｪｸﾄ						*/
/*  splt   csv結合時の文字列								*/
/*  return: 結合した文字列の Arrayｵﾌﾞｼﾞｪｸﾄ					*/
/*  onClick="rtnPopup(makeRtnCSV(listTo,'{@separator}'));"	*/
/************************************************************/
function makeRtnCSV( listTo,splt ) {
	csvList = "";
	if( listTo.length > 0 ) {
		csvList = listTo.options[0].value;

		// Note : Begin from index 1
		for( nidx=1; nidx < listTo.length; nidx++ ) {
			csvList += splt + listTo.options[nidx].value ;
		}
	}
	return new Array( csvList );
}

/************************************************************/
/* initOpts 要素リストの初期設定							*/
/*   oListFrom 移動元										*/
/*   oListTo   移動先										*/
/*   inVal     移動させる値									*/
/*   splt      csv分割時の文字列							*/
/*   cnstVals  固定値の値									*/
/*   color     固定値の文字色								*/
/************************************************************/
function initOpts(oListFrom, oListTo, inVals, splt, cnstVals, color ) {
	var vals , i ;

	// 先に固定値をセットしないと、色がつかない。
	if( cnstVals != null ) {
		var col = color ? color : "red" ;
		vals = cnstVals.split( splt );
		for ( i=0; i < vals.length; i++) {
			switchListOpts(oListFrom, oListTo, true , vals[i] , col );
		}
	}

	// 従来からのロジック
	if( inVals != null ) {
		vals = inVals.split( splt );
		for ( i=0; i < vals.length; i++) {
			switchListOpts(oListFrom, oListTo, true , vals[i] );
		}
	}
}
