/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.filter.GZIPResponseWrapper;

public class GZIPFilter
implements Filter {
    private String[] ipaddrArray;
    private boolean isDebug;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            if (this.isFiltering(httpServletRequest)) {
                GZIPResponseWrapper gZIPResponseWrapper = new GZIPResponseWrapper(httpServletResponse);
                filterChain.doFilter(servletRequest, (ServletResponse)gZIPResponseWrapper);
                gZIPResponseWrapper.finishResponse();
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private boolean isFiltering(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        String string = httpServletRequest.getHeader("accept-encoding");
        String string2 = httpServletRequest.getRequestURI();
        String string3 = httpServletRequest.getRemoteAddr();
        if (string != null && string.indexOf("gzip") >= 0 && (string2.endsWith(".jsp") || string2.endsWith(".js") || string2.endsWith(".css"))) {
            for (int i = 0; i < this.ipaddrArray.length; ++i) {
                if (!string3.startsWith(this.ipaddrArray[i])) continue;
                bl = true;
                break;
            }
        }
        if (this.isDebug) {
            System.out.println("[Filtering " + bl + "]");
            System.out.println("  IP Address :" + string3);
            System.out.println("  Request URI:" + string2);
        }
        return bl;
    }

    public void init(FilterConfig filterConfig) {
        this.ipaddrArray = StringUtil.csv2Array((String)filterConfig.getInitParameter("ipAddress"));
        this.isDebug = Boolean.parseBoolean(filterConfig.getInitParameter("debug"));
    }

    public void destroy() {
    }
}

