/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.io.File;
import java.util.function.Supplier;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.model.FileOperationFactory;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public final class HybsFileOperationFactory {
    private static String PLUGIN = HybsSystem.sys("CLOUD_TARGET");
    private static String BUCKET = HybsSystem.sys("CLOUD_BUCKET");

    private HybsFileOperationFactory() {
    }

    public static FileOperation create(String string) {
        return FileOperationFactory.newStorageOperation((String)PLUGIN, (String)BUCKET, (String)string);
    }

    public static FileOperation create(String string, String string2) {
        return FileOperationFactory.newStorageOperation((String)PLUGIN, (String)BUCKET, (String)string, (String)string2);
    }

    public static FileOperation create(File file, String string) {
        return HybsFileOperationFactory.create(new File(file, string).getPath());
    }

    public static FileOperation create(String string, String string2, String string3) {
        return FileOperationFactory.newStorageOperation((String)StringUtil.nval((String)string, (String)PLUGIN), (String)StringUtil.nval((String)string2, (String)BUCKET), (String)string3);
    }

    public static FileOperation create(String string, String string2, File file, String string3) {
        return HybsFileOperationFactory.create(string, string2, new File(file, string3).getPath());
    }

    public static FileOperation create(String string, String string2, String string3, String string4) {
        return HybsFileOperationFactory.create(string, string2, new File(string3, string4).getPath());
    }

    public static boolean useCloud() {
        return !StringUtil.isNull((CharSequence[])new CharSequence[]{PLUGIN, BUCKET});
    }

    public static void local2cloud(Supplier<File> supplier) {
        if (HybsFileOperationFactory.useCloud()) {
            File file = supplier.get();
            FileOperation fileOperation = HybsFileOperationFactory.create(file.getPath());
            FileUtil.copy((File)file, (File)fileOperation);
            file.delete();
        }
    }

    public static void cloud2local(Supplier<File> supplier) {
        if (HybsFileOperationFactory.useCloud()) {
            File file = supplier.get();
            FileOperation fileOperation = HybsFileOperationFactory.create(file.getPath());
            file.delete();
            File file2 = file.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            FileUtil.copy((File)fileOperation, (File)file);
            fileOperation.delete();
        }
    }

    public static FileOperation createDir(String string, String string2, String string3) {
        FileOperation fileOperation = HybsFileOperationFactory.create(string, string2, string3);
        if (!HybsFileOperationFactory.useCloud()) {
            if (!fileOperation.exists() && !fileOperation.mkdirs()) {
                throw new IllegalArgumentException("Not make directory: " + string3);
            }
            if (!fileOperation.isDirectory()) {
                throw new IllegalArgumentException("Not a directory: " + string3);
            }
            if (!fileOperation.canWrite()) {
                throw new IllegalArgumentException("Not writable: " + string3);
            }
        }
        return fileOperation;
    }
}

