/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.cloud;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.util.StringUtil;

public abstract class CloudFileOperation
extends FileOperation {
    private static final String VERSION = "8.0.0.1 (2021/10/08)";
    private static final long serialVersionUID = 800120211008L;
    private static final int BUFFER_SIZE = 4096;
    private static final String UNIMPLEMNTED_ERR = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u672a\u5b9f\u88c5\u306e\u30e1\u30bd\u30c3\u30c9\u3067\u3059\u3002";
    private static final char FS = '/';
    private static final Pattern PTN_PRE_DIR = Pattern.compile("(?<=/|^)[^/]+/\\.\\./");
    protected final String conPath;
    protected final String conBucket;

    public CloudFileOperation(String string, String string2) {
        super(string2);
        this.conPath = this.editPath(this.replaceFileSeparetor(string2));
        this.conBucket = string;
        if (StringUtil.isNull((CharSequence[])new CharSequence[]{this.conBucket})) {
            throw new RuntimeException("\u30d0\u30b1\u30c3\u30c8\u672a\u6307\u5b9a\u3067\u3059\u3002hayabusa\u5229\u7528\u3067\u306f\u30b7\u30b9\u30c6\u30e0\u5909\u6570\u306e\u300cCLOUD_BUCKET\u300d\u306b\u30d0\u30b1\u30c3\u30c8\u540d\u3092\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002");
        }
    }

    public abstract void write(File var1) throws IOException;

    public abstract void write(InputStream var1) throws IOException;

    public abstract InputStream read() throws FileNotFoundException;

    public abstract boolean delete();

    public abstract boolean copy(String var1);

    public boolean move(String string) {
        return this.copy(string) && this.delete();
    }

    public abstract long length();

    public abstract long lastModified();

    public abstract boolean isFile();

    public abstract boolean isDirectory();

    public abstract File[] listFiles(FileFilter var1);

    public abstract File getParentFile();

    public String getPath() {
        return this.conPath;
    }

    public String getAbsolutePath() {
        return this.conPath;
    }

    public String getName() {
        return this.drawName(this.conPath);
    }

    public String getParent() {
        return this.drawParent(this.conPath);
    }

    public boolean exists() {
        return this.isDirectory() | this.isFile();
    }

    public boolean mkdir() {
        return true;
    }

    public boolean mkdirs() {
        return true;
    }

    public boolean renameTo(File file) {
        return this.move(file.getPath());
    }

    public boolean canWrite() {
        return this.exists();
    }

    public boolean canRead() {
        return this.exists();
    }

    public boolean isHidden() {
        return false;
    }

    public boolean createNewFile() throws IOException {
        boolean bl = false;
        if (!this.exists()) {
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                this.write(byteArrayInputStream);
                bl = true;
            }
            catch (Throwable throwable) {
                Closer.ioClose(byteArrayInputStream);
                throw throwable;
            }
            Closer.ioClose((Closeable)byteArrayInputStream);
        }
        return bl;
    }

    public boolean setLastModified(long l) {
        return true;
    }

    public FileOperation getCanonicalFile() throws IOException {
        return this;
    }

    public String toString() {
        return this.conPath;
    }

    private String editPath(String string) {
        if (StringUtil.isNull((CharSequence[])new CharSequence[]{string})) {
            return "";
        }
        String string2 = string;
        if ('/' == (string2 = string2.replaceAll("//+", "/")).charAt(0)) {
            string2 = string2.substring(1);
        }
        string2 = this.rTrim(string2, '.');
        string2 = this.rTrim(string2, '/');
        Matcher matcher = PTN_PRE_DIR.matcher(string2);
        while (matcher.find()) {
            string2 = matcher.replaceFirst("");
            matcher = PTN_PRE_DIR.matcher(string2);
        }
        return string2;
    }

    private String drawParent(String string) {
        int n = string.lastIndexOf(47);
        Object object = "";
        if (n > 0) {
            object = string.substring(0, string.lastIndexOf(47));
        }
        if ("/".equals(File.separator)) {
            object = File.separator + (String)object;
        }
        return object;
    }

    private String drawName(String string) {
        int n = string.lastIndexOf(47);
        String string2 = string;
        if (n > 0) {
            string2 = string.substring(string.lastIndexOf(47) + 1);
        }
        return string2;
    }

    protected String setDirTail(String string) {
        if (StringUtil.isNull((CharSequence[])new CharSequence[]{string})) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        if ('/' != string.charAt(string.length() - 1)) {
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    protected String rTrim(String string, char c) {
        String string2 = string;
        int n = 0;
        for (int i = string.length() - 1; i >= 0 && string.charAt(i) == c; --i) {
            n = i;
            if (n != 0) continue;
            string2 = "";
        }
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private String replaceFileSeparetor(String string) {
        if (StringUtil.isNull((CharSequence[])new CharSequence[]{string})) {
            return "";
        }
        return string.replaceAll("\\\\", "/");
    }

    protected File[] filter(List<File> list, FileFilter fileFilter) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : list) {
            if (!fileFilter.accept(file)) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] toByteArray(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }

    public boolean isCloud() {
        return true;
    }

    public boolean canExecute() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    public void deleteOnExit() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    public File getAbsoluteFile() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    public long getFreeSpace() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    public long getTotalSpace() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    public long getUsableSpace() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    public boolean isAbsolute() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    public boolean setReadable(boolean bl) {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    public boolean setReadable(boolean bl, boolean bl2) {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    public boolean setWritable(boolean bl) {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    public boolean setWritable(boolean bl, boolean bl2) {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }

    public URI toURI() {
        throw new RuntimeException(UNIMPLEMNTED_ERR);
    }
}

