/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import org.opengion.fukurou.model.NativeType;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.DBType;
import org.opengion.hayabusa.db.DBTypeCheckUtil;

public abstract class AbstractDBType
implements DBType {
    private final String defValue;
    protected static final String CR = HybsConst.CR;
    protected static final int BUFFER_MIDDLE = 200;

    public AbstractDBType() {
        this("");
    }

    public AbstractDBType(String string) {
        this.defValue = string;
    }

    @Override
    public NativeType getNativeType() {
        return NativeType.STRING;
    }

    @Override
    public String valueFill(String string, int n, int n2, String string2) {
        int n3 = n2 == 0 ? n : n + n2 + 1;
        return StringUtil.stringFill((String)string, (int)n3, (String)string2);
    }

    @Override
    public String getDefault() {
        return this.defValue;
    }

    @Override
    public String valueAdd(String string) {
        if (string == null || string.isEmpty()) {
            return this.getDefault();
        }
        char[] cArray = string.toCharArray();
        for (int i = cArray.length - 1; i >= 0; --i) {
            boolean bl = true;
            switch (cArray[i]) {
                case '9': {
                    cArray[i] = 48;
                    break;
                }
                case 'z': {
                    cArray[i] = 97;
                    break;
                }
                case 'Z': {
                    cArray[i] = 65;
                    break;
                }
                case '\uff19': {
                    cArray[i] = 65296;
                    break;
                }
                case '\uff5a': {
                    cArray[i] = 65345;
                    break;
                }
                case '\uff3a': {
                    cArray[i] = 65313;
                    break;
                }
                default: {
                    int n = i;
                    cArray[n] = (char)(cArray[n] + '\u0001');
                    bl = false;
                }
            }
            if (!bl) break;
        }
        return new String(cArray);
    }

    @Override
    public String valueAdd(String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            return this.valueAdd(string);
        }
        String string3 = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u3001\u5f15\u6570\u4ed8\u306e\u4efb\u610f\u306e\u52a0\u7b97\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + this.getClass().getName() + " Action=[ADD] oldValue=[" + string + "] newValue=[" + string2 + "]";
        throw new UnsupportedOperationException(string3);
    }

    @Override
    public String valueSet(String string) {
        return StringUtil.rTrim((String)string);
    }

    @Override
    public String valueAction(String string, String string2, String string3) {
        String string4 = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u3001\u3053\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + this.getClass().getName() + " Action=[" + string + "] oldValue=[" + string2 + "] newValue=[" + string3 + "]";
        throw new UnsupportedOperationException(string4);
    }

    @Override
    public ErrorMessage valueCheck(String string, String string2, int n, int n2, String string3, boolean bl) {
        int n3;
        int n4;
        ErrorMessage errorMessage = new ErrorMessage();
        if (string2 == null || string2.isEmpty()) {
            return errorMessage;
        }
        int n5 = n4 = n2 == 0 ? n : n + n2 + 1;
        if (n4 < string2.length()) {
            errorMessage.addMessage(0, 2, "ERR0006", new String[]{string, string2, String.valueOf(string2.length()), String.valueOf(n4)});
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        boolean bl2 = false;
        for (int i = 0; i < string2.length(); ++i) {
            n3 = string2.charAt(i);
            if (n3 < 32 || n3 > 126) {
                stringBuilder.append("<span class=\"NG\">").append((char)n3).append("</span>");
                bl2 = true;
                continue;
            }
            stringBuilder.append((char)n3);
        }
        if (bl2) {
            errorMessage.addMessage(0, 2, "ERR0009", new String[]{string, stringBuilder.toString()});
        }
        if (string3 != null) {
            String string4;
            String string5 = string3;
            n3 = string3.indexOf("class=");
            if (n3 >= 0) {
                int n6 = string5.indexOf(";", n3);
                string5 = n6 >= 0 ? string5.replaceAll(string5.substring(n3, n6 + 1), "") : string5.substring(0, n3);
            }
            if ((string4 = DBTypeCheckUtil.matcheCheck(string2, string5)) != null) {
                errorMessage.addMessage(0, 2, "ERR0009", new String[]{string, string4});
            }
        }
        errorMessage = this.xssCheck(string, string2, errorMessage);
        return errorMessage;
    }

    protected ErrorMessage xssCheck(String string, String string2, ErrorMessage errorMessage) {
        StringBuilder stringBuilder = new StringBuilder(200);
        boolean bl = false;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '<' || c == '>') {
                stringBuilder.append("<span class=\"NG\">").append(c).append("</span>");
                bl = true;
                continue;
            }
            stringBuilder.append(c);
        }
        if (bl) {
            String string3 = this.getClass().getSimpleName();
            errorMessage.addMessage(0, 2, "ERR0010", new String[]{string, stringBuilder.toString(), string3, "<,>"});
        }
        return errorMessage;
    }
}

