/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.HybsDateUtil;

public final class DBUpdater {
    private final PreparedStatement pstmt;
    private final boolean usePMeta;
    private final int[] types;
    private final boolean[] isTime;
    private final boolean useSelect;
    private int rowCnt;
    private int updCnt;

    public DBUpdater(int n, PreparedStatement preparedStatement) {
        this(n, preparedStatement, true);
    }

    public DBUpdater(int n, PreparedStatement preparedStatement, boolean bl) {
        this(n, preparedStatement, bl, null);
    }

    public DBUpdater(int n, PreparedStatement preparedStatement, boolean bl, boolean[] blArray) {
        this(n, preparedStatement, bl, blArray, false);
    }

    public DBUpdater(int n, PreparedStatement preparedStatement, boolean bl, boolean[] blArray, boolean bl2) {
        this.usePMeta = bl;
        this.pstmt = preparedStatement;
        this.isTime = blArray;
        this.useSelect = bl2;
        if (bl) {
            this.types = new int[n];
            try {
                ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
                for (int i = 0; i < n; ++i) {
                    this.types[i] = parameterMetaData.getParameterType(i + 1);
                }
            }
            catch (SQLException sQLException) {
                throw new OgRuntimeException("ParameterMetaData \u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", sQLException);
            }
        } else {
            this.types = null;
        }
    }

    public void execute(String[] stringArray) throws SQLException {
        if (stringArray != null && stringArray.length > 0) {
            ++this.rowCnt;
            if (this.usePMeta) {
                for (var2_2 = 0; var2_2 < stringArray.length; ++var2_2) {
                    String string = stringArray[var2_2];
                    if (string == null || string.isEmpty()) {
                        this.pstmt.setNull(var2_2 + 1, this.types[var2_2]);
                        continue;
                    }
                    this.pstmt.setObject(var2_2 + 1, (Object)string, this.types[var2_2]);
                }
            } else if (this.isTime == null) {
                for (var2_2 = 0; var2_2 < stringArray.length; ++var2_2) {
                    String string = stringArray[var2_2];
                    this.pstmt.setObject(var2_2 + 1, string);
                }
            } else {
                for (var2_2 = 0; var2_2 < stringArray.length; ++var2_2) {
                    String string = stringArray[var2_2];
                    if (this.isTime[var2_2] && string != null && !string.isEmpty()) {
                        Timestamp timestamp = Timestamp.valueOf(HybsDateUtil.parseTimestamp(string));
                        this.pstmt.setObject(var2_2 + 1, timestamp);
                        continue;
                    }
                    this.pstmt.setObject(var2_2 + 1, string);
                }
            }
            this.pstmt.addBatch();
            if (this.rowCnt % 100 == 0) {
                int[] nArray = this.pstmt.executeBatch();
                this.updCnt += nArray.length;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int update(String[] stringArray) throws SQLException {
        int n = 0;
        if (stringArray == null) return n;
        if (stringArray.length <= 0) return n;
        ++this.rowCnt;
        if (this.usePMeta) {
            for (var3_3 = 0; var3_3 < stringArray.length; ++var3_3) {
                var4_5 = stringArray[var3_3];
                if (var4_5 == null || var4_5.isEmpty()) {
                    this.pstmt.setNull(var3_3 + 1, this.types[var3_3]);
                    continue;
                }
                this.pstmt.setObject(var3_3 + 1, (Object)var4_5, this.types[var3_3]);
            }
        } else if (this.isTime == null) {
            for (var3_3 = 0; var3_3 < stringArray.length; ++var3_3) {
                var4_5 = stringArray[var3_3];
                this.pstmt.setObject(var3_3 + 1, var4_5);
            }
        } else {
            for (var3_3 = 0; var3_3 < stringArray.length; ++var3_3) {
                var4_5 = stringArray[var3_3];
                if (this.isTime[var3_3] && var4_5 != null && !var4_5.isEmpty()) {
                    Timestamp timestamp = Timestamp.valueOf(HybsDateUtil.parseTimestamp(var4_5));
                    this.pstmt.setObject(var3_3 + 1, timestamp);
                    continue;
                }
                this.pstmt.setObject(var3_3 + 1, var4_5);
            }
        }
        if (!this.useSelect) return this.pstmt.executeUpdate();
        try (ResultSet resultSet = this.pstmt.executeQuery();){
            if (!resultSet.next()) return n;
            n = resultSet.getInt(1);
            return n;
        }
    }

    public int execEnd() throws SQLException {
        int[] nArray = this.pstmt.executeBatch();
        this.updCnt += nArray.length;
        return this.updCnt;
    }
}

