/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.ResultSetValue;
import org.opengion.fukurou.fileexec.XLogger;
import org.opengion.fukurou.system.HybsConst;

public final class DBUtil {
    private static final XLogger LOGGER = XLogger.getLogger(DBUtil.class.getSimpleName());
    public static final String DATABASE_KEY = "DATABASE";
    public static final String URL_KEY = "REALM_URL";
    public static final String DRIVER_KEY = "REALM_DRIVER";
    public static final String NAME_KEY = "REALM_NAME";
    public static final String PASSWORD_KEY = "REALM_PASSWORD";
    public static final int CONN_SLEEP_TIME = 2000;
    public static final int CONN_RETRY_COUNT = 10;
    public static final int CONN_VALID_TIMEOUT = 10;
    public static final int DB_FETCH_SIZE = 251;
    private static final DataSource DATA_SOURCE = new DataSource();
    private static boolean readyFlag;
    private static boolean oracleFlag;
    private static final int BUFFER_MIDDLE = 200;

    private DBUtil() {
    }

    public static void init() {
        DBUtil.init(HybsConst.getenv(URL_KEY), HybsConst.getenv(DRIVER_KEY), HybsConst.getenv(NAME_KEY), HybsConst.getenv(PASSWORD_KEY));
    }

    public static void init(Map<String, String> map) {
        DBUtil.init(map.getOrDefault(URL_KEY, HybsConst.getenv(URL_KEY)), map.getOrDefault(DRIVER_KEY, HybsConst.getenv(DRIVER_KEY)), map.getOrDefault(NAME_KEY, HybsConst.getenv(NAME_KEY)), map.getOrDefault(PASSWORD_KEY, HybsConst.getenv(PASSWORD_KEY)));
    }

    public static void init(String ... stringArray) {
        if (readyFlag) {
            throw MsgUtil.throwException("MSG0024", DATA_SOURCE);
        }
        if (stringArray == null || stringArray.length != 4) {
            throw MsgUtil.throwException("MSG0027", Arrays.toString(stringArray));
        }
        PoolProperties poolProperties = new PoolProperties();
        poolProperties.setUrl(stringArray[0]);
        poolProperties.setDriverClassName(stringArray[1]);
        poolProperties.setUsername(stringArray[2]);
        poolProperties.setPassword(stringArray[3]);
        DATA_SOURCE.setPoolProperties((PoolConfiguration)poolProperties);
        readyFlag = true;
        oracleFlag = stringArray[0] != null && stringArray[0].startsWith("jdbc:oracle");
    }

    public static boolean isReady() {
        return readyFlag;
    }

    public static boolean isOracle() {
        return oracleFlag;
    }

    public static Connection getConnection() throws SQLException {
        if (!readyFlag) {
            DBUtil.init();
        }
        Throwable throwable = null;
        for (int i = 0; i < 10; ++i) {
            try {
                Connection connection = DATA_SOURCE.getConnection();
                connection.setAutoCommit(false);
                if (!connection.isValid(10)) continue;
                return connection;
            }
            catch (SQLException sQLException) {
                if (i >= 3) {
                    MsgUtil.errPrintln("MSG0019", sQLException.getMessage(), "");
                }
                throwable = sQLException;
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        String string = throwable == null ? "COUNT Over" : throwable.getMessage();
        throw MsgUtil.throwException(throwable, "MSG0019", string, "getConnection");
    }

    private static void setObject(PreparedStatement preparedStatement, String[] stringArray, ParameterMetaData parameterMetaData) throws SQLException {
        block5: {
            if (stringArray == null || stringArray.length <= 0) break block5;
            if (parameterMetaData == null) {
                int n = 1;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    preparedStatement.setObject(n++, string);
                }
            } else {
                int n = 1;
                for (int i = 0; i < stringArray.length; ++i) {
                    int n2 = parameterMetaData.getParameterType(n);
                    String string = stringArray[i];
                    if (string == null || string.isEmpty()) {
                        preparedStatement.setNull(n++, n2);
                        continue;
                    }
                    preparedStatement.setObject(n++, (Object)string, n2);
                }
            }
        }
    }

    public static int execute(String string, String ... stringArray) {
        int n = 0;
        try (Connection connection = DBUtil.getConnection();){
            try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
                ParameterMetaData parameterMetaData = oracleFlag ? null : preparedStatement.getParameterMetaData();
                DBUtil.setObject(preparedStatement, stringArray, parameterMetaData);
                n = preparedStatement.executeUpdate();
                connection.commit();
            }
            catch (SQLException sQLException) {
                connection.rollback();
                connection.setAutoCommit(true);
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            throw MsgUtil.throwException(sQLException, "MSG0019", string, Arrays.toString(stringArray));
        }
        return n;
    }

    public static int execute(Transaction transaction, String string, String ... stringArray) {
        int n = 0;
        Connection connection = transaction.getConnection(null);
        try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
            ParameterMetaData parameterMetaData = oracleFlag ? null : preparedStatement.getParameterMetaData();
            DBUtil.setObject(preparedStatement, stringArray, parameterMetaData);
            n = preparedStatement.executeUpdate();
            transaction.commit();
        }
        catch (SQLException sQLException) {
            transaction.rollback();
            throw MsgUtil.throwException(sQLException, "MSG0019", string, Arrays.toString(stringArray));
        }
        return n;
    }

    public static int execute(String string, List<String[]> list) {
        return DBUtil.execute(string, list, true);
    }

    public static int execute(String string, List<String[]> list, boolean bl) {
        LOGGER.debug(() -> "execute query=" + string);
        Object[] objectArray = null;
        int n = 0;
        try (Connection connection = DBUtil.getConnection();){
            try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
                ParameterMetaData parameterMetaData = oracleFlag ? null : preparedStatement.getParameterMetaData();
                Iterator<String[]> iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray2;
                    objectArray = objectArray2 = iterator.next();
                    LOGGER.debug(() -> DBUtil.lambda$execute$1((String[])objectArray2));
                    DBUtil.setObject(preparedStatement, (String[])objectArray2, parameterMetaData);
                    try {
                        n += preparedStatement.executeUpdate();
                    }
                    catch (SQLIntegrityConstraintViolationException sQLIntegrityConstraintViolationException) {
                        if (bl) {
                            throw sQLIntegrityConstraintViolationException;
                        }
                        MsgUtil.errPrintln("MSG0033", sQLIntegrityConstraintViolationException.getMessage(), string, Arrays.toString(objectArray));
                    }
                }
                connection.commit();
            }
            catch (SQLException sQLException) {
                connection.rollback();
                connection.setAutoCommit(true);
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            throw MsgUtil.throwException(sQLException, "MSG0019", string, Arrays.toString(objectArray));
        }
        return n;
    }

    public static int execute(String string, String string2, List<String[]> list, List<String[]> list2) {
        return DBUtil.execute(string, string2, list, list2, true);
    }

    public static int execute(String string, String string2, List<String[]> list, List<String[]> list2, boolean bl) {
        LOGGER.debug(() -> "execute insQuery=" + string + " , updQuery=" + string2);
        Object[] objectArray = null;
        String string3 = null;
        int n = 0;
        try (Connection connection = DBUtil.getConnection();){
            try (PreparedStatement preparedStatement = connection.prepareStatement(string);
                 PreparedStatement preparedStatement2 = connection.prepareStatement(string2);){
                ParameterMetaData parameterMetaData = oracleFlag ? null : preparedStatement.getParameterMetaData();
                ParameterMetaData parameterMetaData2 = oracleFlag ? null : preparedStatement2.getParameterMetaData();
                for (int i = 0; i < list2.size(); ++i) {
                    Object[] objectArray2;
                    string3 = string2;
                    objectArray = objectArray2 = list2.get(i);
                    DBUtil.setObject(preparedStatement2, (String[])objectArray2, parameterMetaData2);
                    int n2 = preparedStatement2.executeUpdate();
                    if (n2 <= 0) {
                        string3 = string;
                        String[] stringArray = list.get(i);
                        objectArray = stringArray;
                        DBUtil.setObject(preparedStatement, stringArray, parameterMetaData);
                        LOGGER.debug(() -> "execute INSERT=" + Arrays.toString(stringArray));
                        try {
                            n2 = preparedStatement.executeUpdate();
                        }
                        catch (SQLIntegrityConstraintViolationException sQLIntegrityConstraintViolationException) {
                            if (bl) {
                                throw sQLIntegrityConstraintViolationException;
                            }
                            n2 = 0;
                            MsgUtil.errPrintln("MSG0033", sQLIntegrityConstraintViolationException.getMessage(), string, Arrays.toString(objectArray));
                        }
                    } else {
                        LOGGER.debug(() -> DBUtil.lambda$execute$4((String[])objectArray2));
                    }
                    n += n2;
                }
                connection.commit();
            }
            catch (SQLException sQLException) {
                connection.rollback();
                connection.setAutoCommit(true);
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            throw MsgUtil.throwException(sQLException, "MSG0019", string3, Arrays.toString(objectArray));
        }
        return n;
    }

    /*
     * Exception decompiling
     */
    public static List<String[]> dbQuery(String var0, String ... var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String[]> dbQuery(Transaction transaction, String string, String ... stringArray) {
        Connection connection = transaction.getConnection(null);
        try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
            ParameterMetaData parameterMetaData = oracleFlag ? null : preparedStatement.getParameterMetaData();
            DBUtil.setObject(preparedStatement, stringArray, parameterMetaData);
            if (preparedStatement.execute()) {
                try (ResultSet resultSet = preparedStatement.getResultSet();){
                    List<String[]> list = DBUtil.resultToArray(resultSet);
                    return list;
                }
            }
            transaction.commit();
            return new ArrayList<String[]>();
        }
        catch (SQLException sQLException) {
            transaction.rollback();
            throw MsgUtil.throwException(sQLException, "MSG0019", string, Arrays.toString(stringArray));
        }
    }

    public static List<String[]> resultToArray(ResultSet resultSet) throws SQLException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ResultSetValue resultSetValue = new ResultSetValue(resultSet);
        while (resultSetValue.next()) {
            arrayList.add(resultSetValue.getValues());
        }
        return arrayList;
    }

    public static String getInsertSQL(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        Object[] objectArray = new String[stringArray.length];
        Arrays.fill(objectArray, "?");
        boolean bl = stringArray2 != null && stringArray3 != null && stringArray2.length == stringArray3.length && stringArray2.length > 0;
        StringBuilder stringBuilder = new StringBuilder(200).append("INSERT INTO ").append(string).append(" ( ").append(String.join((CharSequence)",", stringArray));
        if (bl) {
            stringBuilder.append(',').append(String.join((CharSequence)",", stringArray2));
        }
        stringBuilder.append(" ) VALUES ( ").append(String.join((CharSequence)",", (CharSequence[])objectArray));
        if (bl) {
            stringBuilder.append(",'").append(String.join((CharSequence)"','", stringArray3)).append('\'');
        }
        return stringBuilder.append(" )").toString();
    }

    public static String getUpdateSQL(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String string2) {
        boolean bl = stringArray2 != null && stringArray3 != null && stringArray2.length == stringArray3.length && stringArray2.length > 0;
        StringBuilder stringBuilder = new StringBuilder(200).append("UPDATE ").append(string).append(" SET ");
        for (String string3 : stringArray) {
            stringBuilder.append(string3);
            if (!string3.contains("?")) {
                stringBuilder.append(" = ? ");
            }
            stringBuilder.append(',');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        if (bl) {
            for (int i = 0; i < stringArray2.length; ++i) {
                stringBuilder.append(',').append(stringArray2[i]).append(" = '").append(stringArray3[i]).append("' ");
            }
        }
        if (string2 != null && !string2.isEmpty()) {
            stringBuilder.append(" WHERE ").append(string2);
        }
        return stringBuilder.toString();
    }

    public static String getDeleteSQL(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(200).append("DELETE FROM ").append(string);
        if (string2 != null && !string2.isEmpty()) {
            stringBuilder.append(" WHERE ").append(string2);
        }
        return stringBuilder.toString();
    }

    private static /* synthetic */ String lambda$execute$4(String[] stringArray) {
        return "execute UPDATE=" + Arrays.toString(stringArray);
    }

    private static /* synthetic */ String lambda$execute$1(String[] stringArray) {
        return "execute values=" + Arrays.toString(stringArray);
    }
}

