<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC16"
	title	= "JSPファイル一覧"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- テキスト索引の同期化 は、とりあえず毎回実行しておきます。(良い方法があれば、教えて) -->
<!--
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.SYNC_INDEX( 'GF76_TXT_IDX' ) }
</og:query>
-->
<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select ADDRESS,FILENAME,TAGNAME,TITLE,VERNO,MODIFYDATE,
				AUTHOR,TEXTBODY,MODIFIED,FILEPATH,FGOMIT,DYUPD,USRUPD,PGUPD,FGJ,UNIQ,SYSTEM_ID,TBLSYU
				<og:text caseNN="{@TEXT_DATA}">,CTX_DOC.SNIPPET('GF76_TXT_IDX',UNIQ,'{@TEXT_DATA}') AS SNIPPET</og:text>
		from GF76
		where SYSTEM_ID = '{@SYSTEM_ID}'
		and   TBLSYU    = '{@TBLSYU}'
		and   FGJ       in  ('0','1')
	<og:where startKey = "and" >
		<og:and value = "FGOMIT		= '{@FGOMIT}'"			/>
		<og:and value = "ADDRESS	like '{@ADDRESS}'"		/>
		<og:and value = "FILENAME	like '{@FILENAME}'"	/>
		<og:and value = "TAGNAME	like '{@TAGNAME}'"		/>
		<og:and value = "MODIFIED {@CONDITION} '{@MODIFIED}'" />
		<og:and value = "MODIFYDATE	like '{@MODIFYDATE}'"	/>
		<og:and value = "AUTHOR		like '{@AUTHOR}'"		/>
		<og:and value = "TITLE		like '{@TITLE}'"		/>
		<og:and value = "TEXTBODY	like '{@TEXTBODY}'"	/>
		<og:and value = "VERNO		like '{@VERNO}'"		/>
		<og:and value = "CONTAINS ( FILEPATH, '{@TEXT_DATA}' ,1) &gt; 0" />
	</og:where>
		order by ADDRESS,FILENAME,MODIFIED
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="FILENAME" href="[FILEPATH]" target="_blank" type="text/plain" useGamenId="false" />
</og:viewLink>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT">

	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:submit  action="MODIFY" lbl="OMIT" />
		<og:submit  action="DELETE" />
		<br />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

	<og:view
		viewFormType = "HTMLTable"
		command    = "{@command}"
		noDisplay  = "FGJ,UNIQ,SYSTEM_ID,TBLSYU"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
	/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
