<jsp:directive.page pageEncoding="UTF-8" />
<!-- PostgreSQL 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="POSTGRES">
	<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select TABLENAME AS TABLE_NAME ,TABLENAME AS NAME_JA,
				0 AS JKENSU,1000 AS SKENSU,TABLESPACE AS TABLESPACE_NAME,
				0 AS INITIAL_EXTENT,'' AS COMMENTS,
				'{@TBLSYU}' TBLSYU,'{@SYSTEM_ID}' SYSTEM_ID
		from pg_tables
		<og:where>
			<og:and value = "TABLENAME like '{@TABLE_NAME}'" />
			<og:and value = "SCHEMANAME = 'public'" />
		</og:where>
		order by TABLENAME
	</og:query>
</og:equals>

<!-- ORACLE 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
	<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select A.TABLE_NAME,COALESCE(B.COMMENTS,A.TABLE_NAME) AS NAME_JA,
				COALESCE(A.NUM_ROWS,0) AS JKENSU,1000 AS SKENSU,A.TABLESPACE_NAME,
				A.INITIAL_EXTENT/1024 AS INITIAL_EXTENT,
				'' AS COMMENTS,
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from USER_TABLES A left outer join USER_TAB_COMMENTS B
				on A.TABLE_NAME = B.TABLE_NAME
		<og:where>
			<og:and value = "A.TABLE_NAME like '{@TABLE_NAME}'" />
			<og:and value = "INSTR(A.TABLE_NAME,'$') < 1" />
		</og:where>
		order by A.TABLE_NAME
	</og:query>
</og:equals>

<!-- FIREBIRD 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
	<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select trim(RDB$RELATION_NAME) AS TABLE_NAME,trim(RDB$RELATION_NAME) AS NAME_JA,
				0 AS JKENSU,1000 AS SKENSU,'XX' AS TABLESPACE_NAME,
				0 AS INITIAL_EXTENT,
				'' AS COMMENTS,
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from RDB$RELATIONS
		where RDB$SYSTEM_FLAG   = 0
		and   RDB$RELATION_TYPE = 0
		<og:where startKey="and">
			<og:and value = "RDB$RELATION_NAME like '{@TABLE_NAME}'" />
		</og:where>
		order by RDB$RELATION_NAME
	</og:query>
</og:equals>

<!-- MySQL 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="MYSQL">
	<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select TABLE_NAME,
				case when length(TABLE_COMMENT) = 0 then TABLE_NAME
					 else TABLE_COMMENT end AS NAME_JA,
				TABLE_ROWS AS JKENSU,1000 AS SKENSU,TABLE_SCHEMA AS TABLESPACE_NAME,
				0 AS INITIAL_EXTENT,
				TABLE_COMMENT AS COMMENTS,
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from information_schema.tables
		where table_schema=database()
		and   TABLE_TYPE = 'BASE TABLE'
		<og:where startKey="and">
			<og:and value = "TABLE_NAME like '{@TABLE_NAME}'" />
		</og:where>
		order by TABLE_NAME
	</og:query>
</og:equals>

<!-- DERBY 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="DERBY">
	<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select A.TABLENAME as TABLE_NAME,A.TABLENAME AS NAME_JA,
				0 AS JKENSU,1000 AS SKENSU,'XX' AS TABLESPACE_NAME,
				0 AS INITIAL_EXTENT,
				'' AS COMMENTS,
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from SYS.SYSTABLES A left outer join SYS.SYSSCHEMAS B
			on A.SCHEMAID = B.SCHEMAID
		<og:where>
			<og:and value = "A.TABLENAME  like '{@TABLE_NAME}'" />
		</og:where>
		order by TABLENAME
	</og:query>
</og:equals>

<!-- POSTGRES,ORACLE,FIREBIRD,MYSQL 以外の場合 -->
<og:equals val1="POSTGRES,ORACLE,FIREBIRD,MYSQL" val2="{@DBF.NAME @DBID}" contains="true" notEquals="true">
	<!-- GFE0009 : {0} は、{1} のデータベースに対応していません。 -->
	<og:message lbl="GFE0009" val0="{@LBL.GF2010}" val1="{@DBF.NAME @DBID}" />
</og:equals>

<!-- NAME_JA にリソースを適用します。 -->
<og:equals val1="{@USE_RESOURCE}" val2="true">
	<og:tableFilter classId="LABEL" keys="SYSTEM_ID,CLM,LBL" vals="{@SYSTEM_ID},TABLE_NAME,NAME_JA" />
</og:equals>
