<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result"  useChartJSV3="true" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7301"
	title	= "横棒／縦棒グラフ"
	date	= "2012/05/09"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<og:query command="NEW" stopZero="{@stopZero}">
	SELECT 	 ENAME												<!-- 営業担当者 -->
			,ROUND( SAL / 2   * DBMS_RANDOM.VALUE ) as SAL1		<!-- 売上( 1月) -->
			,ROUND( SAL / 2.5 * DBMS_RANDOM.VALUE ) as SAL2		<!-- 売上( 2月) -->
			,ROUND( 30 * DBMS_RANDOM.VALUE ) as BBL_R			<!-- bubbleの半径) -->
			FROM EMP
			<og:where>
				<og:and value=" DEPTNO = {@SOOUID}" />
			</og:where>
</og:query>

<canvas id="mycanvas" height="400" width="400"><!-- --></canvas>

<og:equals val1="bubble,scatter" val2="{@chartType}" contains="true">
	<jsp:directive.include file="resultBubble.jsp" />
</og:equals>

<og:equals val1="bubble,scatter" val2="{@chartType}" contains="true" notEquals="true">
	<jsp:directive.include file="resultBar.jsp" />
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
