<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9300"
	title	= "標準(PLSQL)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck command = "{@command}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" displayMsg="" debug="{@debug}" maxRowCount="{@maxRowCount}">
		SELECT	 SYSTEM_ID								<!-- ｼｽﾃﾑID -->
				,LANG									<!-- 言語 -->
				,CLM									<!-- 項目 -->
				,NAME_JA								<!-- 名称(漢字) -->
				,LABEL_NAME								<!-- 表示名称 -->
				,KBSAKU									<!-- 作成区分 -->
				,CDTAN									<!-- 担当者 -->
				,UNIQ									<!-- ﾕﾆｰｸ -->
		FROM	GF41
		WHERE	FGJ			IN	('0','1')				<!-- GF41》状態F    IN   ('0','1') -->
		AND		SYSTEM_ID	=	'{@SYSTEM_ID}'			<!-- GF41》ｼｽﾃﾑID   ＝   画面》ｼｽﾃﾑID-->
		AND		LANG		=	'{@LANG}'				<!-- GF41》言語     ＝   画面》言語-->
		AND		CLM			=	'{@CLM}'				<!-- GF41》項目     ＝   画面》項目-->
</og:query>

<!-- {@DB.COUNT} で、query実行結果の件数を取得できます。-->
<!-- 下記の例では、件数が 0 件ならば、追加処理を行うメッセージを出しています。-->
<og:equals val1="{@DB.COUNT}" val2="0" >
	<og:message lbl="MSG0044" comment="追加処理を行います。" /><br />
</og:equals>
<og:equals val1="{@DB.COUNT}" val2="1" >
	<og:message lbl="MSG0046" comment="変更処理を行います。" /><br />
</og:equals>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 -->
<!-- 以下は、must属性を true にして、初期値（設定されていない場合）検索条件の値をセットしています。 -->
<!-- ｼｽﾃﾑID -->
<og:columnEditor columns="SYSTEM_ID" must="true" defaultVal="{@SYSTEM_ID}" />
<!-- 言語 -->
<og:columnEditor columns="LANG"      must="true" defaultVal="{@LANG}"      />
<!-- 項目 -->
<og:columnEditor columns="CLM"       must="true" defaultVal="{@CLM}"       />

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消ボタンを作成します。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="entry" lbl="ENTRY" accesskey="E" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<br />
</og:writeCheck>

<!-- 入力画面を表示します。 -->
<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
<!-- viewFormType="HTMLEntry" で、エントリー形式の画面を作成します。 -->
<og:view
	viewFormType   = "HTMLEntry"
	command        = "{@command}"
	noDisplay      = "UNIQ"
	columnWritable = "SYSTEM_ID,LANG,KBSAKU,CLM,NAME_JA,LABEL_NAME,CDTAN,UNIQ"
>
<!-- HTMLEntry で使用される画面レイアウトです。 -->
<!-- [カラム名]で、ラベルと値のセットを、表示します。tdタグ ２個分です。 -->
<!-- [#カラム名]で、カラムのラベルを、tdタグなしで表示します。 -->
<!-- [$カラム名]で、カラムの値(テキストフィールド)を、tdタグなしで表示します。 -->
<table>
	<tr>
		[SYSTEM_ID]									<!-- ｼｽﾃﾑID -->
		[LANG]										<!-- 言語 -->
		[KBSAKU]									<!-- 作成区分 -->
	</tr>
	<tr>
		<td>[#CLM]</td>								<!-- 項目 -->
		<td colspan="3">[$CLM]</td>
	</tr>
	<tr>
		<td>[#NAME_JA]</td>							<!-- 名称(漢字) -->
		<td colspan="5">[$NAME_JA]</td>
	</tr>
	<tr>
		<td>[#LABEL_NAME]</td>						<!-- 表示名称 -->
		<td colspan="3">[$LABEL_NAME]</td>
	</tr>
	<tr>
		[CDTAN]										<!-- 担当者 -->
	</tr>
	<tr>
		[UNIQ]										<!-- ﾕﾆｰｸ -->
	</tr>
</table>
</og:view>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
