/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.business;		// package変更 fukurou.util → fukurou.business

// import org.opengion.fukurou.business.BizLogicHelper;
import org.opengion.fukurou.util.HybsLoader;
import org.opengion.fukurou.util.HybsLoaderFactory;
import org.opengion.fukurou.util.HybsLoaderConfig;
import org.opengion.fukurou.db.TransactionImpl;

/**
 * bizLogicファイル共通クラス
 * bizLogicファイルを処理するための、
 * 共通クラスです。
 *
 * @og.rev 5.10.15.2 (2019/09/20) 新規作成
 *
 * @version 5
 * @author oota
 * @since JDK7
 */
public final class BizUtil {

	/**
	 * private コンスタクター
	 * インスタンスは生成せずに、利用します。
	 */
	private BizUtil() {	}

	/**
	 * bizLogicファイルの実行 bizLogicファイルをホットデプロイして、
	 * 処理を実行します。
	 *
	 * @og.rev 7.0.6.4 (2019/11/29) setTransaction ﾒｿｯﾄﾞ内で、dbid を使っているので、先に設定します。
	 *
	 * @param srcDir ソースディレクトリ
	 * @param classDir クラスディレクトリ
	 * @param isAutoCompile オートコンプリートフラグ
	 * @param isHotDeploy ホットデプロイフラグ
	 * @param classPath クラスパス
	 * @param systemId システムID
	 * @param logicName ロジック名
	 * @param keys キーリスト
	 * @param vals 値リスト
	 * @throws Throwable エラー情報
	 */
	public static void actBizLogic(final String srcDir, final String classDir, final boolean isAutoCompile, final boolean isHotDeploy, final String classPath,
			final String systemId, final String logicName, final String[] keys, final String[] vals) throws Throwable {

		// bizクラスファイルのホットデプロイ
		final HybsLoader ldr = HybsLoaderFactory
				.getLoader(new HybsLoaderConfig(srcDir, classDir, isAutoCompile, isHotDeploy, classPath));

		final BizLogicHelper helper = new BizLogicHelper(logicName, ldr);

		// 7.0.6.4 (2019/11/29) try-with-resources文
		final TransactionImpl tran = new TransactionImpl(null);
//		helper.setTransaction(tran);
//		helper.setTransaction(tran);
//		helper.setKeys(keys);
//		helper.setVals(vals);

		try {
			helper.setDbid(systemId);				// 7.0.6.4 (2019/11/29) setTransaction ﾒｿｯﾄﾞ内で、dbid を使っているので、先に設定します。
			helper.setTransaction(tran);
			helper.setKeys(keys);
			helper.setVals(vals);

			// bizLogic実行
			helper.exec();

			// 正常に実行された場合
			tran.commit();
			tran.finish();
//		}catch(Throwable e) {
		} catch( final Throwable ex ) {
			// エラー発生時
			tran.rollback();
//			throw  e;
			throw  ex;
		} finally {
			if (tran != null) {
				tran.close();
//				tran.realClose();
			}
		}
	}
}
