/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.common;

// import java.io.File;

/**
 * ﾘｿｰｽﾌｧｲﾙの代わりとなるｼｽﾃﾑﾊﾟﾗﾒｰﾀをｸﾗｽ化したﾃﾞｰﾀｸﾗｽです｡
 *
 * それぞれの設定値は､ﾃﾞｰﾀﾍﾞｰｽにｺﾒﾝﾄとともに設定されます｡
 * そのとき､og.paramLevel ﾀｸﾞにより､属性を設定しています｡
 *
 * 0:設定必須
 * 1:設定確認
 * 2:使用時設定
 * 3:標準推奨
 * 4:個人設定可
 * 5:追加設定
 * 7:要再起動
 * 8:設定不可
 * 9:自動設定
 *
 * og.cryptography ﾀｸﾞは､指定の属性値を暗号化するかどうかを指定します｡
 * 暗号化は､org.opengion.hayabusa.security.HybsCryptography ｸﾗｽで行います｡将来的な拡張機能として､
 * 各ｼｽﾃﾑ毎に暗号化ｷｰを変えることで､ｾｷｭﾘﾃｨ強化が可能です｡
 *
 * ｴﾝｼﾞﾝﾊﾟﾗﾒｰﾀﾃﾞｰﾀは､ｴﾝｼﾞﾝとともに配布されるﾏｽﾀﾃﾞｰﾀになります｡
 * よって､配布形式はどのような形でもよく､今回は､JavaDoc にて各ﾊﾟﾗﾒｰﾀの
 * 意味やﾃﾞﾌｫﾙﾄ設定値が判断できるように､ｸﾗｽの public static final 変数として
 * 定義しました｡
 * 従来は､resource.ｼｽﾃﾑﾊﾟﾗﾒｰﾀ の一般設定用の ｼｽﾃﾑﾊﾟﾗﾒｰﾀ ﾌｧｲﾙと
 * ｴﾝｼﾞﾝ内部で持っている org/opengion/hayabusa/resource/properties の
 * ｼｽﾃﾑﾊﾟﾗﾒｰﾀ ﾌｧｲﾙにより維持されていましたが､ｴﾝｼﾞﾝﾊﾟﾗﾒｰﾀ
 * 定義ﾃｰﾌﾞﾙ(GE12)と､commom/SystemData.java ｸﾗｽによる管理に
 * 変更されました｡
 * ｼｽﾃﾑﾊﾟﾗﾒｰﾀは､ＤＢへのｱｸｾｽを決定するため､初期設定値を定義する必要があります｡
 * これは､､ｱﾌﾟﾘｹｰｼｮﾝ･ﾃﾞｨｽｸﾘﾌﾟﾀ(WEB-INF/web.xml)に､context-param として､
 * ｷｰと値のｾｯﾄで､初期ｱｸｾｽ用の情報を渡します｡
 * ｼｽﾃﾑﾊﾟﾗﾒｰﾀ定義ﾃｰﾌﾞﾙ(GE12)には､SYSTEM_IDとして､通常のｼｽﾃﾑIDと､
 * ｴﾝｼﾞﾝﾊﾟﾗﾒｰﾀがあります｡ｴﾝｼﾞﾝﾊﾟﾗﾒｰﾀは､SYSTEM_ID='**'として､登録
 * されています｡
 *
 * SystemData ｸﾗｽのﾌｨｰﾙﾄﾞは､その記述した順番でｾｯﾄしますので､
 * 設定順(ﾌｨｰﾙﾄﾞの記述順)を考慮する必要があります｡
 * また､ﾃﾞｰﾀﾍﾞｰｽへの登録は､このｸﾗｽをJavaDocのｶｽﾀﾑﾄﾞｯｸﾚｯﾄにより
 * 一旦 XML ﾌｧｲﾙに変換後､ｵﾗｸﾙXDK形式のXMLﾌｧｲﾙにXSLTで変換し､
 * このﾊﾟｯｹｰｼﾞ(org.opengion.hayabusa.common)に配置します｡
 * このﾃﾞｰﾀの変換時にｺﾒﾝﾄ情報を付加したXMLﾌｧｲﾙを作成し､DB登録(GE12)しますので､
 * このﾃﾞｰﾀを参考に､ｼｽﾃﾑ個別に書き換えを行えます｡
 *
 * @og.rev 4.0.0.0 (2005/01/31) 新規作成
 * @og.group 初期化
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public final class SystemData {

	/*
	 * ======================================================================
	 * これは，本ｼｽﾃﾑ全般に渡って,使用されるﾘｿｰｽです｡
	 * ｼｽﾃﾑとしての初期値や，設定値などは，すべてここで登録されます｡
	 * このﾘｿｰｽを修正する場合は,注意して下さい｡
	 * 不要な個所(値)を記入したり，記入漏れが発生すると,ｼｽﾃﾑが
	 * 正常に起動しない場合があり得ますので,ご注意願います｡
	 * ======================================================================
	 */

	/*
	 * ======================================================================
	 * ｼｽﾃﾑ毎に設定する必要のある変数
	 * ======================================================================
	 */

	/**
	 * ｱﾄﾞﾚｽ(/)に対する､実ﾃﾞｨﾚｸﾄﾘﾊﾟｽ｡
	 * REAL_PATH = "G:\webapps\ge\" ;
	 * @og.paramLevel 9:自動設定
	 */
	public static final String REAL_PATH = "" ;

	/**
	 * ｱｸｾｽ先の仮想ﾌｫﾙﾀﾞ名(URLのｺﾝﾃｷｽﾄ名)｡
	 * CONTEXT_NAME = "ge" ;
	 * @og.paramLevel 9:自動設定
	 */
	public static final String CONTEXT_NAME = "" ;

	/**
	 * ｱｸｾｽ先のJSPﾌｫﾙﾀﾞ名(/URLのｺﾝﾃｷｽﾄ名/jsp)｡
	 * JSP = "/ge/jsp" ;
	 * @og.paramLevel 9:自動設定
	 */
	public static final String JSP = "" ;

	/**
	 * javaのplugin,taglibなどで使用している画像の保存ﾌｫﾙﾀﾞ｡
	 * ICON_DIR = "icon" ;
	 * 従来の　image ﾌｫﾙﾀﾞから､ｱｲｺﾝとして使用しているﾌｧｲﾙを別に管理します｡
	 * @og.rev 7.3.2.3 (2021/04/09)
	 * @og.paramLevel 7:要再起動
	 */
	public static final String ICON_DIR = "icon" ;

	/**
	 * jspで使用している画像の保存ﾌｫﾙﾀﾞ｡
	 * 従来から存在するimageﾌｫﾙﾀﾞがﾃﾞﾌｫﾙﾄです｡一部iconﾌｫﾙﾀﾞに移動しています｡
	 * IMAGE_DIR = "image" ;
	 * @og.rev 7.3.2.3 (2021/04/09)
	 * @og.paramLevel 7:要再起動
	 */
	public static final String IMAGE_DIR = "image" ;

	/**
	 * jspで使用している画像の保存ﾌｫﾙﾀﾞ(SYS.JSP/SYS.ICON_DIR の短縮形)｡
	 * これは､内部で {&#064;SYS.JSP}/{&#064;SYS.ICON} の合成を行います｡
	 * ICON は､旧来から存在している IMAGE ﾌｫﾙﾀﾞから分離した画像です｡
	 * (例：/gf/jsp/icon)
	 * JSP_ICON = "" ;
	 * @og.rev 7.3.2.3 (2021/04/09)
	 * @og.paramLevel 9:自動設定
	 */
	public static final String JSP_ICON = "" ;

	/**
	 * jspで使用している画像の保存ﾌｫﾙﾀﾞ(IMAGE)｡
	 * これは､内部で {&#064;SYS.JSP}/{&#064;SYS.IMAGE} の合成を行います｡
	 * ICON ではなく､旧来から存在している IMAGE ﾌｫﾙﾀﾞの方です｡
	 * (例：/gf/jsp/image)
	 * JSP_IMG = "" ;
	 * @og.rev 7.3.2.3 (2021/04/09)
	 * @og.paramLevel 9:自動設定
	 */
	public static final String JSP_IMG = "" ;

	/**
	 * 共通ﾒｰﾙｻｰﾊﾞｰＵＲＬ｡
	 * COMMON_MAIL_SERVER = "localhost" ;
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String COMMON_MAIL_SERVER = "" ;

	/**
	 * ﾒｰﾙﾃﾞｰﾓﾝﾃﾞﾌｫﾙﾄﾕｰｻﾞｰ｡
	 * MAIL_DAEMON_DEFAULT_USER = "opengion" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String MAIL_DAEMON_DEFAULT_USER = "opengion" ;

	/**
	 * ﾒｰﾙﾃﾞｰﾓﾝﾃﾞﾌｫﾙﾄﾊﾟｽﾜｰﾄﾞ｡
	 * MAIL_DAEMON_DEFAULT_PASS = "****" ;
	 * @og.paramLevel 3:標準推奨
	 * @og.cryptography 1:暗号化
	 */
	public static final String MAIL_DAEMON_DEFAULT_PASS = "password" ;

	/**
	 * ﾒｰﾙﾃﾞｰﾓﾝの送信件数制限
	 * 正の数値を設定すると､ﾃﾞｰﾓﾝ1回辺りの送信件数が制限される｡
	 * MAIL_DAEMON_LIMIT = "-1" ;
	 * @og.rev 5.9.32.0 (2018/05/02)
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String MAIL_DAEMON_LIMIT = "-1" ;

	// /**
	// * ﾒｰﾙﾃﾞｰﾓﾝで実際に処理する 受信ﾘｽﾅｰ｡
	// * org.opengion.hayabusa.mail.MailReceiveListener を継承している必要があります｡
	// * MAIL_RECEIVE_LISTENER = "org.opengion.hayabusa.report.ExcelInsertReceiveListener" ;
	// *
	// * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(ExcelInsertReceiveListener.java廃止)
	// *
	// * @og.paramLevel 3:標準推奨
	// *
	// */
	// 7.4.4.0 (2021/06/30) Delete
	// public static final String MAIL_RECEIVE_LISTENER = "org.opengion.hayabusa.report.ExcelInsertReceiveListener" ;

	/**
	 * ﾒｰﾙ送信ﾎﾟｰﾄ番号
	 * 指定しなかった場合は標準(25)のﾎﾟｰﾄ番号を利用します｡
	 * SMTP_PORT = "" ;
	 * @og.rev 5.4.3.2 (2012/01/06)
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String SMTP_PORT = "" ;

	/**
	 * ﾒｰﾙ送信時認証方法
	 * ﾒｰﾙﾓｼﾞｭｰﾙ及びmailSender,mailSender2ﾀｸﾞで有効です｡
	 * 認証を行う場合は｢POP_BEFORE_SMTP｣または｢SMTP_AUTH｣が指定できます｡
	 * 認証時には認証ﾕｰｻﾞと認証ﾊﾟｽﾜｰﾄﾞを設定する必要があります｡
	 * MAIL_SEND_AUTH = "" ;
	 * @og.rev 5.4.3.2 (2012/01/06)
	 * @og.rev 6.2.4.1 (2015/05/22) SMTP_AUTH 対応｡ｺﾒﾝﾄのみ修正
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String MAIL_SEND_AUTH = "" ;

	/**
	 * ﾒｰﾙ送信時認証ﾎﾟｰﾄ
	 * ﾒｰﾙﾓｼﾞｭｰﾙ及びmailSender,mailSender2ﾀｸﾞで有効です｡
	 * ｢POP_BEFORE_SMTP｣または｢SMTP_AUTH｣認証を行う場合に､POPｻｰﾊﾞｰに接続するﾎﾟｰﾄ番号を指定します｡
	 * 指定しない場合は､POP3ﾃﾞﾌｫﾙﾄﾎﾟｰﾄを使用します｡
	 * MAIL_SEND_AUTH_PORT = "" ;
	 * @og.rev 5.8.1.1 (2014/11/14)
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String MAIL_SEND_AUTH_PORT = "" ;

	/**
	 * ﾒｰﾙ送信時認証方法
	 * ﾒｰﾙ送信時の認証ﾕｰｻﾞを指定します｡
	 * MAIL_SEND_AUTH_USER = "opengion"
	 *
	 * @og.rev 5.4.3.2 (2012/01/06)
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String MAIL_SEND_AUTH_USER = "opengion" ;

	/**
	 * SSL接続するかどうかを指定します｡
	 *
	 * MAIL_SEND_AUTH_PASSWORD = "password"
	 *
	 * @og.rev 5.4.3.2 (2012/01/06)
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String MAIL_SEND_AUTH_PASSWORD = "password" ;

	/**
	 * ﾒｰﾙ送信時認証方法(SSL)
	 * ﾒｰﾙ送信時の認証ﾕｰｻﾞを指定します｡
	 * MAIL_SEND_USE_SSL = "false"
	 *
	 * @og.rev 6.3.8.0 (2015/09/11)
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String MAIL_SEND_USE_SSL = "false" ;

	/**
	 * ﾒｰﾙ送信時認証方法(STARTTLS)
	 * ﾒｰﾙ送信時の認証ﾕｰｻﾞを指定します｡
	 * MAIL_SEND_USE_STARTTLS = "false"
	 *
	 * @og.rev 6.3.8.0 (2015/09/11)
	 * @og.rev 5.9.29.2 (2018/02/16) ｷｰﾜｰﾄﾞをVer5にあわせます｡
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String MAIL_SEND_USE_STARTTLS = "false" ;

	/**
	 * ｼｽﾃﾑｴﾗｰ時 ﾒｰﾙ発信元｡
	 * ｴﾗｰﾒｰﾙを返信する場合に使用する FROM ｱﾄﾞﾚｽ｡
	 * 未設定の場合は､ｴﾗｰﾒｰﾙを送信しません｡
	 * ERROR_MAIL_FROM_USER = "opengion@users.sourceforge.jp" ;
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String ERROR_MAIL_FROM_USER = "opengion@users.sourceforge.jp" ;

//	/**
//	 * ﾒｰﾙ送信用のｻｰﾋﾞｽsendGridを利用する場合のｷｰ情報｡
//	 * ｸﾗｳﾄﾞ上でｴﾝｼﾞﾝを利用してﾒｰﾙを送信する場合等に利用します｡
//	 * MAIL_SENDGRID_APIKEY = "" ;
//	 * @og.rev 5.9.26.0 (2017/11/02)
//	 * @og.rev 8.0.1.0 (2021/10/29) 廃止
//	 * @og.paramLevel 2:使用時設定
//	 */
//	public static final String MAIL_SENDGRID_APIKEY = "" ;

	/**
	 * ｼｽﾃﾑｴﾗｰ時 ﾒｰﾙ送信者｡
	 * 複数存在する場合は､ｶﾝﾏで区切って指定します｡
	 * 未設定の場合は､送信しません｡
	 * ERROR_MAIL_TO_USERS = "opengion@users.sourceforge.jp" ;
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String ERROR_MAIL_TO_USERS = "" ;

//	/**
//	 * ｸﾗｳﾄﾞ上でｵﾌﾞｼﾞｪｸﾄｽﾄﾚｰｼﾞ利用時にする設定｡
//	 * この設定に基づいてplugin.cloudのStorageAPI_xxxｸﾗｽが使われます｡
//	 * 利用しない場合は空の設定のままとしてください｡
//	 * CLOUD_STORAGE = "bluemix" ;
//	 *
//	 * @og.rev 6.8.1.7 (2017/10/13)
//	 * @og.rev 5.9.25.0 (2017/10/06)
//	 * @og.rev 5.10.9.0 (2019/03/01) CLOUD_STORAGE -> CLOUD_TARGET
//	 * @og.paramLevel 2:使用時設定
//	 */
//	public static final String CLOUD_STORAGE = "" ;

//	/**
//	 * ｸﾗｳﾄﾞ上でｵﾌﾞｼﾞｪｸﾄｽﾄﾚｰｼﾞ利用時にする設定｡
//	 * ｵﾌﾞｼﾞｪｸﾄｽﾄﾚｰｼﾞのｺﾝﾃﾅ名を設定します｡
//	 * CLOUD_STORAGE_CONTAINER = "GF" ;
//	 *
//	 * @og.rev 6.8.1.7 (2017/10/13)
//	 * @og.rev 5.9.25.0 (2017/10/06)
//	 * @og.rev 5.10.9.0 (2019/03/01) CLOUD_STORAGE_CONTAINER ->CLOUD_BUCKET
//	 * @og.paramLevel 2:使用時設定
//	 */
//	public static final String CLOUD_STORAGE_CONTAINER = "" ;

	/**
	 * ﾌｧｲﾙ出力 基準ＵＲＬ(ﾌｧｲﾙ出力する実ﾌｫﾙﾀﾞ)｡
	 * FILE_URL = "filetemp/" ;
	 * FILE_URL = "G:/webapps/webdav/" ;
	 * FILE_URL = "\\\\hnXXXX/ge/filetemp/" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String FILE_URL = "filetemp/" ;

	/**
	 * ｸﾗｳﾄﾞ上でｵﾌﾞｼﾞｪｸﾄｽﾄﾚｰｼﾞ利用時にする設定｡
	 * この設定に基づいてorg.opengion.cloudのFileOperation_xxxｸﾗｽが使われます｡
	 * 利用しない場合は空の設定のままとしてください｡
	 * CLOUD_TARGET､CLOUD_BUCKET のどちらかが､空､もしくは"LOCAL"の場合はﾛｰｶﾙｽﾄﾚｰｼﾞを利用します｡
	 *
	 * CLOUD_TARGET = "AWS" ;
	 *
	 * @og.rev 5.10.9.0 (2019/03/01)
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String CLOUD_TARGET = "" ;

	/**
	 * ｸﾗｳﾄﾞ上でｵﾌﾞｼﾞｪｸﾄｽﾄﾚｰｼﾞ利用時にする設定｡
	 * ｵﾌﾞｼﾞｪｸﾄｽﾄﾚｰｼﾞのｺﾝﾃﾅ名(ﾊﾞｹｯﾄ名)を設定します｡
	 * CLOUD_TARGET､CLOUD_BUCKET のどちらかが､空､もしくは"LOCAL"の場合はﾛｰｶﾙｽﾄﾚｰｼﾞを利用します｡
	 *
	 * CLOUD_BUCKET = "GF" ;
	 *
	 * @og.rev 5.10.9.0 (2019/03/01)
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String CLOUD_BUCKET = "" ;

//	/**
//	 * AWSのS3をｱｸｾｽｷｰを利用して接続する場合に利用する設定｡
//	 * AWS上のｻｰﾊﾞで動作させる場合はIAMで権限を渡すため､通常は設定不要です｡
//	 * この値を設定時は以下も設定が必要です｡
//	 * CLOUD_STORAGE_S3_SECRET_KEY,CLOUD_STORAGE_S3_SERVICE_END_POINT,CLOUD_STORAGE_S3_REGION
//	 *
//	 * CLOUD_STORAGE_S3_ACCESS_KEY = "" ;
//	 *
//	 * @og.rev 5.10.12.3 (2019/06/21)
//	 *
//	 * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(未使用の為廃止)
//	 * @og.rev 8.0.0.0 (2021/09/30) 復活
//	 * @og.rev 8.0.0.1 (2021/10/08) 廃止
//	 *
//	 * @og.paramLevel 2:使用時設定
//	 */
//	 public static final String CLOUD_STORAGE_S3_ACCESS_KEY = "" ;

	/**
	 * ﾌｧｲﾙ出力 基準ＵＲＬ(ExcelOut でのﾘﾀｰﾝURL)｡
	 * FILE_OUT_URL = "../../filetemp/" ;
	 * FILE_OUT_URL = "G:/webapps/webdav/" ;
	 * FILE_OUT_URL = "http://hnXXXX:8823/ge/filetemp/" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String FILE_OUT_URL = "../../filetemp/" ;

	/**
	 * ﾃﾞﾌｫﾙﾄﾌｧｲﾙ名｡
	 * FILE_FILENAME = "file.xlsx" ;
	 * @og.paramLevel 3:標準推奨
	 * @og.rev 6.6.0.0 (2016/12/01) FILE_FILENAME の初期値を､file.xlsx に変更します｡
	 */
	public static final String FILE_FILENAME = "file.xlsx" ;			// 6.6.0.0 (2016/12/01)

//	/**
//	 * 本番環境のＵＲＬ｡
//	 * WebDAV での接続や､ﾘｿｰｽ移行時などに利用します｡
//	 * HONBAN_URL = "" ;
//	 * @og.paramLevel 1:設定確認
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止
//	 */
//	public static final String HONBAN_URL = "" ;

//	/**
//	 * RDC_CODE(設計変更連絡番号)の先頭文字｡
//	 * ﾘｿｰｽ管理で使用する RDC_CODE は､分散環境(本社､中国､ﾌｨﾘﾋﾟﾝなど)
//	 * でそれぞれ採番された後に､1箇所で共通に使用されます｡それぞれの拠点で
//	 * 採番ﾙｰﾙを変えることで､重複を防ぎ､発生元を明確にします｡
//	 * RDC_PREFIX = "RDC" ;
//	 * @og.paramLevel 1:設定確認
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止
//	 */
//	public static final String RDC_PREFIX = "RDC" ;

	/**
	 * ﾍﾙﾌﾟﾌｧｲﾙ 基準ＵＲＬ｡
	 * ※ ｱﾄﾞﾚｽ合成(StringUtil.urlAppend)で処理する為､/help/ にするとおかしくなる｡
	 * HELP_URL = "help/" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String HELP_URL = "help/" ;

	/**
	 * ﾍﾙﾌﾟ標準ｱｲｺﾝ
	 * 初期値は､jspﾌｫﾙﾀﾞ以下の指定になっています｡
	 * DEFAULT_HELP_ICON = "help.png" ;
	 * @og.paramLevel 2:使用時設定
	 * @og.rev 5.4.3.6 (2012/01/12) 追加
	 * @og.rev 6.2.5.0 (2015/06/05) help.png に戻します｡
	 */
//	public static final String DEFAULT_HELP_ICON = "/image/help.png" ;
	public static final String DEFAULT_HELP_ICON = "help.png" ;

	/**
	 * ｶﾗﾑﾍﾙﾌﾟ標準ｱｲｺﾝ
	 * 初期値は､jspﾌｫﾙﾀﾞ以下の指定になっています｡
	 * DEFAULT_CLMHELP_ICON = "help3.png" ;
	 * @og.paramLevel 2:使用時設定
	 *
	 * @og.rev 6.3.2.0 (2015/07/10) ｶﾗﾑﾀｸﾞに help 属性を追加
	 */
//	public static final String DEFAULT_CLMHELP_ICON = "/image/help3.png" ;
	public static final String DEFAULT_CLMHELP_ICON = "help3.png" ;

	/**
	 * FAQ標準ｱｲｺﾝ
	 * 初期値は､jspﾌｫﾙﾀﾞ以下の指定になっています｡
	 * DEFAULT_FAQ_ICON = "qaicon.png" ;
	 * @og.paramLevel 2:使用時設定
	 * @og.rev 5.5.0.4 (2012/01/12) 追加
	 */
//	public static final String DEFAULT_FAQ_ICON = "/image/qaicon.png" ;
	public static final String DEFAULT_FAQ_ICON = "qaicon.png" ;

//	/**
//	 * HelpﾀｸﾞのFAQ表示を利用するか｡
//	 * 互換性を考慮して､初期値はfalseとします｡
//	 * USE_GUI_FAQ = "false" ;
//	 * @og.paramLevel 2:使用時設定
//	 * @og.rev 5.5.0.4 (2012/01/12) 追加
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止
//	 */
//	public static final String USE_GUI_FAQ = "false" ;

//	/**
//	 * HelpﾀｸﾞのFAQ表示で関連画面IDを利用するか｡
//	 * trueの場合は関連に入っている場合のみ表示になります｡
//	 * 初期値はfalse（常に表示）とします｡
//	 * FAQ表示ﾌﾗｸﾞが優先されます｡
//	 * USE_GUI_FAQ_CTRL = "true" ;
//	 * @og.paramLevel 2:使用時設定
//	 * @og.rev 5.6.3.4 (2013/05/24) 追加
//	 * @og.rev 6.3.8.4 (2015/10/09) 初期条件を間違っていた為修正｡基本は､true(関連画面ID使用時のみ)
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止
//	 */
//	public static final String USE_GUI_FAQ_CTRL = "true" ;

	/**
	 * HelpﾀｸﾞのFAQよりﾘﾝｸする画面IDを指定します｡
	 * DEFAULT_FAQ_GUI = "22_FAQ" ;
	 * @og.rev 5.5.0.4 (2012/01/12) 追加
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String DEFAULT_FAQ_GUI = "22_FAQ" ;

	/**
	 * ｴﾗｰﾒｯｾｰｼﾞ表示画面｡
	 * ERR_MSG_FILENAME = "jsp/common/errorMessage.jsp" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String ERR_MSG_FILENAME = "jsp/common/errorMessage.jsp" ;

	/**
	 * ｴﾗｰﾒｯｾｰｼﾞ表示ﾚﾍﾞﾙ｡
	 * 設定により､以下のようにｴﾗｰﾒｯｾｰｼﾞの表示内容を変更することができます｡
	 * (※ここでのｴﾗｰﾒｯｾｰｼﾞとは､例外がｽﾛｰされた場合のｴﾗｰﾒｯｾｰｼﾞの表示方法です
	 *    columnCheckﾀｸﾞ等で表示されるｱﾌﾟﾘｹｰｼｮﾝｴﾗｰの内容は､この設定と関係ありません)
	 *
	 * 0:ｴﾗｰ内容は何も表示されません｡ｴﾗｰ発生時刻のみが表示されます｡
	 * 1:例外名とｴﾗｰ内容のﾒｯｾｰｼﾞのみが表示されます｡ｽﾀｯｸﾄﾚｰｽは表示されません｡
	 * 2:ｽﾀｯｸﾄﾚｰｽも含めてｴﾗｰ内容を表示します｡
	 *
	 * ERR_DISP_LEVEL = "1" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String ERR_DISP_LEVEL = "1" ;

	/**
	 * 帳票ﾌｧｲﾙ出力 基準ＵＲＬ｡
	 * 設定されていない場合は､FILE_URL + /REPORT/ に設定されます｡
	 * REPORT_FILE_URL = "filetemp/REPORT/" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String REPORT_FILE_URL = "filetemp/REPORT/" ;

	// /**
	// * EXCEL取込時に使用するﾃﾝﾎﾟﾗﾘ基準ＵＲＬ｡
	// * 設定されていない場合は､FILE_URL + /EXCELIN/ に設定されます｡
	// * EXCEL_IN_FILE_URL = "filetemp/EXCELIN/" ;
	// *
	// * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(未使用の為廃止)
	// *
	// * @og.paramLevel 3:標準推奨
	// */
	// 7.4.4.0 (2021/06/30) Delete
	// public static final String EXCEL_IN_FILE_URL = "filetemp/EXCELIN/" ;

	/**
	 * 帳票ﾃﾞｰﾓﾝの Shell 実行時のﾀｲﾑｱｳﾄ時間 ｡
	 * 帳票ﾃﾞｰﾓﾝで起動する Shell が､何らかの原因で無応答になる場合があります｡
	 * この場合､それ以降の処理がすべて停止してしまうため､ﾀｲﾑｱｳﾄ時間を指定します｡
	 * 単位は､秒です｡
	 * 初期値は､３００秒です｡
	 * REPORT_DAEMON_TIMEOUT = "300" ;
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String REPORT_DAEMON_TIMEOUT = "300" ;

	/**
	 * 帳票ﾃﾞｰﾓﾝに､ｴﾗｰ時にｽﾘｰﾌﾟして待機する時間(秒) ｡
	 * この設定時間だけｽﾘｰﾌﾟし､再び起動を試みます｡そして失敗すれば､
	 * 再び､ｽﾘｰﾌﾟして待機します｡これを､無限に繰り返します｡
	 * ｽﾘｰﾌﾟ時間(秒)に､０ をｾｯﾄすると､ｴﾗｰ時即終了となります｡
	 * 初期値は､３０秒です｡
	 * REPORT_DAEMON_ERROR_SLEEP_TIME = "30" ;
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String REPORT_DAEMON_ERROR_SLEEP_TIME = "30" ;

	// /**
	// * HTMLからEXCELへ変換するときに要求番号でｵｰﾌﾟﾝするように指定します｡
	// * Office 2003のEXCELより､XXXX.html と XXXX.files の XXXX 部分が異なる場合でも
	// * 画像ﾌｧｲﾙを読み込むようになりました｡従来は､この XXXX を同一にする為､
	// * 帳票ID でﾌｧｲﾙをｵｰﾌﾟﾝしていましたが､EXCELを同時に起動できない為､
	// * 排他制御をｴﾝｼﾞﾝ側で行っていました｡
	// * このﾌﾗｸﾞを true に設定すると､XXXX を要求番号にして､EXCELの同時起動を
	// * 行えるようにします｡同時に､帳票IDでのﾛｯｸを行いません｡
	// * 初期値は､false (互換性の関係)です｡
	// * REPORT_EXCEL_NAME_USE_YKNO = "false" ;
	// *
	// * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(未使用の為廃止)
	// *
	// * @og.paramLevel 3:標準推奨
	// */
	// 7.4.4.0 (2021/06/30) Delete
	// public static final String REPORT_EXCEL_NAME_USE_YKNO = "false" ;

	// /**
	// * 帳票ｴﾗｰ送信対象ID指定｡
	// * ｴﾗｰﾒｰﾙを送信する帳票IDを正規表現で指定します｡
	// * 未設定の場合は､全ての帳票ｴﾗｰが対象になります｡
	// * REPORT_ERRMAIL_REGEX = "" ;
	// *
	// * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(未使用の為廃止)
	// *
	// * @og.paramLevel 2:使用時設定
	// */
	// 7.4.4.0 (2021/06/30) Delete
	// public static final String REPORT_ERRMAIL_REGEX = "" ;

	/**
	 * ｱﾌﾟﾘｹｰｼｮﾝのURLｱｸｾｽに関してのｾｷｭﾘﾃｨ制限ﾚﾍﾞﾙを指定します｡
	 * URLHashFilter ﾌｨﾙﾀｰを使用する設定(web.xml)を行う必要があります｡
	 *
	 * ﾚﾍﾞﾙ０：なにも制限はありません｡
	 * ﾚﾍﾞﾙ１：Referer ﾁｪｯｸを行います｡つまり､URLを直接入力しても動作しません｡
	 * ﾚﾍﾞﾙ２：URLのﾊｯｼｭ化/暗号化処理を､外部URLに対してのみ行います｡(ﾁｪｯｸは､ﾚﾍﾞﾙ１と同等)
	 * ﾚﾍﾞﾙ３：URLのﾊﾟﾗﾒｰﾀがﾊｯｼｭ化/暗号化されている必要があります｡
	 * それ以外：ｱｸｾｽを停止します｡
	 *
	 * @og.rev 5.2.3.0 (2010/12/01) 新規追加
	 *
	 * URL_ACCESS_SECURITY_LEVEL = "0" ;
	 * @og.paramLevel 7:要再起動
	 */
	public static final String URL_ACCESS_SECURITY_LEVEL = "0" ;

	/**
	 * URLﾁｪｯｸを行う際の暗号化ｷｰ
	 * 指定しない場合は標準の値が利用されます｡
	 * 指定する場合はｻｲｽﾞを､8 の倍数 (32 以上 448 以下) にする必要があります｡
	 * 初期値は指定なし｡
	 * URL_CHECK_CRYPT = "" ;
	 *
	 * @og.rev 5.10.6.1 (2018/12/10) 新規追加
	 *
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String URL_CHECK_CRYPT = "" ;

	/**
	 * CALC帳票のﾛｰｶﾙﾘｿｰｽを使用する数値型ｶﾗﾑの互換性設定｡
	 *
	 * CALC帳票の数値型ｶﾗﾑで､帳票ﾃﾞｰﾀのｶﾗﾑ属性を､文字型⇒数値型に変更する処理で､
	 * ﾛｰｶﾙﾘｿｰｽを使用する場合､この処理が､逆にうまく働かないｹｰｽがあります｡
	 * 元は､雛形を､{&#064;XXXX} で定義すると､ｾﾙが文字型になるため､数値型ｾﾙの機能が
	 * 使えなくなるため､強制的に変換していました｡ところが､ﾛｰｶﾙﾘｿｰｽで､修飾すると
	 * 文字型ｾﾙにしておかないと､数値に戻ってしまい､うまく､ﾚﾝﾃﾞﾗｰが適用されません｡
	 * そこで､互換性を考慮して､ﾛｰｶﾙﾘｿｰｽ使用時の文字型⇒数値型変換を行うかどうかを
	 * 指定できるようにします｡
	 * report2/OdsContentParser#writeParsedRow
	 * true で､互換性設定ありです｡
	 * Ver6では､初期値は､true (互換性設定あり)にしておきます｡
	 *
	 * @og.rev 6.8.3.1 (2017/12/01) 新規追加
	 *
	 * REPORT_USE_CHANGETYPE = "true" ;
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String REPORT_USE_CHANGETYPE = "true" ;

	/*
	 * ======================================================================
	 * これは，ﾃﾞｰﾀﾍﾞｰｽ接続先情報に関するﾘｿｰｽです｡
	 * ﾄﾞﾗｲﾊﾞｰ､ＵＲＬ，ﾕｰｻﾞｰ､ﾊﾟｽﾜｰﾄﾞのほかに､ｷｬｯｼｭする
	 * ｺﾈｸｼｮﾝ数､最大同時接続数､ｺﾈｸｼｮﾝ取得待機時間等を設定
	 * します｡
	 * ======================================================================
	 */

	/**
	 * ﾃﾞｰﾀﾍﾞｰｽｴﾝｺｰﾃﾞｨﾝｸﾞ｡
	 * ｵﾗｸﾙのｴﾝｺｰﾃﾞｨﾝｸﾞ名ではなく､Javaのｴﾝｺｰﾃﾞｨﾝｸﾞ名で指定します｡
	 * Javaとｵﾗｸﾙ間の文字ｺｰﾄﾞ変換は､JDBCが自動で行います｡
	 * ここでの設定は､ﾃﾞｰﾀﾍﾞｰｽ登録時の文字ﾊﾞｲﾄ数ﾁｪｯｸに利用しています｡
	 *
	 * DB_ENCODE = "Shift_JIS" ;
	 * DB_ENCODE = "MS932" ;
	 * DB_ENCODE = "Windows-31J" ;
	 * DB_ENCODE = "UTF-8" ;
	 *
	 * @og.paramLevel 1:設定確認
	 */
	public static final String DB_ENCODE = "UTF-8" ;

	/**
	 * ﾃﾞｰﾀﾍﾞｰｽの文字数ﾁｪｯｸ方式の指定｡
	 * PostgreSQLでは､varchar の桁数は､｢文字数｣となっており､ORACLEなど
	 * ｢ﾊﾞｲﾄ数｣ﾁｪｯｸの方式と異なります｡
	 * このﾊﾟﾗﾒｰﾀは､｢true｣ に設定すると､｢文字数｣ﾁｪｯｸとなり､
	 * ｢false｣ または､null(ﾊﾟﾗﾒｰﾀｷｰが存在しない)の場合は､
	 * ｢ﾊﾞｲﾄ数｣ﾁｪｯｸとなります｡
	 * 標準は､ORACLE等の｢ﾊﾞｲﾄ数｣ﾁｪｯｸ方式の ｢false｣ です｡
	 *
	 * DB_USE_TEXT_LENGTH = "false" ; ORACLE等の｢ﾊﾞｲﾄ数｣ﾁｪｯｸ方式
	 * DB_USE_TEXT_LENGTH = "true"  ; PostgreSQL等の｢文字数｣ﾁｪｯｸ方式
	 *
	 * @og.rev 5.3.9.0 (2011/09/01) 新規追加
	 *
	 * @og.paramLevel 1:設定確認
	 */
	public static final String DB_USE_TEXT_LENGTH = "false" ;

	/*
	 * ======================================================================
	 * これは，ＬＤＡＰ接続先情報に関するﾘｿｰｽです｡
	 * initctx､service､entrydn､searchbase を指定できます｡
	 * もちろん､使用時に指定することも可能です｡
	 * ======================================================================
	 */

	/**
	 * LDAP 初期ｺﾝﾃｷｽﾄﾌｧｸﾄﾘ｡
	 * LDAP で使用する初期ｺﾝﾃｷｽﾄﾌｧｸﾄﾘを指定します｡
	 * LDAP_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String LDAP_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory" ;

	/**
	 * LDAP ｻｰﾋﾞｽﾌﾟﾛﾊﾞｲﾀﾞの構成情報｡
	 * LDAP で使用するｻｰﾋﾞｽﾌﾟﾛﾊﾞｲﾀﾞの構成情報を指定します｡
	 * LDAP_PROVIDER_URL = "ldap://ldap.opengion.org:389";
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String LDAP_PROVIDER_URL = "ldap://ldap.opengion.org:389" ;

	/**
	 * LDAP 属性の取得元のｵﾌﾞｼﾞｪｸﾄの名前｡
	 * LDAP で使用する属性の取得元のｵﾌﾞｼﾞｪｸﾄの名前
	 * LDAP_ENTRYDN = "cn=inquiry-sys,o=opengion,c=JP";
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String LDAP_ENTRYDN = "cn=inquiry-sys,o=opengion,c=JP" ;

	/**
	 * LDAP 属性の取得元のﾊﾟｽﾜｰﾄﾞ｡
	 * LDAP で使用する属性の取得元のﾊﾟｽﾜｰﾄﾞ
	 * LDAP_PASSWORD = "****" ;
	 * @og.paramLevel 2:使用時設定
	 * @og.cryptography 1:暗号化
	 */
	public static final String LDAP_PASSWORD = "password" ;

	/**
	 * 検索するｺﾝﾃｷｽﾄまたはｵﾌﾞｼﾞｪｸﾄのﾍﾞｰｽ名｡
	 * LDAP で使用する検索するｺﾝﾃｷｽﾄまたはｵﾌﾞｼﾞｪｸﾄのﾍﾞｰｽ名
	 * LDAP_SEARCH_BASE = "soouid=employeeuser,o=opengion,c=JP";
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String LDAP_SEARCH_BASE = "soouid=employeeuser,o=opengion,c=JP" ;

	/**
	 * LDAP 検索範囲｡
	 * LDAP で使用する検索範囲を設定します｡
	 * 『OBJECT』､『ONELEVEL』､『SUBTREE』のどれか 1 つ
	 * 指定の無い場合は､SearchControls の初期値で設定されます｡
	 * LDAP_SEARCH_SCOPE = "SUBTREE" ;
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String LDAP_SEARCH_SCOPE = "SUBTREE" ;

	/**
	 * LDAPでｻｰﾋﾞｽﾌﾟﾛﾊﾞｲﾀﾞによる照会に対する動作｡
	 * 『ignore』､『follow』､『throw』のどれか 1 つ
	 * 指定の無い場合は､空文字で設定されます｡
	 * LDAP_SEARCH_REFERRAL = "" ;
	 * @og.paramLevel 2:使用時設定
	 * @og.rev 5.6.7.0 (2013/07/27)
	 */
	public static final String LDAP_SEARCH_REFERRAL = "" ;

	/**
	 * malSenderﾀｸﾞでのldapKey初期値｡
	 * ActiveDirectory等でuidで引けない場合等に変更します｡
	 * LDAP_MAILSEND_KEY = "uid"
	 * @og.paramLevel 2:使用時設定
	 * @og.rev 5.6.7.0 (2013/07/27)
	 */
	public static final String LDAP_MAILSEND_KEY = "uid" ;

	/**
	 * malSenderﾀｸﾞでのldapVals初期値｡
	 * cn,mailで取得できない場合に変更します｡
	 * LDAP_MAILSEND_VALS = "cn,mail"
	 * @og.paramLevel 2:使用時設定
	 * @og.rev 5.6.7.0 (2013/07/27)
	 */
	public static final String LDAP_MAILSEND_VALS = "cn,mail" ;

	/*
	 * ======================================================================
	 * ﾛｸﾞﾌｧｲﾙを出力するｸﾗｽの設定項目です｡
	 * initctx､service､entrydn､searchbase を指定できます｡
	 * もちろん､使用時に指定することも可能です｡
	 * ======================================================================
	 */

	/**
	 * ﾛｸﾞﾌｧｲﾙのﾌｫﾙﾀﾞ/ﾌｧｲﾙ名｡
	 * ﾛｸﾞﾌｧｲﾙを出力するﾃﾞｨﾚｸﾄﾘ/ﾌｧｲﾙ名.ｻﾌｨｯｸｽを定義します｡
	 * SYS_LOG_URL = "log/syslog_$(yyyyMM).log" ;
	 * @og.paramLevel 3:標準推奨
	 * @og.rev 7.1.0.1 (2020/02/07) 拡張子を txt から log に変更
	 */
	public static final String SYS_LOG_URL = "log/syslog_$(yyyyMM).log" ;

	/**
	 * ﾛｸﾞﾌｧｲﾙのｴﾝｺｰﾄﾞを指定します｡
	 * 従来は OS依存(Windowsの場合､Windows-31J)でしたが､Tomcatのlogと統一するため､
	 * UTF-8 に変更します｡
	 * SYS_LOG_ENCODE = "UTF-8" ;
	 * @og.paramLevel 3:標準推奨
	 * @og.rev 7.1.0.1 (2020/02/07) 新規追加
	 */
	public static final String SYS_LOG_ENCODE = "UTF-8" ;

	/*
	 * ======================================================================
	 * JSP で使用している変数
	 * ======================================================================
	 */

	/**
	 * ｾｯｼｮﾝﾀｲﾑｱｳﾄ(秒)｡
	 * SESSION_TIMEOUT
	 * Servlet/JSP でのｾｯｼｮﾝﾀｲﾑｱｳﾄを秒で指定します｡
	 * 最後にｾｯｼｮﾝに対してｱｸｾｽを行ってから､この秒間の
	 * ｱｲﾄﾞﾙ時間が経過したｾｯｼｮﾝは､接続が切断されます｡
	 * ｴﾝｼﾞﾝでは､ｾｯｼｮﾝ切断後､検索処理の場合は､自動的に新しい
	 * ｾｯｼｮﾝでｼｰﾑﾚｽに接続しますが､登録処理は､実行できません｡
	 * MAX_INACTIVE_INTERVAL = "1800" ;
	 * @og.paramLevel 1:設定確認
	 */
	public static final String MAX_INACTIVE_INTERVAL = "1800" ;

	/*
	 * ======================================================================
	 * org.opengion.hayabusa.common.* で使用している変数
	 * ======================================================================
	 */

	/**
	 * 時刻のﾌｫｰﾏｯﾄ｡
	 * 時刻のﾌｫｰﾏｯﾄ方法を､指定します｡ 例( 1998/04/17 15:48:22.005 )
	 *
	 * SYS_TIME = "yyyy/MM/dd HH:mm:ss" ;
	 * SYS_TIME = "yyyy/MM/dd HH:mm:ss.SSS" ;
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String SYS_TIME = "yyyy/MM/dd HH:mm:ss" ;

	/*
	 * ======================================================================
	 * org.opengion.hayabusa.io.* で使用している変数
	 * ======================================================================
	 */

	/**
	 * ﾌｧｲﾙｴﾝｺｰﾃﾞｨﾝｸﾞ｡
	 * ﾌｧｲﾙｴﾝｺｰﾃﾞｨﾝｸﾞは､EXCEL出力等のﾌｧｲﾙをｾｰﾌﾞする場合に
	 * 使用する､ｴﾝｺｰﾃﾞｨﾝｸﾞ名です｡
	 * 多言語対応のため､初期値は､UnicodeLittle に設定されています｡
	 * (UTF-8 ではないので､ご注意ください｡)
	 *
	 * FILE_ENCODE = "UnicodeLittle" ;
	 * FILE_ENCODE = "Shift_JIS" ;
	 * FILE_ENCODE = "MS932" ;
	 * FILE_ENCODE = "Windows-31J" ;
	 * FILE_ENCODE = "UTF-8" ;
	 * FILE_ENCODE = "ISO-8859-1" ;
	 * FILE_ENCODE = "GB2312" ;
	 * FILE_ENCODE = "GB18030" ;
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String FILE_ENCODE = "UnicodeLittle" ;

	/**
	 * DBTableModel ﾌｧｲﾙ出力ﾍｯﾀﾞｰ情報｡
	 * DBTableWriter で､DBTableModel を出力する場合のﾍｯﾀﾞｰ部に指定する
	 * 情報を文字列で指定します｡指定の順番どおりに出力されます｡
	 * なお､必ず "D" は必要です｡
	 * N: Name(名前)属性｡ﾌｧｲﾙを読み取る(DBTableReader)場合には必要です｡
	 * L: Label(ﾗﾍﾞﾙ)属性｡指定のｶﾗﾑの名称を表示します｡
	 * S: Size(ｻｲｽﾞ)属性｡指定のｶﾗﾑの桁数を表示します｡
	 * C: Class(ｸﾗｽ)属性｡指定のｶﾗﾑのｸﾗｽ(文字､数字など)を表示します｡
	 * -: ----(区切り記号)属性｡必要な箇所に入れることで､ﾍｯﾀﾞｰ部とﾃﾞｰﾀ部を分離します｡
	 * D: Data(ﾃﾞｰﾀ)属性｡実際のﾃﾞｰﾀを繰り返し表示します｡
	 *
	 * 7.2.6.1 (2020/07/17) H:Header(ﾍｯﾀﾞｰ)属性｡Label(ﾗﾍﾞﾙ)属性の先頭の#を削除します｡
	 *
	 * WRITER_HEADER_SEQUENCE = "NL-D" ;
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String WRITER_HEADER_SEQUENCE = "NL-D" ;

	/**
	 * EXCEL出力で､初期出力ﾌｧｲﾙ形式｡
	 * EXCEL出力で､出力ﾌｧｲﾙ形式を指定します｡
	 * 指定できる値は､DBTableWriter のｻﾌﾞｸﾗｽ名になります｡
	 * writeTable ﾀｸﾞの writeClass 属性の設定値の初期値になります｡
	 *
	 * TABLE_WRITER_DEFAULT_CLASS = "Default";		ﾃｷｽﾄ(全項目)	csv
	 * TABLE_WRITER_DEFAULT_CLASS = "Renderer";		ﾃｷｽﾄ(画面表示)	csv
	 * TABLE_WRITER_DEFAULT_CLASS = "Excel";		Excel(全項目)	xlsx
	 * TABLE_WRITER_DEFAULT_CLASS = "ExcelRenderer";Excel(画面表示)	xlsx
	 *
	 * @og.rev 6.2.0.0 (2015/02/27) EXCEL出力のparamLevel初期値変更 3:標準推奨 → 4:個人設定可
	 * @og.rev 6.6.0.0 (2016/12/01) TABLE_WRITER_DEFAULT_CLASS の初期値を､Excel に変更します｡
	 *
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String TABLE_WRITER_DEFAULT_CLASS = "Excel" ;			// 6.6.0.0 (2016/12/01)

	/**
	 * EXCEL出力で､EXCELﾌｧｲﾙの形式(xls/xlsx)を指定します｡
	 * Office2003形式(xls) か､Office2007形式(xlsx)の指定ができます｡
	 * ただし､従来のﾀﾌﾞ区切りﾃｷｽﾄの拡張子(xls)については､
	 * xlsx 形式にすると読み込めない為､ここでの指定は無視されます｡
	 *
	 * TABLE_WRITER_EXCEL_TYPE = "xls" ;
	 * TABLE_WRITER_EXCEL_TYPE = "xlsx" ;
	 *
	 * @og.rev 6.2.0.0 (2015/02/27) EXCEL出力の形式(xls , xlsx)の選択
	 * @og.rev 6.6.0.0 (2016/12/01) TABLE_WRITER_EXCEL_TYPE の初期値を､xlsx に変更します｡
	 *
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String TABLE_WRITER_EXCEL_TYPE = "xlsx" ;			// 6.6.0.0 (2016/12/01)

	/**
	 * EXCEL出力で､初期入力ﾌｧｲﾙ形式｡
	 * EXCEL入力で､入力ﾌｧｲﾙ形式を指定します｡
	 * readTable ﾀｸﾞの readClass 属性の設定値の初期値になります｡
	 * 指定できる値は､DBTableReader のｻﾌﾞｸﾗｽ名になります｡
	 * また､AutoReader を指定すると､Excel と Default(ﾃｷｽﾄ) を
	 * 順番に試します｡
	 * 初期値は､AutoReader です｡
	 *
	 * TABLE_READER_DEFAULT_CLASS = "Default" ;
	 * TABLE_READER_DEFAULT_CLASS = "Excel" ;
	 * TABLE_READER_DEFAULT_CLASS = "AutoReader" ;
	 *
	 * @og.rev 6.2.0.0 (2015/02/27) EXCEL出力のparamLevel初期値変更 3:標準推奨 → 4:個人設定可
	 *
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String TABLE_READER_DEFAULT_CLASS = "AutoReader" ;

	/**
	 * EXCEL出力時のﾃﾞﾌｫﾙﾄﾌｫﾝﾄ名(初期値:"ＭＳ Ｐｺﾞｼｯｸ")｡
	 * EXCEL出力時のﾃﾞﾌｫﾙﾄﾌｫﾝﾄ名を設定します｡
	 * ﾌｫﾝﾄ名は､EXCELのﾌｫﾝﾄ名をそのまま使用してください｡
	 * 内部的に､org.apache.poi.hssf.usermodel.HSSFFont#setFontName( String )に設定されます｡
	 * 初期値は､"ＭＳ Ｐｺﾞｼｯｸ" です｡(無指定時 POI の初期値は､Arial)
	 *
	 * TABLE_WRITER_DEFAULT_FONT_NAME = "ＭＳ Ｐｺﾞｼｯｸ" ;
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String TABLE_WRITER_DEFAULT_FONT_NAME = "ＭＳ Ｐｺﾞｼｯｸ" ;

	/**
	 * EXCEL出力時のﾃﾞﾌｫﾙﾄﾌｫﾝﾄﾎﾟｲﾝﾄ数(初期値:11)｡
	 * EXCEL出力時のﾃﾞﾌｫﾙﾄﾌｫﾝﾄﾎﾟｲﾝﾄ数を設定します｡
	 * 内部的に､org.apache.poi.hssf.usermodel.HSSFFont#setFontHeightInPoints( short )に設定されます｡
	 * 初期値は､"11" です｡(無指定時 POI の初期値は､10)
	 *
	 * TABLE_WRITER_DEFAULT_FONT_POINTS = "11" ;
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String TABLE_WRITER_DEFAULT_FONT_POINTS = "11" ;

	/**
	 * 書込処理でｺｰﾄﾞﾘｿｰｽのﾗﾍﾞﾙ変換を行うかどうか｡
	 *
	 * ｺｰﾄﾞﾘｿｰｽをﾗﾍﾞﾙに変換して出力するかどうかを指定します｡
	 * 当然､ｺｰﾄﾞはﾕﾆｰｸですが､ﾗﾍﾞﾙはﾕﾆｰｸになるかどうか保障はされていませんので
	 * TableReader 系で読み込む場合には､ﾘｽｸが発生します｡
	 * また､TableReader 系で読み込む場合にも､ﾗﾍﾞﾙからｺｰﾄﾞを求める逆変換を行うように､
	 * setUseRenderer ﾒｿｯﾄﾞで指定する必要があります｡
	 *
	 * USE_TABLE_WRITER_RENDERER = "false" ;
	 *
	 * @og.rev 5.2.1.0 (2010/10/01) 新規追加
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_TABLE_WRITER_RENDERER = "false" ;

	/**
	 * ｾﾚｸﾄﾒﾆｭｰの場合､ｷｰ:ﾗﾍﾞﾙ形式で表示するかどうか[true/false/null]を指定します｡
	 *
	 * ｶﾗﾑがﾌﾟﾙﾀﾞｳﾝﾒﾆｭｰ形式の場合､ｷｰ:ﾗﾍﾞﾙ形式で表示するか､ﾗﾍﾞﾙだけで表示するかを
	 * 選択できます｡
	 * true を指定すると､｢強制的に｣ｷｰ:ﾗﾍﾞﾙ形式で表示します｡
	 * false の場合は､｢強制的に｣ﾗﾍﾞﾙのみで表示されます｡
	 * 初期値の null の場合､ｺｰﾄﾞﾘｿｰｽや､SQL文に準拠した指定通りの形式で表示します｡
	 *
	 * USE_ADD_KEY_LABEL = "" ;
	 *
	 * @og.rev 6.3.1.0 (2015/06/28) 個人ﾘｿｰｽのUSE_ADD_KEY_LABELで初期値設定
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String USE_ADD_KEY_LABEL = "" ;

	/**
	 * 読取処理でﾗﾍﾞﾙをｺｰﾄﾞﾘｿｰｽのｶﾗﾑに対して､ｷｰ:ﾗﾍﾞﾙ形式の読み取りを行うかどうか｡
	 *
	 * TableWriter_Renderer 系のｸﾗｽで､addKeyLabel="true" で出力した場合は､ｺｰﾄﾞﾘｿｰｽが
	 * ｷｰ:ﾗﾍﾞﾙ形式で出力されます｡
	 * そのﾌｧｲﾙを読み取ると､そのままでは､ｴﾗｰになります｡
	 * ここで､ｺｰﾄﾞﾘｿｰｽのｶﾗﾑに対して､ｷｰ:ﾗﾍﾞﾙ形式の場合は､ｷｰだけを求める処理を行うことで､
	 * Renderer 系で出力したﾌｧｲﾙを取り込むことができるようにします｡
	 *
	 * USE_TABLE_READER_RENDERER = "true" ;
	 *
	 * @og.rev 5.2.1.0 (2010/10/01) 新規追加
	 * @og.rev 6.2.1.0 (2015/03/13) ｺｰﾄﾞﾘｿｰｽ毎のﾗﾍﾞﾙ逆引きﾏｯﾌﾟを廃止し､Key:Val 分解のみにする｡
	 * @og.rev 6.2.3.0 (2015/05/01) 初期値を true にする｡
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_TABLE_READER_RENDERER = "true" ;

	/*
	 * ======================================================================
	 * org.opengion.hayabusa.db.* で使用している変数
	 * ======================================================================
	 */

	// /**
	// * ｺﾈｸｼｮﾝを取得するのに,何回ﾘﾄﾗｲするか｡
	// * DB_RETRY_COUNT = "10" ;
	// *
	// * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(未使用の為廃止)
	// *
	// * @og.paramLevel 7:要再起動
	// */
	// 7.4.4.0 (2021/06/30) Delete
	// public static final String DB_RETRY_COUNT = "10" ;

	// /**
	// * ｺﾈｸｼｮﾝを取得するﾘﾄﾗｲの間隔(ﾐﾘ秒)｡
	// * DB_RETRY_TIME = "1000" ;
	// *
	// * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(未使用の為廃止)
	// *
	// * @og.paramLevel 7:要再起動
	// */
	// 7.4.4.0 (2021/06/30) Delete
	// public static final String DB_RETRY_TIME = "1000" ;

	/**
	 * ﾃﾞｰﾀ検索時の最大件数｡
	 * この件数以上のﾃﾞｰﾀは､物理的に取得できなくなります｡
	 * 個人設定可能ですが､帳票ﾃﾞｰﾓﾝ等は､ｼｽﾃﾑﾊﾟﾗﾒｰﾀでの
	 * 設定値が使用されます｡
	 * DB_MAX_ROW_COUNT = "1000" ;
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String DB_MAX_ROW_COUNT = "1000" ;

	/**
	 * ﾃﾞｰﾀ検索時の最大処理制限時間｡
	 * この時間(秒数)以上 SQLが終了しない場合は, 実行中の処理を途中で中断します｡
	 * PL/SQL等で､異常に長い場合や､ﾙｰﾌﾟ状態になっている場合の対応です｡
	 * はじめから､処理時間が長いことが判っている場合は､調整してください｡
	 * 初期値は､３００秒です｡
	 * DB_MAX_QUERY_TIMEOUT = "300" ;
	 * @og.paramLevel 7:要再起動
	 */
	public static final String DB_MAX_QUERY_TIMEOUT = "300" ;

//	/**
//	 * ﾃﾞｰﾀ検索時のﾌｪｯﾁｻｲｽﾞ｡
//	 * ﾃﾞｰﾀﾍﾞｰｽから取り出す必要がある行数についてのﾋﾝﾄをJDBCに与えます｡
//	 * 指定された値が0の場合､ﾋﾝﾄは無視されます｡
//	 * ORACLEのﾃﾞﾌｫﾙﾄ値は､10 ですが､10000以上にすると､逆にﾊﾟﾌｫｰﾏﾝｽが
//	 * 落ちる可能性があります｡
//	 * 初期値は､DB_MAX_ROW_COUNT + 1 にしています｡これは､最大件数が､超えた場合で
//	 * かつ次のﾃﾞｰﾀがある場合は､ｵｰﾊﾞｰﾌﾛｰの判定をしているためで､＋１件余分に
//	 * 取得しています｡この際､１件取得するために､次の1000件を取得する必要はないため､
//	 * 最大件数 + 1 にしています｡(これが､どれくらい効果があるか不明です)
//	 * 初期値は､1001 です｡
//	 *
//	 * @og.rev 6.9.3.0 (2018/03/26) 新規追加
//	 * @og.rev 6.9.3.0 (2018/03/26) 廃止(org.opengion.fukurou.system.HybsConst#DB_FETCH_SIZE に移動)
//	 *
//	 * DB_FETCH_SIZE = "1001" ;
//	 * @og.paramLevel 7:要再起動
//	 */
//	public static final String DB_FETCH_SIZE = "1001" ;

//	/**
//	 * ﾃﾞｰﾀ登録時のﾊﾞｯﾁｻｲｽﾞ｡
//	 * addBatch() と､executeBatch()を行うﾊﾞｯﾁｻｲｽﾞを指定します｡
//	 * ﾊﾞｯﾁできるのは､UPDATE､INSERTまたはDELETE操作のみです｡
//	 * また､ﾌﾟﾘｺﾝﾊﾟｲﾙされたSQL文のみで､OUTﾊﾟﾗﾒｰﾀは
//	 * ｻﾎﾟｰﾄされません｡
//	 * ORACLEは､ﾊﾞｯﾁ･ｻｲｽﾞを50から100の一般的な範囲に保つことを
//	 * 薦めています｡また､StatementおよびCallableStatementｵﾌﾞｼﾞｪｸﾄに
//	 * 対する標準ﾊﾞｯﾁ処理構文の使用をｻﾎﾟｰﾄしますが､ﾊﾟﾌｫｰﾏﾝｽが
//	 * 向上するのはPreparedStatementｵﾌﾞｼﾞｪｸﾄの場合のみです｡
//	 *
//	 * 初期値は､100 です｡
//	 *
//	 * @og.rev 6.9.3.0 (2018/03/26) 新規追加
//	 *
//	 * DB_BATCH_SIZE = "100" ;
//	 * @og.paramLevel 7:要再起動
//	 */
//	public static final String DB_BATCH_SIZE = "100" ;

	/**
	 * Selection_DB ｵﾌﾞｼﾞｪｸﾄをｷｬｯｼｭしておく最大時間(ﾐﾘ秒)｡
	 * この時間(ﾐﾘ秒)以上ﾌﾟｰﾙされているSelection_DB はｷｬｯｼｭを使用しません｡
	 * Selection_DB ｵﾌﾞｼﾞｪｸﾄは､DB検索結果のﾌﾟﾙﾀﾞｳﾝﾒﾆｭｰ情報です｡
	 * 行ごとのﾌﾟﾙﾀﾞｳﾝﾒﾆｭｰをｺｰﾄﾞﾘｿｰｽではなく､DBMENU等のﾃﾞｰﾀﾍﾞｰｽ
	 * より作成する場合､毎回検索していたのではｻｰﾊﾞｰ負荷や実行時間が増えてしまいます｡
	 * この値をｷｬｯｼｭしておき､一覧表示状態では､ｷｬｯｼｭを利用するようにすると､
	 * ﾊﾟﾌｫｰﾏﾝｽが向上します｡
	 * 設定の目安として､一回の検索で連続してＤＢﾌﾟﾙﾀﾞｳﾝﾒﾆｭｰ検索を行う処理時間
	 * を確保しておけばよいでしょう｡それより短いと､ｷｬｯｼｭとのやり取りの分､
	 * ｷｬｯｼｭを使用しない方が早くなります｡また､長すぎると､取得先のＤＢの
	 * 値が反映されない為､登録した項目がﾌﾟﾙﾀﾞｳﾝﾒﾆｭｰより選べなくなります｡
	 * 初期値:10秒(10000 ms)に設定します｡
	 * DB_CACHE_TIME = "10000" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String DB_CACHE_TIME = "10000" ;

//	/**
//	 * DBColumn ｵﾌﾞｼﾞｪｸﾄが正式で無い場合のﾁｪｯｸﾚﾍﾞﾙ｡
//	 * DBColumn ｵﾌﾞｼﾞｪｸﾄは､通常はｶﾗﾑﾘｿｰｽから作成されます｡それ以外に
//	 * 定義が無い場合の初期値値(size 20のﾃｷｽﾄﾌｨｰﾙﾄﾞ)や､ﾃﾞｰﾀﾍﾞｰｽ
//	 * ﾒﾀﾃﾞｰﾀより作成される場合もあります｡(使いすてｶﾗﾑや検索ｶﾗﾑ)
//	 * しかし､ｶﾗﾑﾘｿｰｽより作成していない場合は､ﾁｪｯｸ項目が緩く､
//	 * そのままﾃﾞｰﾀﾍﾞｰｽ登録すると問題になるｹｰｽがあります｡
//	 * そこで､正式なｶﾗﾑｵﾌﾞｼﾞｪｸﾄで無い場合のﾁｪｯｸﾚﾍﾞﾙを指定することで
//	 * 何もしない, 正常(0), 警告(1), 異常(2) のﾚﾍﾞﾙを登録します｡
//	 * DB_OFFICIAL_COLUMN_CHECK_LEVEL = "1" ;
//	 * @og.paramLevel 3:標準推奨
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止
//	 */
//	public static final String DB_OFFICIAL_COLUMN_CHECK_LEVEL = "1" ;

	/**
	 * [統合DB]ｱｸｾｽﾛｸﾞ取得の為,ｱﾌﾟﾘｹｰｼｮﾝ情報を追記するかどうか指定します｡
	 *
	 * 内部情報とは､接続ﾕｰｻﾞｰのｸﾗｲｱﾝﾄ情報と､実行状況のｱﾌﾟﾘｹｰｼｮﾝ情報があります｡
	 *
	 * ｸﾗｲｱﾝﾄ情報とは､"i=192.168.51.81,h=null,u=C12345" 的な文字列で､
	 * i=の後ろに IPｱﾄﾞﾚｽ､h=の後ろにﾎｽﾄ名､u=の後ろにﾕｰｻﾞｰ名をｾｯﾄして､
	 * DBMS_APPLICATION_INFO.SET_CLIENT_INFO( "i=192.168.51.81,h=null,u=C12345" ) を
	 * CALL します｡
	 *
	 * ｱﾌﾟﾘｹｰｼｮﾝ情報とは､"o=SELECT,p=GEXXXX" 的な文字列で､o=の後ろに 操作､
	 * p=の後ろにﾌﾟﾛｸﾞﾗﾑIDをｾｯﾄして､
	 * DBMS_APPLICATION_INFO.SET_MODULE( "GE0010","o=操作,p=ﾌﾟﾛｸﾞﾗﾑID" ) を
	 * CALL します｡
	 *
	 * このPL/SQL を使用するｺﾈｸｼｮﾝについて実行すると､ｱｸｾｽﾛｸﾞ記録を行う為の
	 * 情報として取り出すことが可能になります｡
	 * ※ 一般のDBでは､この値を取得する機構を用意する必要がる為､通常は設定不要です｡
	 *
	 * @og.rev 6.2.5.0 (2015/06/05) 初期値変更 true → false
	 * @og.rev 6.3.6.1 (2015/08/28) 初期値変更 false → true
	 *
	 * USE_DB_APPLICATION_INFO = "true" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_DB_APPLICATION_INFO = "true" ;

	/**
	 * ﾘｿｰｽ更新時に､ﾘﾓｰﾄﾘｿｰｽのｷｬｯｼｭｸﾘｱを行うかどうか指定します｡
	 *
	 * ﾘﾓｰﾄﾘｿｰｽとは､同じｼｽﾃﾑIDの別のTomcatのﾘｿｰｽの事で､大規模ｼｽﾃﾑで
	 * 複数Tomcatを起動して運用している場合､一つのTomcatでﾘｿｰｽの変更を行った場合､
	 * 別のTomcatのｷｬｯｼｭをｸﾘｱして､新しいﾘｿｰｽを取り込むようにする事で､
	 * 一斉に更新する機能です｡
	 * GEでﾘｿｰｽ更新する場合に､元のｼｽﾃﾑへの自動反映させるため､初期値は､true にします｡
	 *
	 * @og.rev 6.2.6.0 (2015/06/19) 新規追加
	 *
	 * USE_REMOTE_RESOURCE_CLEAR = "true" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_REMOTE_RESOURCE_CLEAR = "true" ;

	/**
	 * [統合DB]ﾘｿｰｽ更新時の､BASIC認証のﾕｰｻﾞｰとﾊﾟｽﾜｰﾄﾞです｡
	 *
	 * ﾘﾓｰﾄﾘｿｰｽ更新で､他のTomcatへURLConnect で接続する場合に使用される
	 * 認証情報です｡
	 *
	 * @og.rev 6.2.5.0 (2015/06/05) 新規追加
	 * @og.rev 6.9.0.1 (2018/02/05) ]ﾘｿｰｽ更新時のﾕｰｻﾞｰ､ﾊﾟｽ変更
	 *
//	 * REMOTE_USER_PASS = "RMCN_USR:RMCN_PASS" ;
	 * REMOTE_USER_PASS = "admin:admin" ;
	 * @og.paramLevel 3:標準推奨
	 */
//	public static final String REMOTE_USER_PASS = "RMCN_USR:RMCN_PASS" ;
	public static final String REMOTE_USER_PASS = "admin:admin" ;

	/**
	 * urlConnectﾀｸﾞの接続ﾀｲﾑｱｳﾄ時間の初期値を､(秒)で指定します｡
	 *
	 * urlConnectﾀｸﾞのtimeout属性でもﾀｲﾑｱｳﾄ時間を設定できますが､その共通初期値です｡
	 * 実際には､java.net.URLConnection#setConnectTimeout(int) に 1000倍して設定されます｡
	 * 0 は､無限のﾀｲﾑｱｳﾄ､ﾏｲﾅｽは､設定しません｡(つまりJavaの初期値のまま)
	 *
	 * @og.rev 6.2.5.0 (2015/06/05) 新規追加
	 *
	 * URL_CONNECT_TIMEOUT = "1" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String URL_CONNECT_TIMEOUT = "1" ;

	/**
	 * ﾚﾝﾃﾞﾗｰを利用したExcel出力時の文字ﾀｲﾌﾟを文字型にするかどうか指定します｡
	 *
	 * trueの場合は標準として文字型出力を行います｡
	 *
	 * ﾚﾝﾃﾞﾗｰをかけた場合は数値型に対しても文字が入る可能性があります｡
	 * その場合に数値変換をかけるとｴﾗｰとなるため､標準は文字型として出力します｡
	 * falseとするとDBTypeに従った出力となります｡
	 * 初期値はｴﾗｰ回避のためにtrueとしています｡
	 * ※ 6.2.0.0 (2015/02/27) 初期値を false に変更しました｡
	 *
	 * ｶﾗﾑｵﾌﾞｼﾞｪｸﾄに対する指定のため､ColumnEditorﾀｸﾞでのｺﾝﾄﾛｰﾙも可能です｡
	 *
	 * @og.rev 6.2.0.0 (2015/02/27) 初期値変更 true → false
	 *
	 * USE_STRING_EXCEL_OUTPUT = "false" ;
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String USE_STRING_EXCEL_OUTPUT = "false" ;			// 6.2.0.0 (2015/02/27)

	/*
	 * ======================================================================
	 * org.opengion.hayabusa.html.* で使用している変数
	 * ======================================================================
	 */

	/**
	 * 画面上に一度に表示されるﾃﾞｰﾀ件数｡
	 * ただし，HTMLTextField.java のみ，１件ずつ表示に固定されています｡
	 * HTML_PAGESIZE = "100" ;
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String HTML_PAGESIZE = "100" ;

//	/**
//	 * ﾃｰﾌﾞﾙ表示の 各種属性を一括指定します｡
//	 * 以前は､それぞれの属性を個別に定義するｷｰﾜｰﾄﾞを持っていましたが､
//	 * 現在は､CSS で定義するようになりました｡
//	 * それでも､場合によっては､table ﾀｸﾞに直接属性を設定したいｹｰｽがありますので
//	 * その場合に､指定してください｡
//	 *
//	 * HTML_TABLE_PARAM = "frame=\"box\" border=\"1px\" cellpadding=\"0\" cellspacing=\"0\" rules=\"all\" bordercolor=\"#ff0000\"" ;
//	 * HTML_TABLE_PARAM = "0" ;
//	 *
//	 * @og.rev 5.2.3.0 (2010/12/01) ﾃｰﾌﾞﾙ罫線対応
//	 * @og.rev 5.3.4.0 (2011/04/01) 初期値変更
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止
//	 * @og.paramLevel 3:標準推奨
//	 */
//	public static final String HTML_TABLE_PARAM = "" ;

	// /**
	// * ｶﾗﾑ値合成のｾﾊﾟﾚｰﾀｰ｡
	// * 複数のｶﾗﾑ値を合成して表示する場合に使用するｾﾊﾟﾚｰﾀｰを設定します｡
	// * 初期値は､":" です｡
	// * HTML_SEPARATOR = ":" ;
	// *
	// * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(未使用の為廃止)
	// *
	// * @og.paramLevel 3:標準推奨
	// */
	// 7.4.4.0 (2021/06/30) Delete
	// public static final String HTML_SEPARATOR = ":" ;

	/**
	 * ｶﾗﾑﾀｸﾞのﾃｷｽﾄﾌｨｰﾙﾄﾞを表示する最大桁数｡
	 * ｶﾗﾑﾀｸﾞは､ｶﾗﾑ定義の使用桁数(USE_LENGTH)だけのﾃｷｽﾄﾌｨｰﾙﾄﾞを
	 * 作成しようとしますが､ここで指定の値を最大値として､表示します｡
	 * ただし､表示桁数(VIEW_LENGTH)が設定されている場合は､そちらを優先します｡
	 * 入力可能文字数の制限とは異なり､ﾌｨｰﾙﾄﾞをどの長さまで表示させるかを
	 * 指定するだけです｡
	 * この長さ以下のﾌｨｰﾙﾄﾞについては，元のﾌｨｰﾙﾄﾞの長さで表示します｡
	 * HTML_COLUMNS_MAXSIZE = "20" ;
	 * @og.paramLevel 1:設定確認
	 */
	public static final String HTML_COLUMNS_MAXSIZE = "20" ;

	/**
	 * VIEWﾀｸﾞのﾃｷｽﾄﾌｨｰﾙﾄﾞを表示する最大桁数｡
	 * VIEWﾀｸﾞ で表示する場合の HTML_COLUMNS_MAXSIZE に対する値になります｡
	 *
	 * 元々､検索条件を入力する ｶﾗﾑﾀｸﾞ は､多くのﾌｨｰﾙﾄﾞ長は不要です｡
	 * ﾃﾞｰﾀを入力する VIEWﾀｸﾞでは､ｶﾗﾑﾀｸﾞで作成するより大きなﾌｨｰﾙﾄﾞを
	 * 必要とします｡
	 * 以前は､HTML_COLUMNS_MAXSIZE * 2 がﾊｰﾄﾞｺｰﾃﾞｨﾝｸﾞされていました｡
	 * この長さ以下のﾌｨｰﾙﾄﾞについては，元のﾌｨｰﾙﾄﾞの長さで表示します｡
	 * HTML_VIEW_COLUMNS_MAXSIZE = "50" ;
	 *
	 * @og.rev 6.2.0.0 (2015/02/27) 初期値変更 "40" → "30"
	 * @og.paramLevel 1:設定確認
	 */
	public static final String HTML_VIEW_COLUMNS_MAXSIZE = "30" ;			// 6.2.0.0 (2015/02/27)

	/**
	 * ﾃｷｽﾄﾌｨｰﾙﾄﾞを並べて表示させる場合の,横方向の表示間隔｡
	 * ﾃｷｽﾄﾌｨｰﾙﾄﾞの自動表示では､縦×横に並べますが､その横の箱同士が
	 * 近すぎると､表示文字とﾗﾍﾞﾙがくっついた状態で見えることがあります｡
	 * この箱間の幅をﾋﾟｸｾﾙで指定します｡
	 * HTML_COLUMS_SPACE = "10" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String HTML_COLUMS_SPACE = "10" ;

	/**
	 * ﾃｷｽﾄﾌｨｰﾙﾄﾞを並べて表示させる場合の,縦方向の最大表示件数｡
	 * 逆にこの件数を超える場合は､横方向の表示を行います｡
	 * ﾃｷｽﾄﾌｨｰﾙﾄﾞの自動表示では､ﾌｨｰﾙﾄﾞの数に対して､縦方向に
	 * この数だけ並べます｡それ以上の場合は､横のﾌｨｰﾙﾄﾞへ､さらに超える場合は､
	 * その横と､順次並べていきます｡
	 * 初期値は､10 個です｡
	 * HTML_MAXROW_NUMBER = "10" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String HTML_MAXROW_NUMBER = "10" ;

	/**
	 * ﾗﾍﾞﾙｾﾊﾟﾚｰﾀｰ使用有無｡
	 * ﾗﾍﾞﾙとﾌｨｰﾙﾄﾞのｾﾊﾟﾚｰﾀｰとして､ｺﾛﾝ(:)を使用するかどうか指定します｡
	 * 初期値は､使用する(true)です｡
	 * HTML_LABEL_SEPARATOR = "true" ;
	 * @og.paramLevel 7:要再起動
	 */
	public static final String HTML_LABEL_SEPARATOR = "true" ;

//	/**
//	 * ﾁｪｯｸﾎﾞｯｸｽの全ﾁｪｯｸ属性の初期値｡
//	 * viewForm の useCheckControl 属性の初期値を設定します｡
//	 *
//	 * この属性は､selectedTypeがCHECKBOXの時に､ﾁｪｯｸﾎﾞｯｸｽの全ﾁｪｯｸを選択する
//	 * JavaScript の機能を使用するかどうかを指定するのに使います｡
//	 * useCheckControl=true に設定すると､ｺﾝﾄﾛｰﾙ用のﾁｪｯｸﾎﾞｯｸｽが現れて､
//	 * この機能を使用することができるようになります｡
//	 * false は､全ﾁｪｯｸを使用しません｡checked は､初期値を､ﾁｪｯｸ済みにします｡
//	 * false は､0でも代用可能です｡true は､1でも代用可能です｡
//	 * checked は､2でも代用可能です｡
//	 * VIEW_USE_CHECK_CONTROL = "true" ; 全ﾁｪｯｸを使用
//	 * VIEW_USE_CHECK_CONTROL = "1" ;  true と同じ
//	 * VIEW_USE_CHECK_CONTROL = "checked" ;  ﾁｪｯｸ済みの全ﾁｪｯｸを作成
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止
//	 *
//	 * @og.paramLevel 4:個人設定可
//	 */
//	public static final String VIEW_USE_CHECK_CONTROL = "true" ;

	/**
	 * EDITOR の AUTOAREA(自動ｻｲｽﾞﾃｷｽﾄｴﾘｱ)の最大列数｡
	 *
	 * AUTOAREAは､ﾃﾞｰﾀ量によって､自動的にｻｲｽﾞを変更するﾃｷｽﾄｴﾘｱです｡
	 * このﾃｷｽﾄｴﾘｱの最大列数を外部で指定する場合にこのﾊﾟﾗﾒｰﾀを使用します｡
	 * この大きさ分のﾃｷｽﾄｴﾘｱの幅で折り返しが発生するとして､
	 * 行数計算も行われます｡
	 * 0 が指定された場合は､無制限になります｡
	 * AUTOAREA の編集ﾊﾟﾗﾒｰﾀに､minRow-maxRow,minCol-maxCol として､最小､最大の
	 * それぞれの行列数を指定した場合は､そちらが優先されます｡
	 * HTML_AUTOAREA_MAX_COL_SIZE = "80" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String HTML_AUTOAREA_MAX_COL_SIZE = "80" ;

	/**
	 * EDITOR の AUTOAREA(自動ｻｲｽﾞﾃｷｽﾄｴﾘｱ)の最大行数｡
	 *
	 * AUTOAREAは､ﾃﾞｰﾀ量によって､自動的にｻｲｽﾞを変更するﾃｷｽﾄｴﾘｱです｡
	 * このﾃｷｽﾄｴﾘｱの最大行数を外部で指定する場合にこのﾊﾟﾗﾒｰﾀを使用します｡
	 * この大きさ分のﾃｷｽﾄｴﾘｱの行で打ち切られます｡
	 * 0 が指定された場合は､無制限になります｡
	 * AUTOAREA の編集ﾊﾟﾗﾒｰﾀに､minRow-maxRow,minCol-maxCol として､最小､最大の
	 * それぞれの行列数を指定した場合は､そちらが優先されます｡
	 * HTML_AUTOAREA_MAX_ROW_SIZE = "30" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String HTML_AUTOAREA_MAX_ROW_SIZE = "30" ;

//	/**
//	 * ﾏﾙﾁｷｰ入力ﾒﾆｭｰの作成可否｡
//	 *
//	 * 複数文字列のｷｰ入力に反応するﾌﾟﾙﾀﾞｳﾝﾒﾆｭｰを追加します｡
//	 * JavaScriptでの対応ですので､便利機能と位置付けてください｡
//	 * 使用する場合は､optionAttributes 属性を使用して設定するか､
//	 * USE_MULTI_KEY_SELECT=true で設定します｡
//	 * 初期値は､false (作成しない)です｡
//	 * USE_MULTI_KEY_SELECT = "false" ;
//	 * @og.paramLevel 3:標準推奨
//	 *
//	 * @og.rev 5.6.3.0 (2013/04/01) IE10対応でfalseに変更｡(IE8以降ﾌﾞﾗｳｻﾞ標準)
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止
//	 */
//	public static final String USE_MULTI_KEY_SELECT = "false" ;

//	/**
//	 * 登録時整合性ﾁｪｯｸの使用有無｡
//	 *
//	 * Consistency ｷｰ による整合性ﾁｪｯｸを行うかどうかを指定する
//	 * 属性の初期値を設定します｡
//	 *
//	 * 画面よりＤＢ登録時に､ＩＥの戻るﾎﾞﾀﾝで戻り､ｷｬｯｼｭされている画面を
//	 * 登録すると､画面と異なるﾒﾓﾘ上のDBTableModel が再び更新されてしまう
//	 * というﾄﾗﾌﾞﾙへ対応する為､画面の hidden ﾊﾟﾗﾒｰﾀ と DBTableModel が
//	 * 一致しないとｴﾗｰにするという処理を､行うかどうかを指定できます｡
//	 * viewFormTag で､整合性ﾊﾟﾗﾒｰﾀを出力し､entryTag で､ﾁｪｯｸします｡
//	 * 初期値は､true (使用する)です｡
//	 * USE_CONSISTENCY = "true" ;
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止
//	 * @og.paramLevel 3:標準推奨
//	 */
//	public static final String USE_CONSISTENCY = "true" ;

//	/**
//	 * 同一ｾｯｼｮﾝでのﾏﾙﾁ起動対策を行うかどうか｡
//	 *
//	 * 通常､同一ｾｯｼｮﾝで登録操作を行うと､『画面とﾃﾞｰﾀの整合性ﾁｪｯｸで
//	 * ｴﾗｰが出ました｡』ｴﾗｰが発生するようになっていますが､その前の段階､
//	 * つまり､ﾒﾆｭｰより選択した段階で､ﾏﾙﾁｾｯｼｮﾝになっていない
//	 * (つまり､同一ｾｯｼｮﾝで､以前に作成されたﾒﾆｭｰからｱｸｾｽされた)
//	 * 事を判定します｡
//	 * ﾒﾆｭｰにMSC=ｶｳﾝﾀというﾊﾟﾗﾒｰﾀを儲け､session_init.jsp で判定しています｡
//	 * 初期値は､true (使用する)です｡
//	 * USE_MULTI_SESSION_CHECK = "true" ;
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止
//	 * @og.paramLevel 3:標準推奨
//	 */
//	public static final String USE_MULTI_SESSION_CHECK = "true" ;

	/*
	 * ======================================================================
	 * org.opengion.hayabusa.taglib.* で使用している変数
	 * ======================================================================
	 */

	/**
	 * ﾒｰﾙ送信ｴﾝｺｰﾄﾞ名｡
	 *
	 * E-Mail で日本語を送信する場合のﾃﾞﾌｫﾙﾄｴﾝｺｰﾄﾞ名を指定します｡
	 * 現状では､Windows-31J , MS932 , ISO-2022-JP ,それ以外 となっています｡
	 * それ以外は､一律に､ISO-2022-JP にて送信されます｡
	 * 一般に､E-Mail で日本語を送信する場合､ISO-2022-JP (JISｺｰﾄﾞ)化して､
	 * 7bit でｴﾝｺｰﾄﾞして送信する必要がありますが､Windows系の特殊文字や､
	 * unicodeと文字のﾏｯﾋﾟﾝｸﾞが異なる文字､半角ｶﾀｶﾅなどが､文字化けします｡
	 * 社内ｼｽﾃﾑなどの連絡用に使用するのであれば､Windowsｼｽﾃﾑに
	 * 特化した､Windows-31J の方が文字化けに関する心配は低減されます｡
	 * 初期値は､ISO-2022-JP です｡
	 * MAIL_DEFAULT_CHARSET = "ISO-2022-JP" ;
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String MAIL_DEFAULT_CHARSET = "ISO-2022-JP" ;

	/**
	 * mailSenderﾀｸﾞでGE32,34に送信履歴を残すかどうか[true/false]｡
	 * USE_MAILSENDER_HISTORY = "false"
	 *
	 * @og.rev 5.9.3.0 (2015/12/04) 新規追加
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String USE_MAILSENDER_HISTORY = "false" ;

	/**
	 * 編集ﾃﾞｰﾀのﾘｸｴｽﾄ値の転送有無｡
	 * DBTableModel からの編集ﾃﾞｰﾀ(ｷｰ__行番号)のﾘｸｴｽﾄを
	 * frame ﾀｸﾞで渡すかどうかを指定します｡
	 * 引数が多いと､画面が空白になる現象があるため通常､転送しません｡
	 * 初期値は､false (転送しません)｡
	 * FRAME_UNDER_BAR_REQUEST_KEY_USED = "false" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String FRAME_UNDER_BAR_REQUEST_KEY_USED = "false" ;

	/**
	 * ﾍﾟｰｼﾞの先頭へのﾘﾝｸの間隔｡
	 * ViewFormTagで､backLinkCount(ﾍﾟｰｼﾞの先頭へのﾘﾝｸの間隔)の
	 * 初期値を設定します｡
	 * 0 が設定された場合は､ﾍﾟｰｼﾞ先頭へのﾘﾝｸは作成されません｡
	 * (通常､ﾍｯﾀﾞｰ固定を使用する場合は､"0"ﾘﾝｸなしとします｡)
	 * 設定がない場合は､NumberFormatException がｽﾛｰされます｡
	 * VIEW_BACK_LINK_COUNT = "0" ;  ﾘﾝｸなし
	 * VIEW_BACK_LINK_COUNT = "10" ; ﾃﾞｰﾀ１０行毎に先頭へのﾘﾝｸが作成される｡
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String VIEW_BACK_LINK_COUNT = "0" ;

	/**
	 * ﾍｯﾀﾞｰを出力する間隔｡
	 * ViewFormTagで､headerSkipCount(ﾍｯﾀﾞｰを出力する間隔)の
	 * 初期値を設定します｡
	 * 0 が設定された場合は､ﾍｯﾀﾞｰは､最初だけで繰り返し出力されません｡
	 * (通常､ﾍｯﾀﾞｰ固定を使用する場合は､"0"先頭のみとします｡)
	 * 設定がない場合は､NumberFormatException がｽﾛｰされます｡
	 * VIEW_HEADER_SKIP_COUNT = "0" ;  ﾍｯﾀﾞｰは､先頭のみ作成される｡
	 * VIEW_HEADER_SKIP_COUNT = "10" ; ﾍｯﾀﾞｰは､ﾃﾞｰﾀ１０行毎に作成される｡
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String VIEW_HEADER_SKIP_COUNT = "0" ;

	/**
	 * ﾍｯﾀﾞｰのｿｰﾄ用ﾘﾝｸの有無｡
	 * ViewFormTagで､useTableSorter(ﾍｯﾀﾞｰにｿｰﾄ用ﾘﾝｸを作成するかどうか)の
	 * 初期値を設定します｡
	 * true が設定された場合は､ﾍｯﾀﾞｰにｿｰﾄ用ﾘﾝｸを作成します｡
	 *
	 * VIEW_USE_TABLE_SORTER = "true" ;
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String VIEW_USE_TABLE_SORTER = "true" ;

	/**
	 * QUERY画面のﾍｯﾀﾞｰﾒﾆｭｰの形式指定｡
	 * QUERY画面のﾍｯﾀﾞｰﾒﾆｭｰの形式として､ONELEVEL,NEXTGUI,NONE が指定可能です｡
	 * 初期値は､ONELEVELです｡
	 * この設定は､jsp/custom/query_info.jsp 内の og:topMenu の menuType属性で
	 * 使用しています｡
	 *
	 * HEADER_MENU_TYPE = "ONELEVEL" ;
	 * @og.rev 6.3.8.3 (2015/10/03) 新規作成
	 *
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String HEADER_MENU_TYPE = "ONELEVEL" ;

	/**
	 * JSPのﾒﾆｭｰを元に､各画面を自動実行するかどうかを指定します(初期値:false)
	 * 紙芝居作成で､画面ﾒﾆｭｰから､各画面を表示し､追加､変更､削除ﾎﾞﾀﾝや､
	 * ﾘﾝｸを自動的にｸﾘｯｸしていきます｡
	 * 処理対象外の画面IDや､処理の待ち時間などのﾊﾟﾗﾒｰﾀは､
	 * custom/autoRunParam.js に記述します｡
	 * 実際には､menu/multiMenu.jsp , menu/matrixMenu.jsp から､
	 * menu/autoRun.jsp を呼び出すかどうかを､このﾊﾟﾗﾒｰﾀで指定します｡
	 * 初期値は､無効:false です｡
	 *
	 * USE_AUTO_RUN = "false" ;
	 * @og.rev 6.3.8.3 (2015/10/03) 新規作成
	 *
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String USE_AUTO_RUN = "false" ;

	/**
	 * SVGﾁｬｰﾄのﾃﾝﾎﾟﾗﾘﾃﾞｨﾚｸﾄﾘ定義｡
	 * SVGﾁｬｰﾄを作成する場合､SVGﾌｧｲﾙをﾃﾝﾎﾟﾗﾘのﾃﾞｨﾚｸﾄﾘに
	 * 出力して､そこへのｱﾄﾞﾚｽを付けて､HTMLを作成しています｡(組み込めないため)
	 * 以前は､ﾌｧｲﾙのﾃﾝﾎﾟﾗﾘと同じ､FILE_URL で指定したﾃﾞｨﾚｸﾄﾘの
	 * 下の､ChartTemp ﾌｫﾙﾀﾞでした｡
	 * ここでの定義のﾌｫﾙﾀﾞが､そのままﾃﾝﾎﾟﾗﾘﾌｧｲﾙのﾌｫﾙﾀﾞ名になります｡
	 * SVGﾁｬｰﾄのﾃﾝﾎﾟﾗﾘﾌｧｲﾙは､Tomcat終了時に自動的に削除されます｡
	 * CHART_TEMP_DIR = "filetemp/ChartTemp/" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String CHART_TEMP_DIR = "filetemp/ChartTemp/" ;

//	/**
//	 * SVGﾁｬｰﾄのﾃﾝﾎﾟﾗﾘﾃﾞｨﾚｸﾄﾘ定義｡
//	 * ChartCreateTag で使用される JFreeChart/画像ﾌｧｲﾙのｷｬｯｼｭ時間(秒)を指定します｡
//	 * この､ｷｬｯｼｭ時間(秒)を過ぎると､ｷｬｯｼｭを初期化します｡
//	 * 初期値は､600(秒) = １０分です｡
//	 * CHART_CACHE_TIME = "600" ;
//	 * @og.paramLevel 3:標準推奨
//	 *
//	 * @og.rev 8.0.0.0 (2021/10/01) jFreeChart廃止に伴う削除
//	 */
//	public static final String CHART_CACHE_TIME = "600" ;

	/**
	 * ﾍｯﾀﾞｰ固定のｽｸﾛｰﾙﾊﾞｰの使用有無｡
	 * ﾍｯﾀﾞｰ固定のｽｸﾛｰﾙﾊﾞｰを使用すると､登録ﾎﾞﾀﾝの領域を残したまま､
	 * ﾃｰﾌﾞﾙ部のみｽｸﾛｰﾙすることが可能になります｡
	 * これは､ViewFormTagで､useScrollBar(ｽｸﾛｰﾙﾊﾞｰ用のDIV要素を
	 * 出力するかどうか)の初期値を設定しています｡
	 * true が設定された場合は､ﾍｯﾀﾞｰ固定のｽｸﾛｰﾙﾊﾞｰを使用します｡
	 * VIEW_USE_SCROLLBAR = "true" ;
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String VIEW_USE_SCROLLBAR = "true" ;

	/**
	 * ﾍｯﾀﾞｰ固定のｽｸﾛｰﾙﾊﾞｰ使用時の最大行数｡
	 * ﾍｯﾀﾞｰ固定のｽｸﾛｰﾙﾊﾞｰは､JavaScriptで処理しているため､
	 * 大量のﾃﾞｰﾀを読み取ると､非常に時間がかかったり､場合によっては
	 * ﾌﾞﾗｳｻﾞがﾊﾝｸﾞｱｯﾌﾟします｡
	 * そこで､ある表示件数以上の場合は､強制的にｽｸﾛｰﾙﾊﾞｰを
	 * ｵﾌにします｡
	 * 指定以上のﾃﾞｰﾀ件数を､表示する場合に､ｵﾌにします｡
	 *
	 * VIEW_SCROLLBAR_MAX_ROW_SIZE = "1001" ;
	 *
	 * @og.rev 6.2.4.0 (2015/05/15) 新規作成
	 * @og.rev 6.6.0.0 (2016/12/01) 初期値を､1000行から､1001行に変更｡
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String VIEW_SCROLLBAR_MAX_ROW_SIZE = "1001" ;			// 6.6.0.0 (2016/12/01)

	/**
	 * 戻るﾘﾝｸ時等の行送り機能の使用有無｡
	 * ViewFormTagで､useSelectedRow(指定行の行送りを行うかどうか)の初期値を設定します｡
	 * SEL_ROW機能(戻るﾘﾝｸから戻ったときに､先にｸﾘｯｸされた行番号を返す機能)で､
	 * この機能を有効/無効を指定します｡(true:使用する/false:使用しない)
	 * 有効な場合は､選択行まで画面がｽｸﾛｰﾙします｡
	 * VIEW_USE_SELECTED_ROW = "true" ;
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String VIEW_USE_SELECTED_ROW = "true" ;

	/**
	 * 戻るﾘﾝｸ時等の選択行ﾏｰｶｰの使用有無｡
	 * AbstractViewFormで､指定行のﾏｰｶｰを行う場合の選択行色指定を行うかどうかを設定します｡
	 * 選択行の色指定(class="row_sel")を有効/無効を指定します｡(true:使用する/false:使用しない)
	 * ここでは､使用するかどうかのみの設定で､実際の色は､CSSﾌｧｲﾙで行います｡
	 * VIEW_USE_SELROW_COLOR = "true" ;
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String VIEW_USE_SELROW_COLOR = "true" ;

	/**
	 * 選択行のﾊｲﾗｲﾄ表示を行うかどうか｡
	 * ViewFormTagで､useHilightRow(選択行のﾊｲﾗｲﾄ表示を行うかどうか)の初期値を設定します｡
	 * これは､ﾁｪｯｸﾎﾞｯｸｽやﾗｼﾞｵﾎﾞﾀﾝで行選択した際に､どの行が選択されたか
	 * 判るように行のﾊｲﾗｲﾄ表示を行う機能です｡
	 * さらに､行の任意の箇所をｸﾘｯｸしても､ﾁｪｯｸが入り､ﾊｲﾗｲﾄ表示されます｡
	 * VIEW_USE_HILIGHT_ROW = "true" ;
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String VIEW_USE_HILIGHT_ROW = "true" ;

	/**
	 * 選択行のﾊｲﾗｲﾄ表示を行った場合に､ON/OFFの制御を行選択のﾁｪｯｸﾎﾞｯｸｽのみで有効にするか｡
	 * ViewFormTagで､useHilightCheckOnly(選択行ﾊｲﾗｲﾄの制御をﾁｪｯｸﾎﾞｯｸｽのみで有効にするか)の初期値を設定します｡
	 * trueの場合､ﾁｪｯｸﾎﾞｯｸｽのみで有効になります｡
	 * falseの場合､行全体の各要素で有効になります｡
	 * trueにした場合､ﾁｪｯｸﾎﾞｯｸｽが存在しない行に対しては､ﾊｲﾗｲﾄすることはできません｡
	 * VIEW_USE_HILIGHT_CHECK_ONLY = "false" ;
	 *
	 * @og.rev 4.3.7.0 (2009/06/01) 新規作成
	 *
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String VIEW_USE_HILIGHT_CHECK_ONLY = "false" ;

	/**
	 * 選択行のﾊｲﾗｲﾄ表示を行った場合に､行選択でRadioﾎﾞﾀﾝにclickｲﾍﾞﾝﾄを発行させるかどうか指定します｡
	 * true にｾｯﾄすると､行選択で､ﾗｼﾞｵにﾁｪｯｸが付くと同時に､ｸﾘｯｸｲﾍﾞﾝﾄが発行されます｡
	 * POPUP系の場合は､その時点でRETURN(画面が閉じて､値がｾｯﾄ)されます｡
	 * 個別に指定する場合は､ViewFormTagで､JavaScriptの hilightRow ﾒｿｯﾄﾞの引数に指定します｡
	 * trueの場合､clickｲﾍﾞﾝﾄを発行させます｡
	 * falseの場合､従来通り､ﾊｲﾗｲﾄ表示でﾗｼﾞｵのﾁｪｯｸは入りますが､ｲﾍﾞﾝﾄは発行されません｡
	 * 互換性を考えれば､false ですが､POPUP系で､行選択してしまうと､選択できなくなるため､
	 * 行選択で､即POPUPが閉じる true にしておきます｡
	 * VIEW_USE_HILIGHT_RADIO_CLICK = "true" ;
	 *
	 * @og.rev 6.2.2.0 (2015/03/27) hilightRow で､行選択時にｲﾍﾞﾝﾄ発行可否を指定できるようにする｡
	 *
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String VIEW_USE_HILIGHT_RADIO_CLICK = "true" ;

	/**
	 * QUERY 検索時等の結果を画面に出力する時のﾒｯｾｰｼﾞを指定｡
	 * 従来の検索結果は､画面上方に記述していましたが､[X/Y]等も出力される為､
	 * 実質的に不要な項目です｡
	 * 初期値は､ｾﾞﾛ文字列とし､何も表示しないようにしておきます｡
	 * 従来は､MSG0033 『　件検索しました｡』です｡
	 * VIEW_DISPLAY_MSG = "" ;
	 * VIEW_DISPLAY_MSG = "MSG0033" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String VIEW_DISPLAY_MSG = "" ;

	/**
	 * 一括入力ｶﾗﾑのｱｼｽﾄ機能の初期値｡
	 *
	 * これは､ｶﾗﾑの書き込み時に､一括入力可能なｶﾗﾑをﾍｯﾀﾞｰに表示し､
	 * 一括登録できる機能について､初期状態を規定します｡
	 * true:に設定すると､何も指定しない限り､一括入力用のｶﾗﾑが表示されます｡
	 * これは､ViewFormTag の clmBulkSet に､"*" を設定したのと同じ状態を作ります｡
	 * false:に設定すると､従来どおりです｡(null が設定された状態)
	 * どちらが設定されていても､ViewFormTag の clmBulkSet に､ｶﾗﾑ名を指定すると
	 * そちらが優先されます｡
	 *
	 * VIEW_USE_DEFAULT_BULKSET = "false"
	 *
	 * @og.rev 5.2.1.0 (2010/10/01) 新規追加
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String VIEW_USE_DEFAULT_BULKSET = "false" ;

	/**
	 * 処理時間を表示する TimeView を表示するかどうかの初期値(初期値:true)｡
	 *
	 * true に設定すると､処理時間を表示するﾊﾞｰｲﾒｰｼﾞが表示されます｡
	 * これは､DB検索､APｻｰﾊﾞｰ処理､画面表示の各処理時間をﾊﾞｰｲﾒｰｼﾞで
	 * 表示させる機能です｡処理時間の目安になります｡
	 * 初期値は､true です｡
	 *
	 * VIEW_USE_TIMEBAR = "true"
	 *
	 * @og.rev 6.3.5.1 (2015/08/16) 新規追加
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String VIEW_USE_TIMEBAR = "true" ;

	/**
	 * 全件無条件でのﾘｾｯﾄ呼び出しの使用有無｡
	 * EntryTagで､command="RESET" 時のｱｸｼｮﾝとして allReset() を
	 * 呼び出すかどうかを指定します｡
	 * true が設定された場合は､allReset() を呼び出します｡
	 * 初期値は､true です｡
	 * RESET_ACTION_ALL_USE = "true" ;
	 *
	 * @og.rev 6.2.6.0 (2015/06/19) 初期値を､false → true に変更
	 * @og.paramLevel 7:要再起動
	 */
	public static final String RESET_ACTION_ALL_USE = "true" ;

//	/**
//	 * ｵﾗｸﾙ文字化け対応処理の実施有無｡
//	 * Shift-JISで作成されたｵﾗｸﾙとWindowsとの間の 文字ｺｰﾄﾞ変換を行うかどうか
//	 * を指定します｡
//	 * 例えば､"～"は､正常に登録できますが､表示を行う段階で文字化けが発生します｡
//	 * これは､unicode 0x301c ですが､Windows上では､このｺｰﾄﾞが認識できず､
//	 * 0xff5e を､"～" に認識します｡
//	 * 登録時は､JDBCが Shift-JIS(0x8160)を､0x301c に変換して登録する為､
//	 * 文字化けは発生しません｡
//	 * 対策として､ＤＢから検索した値 0x301c は､0xff5e に変換して表示させます｡
//	 * また､UTF-8では､『円ﾏｰｸ』が､『ﾊﾞｯｸｽﾗｯｼｭ』で表示されます｡
//	 * これは､ｺｰﾄﾞが全く異なる 『円ﾏｰｸ』に置き換えないと､きちんと
//	 * 表示されません｡この場合は､Set時には､元に戻す必要があります｡
//	 * 初期値は､false です｡
//	 * USE_UTF8_CHARACTER_TRANSLATION = "false" ;
//	 * @og.paramLevel 7:要再起動
//	 */
//	//	public static final String USE_UTF8_CHARACTER_TRANSLATION = "false" ;

	/**
	 * ｼｪﾙ実行時のﾀｲﾑｱｳﾄ時間(秒)｡
	 * 指定時間の単位は､秒です｡
	 * 0 秒に設定すると､割り込みが入るまで､待ちつづけます｡
	 * 過去の互換性の関係で､大きな時間が入っていますが､基本的には､
	 * １０分､１５分を目安に設定してください｡
	 * 初期値は､3600 秒です｡
	 * SHELL_TIMEOUT = "3600" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String SHELL_TIMEOUT = "3600" ;

	/**
	 * ｶﾗﾑでﾘｿｰｽﾌｧｲﾙの初期値を使うかどうかを指定｡
	 * ｶﾗﾑの値や初期値がｾｯﾄされていないときに､ｶﾗﾑﾘｿｰｽの
	 * 初期値を利用するかどうかを､true/false で指定します｡
	 * true の場合は､初期値を使用します｡
	 * 過去との互換性の関係で､この属性は､false に設定されています｡
	 * USE_DEFAULT_PROPERTIE_VALUE = "false" ;
	 *
	 * @og.rev 5.2.3.0 (2010/12/01) 新規追加
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_DEFAULT_PROPERTIE_VALUE = "false" ;

	/**
	 * EDITNAME（ｶﾗﾑの並び替えや表示等）利用時に編集を許可するかどうか(true:許可/false:不許可)を指定｡
	 * writeCheckﾀｸﾞのuseEdit属性の初期値に利用されます｡
	 * USE_EDIT_WITH_EDITNAME = "false"
	 *
	 * @og.rev 5.5.4.2 (2012/07/13) 新規追加
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String USE_EDIT_WITH_EDITNAME = "false" ;

	/**
	 * EDITNAME利用時に､ｶﾗﾑの非表示/小計/合計/が無ければ､書き込み許可するかどうか(true:許可/false:不許可)を指定｡
	 * writeCheckﾀｸﾞで利用されます｡
	 * この設定は､個別指定できません｡
	 * 初期値：USE_EDIT_WITH_NAME_SEQ = "true"
	 *
	 * @og.rev 6.2.5.0 (2015/06/05) 新規追加
	 * @og.rev 7.2.9.1 (2020/10/23) 非表示＋小計/合計も加味します｡
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String USE_EDIT_WITH_NAME_SEQ = "true" ;

	/**
	 * EDITNAME利用時の編集可能時に､update.jsp等で､ViewFormType を､画面の指定通りにするか､
	 * HTMLSeqClmTable に､強制的に切り替えるかを､指定します(true:強制切替/false:通常通り)｡
	 * 通常､検索を意識した､EDITNAME利用ですが､ﾕｰｻﾞｰがｶｽﾀﾏｲｽﾞした並び順で､
	 * 登録したい場合に､true に設定します｡
	 * viewﾀｸﾞで利用されます｡
	 * この設定は､個別指定できません｡
	 * 初期値：USE_EDIT_WITH_VIEW_CHANGE = "false"
	 *
	 * @og.rev 6.2.5.0 (2015/06/05) 新規追加
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String USE_EDIT_WITH_VIEW_CHANGE = "false" ;

	/**
	 * writeCheckﾀｸﾞでeditNameをhiddenﾀｸﾞで出力するかどうか｡
	 * OUTPUT_EDITNAME = "false"
	 *
	 * @og.rev 5.5.4.2 (2012/07/13) 新規追加
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String OUTPUT_EDITNAME = "false" ;

//	/**
//	 * writeCheckﾀｸﾞとqueryButtonﾀｸﾞでdisplay:noneのﾀﾞﾐｰを出力するかどうか｡
//	 * USE_DUMMY_INPUT = "false"
//	 *
//	 * @og.rev 5.6.1.0 (2013/02/01) 新規追加
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止
//	 * @og.paramLevel 2:使用時設定
//	 */
//	public static final String USE_DUMMY_INPUT = "false" ;

	/**
	 * 画面を開いた時のEditNameの初期値に前回利用ｺｰﾄﾞを使うかどうか｡
	 *
	 * EditNameに前回利用ｺｰﾄﾞを使うかどうかを決める設定です｡
	 * trueの場合は前回利用ｺｰﾄﾞを使います｡
	 * falseの場合はNULLを初期値とします｡
	 * 但し､引数で与えられた場合はその値を利用します｡
	 * 初期値はtrue(利用する)です｡
	 * USE_DEFAULT_EDITNAME = "true"
	 *
	 * @og.rev 5.7.1.2 (2013/12/20) 新規追加
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String USE_DEFAULT_EDITNAME = "true" ;

	/**
	 * QUERYで検索ﾎﾞﾀﾝを押した時に､｢検索中です｣表示を行うかどうか｡
	 *
	 * jquery.blockUI.js による検索中表示機能を使うかどうかを設定します｡
	 * trueの場合は検索中表示を行います｡
	 * falseの場合はなにもしません｡
	 * これは､jQuery ｵﾌﾟｼｮﾝのjquery.blockUI.js と､独自開発した blockUI.js を
	 * 使用して､QUERYﾌﾚｰﾑで検索ﾎﾞﾀﾝが押されたら､｢検索中です･･･｣を表示し
	 * RESULT画面で､解除する仕組みです｡
	 * 検索中表示まで､0.5秒の待ち処理を入れています｡
	 *
	 * 初期値はtrue(利用する)です｡
	 * VIEW_USE_BLOCKUI = "true"
	 *
	 * @og.rev 5.7.7.1 (2014/06/13) 新規追加
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String VIEW_USE_BLOCKUI = "true" ;

	/**
	 * jquery-ui.js を使用するかどうかの初期値を指定します｡
	 *
	 * common/jquery内のjquery-ui.js及び.cssを利用するかどうかを指定します｡
	 * これにより autoManual ､draggable ､tab の機能が利用できます｡
	 *
	 * 初期値は false (利用しない)です｡
	 * VIEW_USE_JQUERY_UI = "false"
	 *
	 * @og.rev 6.4.0.5 (2016/01/09) useJQUIの初期値を､ｼｽﾃﾑ定数から取得するように変更｡
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String VIEW_USE_JQUERY_UI = "false" ;

	/**
	 * jquery.js を使用するかどうかの初期値を指定します｡
	 *
	 * common/jquery内のjquery.jsを利用するかどうかを指定します｡
	 * これは､従来から使用している､JQuery1.4を利用します｡
	 * VIEW_USE_JQUERY1,VIEW_USE_JQUERY12,VIEW_USE_JQUERY22,VIEW_USE_JQUERY33 は､独立した変数で､それぞれ､
	 * true に設定すると各ﾊﾞｰｼﾞｮﾝの jQuery がｲﾝﾎﾟｰﾄされます｡組み込み順は､ﾊﾞｰｼﾞｮﾝの古い順のため､
	 * 最後が優先（新しいﾊﾞｰｼﾞｮﾝが優先）されます｡
	 * 複数ﾊﾞｰｼﾞｮﾝの同時使用で､ｺﾝﾌﾘｸﾄを避ける方法が､各種紹介されていますので､そちらを参照願います｡
	 *
	 * @og.rev 7.0.1.0 (2018/10/15) JQueryのﾊﾞｰｼﾞｮﾝ設定用属性
	 *
//	 * × 初期値は true (利用する)です｡
	 * 初期値は false (利用しない)です｡
	 * VIEW_USE_JQUERY1 = "false"
	 *
	 * @og.rev 6.8.2.0 (2017/10/13) headﾀｸﾞのuseJquery1の初期値を､ｼｽﾃﾑ定数から取得します｡
	 * @og.rev 7.0.1.0 (2018/10/15) 初期値を false (利用しない)に変更｡
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String VIEW_USE_JQUERY1 = "false" ;

	/**
	 * jquery-1.12.4.min.js と､jquery-migrate.js を使用するかどうかの初期値を指定します｡
	 *
	 * common/jquery内のjquery1.12.js及び.jquery-migrate.jsを利用するかどうかを指定します｡
	 * JQuery1.4を利用してきましたが､一般的には1.9以降対応のﾓｼﾞｭｰﾙも増えてきているため､
	 * IE7ﾓｰﾄﾞに対応した1.x系の最新である1.12を利用可能にします｡
	 * ただし､互換性を保つため標準状態では1.4を読み込むようにします｡
	 * また､1.12読み込み時もこれまでのｽｸﾘﾌﾟﾄ利用できるようにするため､jquery-migrate1.4を同時に読み込みます｡
	 * ﾍｯﾀﾞ固定やHTML5向けﾎﾟｯﾌﾟｱｯﾌﾟ等の主要ｽｸﾘﾌﾟﾄの動作は見ていますが､全ての標準ｽｸﾘﾌﾟﾄの動作を保証するものではありません｡
	 * 5.9.25.0 (2017/10/06) で､headﾀｸﾞで個別に指定する初期値になります｡
	 *
//	 * × 初期値は false (利用しない)です｡
	 * 初期値は true (利用する)です｡
	 * VIEW_USE_JQUERY12 = "true"
	 *
	 * @og.rev 6.8.2.0 (2017/10/13) headﾀｸﾞのuseJquery12の初期値を､ｼｽﾃﾑ定数から取得します｡
	 * @og.rev 7.0.1.0 (2018/10/15) JQueryのﾊﾞｰｼﾞｮﾝ設定用属性で､初期値を true (利用する)に変更｡
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String VIEW_USE_JQUERY12 = "true" ;

	/**
	 * jquery-2.2.4.min.js と､jquery-migrate.js を使用するかどうかの初期値を指定します｡
	 *
	 * common/jquery内のjquery-2.2.4.min.js及び.jquery-migrate.jsを利用するかどうかを指定します｡
	 * VIEW_USE_JQUERY1,VIEW_USE_JQUERY12,VIEW_USE_JQUERY22,VIEW_USE_JQUERY33 は､独立した変数で､それぞれ､
	 * true に設定すると各ﾊﾞｰｼﾞｮﾝの jQuery がｲﾝﾎﾟｰﾄされます｡組み込み順は､ﾊﾞｰｼﾞｮﾝの古い順のため､
	 * 最後が優先（新しいﾊﾞｰｼﾞｮﾝが優先）されます｡
	 * 複数ﾊﾞｰｼﾞｮﾝの同時使用で､ｺﾝﾌﾘｸﾄを避ける方法が､各種紹介されていますので､そちらを参照願います｡
	 *
	 * 初期値は false (利用しない)です｡
	 * VIEW_USE_JQUERY22 = "false"
	 *
	 * @og.rev 7.0.1.0 (2018/10/15) JQueryのﾊﾞｰｼﾞｮﾝ設定用属性
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String VIEW_USE_JQUERY22 = "false" ;

	/**
	 * jquery-3.3.1.min.js と､jquery-migrate-3.0.0.min.js を使用するかどうかの初期値を指定します｡
	 *
	 * common/jquery内のjquery-3.3.1.min.js及び.jquery-migrate-3.0.0.min.jsを利用するかどうかを指定します｡
	 * VIEW_USE_JQUERY1,VIEW_USE_JQUERY12,VIEW_USE_JQUERY22,VIEW_USE_JQUERY33 は､独立した変数で､それぞれ､
	 * true に設定すると各ﾊﾞｰｼﾞｮﾝの jQuery がｲﾝﾎﾟｰﾄされます｡組み込み順は､ﾊﾞｰｼﾞｮﾝの古い順のため､
	 * 最後が優先（新しいﾊﾞｰｼﾞｮﾝが優先）されます｡
	 * 複数ﾊﾞｰｼﾞｮﾝの同時使用で､ｺﾝﾌﾘｸﾄを避ける方法が､各種紹介されていますので､そちらを参照願います｡
	 *
	 * 初期値は false (利用しない)です｡
	 * VIEW_USE_JQUERY33 = "false"
	 *
	 * @og.rev 7.0.1.0 (2018/10/15) JQueryのﾊﾞｰｼﾞｮﾝ設定用属性
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String VIEW_USE_JQUERY33 = "false" ;

	/**
	 * ﾌｧｲﾙのhref 部分の一部をURLEncodeするかどうか
	 *
	 * ﾌｧｲﾙ等のﾘﾝｸで､keys,vals は､URLEncode していましたが､URL に相当する箇所は
	 * http:// など URLEncode してはいけない箇所がある為､何もしていませんでした｡
	 * ﾌｧｲﾙのﾀﾞｳﾝﾛｰﾄﾞ等で､ﾌｧｲﾙ名に､";" や "%" が存在すると､認識できないため
	 * ﾌｧｲﾙが見つからないｴﾗｰが発生していました｡
	 *
	 * ※ 6.2.0.1 (2015/03/06) ASCII以外の文字＋";" と "%"の､URLｴﾝｺｰﾄﾞを行う様に仕様変更｡
	 *
	 * 初期値は､互換性を考慮し､false(URLEncodeしない)です｡
	 * USE_HREF_URLENCODE = "false"
	 *
	 * @og.rev 6.0.2.0 (2014/09/19) 新規追加
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_HREF_URLENCODE = "false" ;

	/**
	 * ｻｰﾊﾞｰのﾌﾟﾘﾝﾀｰ一覧取得時に､除外するﾌﾟﾘﾝﾀ名(の先頭一致)をCSV形式で指定します｡
	 *
	 * javax.print.PrintServiceLookup で､ﾌﾟﾘﾝﾀ一覧を取得しますが､Windows等で､
	 * Fax や､Microsoft XPS Document Writer など ﾌﾟﾘﾝﾀとして使用できないものを
	 * ﾌﾟﾘﾝﾀｰ一覧から除外します｡
	 * 除外ﾙｰﾙは､先頭一致です｡(startsWith なので､大文字小文字も一致が必要です)
	 * 除外指定のﾌﾟﾘﾝﾀ名(の先頭一致)には､ｶﾝﾏを含めることはできません｡
	 *
	 * 初期値は､Fax,Microsoft XPS です｡
	 * OMIT_PRINTER_NAMES = "Fax,Microsoft XPS"
	 *
	 * @og.rev 6.4.3.0 (2016/02/05) 新規追加
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String OMIT_PRINTER_NAMES = "Fax,Microsoft XPS" ;

	/**
	 * ﾌｧｲﾙﾀﾞｳﾝﾛｰﾄﾞさせる場合に､Content-Disposition に設定する値を指定します｡
	 *
	 * inline(そのまま開く) を指定すると､PDF などは直接ﾀﾞｳﾝﾛｰﾄﾞが始まります｡
	 * attachment(ﾀﾞｳﾝﾛｰﾄﾞﾀﾞｲｱﾛｸﾞを表示する) を指定すると､保存のﾀﾞｲｱﾛｸﾞを表示しますが
	 * EXCEL などの場合､inline にしても､ﾀﾞｲｱﾛｸﾞが表示され､開くをｸﾘｯｸしても
	 * ﾀﾞｳﾝﾛｰﾄﾞが始まらなかったり､EXCELが開いたあと､ﾌﾞﾗｳｻﾞの操作が出来なくなったり､
	 * よくわからないため､選択できるようにします｡
	 *
	 * 初期値は､attachment です｡
	 * CONTENT_DISPOSITION = "attachment"
	 *
	 * @og.rev 6.4.3.0 (2016/02/05) disposition属性､新規追加｡
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String CONTENT_DISPOSITION = "attachment" ;

	/**
	 * FileUDﾀｸﾞのExcelﾘﾝｸにURLﾁｪｯｸをかけるかどうか｡
	 *
	 * 初期値はfalse(利用しない)です｡
	 * USE_FILEUD_URL_CHECK = "false"
	 *
	 * @og.rev 5.9.32.1 (2018/05/08) 新規追加 (FILEUD_URL_CHECK)
	 * @og.rev 6.9.7.0 (2018/05/14) USE_ を付けておきます｡ (USE_FILEUD_URL_CHECK)
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String USE_FILEUD_URL_CHECK = "false" ;

	/**
	 * LinkﾀｸﾞでURLﾁｪｯｸを利用するかどうか｡
	 * useURLCheck属性の標準値として利用されます｡
	 *
	 * 初期値はfalse(利用しない)です｡
	 * LINK_URL_CHECK = "false"
	 *
	 * @og.rev 5.10.11.0 (2019/05/03) 新規追加
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String LINK_URL_CHECK = "false" ;

	/**
	 * linkTagでbackAddressに利用するｱﾄﾞﾚｽ｡
	 * LBやﾘﾊﾞｰｽﾌﾟﾛｷｼでURL変換が発生する場合に利用します｡
	 * 初期値は空文字(requestから構成する)です｡
	 * 設定する場合はhttps://xxx.com:443のようにｺﾝﾃｷｽﾄの手前までを設定してください｡
	 * ﾎﾟｰﾄ番号は標準の場合はなくても問題ありません｡
	 *
	 * SERVER_ACCESS_URL = "" ;
	 * @og.rev 5.10.16.3 (2019/10/25) 新規追加
	 * @og.paramLevel 7:要再起動
	 */
	public static final String SERVER_ACCESS_URL = "" ;

	/**
	 * QueryButtonTag と､SubmitTag において､accesskey の設定の有効/無効を設定します｡
	 *
	 * false にすると､上記2つのaccesskey は､無効(表示されない)になります｡
	 * 初期値は､互換性の観点から､true(accesskey の設定は有効)です｡
	 *
	 * USE_ACCESSKEY = "true" ;
	 * @og.rev 7.4.2.1 (2021/05/21) 新規追加
	 * @og.paramLevel 7:要再起動
	 */
	public static final String USE_ACCESSKEY = "true" ;

	/*
	 * ======================================================================
	 * org.opengion.hayabusa.resource.* で使用している変数
	 *
	 * 基本は､ﾘｿｰｽDBを読み取る設定です｡ただし､ﾘｿｰｽﾌｧｲﾙの
	 * 設定があれば､ﾘｿｰｽDBは､無視します｡
	 * (このﾌｧｲﾙの RESOURCE_xx_DB は､ｺﾒﾝﾄにする必要はありません｡)
	 *
	 * ﾘｿｰｽは､同一ｷｰが存在する場合は､後ろを優先します｡
	 * ﾘｿｰｽDBでは､KBSAKU(作成区分)でｿｰﾄしている為､これが大きいほど､
	 * 優先順位が高いことになります｡
	 * ｼｽﾃﾑ(GE)は､KBSAKU=0 ですので､それ以上の値で各ｼｽﾃﾑﾌﾟﾛﾊﾟﾃｨｰを
	 * 登録すれば､そちらが優先されます｡
	 * ======================================================================
	 */

	/**
	 * ｶﾚﾝﾀﾞＤＢの使用有無｡
	 * CalendarFactoryで､ｶﾚﾝﾀﾞＤＢを使用するかどうかを指定します｡
	 * 使用する場合は､true , 使用しない場合は､false を設定します｡
	 * true が設定された場合は､CalendarQuery_**** から､事業所と年月より､
	 * ｶﾚﾝﾀﾞｵﾌﾞｼﾞｪｸﾄを作成します｡
	 * 初期値は､false です｡
	 * USE_CALENDAR_DATABASE = "false" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_CALENDAR_DATABASE = "false" ;

	/**
	 * ｶﾚﾝﾀﾞＤＢの接続先
	 * CalendarFactoryで､ｶﾚﾝﾀﾞＤＢを使用する場合､どの接続先に接続するか指定します｡
	 * ここでは､接続先そのものではなく､接続先のDBID文字列を指定します｡
	 * 初期値は､null(標準の接続先) です｡
	 * RESOURCE_CALENDAR_DBID = "" ;
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String RESOURCE_CALENDAR_DBID = "" ;

	/**
	 * ﾁｪｯｸﾎﾞｯｸｽの id を出力可否｡
	 * ﾁｪｯｸﾎﾞｯｸｽの id を出力するかどうかを指定します｡
	 * ｶﾞﾝﾄﾁｬｰﾄのｽﾗｲﾀﾞｰ機能で､ｽﾗｲﾄﾞした行のﾁｪｯｸﾎﾞｯｸｽにﾁｪｯｸを
	 * 付けるために､ﾁｪｯｸﾎﾞｯｸｽの id を利用する必要があります｡
	 * id は､HybsSystem.ROW_ID_KEY で指定しており､[ROW.ID] で取得できます｡
	 * 初期値は､true です｡
	 * USE_CHECKBOX_ROW_ID = "true" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_CHECKBOX_ROW_ID = "true" ;

	/**
	 * ｻｰﾊﾞｰ名｡
	 * このTomcatが実行しているｻｰﾊﾞｰ名で､request.getServerName() で求められる値です｡
	 * Webｻｰﾊﾞｰとしてｱｸｾｽされたときのｻｰﾊﾞｰ名になります｡
	 * [例： HN50G5]
	 * SERVER_NAME = "HN50G5" ;
	 * @og.paramLevel 9:自動設定
	 */
	public static final String SERVER_NAME = "" ;

	/**
	 * ﾎｽﾄ名｡
	 * Java VM が実行しているｻｰﾊﾞｰ名で､InetAddress.getLocalHost().getHostName() で
	 * 求められる値です｡これは､ﾘｸｴｽﾄとは関係なく､ｻｰﾊﾞｰそのものの名称になります｡
	 * [例： HN50G5]
	 * HOST_NAME = "HN50G5" ;
	 * @og.paramLevel 9:自動設定
	 */
	public static final String HOST_NAME = "" ;

	/**
	 * ﾎｽﾄIPｱﾄﾞﾚｽ｡
	 * Java VM が実行しているﾎｽﾄIPｱﾄﾞﾚｽで､InetAddress.getLocalHost().getHostAddress() で
	 * 求められる値です｡
	 * [例： 200.1.50.165]
	 * HOST_ADRS = "200.1.50.165" ;
	 * @og.paramLevel 9:自動設定
	 */
	public static final String HOST_ADRS = "" ;

	/**
	 * ｻｰﾊﾞｰ本体の URL
	 * scheme + "://" + serverName + portStr の各情報から作成します｡
	 * このｼｽﾃﾑの外部へﾒｰﾙ＋URLﾘﾝｸ等を作成する場合や､
	 * そのｻｰﾊﾞｰの別のWebｻｰﾊﾞｰへのｱﾄﾞﾚｽ生成などに使用します｡
	 * [例： http://localhost:8824/]
	 * SERVER_URL = "http://localhost:8824/" ;
	 * @og.paramLevel 9:自動設定
	 */
	public static final String SERVER_URL = "" ;

	/**
	 * ｺﾝﾃｷｽﾄの URL
	 * scheme + "://" + serverName + portStr + serverURL + path + "/" の各情報から作成します｡
	 * これは､ｻｰﾊﾞｰURL＋ｺﾝﾃｷｽﾄまで加味したURLになっています｡
	 * このｼｽﾃﾑの外部へﾒｰﾙ＋URLﾘﾝｸ等を作成する場合などに使用します｡
	 * [例： http://localhost:8824/gf/]
	 * CONTEXT_URL = "http://localhost:8824/gf/" ;
	 * @og.paramLevel 9:自動設定
	 */
	public static final String CONTEXT_URL = "" ;

	/**
	 * ｻｰﾊﾞｰ情報｡
	 * ﾎｽﾄ名とﾎｽﾄｱﾄﾞﾚｽをｺﾒﾝﾄ情報として表示する場合に使用します｡
	 * [例： HN50G5 ( 200.1.50.165 )]
	 * SERVER_INFO = "HN50G5 ( 200.1.50.165 )" ;
	 * @og.paramLevel 9:自動設定
	 */
	public static final String SERVER_INFO = "" ;

	/**
	 * ｻｰﾌﾞﾚｯﾄ情報｡
	 * [例： Apache Tomcat/5.0.28]
	 * SERVLET_INFO = "Apache Tomcat/5.0.28" ;
	 * @og.paramLevel 9:自動設定
	 */
	public static final String SERVLET_INFO = "" ;

	/**
	 * ﾘｿｰｽﾃﾞｰﾀﾍﾞｰｽのｼｽﾃﾑID名｡
	 * web.xml で初期値指定する必要があります｡
	 * SYSTEM_ID = "GE" ;
	 * @og.paramLevel 9:自動設定
	 */
	public static final String SYSTEM_ID = "" ;

	/**
	 * ｱﾌﾟﾘｹｰｼｮﾝﾄｯﾌﾟﾀｲﾄﾙ｡
	 * ｱﾌﾟﾘｹｰｼｮﾝのWindowsに表示するﾄｯﾌﾟﾀｲﾄﾙ名を指定します｡
	 * ﾌﾞﾗｳｻﾞの､上端に表示されます｡また､お気に入り等への登録時の名称になります｡
	 * GUI_TOP_TITLE = "Web ｱﾌﾟﾘｹｰｼｮﾝｼｽﾃﾑ" ;
	 * @og.paramLevel 1:設定確認
	 */
	public static final String GUI_TOP_TITLE = "Web ｱﾌﾟﾘｹｰｼｮﾝｼｽﾃﾑ" ;

	/**
	 * ﾘｿｰｽ利用時のﾍﾞｰｽとなるSYSTEM_IDをCSV指定します｡
	 *
	 * ｶﾗﾑ(GEA03)､ｺｰﾄﾞ(GEA04)､ﾗﾍﾞﾙ(GEA08)､画面(GEA11) ﾘｿｰｽに関して､通常は､
	 * 自身のSYSTEM_ID(通常は､ｺﾝﾃｷｽﾄの大文字)と､ｴﾝｼﾞﾝ標準 "**" をﾏｰｼﾞした
	 * ﾃﾞｰﾀを､ｷｰで管理しています｡
	 * <del>SYSTEM_IDに関係なく､同一ｷｰでは､作成区分の上位ほど有効になります｡</del>
	 * SYSTEM_ID の順番が第一優先で､同一SYSTEM_ID内では､作成区分の上位ほど有効になります｡
	 *
	 * 従来は､ｴﾝｼﾞﾝ標準 "**" のみがﾍﾞｰｽとなっていましたが､それ以外に､
	 * この､RESOURCE_BASE_SYSTEM_ID を指定することで､ﾍﾞｰｽとなるSYSTEM_ID を
	 * 『CSV形式で､複数(8.0.0.0 以降)』指定指定することができます｡
	 *
	 * SYSTEM_ID､RESOURCE_BASE_SYSTEM_ID､"**" の順で有効｡
	 *
	 * 何も指定しない場合(初期値)は､従来通りの有効範囲(SYSTEM_ID､"**" の順)です｡
	 *
	 * 例) RESOURCE_BASE_SYSTEM_ID = "VV,GE" ;
	 *
	 * @og.rev 7.2.6.0 (2020/06/30) 新規追加
	 * @og.rev 8.0.0.0 (2021/09/30) ﾍﾞｰｽに複数使用可能にする｡
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String RESOURCE_BASE_SYSTEM_ID = "" ;

	/**
	 * 共有ﾘｿｰｽﾃﾞｰﾀ DBID｡
	 * ﾕｰｻﾞｰﾘｿｰｽ(GEA10)を除く他のﾘｿｰｽ(ｶﾗﾑ(GEA03),ﾗﾍﾞﾙ(GEA08),
	 * ｺｰﾄﾞ(GEA04),ﾒｯｾｰｼﾞ(GEA09),画面(GEA11),ｼｽﾃﾑﾊﾟﾗﾒｰﾀ(GE12),
	 * ｱｸｾｽ統計(GE15),ﾕｰｻﾞｰ設定ﾃｰﾌﾞﾙ(GE20),URL転送(GE17))
	 * のﾃﾞｰﾀﾍﾞｰｽを通常の､DEFAULT_DB_URL 設定値以外の場所にｱｸｾｽする
	 * 場合に､DBID で指定します｡
	 * DBID は､'GE' や 'XX' などの通常は､ｼｽﾃﾑID名を使用しますが､
	 * 何でも構いません｡このDBIDは､XX_DB_URL や､XX_DB_USER ､XX_DB_PASSWD として
	 * 登録しておく必要があります｡指定がない場合は､DEFAULT_DB_URL を使用します｡
	 * RESOURCE_DBID = "" ;
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String RESOURCE_DBID = "" ;

	/**
	 * ﾕｰｻﾞｰﾘｿｰｽDBID｡
	 * ﾘｿｰｽDBが､他のﾃﾞｰﾀﾍﾞｰｽにある場合(統合されているなど)取得ﾃﾞｰﾀﾍﾞｰｽを
	 * 通常の､DEFAULT_DB_URL 設定値以外の場所にｱｸｾｽする場合に､DBID で指定します｡
	 * DBID は､'GE' や 'XX' などの通常は､ｼｽﾃﾑID名を使用しますが､何でも構いません｡
	 * このDBIDは､XX_DB_URL や､XX_DB_USER ､XX_DB_PASSWD として登録する必要があります｡
	 * 未定義の場合は､RESOURCE_DBID から､それも未定義の場合は ﾃﾞﾌｫﾙﾄの接続先を使用します｡
	 * RESOURCE_USER_DBID = "" ;
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String RESOURCE_USER_DBID = "" ;

	/**
	 * 共有ﾘｿｰｽｱｸｾｽｱﾄﾞﾚｽ｡
	 * 共有ﾘｿｰｽを統一した環境でｱｸｾｽする場合のｻｰﾊﾞｱﾄﾞﾚｽを指定します｡
	 * 共有ﾘｿｰｽ環境を個別に作成する場合､すべtのﾕｰｻﾞｰで利用可能な転送URLや
	 * 共有ﾒｯｾｰｼﾞ､ｱｸｾｽ統計管理､ﾕｰｻﾞｰﾊﾟﾗﾒｰﾀなどの画面は､ﾌﾘｰに
	 * しておき､各種ﾘｿｰｽは管理者のみｱｸｾｽできるようにします｡
	 * 未指定の場合は､自分自身のｱﾄﾞﾚｽを使用します｡
	 * RESOURCE_ADDRESS = "http://localhost:8823/gf/jsp/index.jsp" ;
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String RESOURCE_ADDRESS = "" ;

	/**
	 * ﾕｰｻﾞｰﾘｿｰｽ検索SQL｡
	 * 検索するｶﾗﾑには､必ず､USERID,LANG,NAME_JA,ROLES がこの順番で含まれており､
	 * 絞込み条件(?ﾊﾟﾗﾒｰﾀ)として､SYSTEM_ID,USERID がこの順番で指定される必要があります｡
	 * (ｶﾗﾑ名は関係ありません｡並び順と意味が重要です｡)
	 * また､検索順(ORDER BY)は､優先順位の低い順に検索してください｡使用するのは､一番最後に
	 * 検索された行を使用します｡
	 * ﾕｰｻﾞｰﾘｿｰｽは､RESOURCE_USER_DBID で指定のﾃﾞｰﾀﾍﾞｰｽから取得します｡
	 * 未定義の場合は､RESOURCE_DBID から､それも未定義の場合は ﾃﾞﾌｫﾙﾄの接続先を使用します｡
	 *
	 * RESOURCE_USER_SQL = "SELECT USERID,LANG,NAME_JA,ROLES FROM GEA10V01 ････" ;
	 * @og.rev 4.1.0.0 (2007/01/11) GEA10ではなくGEA10V01を見るように変更
	 * @og.rev 4.4.0.0 (2008/08/02) DROLES(ﾃﾞｰﾀﾛｰﾙｽﾞ)の項目追加
	 * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(GEA10V01.DROLES､FGJ､FGDEFAULT廃止)
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String RESOURCE_USER_SQL
	// 7.4.4.0 (2021/06/30) Modify
	//								= "SELECT USERID,LANG,NAME_JA,ROLES,DROLES"
	//								+ " FROM GEA10V01"
	//								+ " WHERE SYSTEM_ID IN ( ?,'**') AND USERID=? AND FGJ='1'"
	//								+ " ORDER BY SYSTEM_ID, FGDEFAULT DESC" ;
									= "SELECT USERID,LANG,NAME_JA,ROLES"
									+ " FROM GEA10V01"
									+ " WHERE SYSTEM_ID IN ( ?,'**') AND USERID=?"
									+ " ORDER BY SYSTEM_ID" ;

	/**
	 * ﾕｰｻﾞｰﾘｿｰｽ検索SQL(ﾛｰﾙ指定)｡
	 * 検索するｶﾗﾑには､必ず､USERID,LANG,NAME_JA,ROLES がこの順番で含まれており､
	 * 絞込み条件(?ﾊﾟﾗﾒｰﾀ)として､SYSTEM_ID,USERID がこの順番で指定される必要があります｡
	 * (ｶﾗﾑ名は関係ありません｡並び順と意味が重要です｡)
	 * また､検索順(ORDER BY)は､優先順位の低い順に検索してください｡使用するのは､一番最後に
	 * 検索された行を使用します｡
	 * ﾕｰｻﾞｰﾘｿｰｽは､RESOURCE_USER_DBID で指定のﾃﾞｰﾀﾍﾞｰｽから取得します｡
	 * 未定義の場合は､RESOURCE_DBID から､それも未定義の場合は ﾃﾞﾌｫﾙﾄの接続先を使用します｡
	 *
	 * RESOURCE_USER_ROLE_SQL = "SELECT USERID,LANG,NAME_JA,ROLES FROM GEA10V01 ････" ;
	 * @og.rev 4.4.0.0 (2008/08/02) DROLES(ﾃﾞｰﾀﾛｰﾙｽﾞ)の項目追加
	 * @og.rev 5.6.5.2 (2013/06/21) GEA10ではなくGEA10V01を見るように変更(RESOURCE_USER_SQLに合わせる)
	 * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(GEA10V01.DROLES､FGJ廃止)
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String RESOURCE_USER_ROLE_SQL
	// 7.4.4.0 (2021/06/30) Modify
	//								= "SELECT USERID,LANG,NAME_JA,ROLES,DROLES"
	//								+ " FROM GEA10V01"
	//								+ " WHERE SYSTEM_ID IN ( ?,'**') AND USERID=? AND ROLES=? AND FGJ='1'"
	//								+ " ORDER BY SYSTEM_ID" ;
									= "SELECT USERID,LANG,NAME_JA,ROLES"
									+ " FROM GEA10V01"
									+ " WHERE SYSTEM_ID IN ( ?,'**') AND USERID=? AND ROLES=?"
									+ " ORDER BY SYSTEM_ID" ;

	/**
	 * ﾕｰｻﾞｰﾘｿｰｽの情報を取得するﾃﾞｰﾀｿｰｽの種別を指定します(初期値:""⇒DB,LDAP)｡
	 * 何も指定しない場合(初期値)は､DBからﾕｰｻﾞｰﾘｿｰｽの情報を取得します｡
	 * "LDAP"を指定すると､LDAPからﾕｰｻﾞｰﾘｿｰｽを取得します｡
	 *  "LDAP"を使用する場合の設定方法については､RESOURCE_USER_LDAP_CLMの説明を参照して下さい｡
	 *
	 * RESOURCE_USER_SRC_TYPE = "" ;
	 * @og.rev 5.2.0.0 (2010/09/01) 新規追加
	 *
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String RESOURCE_USER_SRC_TYPE = "";

	/**
	 * ﾕｰｻﾞｰﾘｿｰｽ検索LDAP項目｡
	 * ﾕｰｻﾞｰをLDAPから検索する場合のｶﾗﾑを指定します｡
	 * ｶﾗﾑには､必ず､USERID,LANG,NAME_JA,ROLES がこの順番で含まれる必要があります｡
	 * 検索条件は､RESOURCE_USER_LDAP_FILTER で指定しておいてください｡
	 * 対象となる属性名が存在しない場合は､ﾀﾞﾐｰの属性名を指定することもできます｡
	 * 各項目において､値が取得できない場合は､以下のﾃﾞﾌｫﾙﾄ値が適用されます｡
	 *  lang(言語)             : 'ja'
	 *  cn(名称)               : ﾛｸﾞｲﾝID
	 *  roles(ﾛｰﾙｽﾞ)        : 属性名と同じ文字列
	 *
	 * なお､LDAPの基本情報は､LDAP_INITIAL_CONTEXT_FACTORY , LDAP_PROVIDER_URL ,
	 * LDAP_ENTRYDN , LDAP_PASSWORD , LDAP_SEARCH_BASE , LDAP_SEARCH_SCOPE
	 * 定数の値を使用します｡
	 *
	 * ※LDAPからﾕｰｻﾞｰﾘｿｰｽを取得するには､RESOURCE_USER_SRC_TYPEが"LDAP"に設定されている必要があります｡
	 *
	 * RESOURCE_USER_LDAP_CLM = "uid,lang,cn,roles" ;
	 * @og.rev 5.2.0.0 (2010/09/01) 新規追加
	 * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(DROLES廃止)
	 *
	 * @og.paramLevel 2:使用時設定
	 */
	//public static final String RESOURCE_USER_LDAP_CLM = "uid,lang,cn,roles,droles" ;	// 7.4.4.0 (2021/06/30) Modify
	public static final String RESOURCE_USER_LDAP_CLM = "uid,lang,cn,roles" ;

	/**
	 * ﾕｰｻﾞｰﾘｿｰｽ検索LDAP条件(ﾛｰﾙ指定)｡
	 * ﾕｰｻﾞｰをﾛｰﾙ指定でLDAPから検索する場合の検索条件を指定します｡
	 * 検索条件で定義される {0}にはｼｽﾃﾑIDが､{1}にはﾛｸﾞｲﾝIDが､{2}にはﾛｰﾙが指定されます｡
	 * ｼｽﾃﾑIDの検索条件が不要な場合は､{0}の指定を外すことも可能です｡
	 * また､ここで指定された条件は､LDAP検索のﾌｨﾙﾀｰとしてそのまま渡されますので､
	 * 固定条件を追加することもできます｡
	 *
	 * なお､LDAPの基本情報は､LDAP_INITIAL_CONTEXT_FACTORY , LDAP_PROVIDER_URL ,
	 * LDAP_ENTRYDN , LDAP_PASSWORD , LDAP_SEARCH_BASE , LDAP_SEARCH_SCOPE
	 * 定数の値を使用します｡
	 *
	 * ※LDAPからﾕｰｻﾞｰﾘｿｰｽを取得するには､RESOURCE_USER_SRC_TYPEが"LDAP"に設定されている必要があります｡
	 *
	 * RESOURCE_USER_ROLE_LDAP_FILTER = "(&amp;(sysid={0})(uid={1})(roles={2}))" ;
	 * @og.rev 5.2.0.0 (2010/09/01) 新規追加
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String RESOURCE_USER_ROLE_LDAP_FILTER = "(&(sysid={0})(uid={1})(roles={2}))" ;

	/**
	 * ﾕｰｻﾞｰﾘｿｰｽ検索LDAP条件｡
	 * ﾕｰｻﾞｰをLDAPから検索する場合の検索条件を指定します｡
	 * 検索条件で定義される {0}にはｼｽﾃﾑIDが､{1}にはﾛｸﾞｲﾝIDが指定されます｡
	 * ｼｽﾃﾑIDの検索条件が不要な場合は､{0}の指定を外すことも可能です｡
	 * また､ここで指定された条件は､LDAP検索のﾌｨﾙﾀｰとしてそのまま渡されますので､
	 * 固定条件を追加することもできます｡
	 *
	 * なお､LDAPの基本情報は､LDAP_INITIAL_CONTEXT_FACTORY , LDAP_PROVIDER_URL ,
	 * LDAP_ENTRYDN , LDAP_PASSWORD , LDAP_SEARCH_BASE , LDAP_SEARCH_SCOPE
	 * 定数の値を使用します｡
	 *
	 * ※LDAPからﾕｰｻﾞｰﾘｿｰｽを取得するには､RESOURCE_USER_SRC_TYPEが"LDAP"に設定されている必要があります｡
	 *
	 * RESOURCE_USER_LDAP_FILTER = "(&amp;(sysid={0})(uid={1}))" ;
	 * @og.rev 5.2.0.0 (2010/09/01) 新規追加
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String RESOURCE_USER_LDAP_FILTER = "(&(sysid={0})(uid={1}))" ;

	// /**
	// * ﾕｰｻﾞｰﾊﾟﾗﾒｰﾀ検索SQL｡
	// * ｼｽﾃﾑﾊﾟﾗﾒｰﾀを個別ﾕｰｻﾞｰ毎にｶｽﾀﾏｲｽﾞする場合に使用する
	// * ﾕｰｻﾞｰﾊﾟﾗﾒｰﾀを取得するSQLを定義します｡
	// * 検索するｶﾗﾑには､必ず､PARAM_ID,PARAM,FGCRYPT がこの順番で含まれており､
	// * 絞込み条件(?ﾊﾟﾗﾒｰﾀ)として､SYSTEM_ID,USERID がこの順番で指定される必要があります｡
	// * (ｶﾗﾑ名は関係ありません｡並び順と意味が重要です｡)
	// * また､検索順(ORDER BY)は､優先順位の低い順に検索してください｡同一PARAM_IDが
	// * 複数存在する場合は､一番最後に検索されたPARAMを使用します｡
	// * ﾕｰｻﾞｰﾊﾟﾗﾒｰﾀは､ﾕｰｻﾞｰﾘｿｰｽ と異なり､RESOURCE_DBID から取得します｡
	// * それが未定義の場合は ﾃﾞﾌｫﾙﾄの接続先を使用します｡
	// *
	// * USER_PARAMETER_SQL = "SELECT PARAM_ID,PARAM,FGCRYPT FROM GE16 ･･･" ;
	// *
	// * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(GE16廃止)
	// *
	// * @og.paramLevel 3:標準推奨
	// */
	// 7.4.4.0 (2021/06/30) Delete
	// public static final String USER_PARAMETER_SQL = "SELECT PARAM_ID,PARAM,FGCRYPT FROM GE16"
	// 								+ " WHERE SYSTEM_ID IN ( ?,'**') AND USERID=? AND FGJ='1'"
	// 								+ " ORDER BY SYSTEM_ID" ;

	/**
	 * ｱｸｾｽ統計ﾃｰﾌﾞﾙ使用設定｡
	 * ｱｸｾｽ統計ﾃｰﾌﾞﾙを使用する場合は､true , 使用しない場合は､false を設定します｡
	 * 初期値は､true です｡
	 * USE_ACCESS_TOKEI_TABLE = "true" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_ACCESS_TOKEI_TABLE = "true" ;

	/**
	 * ｱｸｾｽ統計ﾃｰﾌﾞﾙを再編成するまでのﾃﾞｰﾀの生存期間を設定します｡
	 * ﾃﾞｰﾀが作成された日時を基準として､ここで指定された期間よりも古い
	 * ﾃﾞｰﾀは､物理削除されます｡
	 * ACCESS_TOKEI_ALIVE_DAYSが指定されていない(null)場合､ﾃﾞｰﾀの削除は行われません｡
	 * 初期値は､180日です｡
	 *
	 * ACCESS_TOKEI_ALIVE_DAYS = "180" ;
	 * @og.paramLevel 1:設定確認
	 */
	public static final String ACCESS_TOKEI_ALIVE_DAYS = "180" ;

	/**
	 * ｱｸｾｽ統計ﾃｰﾌﾞﾙを使用したﾒﾆｭｰ表示の過去日付の設定日数｡
	 * 階層ﾒﾆｭｰでﾚﾍﾞﾙ３の場合､非標準としてﾃﾞﾌｫﾙﾄでは表示されません｡
	 * これに､ｱｸｾｽ統計ﾃｰﾌﾞﾙの個人別過去の訪問履歴より､設定日数以内に
	 * ｱｸｾｽされていれば､動的にﾚﾍﾞﾙ２へ引き上げます｡
	 * 前準備として､ｱｸｾｽ統計ﾃｰﾌﾞﾙ使用設定(USE_ACCESS_TOKEI_TABLE)を
	 * true にしておく必要があります｡
	 * 初期値は､20日 です｡
	 * ACCESS_TOKEI_PAST_DAYS = "20" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String ACCESS_TOKEI_PAST_DAYS = "20" ;

	/**
	 * ＳＱＬｲﾝｼﾞｪｸｼｮﾝ対策用ﾁｪｯｸの実施有無の設定 ｡
	 * 特定ﾘｸｴｽﾄ情報にｼﾝｸﾞﾙｸｫｰﾄ(')が含まれている場合に､入力ｴﾗｰに
	 * するかどうかを指定します｡
	 * SQLのWHEREﾊﾟﾗﾒｰﾀの値に､' or 'A' like 'A のような形式を使用すると､
	 * 意図しない情報を抜き出すことが可能になります｡
	 * ﾘｸｴｽﾄが数字ﾀｲﾌﾟの場合は､or 5=5 などのｼﾝｸﾞﾙｸｫｰﾄを使用しない
	 * ｺｰﾄﾞを埋めても､数字ﾁｪｯｸで検出可能です｡
	 * ｴﾝｼﾞﾝでは､２つのSQLを連続で流す事が出来ないので､上記形式でのﾁｪｯｸで
	 * ある程度のｾｷｭﾘﾃｨは確保できます｡
	 * 初期値は､true です｡
	 * USE_SQL_INJECTION_CHECK = "true" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_SQL_INJECTION_CHECK = "true" ;

	/**
	 * 読込ﾌﾗｸﾞ(FGLOAD) のﾏｰｶｰ設定ﾓｰﾄﾞを使用するかどうか指定(true:使用する)
	 * 読込ﾌﾗｸﾞ(FGLOAD)が '1' のﾃﾞｰﾀは､起動時に先読みします｡
	 * '0'の場合は､個別にｷｰ要求が発生した時点で読み込みます｡
	 * その時､追加読み込み(先読みされていないｶﾗﾑ)に対して､読込ﾌﾗｸﾞ(FGLOAD)を '2' に
	 * 自動設定します｡('2' はﾏｰｶｰだけで､自動読込は行いません｡)
	 * USE_FGLOAD_AUTOSET = "true" ;
	 *
	 * @og.rev 6.3.1.0 (2015/06/28) 読込ﾌﾗｸﾞ(FGLOAD) のﾏｰｶｰ設定追加｡
	 *
	 * @og.paramLevel 7:要再起動
	 */
	public static final String USE_FGLOAD_AUTOSET = "true";

	// /**
	// * 個人別お気に入りﾒﾆｭｰを登録する場合の画面IDﾘｽﾄ｡
	// * このｷｰには､お気に入りﾒﾆｭｰの画面IDをCSV形式で記述します｡
	// * 個人設定可能ですが､SystemData としては､初期値を持っていません｡
	// * GUI_FAVORITE_MENU_LIST = "" ;
	// *
	// * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(未使用の為廃止)
	// *
	// * @og.paramLevel 4:個人設定可
	// */
	// 7.4.4.0 (2021/06/30) Delete
	// public static final String GUI_FAVORITE_MENU_LIST = "";

	/**
	 * ﾀﾞｲﾚｸﾄｼﾞｬﾝﾌﾟﾘﾝｸ時のﾊｯｼｭ化されたURLの有効期間を日数の初期値｡
	 * これは､登録された時間から計算して､何日間有効にしておくかを指定します｡
	 * ｾﾞﾛ､またはﾏｲﾅｽが指定された場合は､制限なしに設定されます｡
	 * 初期値は､20日 です｡
	 * LINK_VALID_DURATION_DAYS = "20" ;
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String LINK_VALID_DURATION_DAYS = "20" ;

	/**
	 * Tomcat起動時初期処理 URL｡
	 * これは､Tomcatが起動された初期化処理時に呼び出されるURLを指定します｡
	 * ｴﾝｼﾞﾝでは､各画面に対してURLを呼び出すことで､処理を実行することが
	 * 可能になります｡例えば､帳票ﾃﾞｰﾓﾝの起動URLを設定しておけば､Tomcat
	 * 起動時に､URLがｺｰﾙされて､帳票ﾃﾞｰﾓﾝが自動的に起動します｡
	 * このｷｰで始まるｷｰで登録します｡処理は､ｷｰのｿｰﾄ順です｡
	 *
	 * CONTEXT_INITIAL_CALL_URL = "" ;
	 * @og.paramLevel 7:要再起動
	 */
	public static final String CONTEXT_INITIAL_CALL_URL = "" ;

	/**
	 * Tomcat起動時初期処理 URLを起動するﾕｰｻﾞｰ､ﾊﾟｽ｡
	 * これは､Tomcatが起動された初期化処理時に呼び出されるURLを実行する際の
	 * ﾕｰｻﾞｰ及びﾊﾟｽを指定します｡
	 * [ﾕｰｻﾞｰ名]:[ﾊﾟｽﾜｰﾄﾞ]の形式で指定します｡
	 * 初期値はadmin:admin(ﾕｰｻﾞｰ､ﾊﾟｽﾜｰﾄﾞ共にadmin)です｡
	 *
	 * @og.rev 4.2.2.0 (2008/05/22) 新規作成
	 *
	 * CONTEXT_INITIAL_CALL_USERPASS = "admin:admin" ;
	 * @og.paramLevel 7:要再起動
	 */
	public static final String CONTEXT_INITIAL_CALL_USERPASS = "admin:admin" ;

	/**
	 * ﾌｧｲﾙﾀﾞｳﾝﾛｰﾄﾞ時の半角ｶﾅ-全角ｶﾅ変換使用有無｡
	 * ﾌｧｲﾙﾀﾞｳﾝﾛｰﾄﾞ時のﾌｧｲﾙ名を半角ｶﾅ-全角ｶﾅ変換を行うかどうかを指定します｡
	 * FileDownload ｻｰﾌﾞﾚｯﾄで､漢字(特に半角ｶﾀｶﾅ)を含むﾌｧｲﾙ名でﾀﾞｳﾝﾛｰﾄﾞ
	 * させようとすると､ﾌｧｲﾙ名が途中で切れてしまう現象が発生します｡
	 * 原因は､IEの仕様で､ある程度仕方がないとの事です｡
	 * ｴﾝｼﾞﾝでは､URLEncodeを行うことで､若干の改善は図られていますが､半角ｶﾀｶﾅを
	 * 半角ｶﾀｶﾅを全角ｶﾀｶﾅに変換することでさらに改善を図ることが可能です｡
	 * 初期値は true(半角ｶﾅ-全角ｶﾅ変換を行う)です｡
	 *
	 * USE_FILEDOWNLOAD_HAN_ZEN = "true" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_FILEDOWNLOAD_HAN_ZEN = "true" ;

	/**
	 * ﾌｧｲﾙﾀﾞｳﾝﾛｰﾄﾞ時のURLﾁｪｯｸ機能利用有無｡
	 * ﾌｧｲﾙﾀﾞｳﾝﾛｰﾄﾞ時のURLﾁｪｯｸ機能を利用するどうかを指定します｡
	 * このｷｰFileDownload ｻｰﾌﾞﾚｯﾄに対してのみ適用されます｡
	 * trueに指定して場合､"file"で指定するﾌｧｲﾙ文字列のMD5ﾊｯｼｭｷｰを
	 * "key"に指定しておく必要があります｡これが一致しない場合､ﾌｧｲﾙへの
	 * ｱｸｾｽが拒否されます｡falseの場合は､これらのﾁｪｯｸは行われません｡
	 * 初期値は false(ﾁｪｯｸしない)です｡
	 *
	 * USE_FILEDOWNLOAD_CHECKKEY = "false" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_FILEDOWNLOAD_CHECKKEY = "false" ;

	// /**
	// * PAGE_END_CUT ﾌﾗｸﾞを使用(true)すると､最後の一行が表示されない不具合対応です｡
	// * これは､ﾃﾞｰﾀが存在しなくなった状態で､PAGE_END_CUTという文字列を見つけると
	// * それ以降の､PAGE_END_CUTという文字列が存在している行を削除するという仕様です｡
	// * そのときのﾃﾞｰﾀ存在ﾁｪｯｸの関係で､最後のﾃﾞｰﾀが存在しているにもかかわらず
	// * その行を削除していました｡(判定に rowOver ﾌﾗｸﾞを見ていた)
	// * これを､ﾃﾞｰﾀがなくなったことを示す､dataOver ﾌﾗｸﾞを見るようにします｡
	// * COMPATIBLE_PAGE_END_CUT_RETRIEVAL ﾌﾗｸﾞは､互換性を考慮し､true の場合は､
	// * dataOver ﾌﾗｸﾞを見ます｡(つまり正常に動作します)
	// * false(初期値)の場合は､現在の状態のままとして､rowOver ﾌﾗｸﾞを見ます｡
	// * 初期値は 互換性を考慮し false(現在の状態のまま)とします｡
	// *
	// * COMPATIBLE_PAGE_END_CUT_RETRIEVAL = "false" ;
	// * @og.rev 3.8.1.2 (2005/12/19) 新規作成
	// * @og.rev 5.7.1.0 (2013/12/06) 帳票側を対応｡Excel帳票でのみ有効
	// * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(未使用の為廃止)
	// *
	// * @og.paramLevel 3:標準推奨
	// */
	// 7.4.4.0 (2021/06/30) Delete
	// public static final String COMPATIBLE_PAGE_END_CUT_RETRIEVAL = "false" ;

	/**
	 * ｶﾞﾝﾄﾍｯﾀﾞｰにおいて､時間ﾍｯﾀﾞｰの上段に日付を､下段の時間軸の(h)の削除を行います｡
	 * 日付は､表示開始時刻の上と､その１２時間後に表示します｡
	 * この２段組の対応を使用するかどうかを指定します｡
	 * 初期値は､false です｡
	 *
	 * USE_GANTTHEADER_MULTIPLE_COLUMN = "false" ;
	 * @og.rev 3.8.1.4 (2006/03/13) 新規作成
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_GANTTHEADER_MULTIPLE_COLUMN = "false" ;

	/**
	 * ｶﾞﾝﾄﾍｯﾀﾞｰにおいて､30日､90日､180日のﾍｯﾀﾞｰ表示で､日付まで
	 * 表示するか､月のみ表示するかを指定します｡
	 * ｶﾞﾝﾄﾍｯﾀﾞｰの繰返し表示でﾊﾞｯｸｸﾞﾗｳﾝﾄﾞｲﾒｰｼﾞは固定日なので､一月表示を
	 * 30日単位で表示していますが､先頭日付が 1日でないため､判りにくいと苦情がありました｡
	 * そこで､30日､90日､180日のﾍｯﾀﾞｰ表示時に､日付を表示しないようにするﾌﾗｸﾞです｡
	 * 月表示は､その月が 20日以降の場合､翌月を表示します｡
	 *
	 * 初期値は､互換性の為､false です｡
	 *
	 * USE_GANTTHEADER_MONTH_DATE = "false" ;
	 * @og.rev 3.8.5.2 (2006/06/09) 新規作成
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_GANTTHEADER_MONTH_DATE = "false" ;

	/**
	 * ｶﾞﾝﾄﾍｯﾀﾞｰにおいて時間単位のｶﾞﾝﾄを表示する際に､上段に
	 * 月日を表示するかどうかを指定します｡
	 * trueにした場合は表示します｡
	 *
	 * 初期値は､互換性の為､false です｡
	 *
	 * USE_MDHEADER_ONTIME = "false" ;
	 * @og.rev 5.7.0.0 (2013/11/03) 新規作成
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_MDHEADER_ONTIME = "false" ;

	/**
	 * ﾕｰｻﾞｰ情報の IDNO で ﾛｸﾞｲﾝﾕｰｻﾞｰIDの先頭 C を取り除くかどうか｡
	 *
	 * ﾕｰｻﾞｰ情報の IDNO で ﾛｸﾞｲﾝﾕｰｻﾞｰIDの先頭 C を取り除くかどうかを
	 * 指定するﾊﾟﾗﾒｰﾀ(USE_USER_IDNO_C_SAPLESS)を追加します｡
	 * true にすると､現状とおなじ､６桁以上の場合に 先頭 C を取り除きます｡
	 * false にすると､ID と IDNO が同じ値にｾｯﾄされます｡
	 * それ以外の IDNO を使用する場合は､3.8.1.2 (2005/12/19) で対応したように
	 * IDNO に直接値を設定する機能を使用して､書き換えてください｡
	 * 初期値は､互換性の為､true です｡
	 *
	 * USE_USER_IDNO_C_SAPLESS = "true" ;
	 * @og.rev 3.8.5.3 (2006/06/30) 新規作成
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_USER_IDNO_C_SAPLESS = "true" ;

	/**
	 * ﾎﾟｯﾌﾟｱｯﾌﾟｶﾚﾝﾀﾞの種類を指定します｡
	 *
	 * ここでは､CAL1 と CAL3 の２種類のﾎﾟｯﾌﾟｱｯﾌﾟｶﾚﾝﾀﾞの種類を指定できます｡
	 * CAL1 が､従来の１か月分の表示ｶﾚﾝﾀﾞで､CAL3 が３か月分のｶﾚﾝﾀﾞです｡
	 * 数字は動的な月数ではなく､個別に JSP ﾌｧｲﾙを呼び出しているため､現時点では､
	 * この､２つだけが指定できます｡
	 *
	 * CAL1: common/calendar.jsp
	 * CAL3: calendar_3month.jsp
	 * 初期値は､CAL3(calendar_3month.jsp)です｡
	 *
	 * CALENDAR_POPUP_JSP = "CAL3" ;
	 *
	 * @og.rev 6.8.5.0 (2018/01/09) 新規作成
	 *
	 * @og.paramLevel 7:要再起動
	 */
	public static final String CALENDAR_POPUP_TYPE = "CAL3" ;

	/**
	 * ｶﾚﾝﾀﾞﾃﾞｰﾀの初期設定
	 * ｶﾚﾝﾀﾞｰﾎﾟｯﾌﾟｱｯﾌﾟ上での先頭曜日を月曜日にします｡
	 * 通常はfalse(日曜日)です｡
	 *
	 * CALENDAR_START_MONDAY = "false" ;
	 * @og.rev 5.6.5.2 (2013/06/21) 新規作成
	 *
	 * @og.paramLevel 4:個人設定可
	 */
	public static final String CALENDAR_START_MONDAY = "false" ;

	/**
	 * ｶﾚﾝﾀﾞの先頭曜日を月曜日にするかどうか｡
	 * ｶﾚﾝﾀﾞｰDBにﾃﾞｰﾀが存在しない場合に､使用されるｶﾚﾝﾀﾞｰｸﾗｽを設定します｡
	 * 初期設定は､org.opengion.plugin.calendar ﾊﾟｯｹｰｼﾞの SUNDAY(日曜日のみが休日) です｡
	 *
	 * DEFAULT_CALENDAR_CLASS = "org.opengion.hayabusa.resource.CalendarPGData_SUNDAY" ;
	 * @og.rev 4.0.0.0 (2007/08/28) 新規作成
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String DEFAULT_CALENDAR_CLASS = "org.opengion.hayabusa.resource.CalendarPGData_SUNDAY" ;

	/**
	 * 時間単位のｶﾞﾝﾄﾍｯﾀﾞｰにおいて､休日を表示するかどうかを判定します｡
	 * 初期値は､true です｡
	 *
	 * USE_GANTTHEADER_SKIP_HOLIDAY = "true" ;
	 * @og.rev 4.0.0.0 (2007/09/05) 新規作成
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_GANTTHEADER_SKIP_HOLIDAY = "true" ;

	/**
	 * 帳票ﾃﾞｰﾓﾝの検索条件(ORDER BY)を指定します｡
	 *
	 * １ﾍﾟｰｼﾞ目と２ﾍﾟｰｼﾞ目で帳票IDを変更し､２ﾍﾟｰｼﾞ目のみを
	 * 大量出力する場合は､検索順(つまり､印字順)を変更することで､対応できます｡
	 * ただし､帳票ｼｽﾃﾑは､共通に使用するため､勝手にｿｰﾄ順を変更すると
	 * 大変なことになる為､自ｼｽﾃﾑのみで使用することを確認の上､設定変更を
	 * して下さい｡並び替えの項目の前には､必ず"A."(GE50)を付加して下さい｡
	 *
	 * REPORT_DAEMON_ORDER_BY = " A.SYSTEM_ID,A.LISTID,A.GROUPID,A.YKNO" ;
	 * @og.rev 4.0.1.0 (2007/12/19) 新規作成 (Ver3より復活)
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String REPORT_DAEMON_ORDER_BY = " A.SYSTEM_ID,A.LISTID,A.GROUPID,A.YKNO" ;

	// /**
	// * RFID帳票を発行するためのｻｰﾋﾞｽｸﾗｽを指定します｡
	// * org.opengion.hayabusa.report.RFIDPrintPointService を継承している必要があります｡
	// * ﾃﾞﾌｫﾙﾄ設定は､org.opengion.plugin.report.rfid.RFIDPrintPointService_DEFAULTです｡
	// *
	// * REPORT_RFID_SERVICE_CLASS = "org.opengion.plugin.report.RFIDPrintPointService_DEFAULT" ;
	// * @og.rev 5.4.3.0 (2011/12/26) INUYAMAからDEFAULTに変更
	// * @og.rev 5.9.0.0 (2015/09/04) ﾌﾟﾗｸﾞｲﾝ扱いに変更
	// * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(RFIDPrintPointService_DEFAULT.java廃止)
	// *
	// * @og.paramLevel 2:使用時設定
	// */
	// 7.4.4.0 (2021/06/30) Delete
	// public static final String REPORT_RFID_SERVICE_CLASS = "org.opengion.plugin.report.RFIDPrintPointService_DEFAULT" ;
	//public static final String REPORT_RFID_SERVICE_CLASS = "org.opengion.hayabusa.report.RFIDPrintPointService_DEFAULT" ;
	//public static final String REPORT_RFID_SERVICE_CLASS = "org.opengion.hayabusa.report.rfid.RFIDPrintPointService_INUYAMA";

	// /**
	// * RFID帳票でﾌｧｲﾙ出力をする際の文字ｺｰﾄﾞを指定します｡
	// * ﾃﾞﾌｫﾙﾄ設定は､UTF-8です｡
	// *
	// * REPORT_RFID_TEXT_ENCODE = "UTF-8" ;
	// * @og.rev 5.4.3.0 (2011/12/26) 新規作成
	// * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(RFIDPrintPointService_DEFAULT廃止)
	// *
	// * @og.paramLevel 2:使用時設定
	// */
	// 7.4.4.0 (2021/06/30) Delete
	// public static final String REPORT_RFID_TEXT_ENCODE = "UTF-8" ;

	/**
	 * CSV帳票を発行するためのｻｰﾋﾞｽｸﾗｽを指定します｡
	 * org.opengion.hayabusa.report.CSVPrintPointService を継承している必要があります｡
	 * ﾃﾞﾌｫﾙﾄ設定は､org.opengion.hayabusa.report.rfid.CSVPrintPointService_DEFAULTです｡
	 *
	 * REPORT_CSV_SERVICE_CLASS = "org.opengion.plugin.report.CSVPrintPointService_DEFAULT" ;
	 * @og.rev 5.9.0.0 (2015/09/04) 新規作成
	 *
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String REPORT_CSV_SERVICE_CLASS = "org.opengion.plugin.report.CSVPrintPointService_DEFAULT" ;

	/**
	 * CSV帳票でﾌｧｲﾙ出力をする際の文字ｺｰﾄﾞを指定します｡
	 * ﾃﾞﾌｫﾙﾄ設定は､UTF-8です｡
	 *
	 * REPORT_CSV_TEXT_ENCODE = "UTF-8" ;
	 * @og.rev 5.9.0.0 (2015/09/04) 新規作成
	 *
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String REPORT_CSV_TEXT_ENCODE = "UTF-8" ;

	/**
	 * GEｼｽﾃﾑのﾌｫﾙﾀﾞ名(URLのｺﾝﾃｷｽﾄ名)｡
	 * GE_CONTEXT_NAME = "ge" ;
	 *
	 * @og.rev 6.3.8.3 (2015/10/03) ge4 → ge 変更｡
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String GE_CONTEXT_NAME = "ge" ;

	/**
	 * 帳票出力に使用するOpenOffice.orgのsoffice.binﾌﾟﾛｾｽの最大数｡
	 *
	 * 初期値は256ですが､ﾃﾞｰﾓﾝﾌﾞﾙｰﾌﾟの分だけ起動されるため､通常
	 * 意識する必要はありません｡
	 * REPORT_MAX_PROCESS_COUNT = "256" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String REPORT_MAX_PROCESS_COUNT = "256" ;

	/**
	 * 帳票出力に使用するOpenOffice.orgのsoffice.binﾌﾟﾛｾｽの生存時間(秒)｡
	 *
	 * soffice.binのﾌﾟﾛｾｽは､ﾌﾟｰﾙされ各ﾃﾞｰﾓﾝｸﾞﾙｰﾌﾟで再利用されます｡
	 * この時､生成から一定期間が過ぎたﾌﾟﾛｾｽは､一度終了させ､再度起動します｡
	 * 初期値は1800秒です｡
	 * REPORT_PROCESS_ALIVE = "1800" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String REPORT_PROCESS_ALIVE = "1800" ;

	/**
	 * 帳票出力時にｴﾗｰが発生した場合の再試行回数｡
	 *
	 * 帳票出力処理は､全体で[再試行回数+1回]処理を試みます｡
	 * 初期値は0(ﾘﾄﾗｲしない)です｡
	 * REPORT_RETRY_COUNT = "0" ;
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String REPORT_RETRY_COUNT = "0" ;

	/**
	 * 帳票出力に使用するOpenOffice.orgのsoffice.binﾌﾟﾛｾｽに接続する方法を指定します｡
	 *
	 * 特に理由がない限り､初期値のPIPE接続を利用して下さい｡
	 * 但し､PIPE接続を利用した場合､64Bit版のJavaから帳票ｼｽﾃﾑを動作させると､
	 * "UnsatisfiedLinkError"が発生することがあります｡
	 * このような場合は､この値を"TCP"に変更し､soffice.binのﾌﾟﾛｾｽにTCP接続するようにして下さい｡
	 * ※ Windowsは６４Bit版が主流なので､初期値も､TCP に変更しておきます｡
	 * 初期値は"TCP"(TCP接続)です｡
	 *
	 * REPORT_OOO_CONN_TYPE = "TCP" ;
	 * @og.rev 5.1.7.0 (2010/06/01) 新規作成
	 * @og.rev 6.2.4.0 (2015/05/15) 初期値変更(PIPE → TCP)
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String REPORT_OOO_CONN_TYPE = "TCP" ;		// 6.2.4.0 (2015/05/15)

	/**
	 * 帳票出力で接続方法(REPORT_OOO_CONN_TYPE)を"TCP"(TCP接続)にした場合の初期ﾎﾟｰﾄ番号を指定します｡
	 *
	 * soffice.binへの接続方法をTCP接続にした場合の､初期の接続ﾎﾟｰﾄ番号を指定します｡
	 * このﾎﾟｰﾄ番号を基点に､最大で
	 *  [初期ﾎﾟｰﾄ番号]+[接続最大ﾌﾟﾛｾｽ数(REPORT_MAX_PROCESS_COUNT)]-1
	 * のﾎﾟｰﾄ番号が使用される可能性がありますので､この間のﾎﾟｰﾄ番号は確実に使用されないことを
	 * 確認した上で､この初期ﾎﾟｰﾄ番号を指定して下さい｡
	 * 初期値は8100です｡
	 *
	 * REPORT_OOO_MIN_PORT = "8100" ;
	 * @og.rev 5.1.7.0 (2010/06/01) 新規作成
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String REPORT_OOO_MIN_PORT = "8100" ;

	/**
	 * 帳票出力のQRｺｰﾄﾞ作成時の初期ﾊﾟﾗﾒｰﾀ(ﾊﾞｰｼﾞｮﾝ)を指定します｡
	 *
	 * これは､org.opengion.hayabusa.report2.OdsContentParser 内でしか使用していません｡
	 *
	 * ﾊﾞｰｼﾞｮﾝ (1から40の整数｡0を設定すると自動設定になります｡)
	 *
	 * REPORT_QR_VERSION = "5" ;
	 *
	 * @og.rev 7.0.5.1 (2019/09/27) 帳票出力のQRｺｰﾄﾞ作成時の初期ﾊﾟﾗﾒｰﾀ
	 *
	 * @og.paramLevel 7:要再起動
	 */
	public static final String REPORT_QR_VERSION = "5" ;

	/**
	 * 帳票出力のQRｺｰﾄﾞ作成時の初期ﾊﾟﾗﾒｰﾀ(ｴﾝｺｰﾄﾞﾓｰﾄﾞ)を指定します｡
	 *
	 * これは､org.opengion.hayabusa.report2.OdsContentParser 内でしか使用していません｡
	 *
	 * ｴﾝｺｰﾄﾞﾓｰﾄﾞ('N':数字ﾓｰﾄﾞ 'A':英数字ﾓｰﾄﾞ　'B':8bit byteﾓｰﾄﾞ)
	 *
	 * REPORT_QR_ENCMODE = "B" ;
	 *
	 * @og.rev 7.0.5.1 (2019/09/27) 帳票出力のQRｺｰﾄﾞ作成時の初期ﾊﾟﾗﾒｰﾀ
	 *
	 * @og.paramLevel 7:要再起動
	 */
	public static final String REPORT_QR_ENCMODE = "B" ;

	/**
	 * 帳票出力のQRｺｰﾄﾞ作成時の初期ﾊﾟﾗﾒｰﾀ(ｴﾗｰ訂正ﾚﾍﾞﾙ)を指定します｡
	 *
	 * これは､org.opengion.hayabusa.report2.OdsContentParser 内でしか使用していません｡
	 *
	 * ｴﾗｰ訂正ﾚﾍﾞﾙ ('L','M','Q','H') H とM のみｻﾎﾟｰﾄ
	 *
	 * REPORT_QR_ERRCRCT = "M" ;
	 *
	 * @og.rev 7.0.5.1 (2019/09/27) 帳票出力のQRｺｰﾄﾞ作成時の初期ﾊﾟﾗﾒｰﾀ
	 *
	 * @og.paramLevel 7:要再起動
	 */
	public static final String REPORT_QR_ERRCRCT = "M" ;

	/**
	 * 帳票出力のQRｺｰﾄﾞ作成時の初期ﾊﾟﾗﾒｰﾀ(ﾋﾟｸｾﾙ数)を指定します｡
	 *
	 * これは､org.opengion.hayabusa.report2.OdsContentParser 内でしか使用していません｡
	 *
	 * １ｾﾙ辺りの塗りつぶしﾋﾟｸｾﾙ数
	 *
	 * REPORT_QR_PIXEL = "3" ;
	 *
	 * @og.rev 7.0.5.1 (2019/09/27) 帳票出力のQRｺｰﾄﾞ作成時の初期ﾊﾟﾗﾒｰﾀ
	 *
	 * @og.paramLevel 7:要再起動
	 */
	public static final String REPORT_QR_PIXEL = "3" ;

	/**
	 * 帳票出力のQRｺｰﾄﾞ作成時のﾃｷｽﾄのｴﾝｺｰﾄﾞを指定します｡
	 *
	 * これは､org.opengion.hayabusa.report2.OdsContentParser 内でしか使用していません｡
	 *
	 * ﾃｷｽﾄのｴﾝｺｰﾄﾞの指定がない場合は､ﾌﾟﾗｯﾄﾌｫｰﾑ依存のﾃﾞﾌｫﾙﾄの Charset です｡
	 * java.nio.charset.Charset#defaultCharset()
	 * QRｺｰﾄﾞで､機種依存文字(①など)は､Windows-31J を指定しても読み取り側が対応していません｡
	 * その場合は､UTF-8 を指定します｡(必要なﾊﾞｲﾄ数は当然増えます)
	 *
	 * REPORT_QR_TEXT_ENCODE = "" ;
	 * 初期値は､Shift-JIS 相当
	 *
	 * @og.rev 7.2.3.0 (2020/04/10) 帳票出力のQRｺｰﾄﾞ作成時のﾃｷｽﾄのｴﾝｺｰﾄﾞ指定
	 *
	 * @og.paramLevel 7:要再起動
	 */
	public static final String REPORT_QR_TEXT_ENCODE = "" ;

	/**
	 * 画面遷移なしの登録を行うかどうかを指定します｡
	 * trueが指定された場合､画面遷移を行わず選択行のみを動的に切り替えることで､
	 * 編集､登録を行います｡ｻｰﾊﾞｰへのﾃﾞｰﾀ送信には､jQueryのFormPluginを
	 * 利用しています｡
	 * また､ﾃﾞｰﾀを送信する対象のﾌｫｰﾑには､id="noTransition"を指定して下さい｡
	 * (該当のIDのﾌｫｰﾑが存在しない場合は､JSPの1番目のﾌｫｰﾑが送信されます｡)
	 *
	 * 初期値はfalse(画面遷移なしﾓｰﾄﾞを使用しない)です｡
	 * NO_TRANSITION_MODE = "false" ;
	 *
	 * @og.rev 4.3.1.0 (2008/09/02) 新規作成
	 *
	 * @og.paramLevel 1:設定確認
	 */
	public static final String NO_TRANSITION_MODE = "false" ;

	/**
	 * 利用するﾍｯﾀﾞ固定ｽｸﾘﾌﾟﾄ及びｽﾀｲﾙｼｰﾄを選択します｡
	 * 拡張子を抜いた状態でﾌｧｲﾙを指定して下さい｡
	 *
	 * 初期値:common/scrollBar
	 * SCROLL_BAR_TYPE = "common/scrollBar"
	 *
	 * @og.rev 4.3.5.0 (2009/02/01) 新規作成
	 * @og.rev 5.0.0.0 (2009/08/03) scrollBar2を標準とする｡
	 *
	 * @og.paramLevel 1:設定確認
	 */
	public static final String SCROLL_BAR_TYPE = "common/scrollBar2" ;

	/**
	 * hideMenuの初期指定の｢開く｣ﾎﾞﾀﾝの画像を指定します｡
	 *
	 * hideMenuﾀｸﾞで作成されるﾎﾞﾀﾝの画像です｡
	 * jsp/iconﾌｫﾙﾀﾞ内の画像ﾌｧｲﾙを指定して下さい｡
	 *
	 * 初期値:expand_u.png
	 * HIDE_OPEN_BUTTON = "expand_u.png"
	 *
	 * @og.rev 4.3.6.0 (2009/04/01) 新規作成
	 *
	 * @og.paramLevel 1:設定確認
	 */
	public static final String HIDE_OPEN_BUTTON = "expand_u.png" ;

	/**
	 * hideMenuの初期指定の｢閉じる｣ﾎﾞﾀﾝの画像を指定します｡
	 *
	 * hideMenuﾀｸﾞで作成されるﾎﾞﾀﾝの画像です｡
	 * jsp/iconﾌｫﾙﾀﾞ内の画像ﾌｧｲﾙを指定して下さい｡
	 *
	 * 初期値:shrink_u.png
	 * HIDE_CLOSE_BUTTON = "shrink_u.png"
	 *
	 * @og.rev 4.3.6.0 (2009/04/01) 新規作成
	 *
	 * @og.paramLevel 1:設定確認
	 */
	public static final String HIDE_CLOSE_BUTTON = "shrink_u.png" ;

	/**
	 * eventColumn設定時の標準処理JSPﾌｧｲﾙの指定します｡
	 *
	 * eventColumnを設定した場合に実際にｶﾗﾑを作成する標準のJSPを指定します｡
	 * ここでの記述はjspﾌｫﾙﾀﾞを基底にして下さい
	 *
	 * 初期値:common/eventColumnMaker.jsp
	 * EVENT_COLUMN_URL = "common/eventColumnMaker.jsp"
	 *
	 * @og.rev 4.3.6.0 (2009/04/01) 新規作成
	 *
	 * @og.paramLevel 1:設定確認
	 */
	public static final String EVENT_COLUMN_URL = "common/eventColumnMaker.jsp" ;

	/**
	 * eventColumn利用時のｾｷｭﾘﾃｨ向上対応を行います｡
	 *
	 * trueにした場合は暗号化処理を入れます｡
	 * trueの場合はvalueﾀｸﾞでﾃﾞｺｰﾄﾞする必要があります｡
	 * 初期値は互換性のあるfalseです｡
	 *
	 * 初期値:false
	 * EVENT_COLUMN_URL = "false"
	 *
	 * @og.rev 5.10.4.0 (2018/10/05) 新規作成
	 *
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String EVENT_SQL_ENCRYPT = "false" ;

	/**
	 * TableUpdateParamで使用される固定ｶﾗﾑを処理するｸﾗｽを指定します｡
	 *
	 * TableUpdateParamで通常利用されるｸﾗｽは
	 * org.opengion.plugin.query.DBConstValue_"SYSTEM_ID"
	 * ですが､このﾌﾟﾗｸﾞｲﾝが存在しない場合に利用される標準のｸﾗｽを設定します｡
	 *
	 * ｸﾗｽは､ﾌﾙﾊﾟｽで指定する必要があり､DBConstValue を継承している必要があります｡
	 *
	 * 初期値:ｾﾞﾛ文字列("")
	 * DEFAULT_CONST_CLASS = ""
	 *
	 * @og.rev 4.3.6.4 (2009/05/01) 新規作成
	 * @og.rev 5.3.4.0 (2011/04/01) 初期値変更
	 *
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String DEFAULT_CONST_CLASS = "" ;

//	/**
//	 * IE8でIE7ｴﾐｭﾚｰﾄﾓｰﾄﾞで動作させるﾀｸﾞを出力するかを指定します｡
//	 *
//	 * trueを指定するとIE8でIE7ｴﾐｭｰﾚｰﾄﾓｰﾄﾞで動作するように
//	 * og:headﾀｸﾞでmetaﾀｸﾞを出力します｡
//	 * openGion Ver6 以降は､ﾈｲﾃｨﾌﾞﾓｰﾄﾞ(=false)を初期値にします｡
//	 * 画面の動作がおかしい場合は､true(IE7ｴﾐｭｰﾚｰﾄﾓｰﾄﾞで動作させる)を設定するか
//	 * IEなどのﾌﾞﾗｳｻﾞ上で､互換ﾓｰﾄﾞに指定してください｡
//	 *
//	 * HTML5 の機能を有効にするには､ﾈｲﾃｨﾌﾞﾓｰﾄﾞで動作させるだけでなく､
//	 * HTML5 のﾀｸﾞを出力する必要があります｡
//	 *   ① USE_IE7_HEADER = "false" に設定する(Ver6 より初期値)｡
//	 *   ② USE_HTML5_HEADER = "true" に設定する(Ver6 より初期値)｡
//	 *   ③ IEのﾂｰﾙ⇒互換表示設定で､互換表示に追加したWebｻｲﾄから削除する｡
//	 *   ④ 同上の設定で､ｲﾝﾄﾗｻｲﾄを互換表示で表示するのﾁｪｯｸを外す｡
//	 * 必要があります｡
//	 *
//	 * 初期値:false
//	 * USE_IE7_HEADER = "false"
//	 *
//	 * @og.rev 4.3.7.0 (2009/06/01) 新規作成
//	 * @og.rev 6.0.0.0 (2014/04/11) true → false に初期値変更 (初期値をﾈｲﾃｨﾌﾞﾓｰﾄﾞにします)
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止(false固定)
//	 *
//	 * @og.paramLevel 3:標準推奨
//	 */
//	public static final String USE_IE7_HEADER = "false" ;

//	/**
//	 * HTML5 に対応した ﾍｯﾀﾞｰを出力するか､どうかを指定します｡
//	 *
//	 * trueを指定すると HTML5 形式のﾍｯﾀﾞｰ情報を作成します｡
//	 * og:headﾀｸﾞで DOCTYPE,html,head,metaﾀｸﾞを出力します｡
//	 * openGion Ver6 以降は､HTML5ﾍｯﾀﾞｰ(=true)を初期値にします｡
//	 *
//	 * HTML5 の機能を有効にするには､ﾈｲﾃｨﾌﾞﾓｰﾄﾞで動作させるだけでなく､
//	 * HTML5 のﾀｸﾞを出力する必要があります｡
//	 *   ① USE_IE7_HEADER = "false" に設定する(Ver6 より初期値)｡
//	 *   ② USE_HTML5_HEADER = "true" に設定する(Ver6 より初期値)｡
//	 *   ③ IEのﾂｰﾙ⇒互換表示設定で､互換表示に追加したWebｻｲﾄから削除する｡
//	 *   ④ 同上の設定で､ｲﾝﾄﾗｻｲﾄを互換表示で表示するのﾁｪｯｸを外す｡
//	 * 必要があります｡
//	 *
//	 * 初期値:true
// 	 * USE_HTML5_HEADER = "true"
//	 *
//	 * @og.rev 5.7.1.0 (2013/12/06) 新規作成
//	 * @og.rev 6.0.0.0 (2014/04/11) false → true に初期値変更 (初期値をHTML5にします)
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止(true固定)
//	 *
//	 * @og.paramLevel 3:標準推奨
//	 */
// 	public static final String USE_HTML5_HEADER = "true" ;

//	/**
//	 * IEで最新のﾚﾝﾀﾞﾘﾝｸﾞを行うためのﾍｯﾀﾞｰを出力するかの設定をします｡
//	 *
//	 * trueを指定するとcommon/option/html5modalDialog.js､cssをog:headﾀｸﾞで読み込みます｡
//	 *
//	 * 初期値:true
//	 * USE_HTML5_MODAL = "true"
//	 *
//	 * @og.rev 5.5.8.0 (2012/11/01) 新規作成
//	 * @og.rev 6.6.0.0 (2016/12/01) USE_HTML5_MODAL の初期値を､true に変更します｡
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止(true固定)
//	 *
//	 * @og.paramLevel 2:使用時設定
//	 */
//	public static final String USE_HTML5_MODAL = "true" ;			// 6.6.0.0 (2016/12/01)

	/**
	 * HeadﾀｸﾞのUSERID取得をrequestﾍｯﾀﾞから取得する場合に利用します｡
	 * 指定した場合はrequest.getRemoteUser()ではなくrequest.getHeaderを利用します｡
	 *
	 * 一部のSSO製品でこの方式を取っているものがあるためです｡
	 * 初期値は空文字(利用しない)です｡
	 * USERID_HEADER_NAME = ""
	 *
	 * @og.rev 5.10.14.2 (2019/08/23) 新規追加
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String USERID_HEADER_NAME = "" ;

	/**
	 * IEで最新のﾚﾝﾀﾞﾘﾝｸﾞを行うためのﾍｯﾀﾞｰを出力するかの設定をします｡
	 *
	 * これを､true にすると､ﾌﾞﾗｳｻﾞを､HTML5 ﾈｲﾃｨﾌﾞに強制的に指定します｡
	 *
	 * trueを指定するとmetaﾀｸﾞで
	 * http-equiv="X-UA-Compatible" content="IE=edge"
	 * を出力します
	 *
	 * ※ Surface等のﾀｯﾁ画面での拡大縮小の動きを有効にするには､true にしておく必要があります｡
//	 * ※ true にすると､旧ﾎﾟｯﾌﾟｱｯﾌﾟのｻｲｽﾞが最小化されます｡同時に､USE_HTML5_MODAL も､true に
//	 *    設定する必要があります｡
	 *
	 * 初期値:false
	 * USE_EDGE_HEADER = "true"
	 *
	 * @og.rev 5.9.2.3 (2015/11/27) 新規作成
	 * @og.rev 6.4.2.1 (2016/02/05) 初期値を､true に変更します｡
	 * @og.rev 6.4.4.1 (2016/03/18) 初期値を､false に変更します｡
	 * @og.rev 6.9.1.0 (2018/02/26) false → true に初期値変更(この状態で動作するように調整します)
	 *
	 * @og.paramLevel 2:使用時設定
	 */
//	public static final String USE_EDGE_HEADER = "false" ;
	public static final String USE_EDGE_HEADER = "true" ;		// 6.9.1.0 (2018/02/26)

	/**
	 * HTML5 の必須入力(required属性)を､must に適用するかどうかを指定します｡
	 *
	 * trueを指定すると HTML5 形式の場合､must属性と同時に､required属性を出力します｡
	 * falseの場合は､must属性は､従来のままです｡
	 * openGion Ver6 以降は､HTML5ﾍｯﾀﾞｰ(=true)を初期値にするため､この値も､true です｡
	 * ただし､must 属性に､すべて適用すると､問題が発生する箇所もあるため､注意が必要です｡
	 *
	 *   ① USE_IE7_HEADER = "false"
	 *   ② USE_HTML5_HEADER = "true"
	 *   ③ USE_MUST_REQUIRED = "true"
	 *
	 * の条件で､must="true" にすると､required属性も同時出力されます｡
	 *
	 * 初期値:false
 	 * USE_MUST_REQUIRED= "false"
	 *
	 * @og.rev 6.4.0.4 (2015/12/26) 新規作成
	 *
	 * @og.paramLevel 7:要再起動
	 */
	public static final String USE_MUST_REQUIRED = "false" ;

//	/**
//	 * ﾀﾌﾞﾚｯﾄ等の画面ｻｲｽﾞ調整METAﾀｸﾞ(viewport)を出力するか指定します｡
//	 *
//	 * trueを指定するとmetaﾀｸﾞで
//	 * content="width=device-width, initial-scale=1" name="viewport"
//	 * を出力します
//	 *
//	 * 初期値:false
//	 * USE_VIEWPORT_HEADER = "false"
//	 *
//	 * @og.rev 5.5.8.0 (2012/11/01) 新規作成
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止
//	 *
//	 * @og.paramLevel 2:使用時設定
//	 */
//	public static final String USE_VIEWPORT_HEADER = "false" ;

	/**
	 * ｴﾗｰをﾎﾟｯﾌﾟｱｯﾌﾟ形式で表示するかを指定します｡
	 *
	 * noTransitionがfalseでも､この値をtrueにする事でajaxを利用して
	 * ｴﾗｰをﾎﾟｯﾌﾟｱｯﾌﾟ表示します(command=ENTRY限定)｡
	 * (一覧でeventColumnを利用する画面は戻るﾎﾞﾀﾝで戻った場合に
	 * 変更した値が保持されていないため､trueが望ましい)
	 * noTransitionがtrueの場合はこの設定は無視され､全画面で非遷移となります｡
	 * 初期値はfalse(利用しない)です｡
	 *
	 * 初期値:false
	 * USE_AJAX_SUBMIT = "false"
	 *
	 * @og.rev 4.3.8.0 (2009/08/01) 新規作成
	 *
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String USE_AJAX_SUBMIT = "false" ;

	/**
	 * ﾘｸｴｽﾄ情報の HTMLTag開始/終了文字(＞＜) 存在ﾁｪｯｸを実施するかどうか[true/false]を設定します｡
	 *
	 * trueにするとｸﾛｽｻｲﾄｽｸﾘﾌﾟﾃｨﾝｸﾞ(XSS)対策の一環としてless/greater than signについてのﾁｪｯｸを行います｡
	 * (＞＜) が含まれていたｴﾗｰにする(true)／かﾉｰﾁｪｯｸか(false)を指定します｡
	 * {&#064;XXXX}の置換え時にﾘｸｴｽﾄﾊﾟﾗﾒｰﾀのみ適用します｡
	 * attributesに対しては動作しません｡
	 *
	 * 初期値:true
	 * USE_XSS_CHECK = "true" ;
	 *
	 * @og.rev 5.0.0.2 (2009/09/15) 新規作成
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String USE_XSS_CHECK = "true" ;

	/**
	 * 業務ﾛｼﾞｯｸのJavaｿｰｽを格納するﾃﾞｨﾚｸﾄﾘを指定します｡
	 *
	 * 業務ﾛｼﾞｯｸのJavaｿｰｽを格納するﾃﾞｨﾚｸﾄﾘを指定します｡
	 * ﾃﾞｨﾚｸﾄﾘは､ｺﾝﾃｷｽﾄﾙｰﾄを基点とした相対ﾊﾟｽで記述します｡
	 *
	 * 初期値:src
	 * BIZLOGIC_SRC_PATH = "src/biz" ;
	 *
	 * @og.rev 5.1.1.0 (2009/12/01) 新規作成
	 * @og.rev 6.9.1.0 (2018/02/26) File.separator を使わず､直接指定します｡
	 *
	 * @og.paramLevel 3:標準推奨
	 */
//	public static final String BIZLOGIC_SRC_PATH = "src" + File.separator + "biz" ;
	public static final String BIZLOGIC_SRC_PATH = "src/biz" ;

	/**
	 * 業務ﾛｼﾞｯｸのJavaｸﾗｽﾌｧｲﾙを格納するﾃﾞｨﾚｸﾄﾘを指定します｡
	 *
	 * 業務ﾛｼﾞｯｸのJavaｸﾗｽﾌｧｲﾙを格納するﾃﾞｨﾚｸﾄﾘを指定します｡
	 * ﾃﾞｨﾚｸﾄﾘは､ｺﾝﾃｷｽﾄﾙｰﾄを基点とした相対ﾊﾟｽで記述します｡
	 *
	 * 初期値:classes
	 * BIZLOGIC_CLASS_PATH = "WEB-INF/biz" ;
	 *
	 * @og.rev 5.1.1.0 (2009/12/01) 新規作成
	 * @og.rev 6.9.1.0 (2018/02/26) File.separator を使わず､直接指定します｡
	 *
	 * @og.paramLevel 3:標準推奨
	 */
//	public static final String BIZLOGIC_CLASS_PATH = "WEB-INF" + File.separator + "biz" ;
	public static final String BIZLOGIC_CLASS_PATH = "WEB-INF/biz" ;

	/**
	 * 業務ﾛｼﾞｯｸのJavaｿｰｽの動的ｺﾝﾊﾟｲﾙを行うかを指定します｡
	 *
	 * 業務ﾛｼﾞｯｸのJavaｿｰｽの動的ｺﾝﾊﾟｲﾙを行うかを指定します｡
	 * trueを指定すると､Javaｿｰｽを変更した後､初めてｱｸｾｽされた
	 * ﾀｲﾐﾝｸﾞで動的にｺﾝﾊﾟｲﾙが行われます｡
	 *
	 * 初期値:true
	 * BIZLOGIC_AUTO_COMPILE = "true" ;
	 *
	 * @og.rev 5.1.1.0 (2009/12/01) 新規作成
	 *
	 * @og.paramLevel 1:設定確認
	 */
	public static final String BIZLOGIC_AUTO_COMPILE ="true";

	/**
	 * 業務ﾛｼﾞｯｸのJavaｸﾗｽﾌｧｲﾙの動的ﾛｰﾄﾞを行うかを指定します｡
	 *
	 * 業務ﾛｼﾞｯｸのJavaｸﾗｽﾌｧｲﾙの動的ﾛｰﾄﾞを行うかを指定します｡
	 * trueを指定すると､Javaｸﾗｽﾌｧｲﾙが変更された後､初めてｱｸｾｽされた
	 * ﾀｲﾐﾝｸﾞで動的にｸﾗｽﾛｰﾄﾞが行われます｡
	 *
	 * 初期値:true
	 * BIZLOGIC_HOT_DEPLOY = "true" ;
	 *
	 * @og.rev 5.1.1.0 (2009/12/01) 新規作成
	 *
	 * @og.paramLevel 3:標準推奨
	 */
	public static final String BIZLOGIC_HOT_DEPLOY ="true";

	/**
	 * 画面編集機能で､共通編集の登録/変更､及び出力方法の追加/変更/削除が可能なﾛｰﾙを指定します｡
	 *
	 * 画面編集機能で､共通編集の登録/変更､及び出力方法の追加/変更/削除が可能なﾛｰﾙを指定します｡
	 * 初期状態では､rootﾕｰｻﾞｰのみが共通編集の登録､変更が可能で､
	 * それ以外のﾕｰｻﾞｰは､個人単位での編集の登録､変更のみが可能です｡
	 *
	 * 初期値:"-"
	 * EDIT_COMMON_ROLES = "-";
	 *
	 * @og.rev 5.3.6.0 (2011/06/01) 新規作成
	 *
	 * @og.paramLevel 1:設定確認
	 */
	public static final String EDIT_COMMON_ROLES = "-";

//	/**
//	 * 伝送ｼｽﾃﾑでﾎｽﾄ間伝送を行う際の送り元ﾎｽﾄｺｰﾄﾞを指定します｡
//	 *
//	 * 伝送ｼｽﾃﾑでﾎｽﾄ間伝送を行う際の送り元ﾎｽﾄｺｰﾄﾞを指定します｡
//	 * 伝送ｼｽﾃﾑ利用時､必要に応じて設定を行って下さい｡
//	 *
//	 * 初期値:""
//	 * TRANSFER_HOSTNO = "";
//	 *
//	 * @og.rev 5.4.1.0 (2011/11/01) 新規作成
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止
//	 *
//	 * @og.paramLevel 2:使用時設定
//	 */
//	public static final String TRANSFER_HOST_CODE = "";

	// /**
	// * URL接続を行う際のﾌﾟﾛｷｼのﾎｽﾄ名のﾃﾞﾌｫﾙﾄ値を指定します｡
	// *
	// * URL接続を行う際のﾌﾟﾛｷｼのﾎｽﾄ名のﾃﾞﾌｫﾙﾄ値を指定します｡
	// * URL接続機能を利用する場合は､必要に応じて設定を行って下さい｡
	// *
	// * 初期値:""
	// * HTTP_PROXY_HOST = "";
	// *
	// * @og.rev 5.4.2.0 (2011/12/01) 新規作成
	// * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(未使用の為廃止)
	// *
	// * @og.paramLevel 2:使用時設定
	// */
	// 7.4.4.0 (2021/06/30) Delete
	// public static final String HTTP_PROXY_HOST = "";

	// /**
	// * URL接続を行う際のﾌﾟﾛｷｼのﾎﾟｰﾄ番号のﾃﾞﾌｫﾙﾄ値を指定します｡
	// *
	// * URL接続を行う際のﾌﾟﾛｷｼのﾎﾟｰﾄ番号のﾃﾞﾌｫﾙﾄ値を指定します｡
	// * URL接続機能を利用する場合は､必要に応じて設定を行って下さい｡
	// *
	// * 初期値:0
	// * HTTP_PROXY_PORT = 0;
	// *
	// * @og.rev 5.4.2.0 (2011/12/01) 新規作成
	// * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(未使用の為廃止)
	// *
	// * @og.paramLevel 2:使用時設定
	// */
	// 7.4.4.0 (2021/06/30) Delete
	// public static final String HTTP_PROXY_PORT = "0";

	/**
	 * 紙芝居用のﾌｨﾙﾀｰｷｰの対応方法を思いつくまでの暫定対応｡
	 *
	 * query_info.jsp の紙芝居使用時の SYSｷｰで､
	 * ｢ｼｽﾃﾑﾘｿｰｽｷｰが存在しません｡｣を避けるため､暫定的に
	 * ﾏｽﾀに設定しておきます｡
	 *
	 * 初期値:false
	 * USE_FILEFILTER = "false" ;
	 *
	 * @og.rev 6.9.5.0 (2018/04/23) 暫定対応
	 *
	 * @og.paramLevel 9:自動設定
	 */
	public static final String USE_FILEFILTER = "false";

	/**
	 * ﾌｧｲﾙ取込ｼｽﾃﾑをTomcat起動時に実行開始するかどうかを指定します｡
	 *
	 * true に設定すると､org.opengion.fukurou.fileexec.MainProcess を起動します｡
	 *
	 * 初期値:false
	 * USE_FILEEXEC = "false" ;
	 *
	 * @og.rev 7.2.5.0 (2020/06/01) 新規作成
	 * @og.rev 7.4.4.0 (2021/06/30) openGionV8事前準備(ｺﾒﾝﾄのGE58廃止)
	 *
	 * @og.paramLevel 2:使用時設定
	 */
	public static final String USE_FILEEXEC = "false";

//	/*******************************************************************************
//	 *
//	 * 以下は､Ver4と共通でﾘｿｰｽDB(GExx)を利用する場合にのみ設定します｡
//	 * 通常､openGionを利用する場合は､確認･設定の必要はありません｡
//	 *
//	 *******************************************************************************/
//
//	/**
//	 * (通常は使いません)Ver4と共通のﾘｿｰｽDB(GExx)を利用する場合に設定します｡
//	 *
//	 * Ver4と共通のDBを利用する場合は､trueを設定することで､openGion本体(Java)及び
//	 * GEｼｽﾃﾑの各画面からｱｸｾｽする際の項目名が､旧項目名に変換されます｡
//	 *
//	 * 内部的に項目名が変化される項目一覧は以下の通りです｡
//	 *
//	 *   ﾃｰﾌﾞﾙID		(false) ※openGion標準	(true) ※Ver4互換
//	 *   ------------	-----------------------	--------------------
//	 *   GEA05			ROLES					ROLE
//	 *   GEA10			NAME_JA					NAME
//	 *   GE50			OUT_FILE				OUTFILE
//	 *   GE50			OUT_DIR					OUTDIR
//	 *   GE51			TEXT_DATA				TEXT
//	 *   GE51			CLM						COLUMN_NAME
//	 *   GE53			OUT_FILE				OUTFILE
//	 *   GE53			OUT_DIR					OUTDIR
//	 *   GE55			HOST_ID					HOST
//	 *   GE30			H_TXT					HEADER
//	 *   GE30			F_TXT					FOOTER
//	 *   GE31			CONTENTS				CONTENT
//	 *   GE32			CONTENTS				CONTENT
//	 *   GE33			ADDRESS					MEMBER
//	 *   GE33			NAME_JA					NAME
//	 *   GE33			KBNAME					NM_KBN
//	 *
//	 * VER4_COMPATIBLE_MODE = "false";
//	 * @og.rev 6.9.5.0 (2018/04/23) 廃止
//	 * @og.paramLevel 3:標準推奨
//	 */
//	public static final String VER4_COMPATIBLE_MODE = "false";

	/**
	 * ｲﾝｽﾀﾝｽを作らないので､ｺﾝｽﾄﾗｸﾀは､private に設定します｡
	 */
	private SystemData() {}
}
