/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.fukurou.util.StringUtil;
// import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

/**
 * RICHLABEL レンデラは、特殊文字のエスケープを元に戻して表示する場合に
 * 使用するクラスです。
 * readonlyのテキストエリアでname属性は付けません。(データは送信されません)
 * 
 * 属性値に1以上の数値を指定した場合はSLABELと同等の処理を行います。
 * その際に、有効なタグについては除外して表示します。（一覧表示用）
 *
 * カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.rev 5.9.33.0 (2018/06/01) 新規作成
 * @og.rev 5.10.1.0 (2018/06/29) IGNORE_STRに値を追加。
 * @og.group データ編集
 *
 * @version  5.9.33.0
 * @author   T.OTA
 * @since    JDK7.0,
 */
// public class Renderer_RICHLABEL extends AbstractRenderer {
public class Renderer_RICHLABEL extends Renderer_SLABEL {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "7.0.1.2 (2018/11/04)" ;

	private static final CellRenderer DB_CELL = new Renderer_RICHLABEL();

	// 2018/06/28 MODIFY pre,img,table,thead,tbody,tr,th,td,ul,li,h[数値]を追加
//	private static final String IGNORE_STR = "strong|font|a|br|p|span|div";
	private static final String IGNORE_STR = "strong|font|a|br|p|span|div|pre|img|table|thead|tbody|tr|th|td|ul|li|h\\d";

	// 7.0.1.2 (2018/11/04) Renderer_RICHLABELか、Renderer_SLABEL の判定用ﾌﾗｸﾞ
	private final boolean isRichLabel ;

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 */
	public Renderer_RICHLABEL() {
		super();
		isRichLabel = true;
	}

	/**
	 * DBColumnオブジェクトを指定したprivateコンストラクター。
	 *
	 * @og.rev 7.0.1.2 (2018/11/04) 出力文字数指定対応
	 *
	 * @param	size	カットサイズ
	 */
	private Renderer_RICHLABEL( final String size ) {
		super( size );
		isRichLabel = false;
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 * 
	 * 属性値に1以上の数値を指定した場合はSLABELと同等の処理を行います。
	 * その際に、有効なタグについては除外して表示します。（一覧表示用）
	 *
	 * @og.rev 5.10.4.2 (2018/10/19) 出力文字数指定対応
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 */
	@Override
	public CellRenderer newInstance( final DBColumn clm ) {
//		return DB_CELL;
		// return dbCell;
		final String param = clm.getRendererParam();

		if( param != null && param.length() > 0 && !"0".equals( param ) ) {		// 1以上の数値 → 0以外の数値
			return new Renderer_RICHLABEL( param );								// カットサイズ指定 のインスタンス
		}
		else {
			return DB_CELL;
		}
	}

	/**
	 * データの表示用文字列を返します。
	 *
	 * @param   value 入力値
	 *
	 * @return  データの表示用文字列
	 */
	@Override
	public String getValue( final String value ) {
//		return StringUtil.escapeFilter( value,IGNORE_STR );

		final String escStr = StringUtil.escapeFilter( value,IGNORE_STR );

		return isRichLabel ? escStr : super.getValue( escStr );
	}
}
