/*
 * intervalAccess.js
 *
 * 定期的に指定のJSPにアクセスして、セッションを維持します。
 * 内部的には単純にURLに非同期でアクセスするだけです。
 * この intervalAccess メソッドを、呼び出すだけです。
 * jQueryが必要です。
 *
 * 使用する場合は、IA_INTERVAL_TIME (ms) 変数をscript で設定する
 * 必要があります。
 * ※ openGionのheadタグで ( MAX_INACTIVE_INTERVAL - 60 ) * 1000
 *    の値を出力しておきます。
 *
 * 2012/02/03 Takahashi Masakazu
 *
 * 6.3.4.1 (2015/08/08) 標準に組込み
 * 7.4.2.0 (2021/04/30) ｷｬｯｼｭ無効化考慮
*/
var intervalAccess = function(){
	 $.ajax({
			url:'../common/dummy.html?time=' + Date.now() ,	// アクセスするURI
			async:true,										// 非同期通信
			type: 'GET',
			dataType: 'html'
		});
};

// 以下の設定を、head ﾀｸﾞで出力します。
// var IA_INTERVAL_TIME = ( MAX_INACTIVE_INTERVAL - 60 ) * 1000;	// インターバルのミリ秒数
$(function(){
	setInterval("intervalAccess()",IA_INTERVAL_TIME);
});
