/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.resource.CodeData;
import org.opengion.hayabusa.resource.LabelData;
import org.opengion.hayabusa.resource.LabelDataLoader;

final class CodeDataLoader {
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private static final String QUERY = "select CLM,CODE,'' as LNAME,'' as SNAME,CODELVL,CODEGRP,CODE_PARAM,ROLES,SYSTEM_ID,KBSAKU,'' as RSNAME,'' as RLNAME,'' as DESCRIPT,SEQNO from GEA04 where SYSTEM_ID=? and FGJ='1' order by KBSAKU,CLM,SEQNO,CODELVL,CODE";
    private static final String QUERY2 = "select CLM,CODE,'' as LNAME,'' as SNAME,CODELVL,CODEGRP,CODE_PARAM,ROLES,SYSTEM_ID,KBSAKU,'' as RSNAME,'' as RLNAME,'' as DESCRIPT,SEQNO from GEA04 where SYSTEM_ID=? and CLM=? and FGJ='1' order by KBSAKU DESC,CLM,SEQNO,CODELVL,CODE";
    private final Map<String, CodeData> codeDtMap = Collections.synchronizedMap(new WeakHashMap());
    private final String[] SYS_ARRAY;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;
    private final LabelDataLoader LABEL_LOADER;

    CodeDataLoader(String[] stringArray, boolean bl, LabelDataLoader labelDataLoader) {
        this.SYS_ARRAY = stringArray;
        this.LABEL_LOADER = labelDataLoader;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYS_ARRAY[0], HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("CodeDataLoader", null, null);
        } else {
            this.appInfo = null;
        }
        if (bl) {
            this.loadDBResource();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadDBResource() {
        void var6_11;
        String[][] stringArray;
        Object object;
        int n = this.SYS_ARRAY.length;
        int[] nArray = new int[n];
        int n2 = 0;
        HashMap hashMap = new HashMap();
        for (int i = n - 1; i >= 0; --i) {
            String object2 = this.SYS_ARRAY[i];
            object = new String[]{object2};
            stringArray = DBUtil.dbExecute((String)QUERY, (String[])object, (ApplicationInfo)this.appInfo, (String)this.DBID);
            int n3 = stringArray.length;
            n2 += n3;
            nArray[i] = n3;
            String string = null;
            String string2 = null;
            LinkedHashMap<String, String[]> linkedHashMap = null;
            for (int j = 0; j < n3; ++j) {
                String string3 = stringArray[j][0];
                String string4 = stringArray[j][1];
                String string5 = stringArray[j][9];
                if (string == null || !string.equals(string3) || !string2.equals(string5)) {
                    linkedHashMap = new LinkedHashMap<String, String[]>();
                    hashMap.put(string3, linkedHashMap);
                    string = string3;
                    string2 = string5;
                }
                String string6 = string3 + "." + string4;
                LabelData labelData = this.LABEL_LOADER.getLabelData(string6);
                stringArray[j][2] = labelData.getLongLabel();
                stringArray[j][3] = labelData.getShortLabel();
                stringArray[j][10] = labelData.getRawShortLabel();
                stringArray[j][11] = labelData.getRawLongLabel();
                stringArray[j][12] = labelData.getDescription();
                linkedHashMap.put(string4, stringArray[j]);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (String)entry.getKey();
            stringArray = (String[][])entry.getValue();
            this.codeDtMap.put((String)object, new CodeData((String)object, (Map<String, String[]>)stringArray));
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("  ").append(this.SYS_ARRAY[0]).append("  CodeDataLoader [").append(n2).append("] Map=[").append(this.codeDtMap.size()).append("] ");
        boolean bl = false;
        while (var6_11 < n) {
            stringBuilder.append(this.SYS_ARRAY[var6_11]).append("=[").append(nArray[var6_11]).append("] ");
            ++var6_11;
        }
        stringBuilder.append("loaded.");
        System.out.println(stringBuilder);
    }

    public CodeData getCodeData(String string) {
        CodeData codeData = this.codeDtMap.get(string);
        if (codeData == null) {
            int n = this.SYS_ARRAY.length;
            LinkedHashMap<String, String[]> linkedHashMap = null;
            for (int i = 0; i < n; ++i) {
                String string2 = this.SYS_ARRAY[i];
                String[] stringArray = new String[]{string2, string};
                String[][] stringArray2 = DBUtil.dbExecute((String)QUERY2, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
                int n2 = stringArray2.length;
                String string3 = null;
                for (int j = 0; j < n2; ++j) {
                    String string4 = stringArray2[j][1];
                    String string5 = stringArray2[j][9];
                    if (string3 == null || !string3.equals(string5)) {
                        linkedHashMap = new LinkedHashMap<String, String[]>();
                        string3 = string5;
                    }
                    String string6 = string + "." + string4;
                    LabelData labelData = this.LABEL_LOADER.getLabelData(string6);
                    stringArray2[j][2] = labelData.getLongLabel();
                    stringArray2[j][3] = labelData.getShortLabel();
                    stringArray2[j][10] = labelData.getRawShortLabel();
                    stringArray2[j][11] = labelData.getRawLongLabel();
                    stringArray2[j][12] = labelData.getDescription();
                    linkedHashMap.put(string4, stringArray2[j]);
                }
                if (linkedHashMap == null) continue;
                codeData = new CodeData(string, linkedHashMap);
                this.codeDtMap.put(string, codeData);
                break;
            }
        }
        return codeData;
    }

    public CodeData getCodeData(String string, String string2) {
        CodeData codeData = this.codeDtMap.get(string);
        if (codeData == null) {
            String[] stringArray = new String[]{string};
            String[][] stringArray2 = DBUtil.dbExecute((String)string2, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
            int n = stringArray2.length;
            LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>();
            for (int i = 0; i < n; ++i) {
                String[] stringArray3 = new String[13];
                String string3 = stringArray2[i][1];
                stringArray3[0] = string;
                stringArray3[1] = string3;
                stringArray3[2] = stringArray2[i][2];
                stringArray3[3] = stringArray2[i][3];
                linkedHashMap.put(string3, stringArray3);
            }
            if (!linkedHashMap.isEmpty()) {
                codeData = new CodeData(string, linkedHashMap);
                this.codeDtMap.put(string, codeData);
            }
        }
        return codeData;
    }

    public void clear(String string) {
        CodeData codeData = this.codeDtMap.remove(string);
        if (codeData != null) {
            String string2 = codeData.getColumn();
            for (int i = 0; i < codeData.getSize(); ++i) {
                this.LABEL_LOADER.clear(string2 + "." + codeData.getCodeKey(i));
            }
        }
    }

    public void clear() {
        this.codeDtMap.clear();
    }
}

