/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.storage.object.options;

import com.google.common.base.Preconditions;

public final class ObjectLocation {
    private String containerName;
    private String objectName;

    private ObjectLocation(String containerName, String objectName) {
        Preconditions.checkNotNull((Object)containerName, (Object)"ContainerName cannot be null");
        Preconditions.checkNotNull((Object)objectName, (Object)"ObjectName cannot be null");
        this.containerName = containerName;
        this.objectName = objectName;
    }

    public static ObjectLocation create(String containerName, String objectName) {
        return new ObjectLocation(containerName, objectName);
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getURI() {
        return String.format("/%s/%s", this.containerName, this.objectName);
    }
}

