/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gbp.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.gbp.PolicyClassifierService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.gbp.PolicyClassifier;
import org.openstack4j.model.gbp.PolicyClassifierUpdate;
import org.openstack4j.openstack.gbp.domain.GbpPolicyClassifier;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class PolicyClassifierServiceImpl
extends BaseNetworkingServices
implements PolicyClassifierService {
    @Override
    public List<? extends PolicyClassifier> list() {
        return this.get(GbpPolicyClassifier.PolicyClassifiers.class, this.uri("/grouppolicy/policy_classifiers", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends PolicyClassifier> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpPolicyClassifier.PolicyClassifiers> policyclassifierInvocation = this.buildInvocation(filteringParams);
        return policyclassifierInvocation.execute().getList();
    }

    private BaseOpenStackService.Invocation<GbpPolicyClassifier.PolicyClassifiers> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpPolicyClassifier.PolicyClassifiers> policyclassifierInvocation = this.get(GbpPolicyClassifier.PolicyClassifiers.class, "/grouppolicy/policy_classifiers");
        if (filteringParams == null) {
            return policyclassifierInvocation;
        }
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                policyclassifierInvocation = policyclassifierInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return policyclassifierInvocation;
    }

    @Override
    public PolicyClassifier get(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.get(GbpPolicyClassifier.class, this.uri("/grouppolicy/policy_classifiers/%s", id)).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.deleteWithResponse(this.uri("/grouppolicy/policy_classifiers/%s", id)).execute();
    }

    @Override
    public PolicyClassifier create(PolicyClassifier policyClassifier) {
        return this.post(GbpPolicyClassifier.class, this.uri("/grouppolicy/policy_classifiers", new Object[0])).entity(policyClassifier).execute();
    }

    @Override
    public PolicyClassifier update(String policyClassifierId, PolicyClassifierUpdate policyClassifier) {
        Preconditions.checkNotNull((Object)policyClassifierId);
        Preconditions.checkNotNull((Object)policyClassifier);
        return this.put(GbpPolicyClassifier.class, this.uri("/grouppolicy/policy_classifiers/%s", policyClassifierId)).entity(policyClassifier).execute();
    }
}

