/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.xml.HybsXMLHandler;
import org.opengion.fukurou.xml.TagElement;
import org.opengion.fukurou.xml.TagElementListener;

public class HybsXMLSave
implements TagElementListener {
    private String tableName;
    private Connection connection;
    private PreparedStatement insPstmt;
    private PreparedStatement updPstmt;
    private ParameterMetaData insMeta;
    private ParameterMetaData updMeta;
    private int insCnt;
    private int updCnt;
    private int delCnt;
    private int ddlCnt;
    private Map<String, String> defaultMap;
    private Map<String, String> afterMap;
    private List<String> updClms;
    private String[] insClms;
    private String lastSQL;
    private final boolean useParamMetaData;
    private static final Pattern PATTERN = Pattern.compile("\\[\\w*\\]");
    private boolean isExecErr = true;
    private final StringBuilder errBuf = new StringBuilder();

    public HybsXMLSave(Connection connection) {
        this(connection, null);
    }

    public HybsXMLSave(Connection connection, String string) {
        this.connection = connection;
        this.tableName = string;
        this.useParamMetaData = HybsXMLSave.useParameterMetaData(this.connection);
    }

    public void onExecErrException(boolean bl) {
        this.isExecErr = bl;
    }

    @Override
    public void actionInit(TagElement tagElement) {
        String string = tagElement.get("tableName");
        if (string != null) {
            this.tableName = string;
        }
    }

    @Override
    public void actionRow(TagElement tagElement) {
        tagElement.setAfterMap(this.afterMap);
        Object[] objectArray = null;
        try {
            Object object;
            int n;
            int n2;
            int n3 = 0;
            if (this.updPstmt != null) {
                objectArray = tagElement.getValues(this.updClms);
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    if (objectArray[n2] != null && ((String)objectArray[n2]).isEmpty()) {
                        objectArray[n2] = null;
                    }
                    if (this.useParamMetaData) {
                        n = this.updMeta.getParameterType(n2 + 1);
                        object = objectArray[n2];
                        if (object == null || ((String)object).isEmpty()) {
                            this.updPstmt.setNull(n2 + 1, n);
                            continue;
                        }
                        this.updPstmt.setObject(n2 + 1, object, n);
                        continue;
                    }
                    this.updPstmt.setObject(n2 + 1, objectArray[n2]);
                }
                n3 = this.updPstmt.executeUpdate();
                if (n3 > 1) {
                    String string = "Update \u30ad\u30fc\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002TABLE=[" + this.tableName + "] ROW=[" + tagElement.getRowNo() + "]" + HybsConst.CR + " SQL=[" + this.lastSQL + "]" + HybsConst.CR + tagElement.toString() + HybsConst.CR + Arrays.toString(objectArray) + HybsConst.CR;
                    throw new OgRuntimeException(string);
                }
                this.updCnt += n3;
            }
            if (n3 == 0) {
                if (this.insPstmt == null) {
                    this.insClms = tagElement.getKeys();
                    this.lastSQL = this.insertSQL(this.insClms, this.tableName);
                    this.insPstmt = this.connection.prepareStatement(this.lastSQL);
                    if (this.useParamMetaData) {
                        this.insMeta = this.insPstmt.getParameterMetaData();
                    }
                }
                objectArray = tagElement.getValues(this.insClms);
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    if (objectArray[n2] != null && ((String)objectArray[n2]).isEmpty()) {
                        objectArray[n2] = null;
                    }
                    if (this.useParamMetaData) {
                        n = this.insMeta.getParameterType(n2 + 1);
                        object = objectArray[n2];
                        if (object == null || ((String)object).isEmpty()) {
                            this.insPstmt.setNull(n2 + 1, n);
                            continue;
                        }
                        this.insPstmt.setObject(n2 + 1, object, n);
                        continue;
                    }
                    this.insPstmt.setObject(n2 + 1, objectArray[n2]);
                }
                this.insCnt += this.insPstmt.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            String string = "DB\u767b\u9332\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002TABLE=[" + this.tableName + "] ROW=[" + tagElement.getRowNo() + "]" + HybsConst.CR + " SQL=[" + this.lastSQL + "]" + HybsConst.CR + tagElement.toString() + HybsConst.CR + Arrays.toString(objectArray) + HybsConst.CR + sQLException.getMessage() + ":" + sQLException.getSQLState() + HybsConst.CR;
            throw new OgRuntimeException(string, sQLException);
        }
    }

    @Override
    public void actionExecSQL(TagElement tagElement) {
        this.lastSQL = tagElement.getBody();
        try (Statement statement = this.connection.createStatement();){
            String[] stringArray;
            for (String string : stringArray = this.getExecSQLs(this.lastSQL)) {
                int n = statement.executeUpdate(string);
                String string2 = string.trim().toUpperCase(Locale.JAPAN);
                if (string2.startsWith("DELETE")) {
                    this.delCnt += n;
                    continue;
                }
                if (string2.startsWith("INSERT")) {
                    this.insCnt += n;
                    continue;
                }
                if (string2.startsWith("UPDATE")) {
                    this.updCnt += n;
                    continue;
                }
                ++this.ddlCnt;
            }
        }
        catch (SQLException sQLException) {
            String string = "DB\u767b\u9332\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002TABLE=[" + this.tableName + "] ROW=[" + tagElement.getRowNo() + "]" + HybsConst.CR + " SQL=[" + this.lastSQL + "]" + HybsConst.CR + tagElement.toString() + HybsConst.CR + sQLException.getMessage() + ":" + sQLException.getSQLState() + HybsConst.CR;
            if (this.isExecErr) {
                throw new OgRuntimeException(string, sQLException);
            }
            System.err.println(string);
            this.errBuf.append(string);
        }
    }

    private String[] getExecSQLs(String string) {
        if (string.contains("BEGIN") && string.contains("END")) {
            return new String[]{string};
        }
        return string.split(";");
    }

    @Override
    public void actionMergeSQL(TagElement tagElement) {
        if (this.updPstmt != null) {
            String string = "MERGE_SQL\u30bf\u30b0\u304c\u3001\u8907\u6570\u56de\u8a18\u8ff0\u3055\u308c\u3066\u3044\u307e\u3059\u3002TABLE=[" + this.tableName + "] ROW=[" + tagElement.getRowNo() + "]" + HybsConst.CR + " SQL=[" + this.lastSQL + "]" + HybsConst.CR + tagElement.toString() + HybsConst.CR;
            throw new OgRuntimeException(string);
        }
        String string = tagElement.getBody();
        Matcher matcher = PATTERN.matcher(string);
        this.updClms = new ArrayList<String>();
        while (matcher.find()) {
            this.updClms.add(string.substring(matcher.start() + 1, matcher.end() - 1));
        }
        this.lastSQL = matcher.replaceAll("?");
        try {
            this.updPstmt = this.connection.prepareStatement(this.lastSQL);
            if (this.useParamMetaData) {
                this.updMeta = this.updPstmt.getParameterMetaData();
            }
        }
        catch (SQLException sQLException) {
            String string2 = "Statement\u4f5c\u6210\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002TABLE=[" + this.tableName + "] ROW=[" + tagElement.getRowNo() + "]" + HybsConst.CR + " SQL=[" + this.lastSQL + "]" + HybsConst.CR + tagElement.toString() + HybsConst.CR + sQLException.getMessage() + ":" + sQLException.getSQLState() + HybsConst.CR;
            throw new OgRuntimeException(string2, sQLException);
        }
    }

    public void setDefaultMap(Map<String, String> map) {
        this.defaultMap = map;
    }

    public void setAfterMap(Map<String, String> map) {
        this.afterMap = map;
    }

    public void insertXML(Reader reader) {
        try {
            HybsXMLHandler hybsXMLHandler = new HybsXMLHandler();
            hybsXMLHandler.setTagElementListener(this);
            hybsXMLHandler.setDefaultMap(this.defaultMap);
            hybsXMLHandler.parse(reader);
        }
        finally {
            Closer.stmtClose(this.insPstmt);
            Closer.stmtClose(this.updPstmt);
            this.insPstmt = null;
            this.updPstmt = null;
            this.insMeta = null;
            this.updMeta = null;
        }
    }

    private String insertSQL(String[] stringArray, String string) {
        if (string == null) {
            String string2 = "tableName \u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + HybsConst.CR + "tableName \u306f\u3001\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u3067\u6307\u5b9a\u3059\u308b\u304b\u3001ROWSET\u306etableName\u5c5e\u6027\u3067\u6307\u5b9a\u3057\u3066\u304a\u304f\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059" + HybsConst.CR;
            throw new OgRuntimeException(string2);
        }
        StringBuilder stringBuilder = new StringBuilder(200).append("INSERT INTO ").append(string).append(" ( ").append(String.join((CharSequence)",", stringArray)).append(" ) VALUES ( ?");
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(",?");
        }
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }

    public int getInsertCount() {
        return this.insCnt;
    }

    public int getUpdateCount() {
        return this.updCnt;
    }

    public int getDeleteCount() {
        return this.delCnt;
    }

    public int getDDLCount() {
        return this.ddlCnt;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getErrorMessage() {
        return this.errBuf.toString();
    }

    private static boolean useParameterMetaData(Connection connection) {
        String string;
        try {
            string = connection.getMetaData().getDatabaseProductName().toLowerCase(Locale.JAPAN);
        }
        catch (SQLException sQLException) {
            string = "none";
        }
        return "PostgreSQL".equalsIgnoreCase(string);
    }

    public static void main(String[] stringArray) throws ClassNotFoundException, SQLException {
        int n;
        int n2;
        int n3;
        int n4;
        if (stringArray.length < 5) {
            LogWriter.log("Usage: java org.opengion.fukurou.xml.HybsXMLSave USER PASSWD URL TABLE FILE [ENCODE] [DRIVER]");
            LogWriter.log("   USER  : DB\u63a5\u7d9a\u30e6\u30fc\u30b6\u30fc(GE)");
            LogWriter.log("   PASSWD: DB\u63a5\u7d9a\u30d1\u30b9\u30ef\u30fc\u30c9(GE)");
            LogWriter.log("   URL   : DB\u63a5\u7d9aJDBC\u30c9\u30e9\u30a4\u30d0URL(jdbc:oracle:thin:@localhost:1521:HYBS)");
            LogWriter.log("   TABLE : \u767b\u9332\u3059\u308b\u30c6\u30fc\u30d6\u30ebID(GE21)");
            LogWriter.log("   FILE  : \u767b\u9332\u3059\u308bORACLE XDK \u5f62\u5f0f XML\u30d5\u30a1\u30a4\u30eb(GE21.xml)");
            LogWriter.log(" [ ENCODE: \u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9 \u521d\u671f\u5024:UTF-8 ]");
            LogWriter.log(" [ DRIVER: JDBC\u30c9\u30e9\u30a4\u30d0\u30fc \u521d\u671f\u5024:oracle.jdbc.OracleDriver ]");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        String string6 = stringArray.length == 6 ? stringArray[5] : "UTF-8";
        String string7 = stringArray.length == 7 ? stringArray[6] : "oracle.jdbc.OracleDriver";
        Class.forName(string7);
        try (Connection connection = DriverManager.getConnection(string3, string, string2);){
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
            HybsXMLSave hybsXMLSave = new HybsXMLSave(connection, string4);
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string5), string6));){
                hybsXMLSave.insertXML(bufferedReader);
                n4 = hybsXMLSave.getInsertCount();
                n3 = hybsXMLSave.getUpdateCount();
                n2 = hybsXMLSave.getDeleteCount();
                n = hybsXMLSave.getDDLCount();
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string8 = "\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" + fileNotFoundException.getMessage() + HybsConst.CR + "Table=[" + string4 + "] File =[" + string5 + "]";
                throw new OgRuntimeException(string8, fileNotFoundException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string9 = "\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" + unsupportedEncodingException.getMessage() + HybsConst.CR + "Table=[" + string4 + "] Encode =[" + string6 + "]";
                throw new OgRuntimeException(string9, unsupportedEncodingException);
            }
            catch (IOException iOException) {
                String string10 = "\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + iOException.getMessage() + HybsConst.CR + "Table=[" + string4 + "] File =[" + string5 + "]";
                throw new OgRuntimeException(string10, iOException);
            }
            Closer.commit(connection);
        }
        System.out.println("XML File[" + string5 + "] Into [" + string4 + "] Table");
        System.out.println("   Insert Count : [" + n4 + "]");
        System.out.println("   Update Count : [" + n3 + "]");
        System.out.println("   Delete Count : [" + n2 + "]");
        System.out.println("   DDL    Count : [" + n + "]");
    }
}

