/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.servlet;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebInitParam;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

@WebServlet(urlPatterns={"/jsp/imageSave"}, initParams={@WebInitParam(name="saveDir", value="jsp/snapshot/")})
public class ImageSave
extends HttpServlet {
    private static final long serialVersionUID = 742120210521L;
    private static final DateTimeFormatter YMDH = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    private String saveDir = "jsp/snapshot/";
    private boolean isDebug;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.saveDir = StringUtil.nval((String)servletConfig.getInitParameter("saveDir"), (String)this.saveDir);
        this.isDebug = Boolean.parseBoolean(servletConfig.getInitParameter("debug"));
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("debug");
        boolean bl = StringUtil.isNull((CharSequence[])new CharSequence[]{string}) ? this.isDebug : Boolean.parseBoolean(string);
        String string2 = httpServletRequest.getParameter("img");
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{string2})) {
            Object object;
            Object object2;
            string2 = string2.replace(' ', '+');
            String string3 = HybsSystem.url2dir(StringUtil.nval((String)httpServletRequest.getParameter("dir"), (String)this.saveDir));
            if (bl) {
                System.out.println("dir=" + string3);
            }
            if (StringUtil.isNull((CharSequence[])new CharSequence[]{object2 = httpServletRequest.getParameter("file")})) {
                object = LocalDateTime.now();
                object2 = ((LocalDateTime)object).format(YMDH) + ".png";
            }
            if (bl) {
                System.out.println("file=" + (String)object2);
            }
            object = Base64.getDecoder().decode(string2);
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);){
                BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
                File file = new File(string3, (String)object2);
                File file2 = file.getParentFile();
                if (file2 != null && !file2.exists() && !file2.mkdirs()) {
                    String string4 = "\u51fa\u529b\u5148\uff8c\uff6b\uff99\uff80\uff9e\u304c\u751f\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + file2;
                    throw new HybsSystemException(string4);
                }
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                if (bl) {
                    System.out.println("output=" + file.getAbsolutePath());
                }
            }
            catch (Throwable throwable) {
                throw new HybsSystemException("Base64 \u30c7\u30b3\u30fc\u30c9\u51e6\u7406\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002", throwable);
            }
        }
    }
}

