/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.column;

import java.text.DecimalFormat;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

public class Renderer_DECIMAL
extends AbstractRenderer {
    private static final String VERSION = "6.8.3.1 (2017/12/01)";
    private final DecimalFormat format;
    private final String defValue;
    private final String noDisplayVal;
    private static final CellRenderer DB_CELL = new Renderer_DECIMAL();

    public Renderer_DECIMAL() {
        this.format = new DecimalFormat("#,##0.#");
        this.defValue = "";
        this.noDisplayVal = null;
    }

    private Renderer_DECIMAL(DBColumn dBColumn) {
        String string = dBColumn.getRendererParam();
        if (string == null || string.isEmpty() || string.equals("_")) {
            string = "#,##0.#";
        }
        this.format = new DecimalFormat(string);
        String string2 = dBColumn.getDefault();
        if (string2 == null || string2.isEmpty()) {
            this.defValue = "";
        } else {
            double d = StringUtil.parseDouble((String)string2);
            this.defValue = this.format.format(d);
        }
        this.noDisplayVal = dBColumn.getNoDisplayVal();
    }

    public CellRenderer newInstance(DBColumn dBColumn) {
        String string = dBColumn.getRendererParam();
        String string2 = dBColumn.getDefault();
        if ((string == null || string.isEmpty() || string.equals("_")) && (string2 == null || string2.isEmpty() || string2.equals("_"))) {
            return DB_CELL;
        }
        return new Renderer_DECIMAL(dBColumn);
    }

    public String getValue(String string) {
        return this.getValue(string, true);
    }

    public String getWriteValue(String string) {
        return this.getValue(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getValue(String string, boolean bl) {
        String string2;
        if (this.noDisplayVal != null && this.noDisplayVal.equalsIgnoreCase(string)) {
            return "";
        }
        if (string == null || string.trim().isEmpty() || "0".equals(string)) {
            return this.defValue;
        }
        double d = StringUtil.parseDouble((String)string);
        DecimalFormat decimalFormat = this.format;
        synchronized (decimalFormat) {
            string2 = this.format.format(d);
        }
        return bl && d < 0.0 ? "<span class=\"minus\">" + string2 + "</span>" : string2;
    }

    public String getValue(int n, String string, String string2) {
        if (this.noDisplayVal != null && this.noDisplayVal.equalsIgnoreCase(string)) {
            return "";
        }
        if (string == null || string.trim().isEmpty() || "0".equals(string)) {
            return this.defValue;
        }
        double d = StringUtil.parseDouble((String)string);
        String string3 = string2;
        if (string3 == null || string3.isEmpty() || string3.equals("_")) {
            string3 = "#,##0.#";
        }
        DecimalFormat decimalFormat = new DecimalFormat(string3);
        String string4 = decimalFormat.format(d);
        return d < 0.0 ? "<span class=\"minus\">" + string4 + "</span>" : string4;
    }
}

