/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Locale;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class ErrorMessageTag
extends CommonTagSupport {
    private static final String VERSION = "7.0.7.0 (2019/12/13)";
    private static final long serialVersionUID = 707020191213L;
    public static final String CMD_NEW = "NEW";
    public static final String CMD_RENEW = "RENEW";
    public static final String CMD_RESET = "RESET";
    public static final String CMD_REVIEW = "REVIEW";
    private static final String ERR_MSG_ID = "h_errMsg";
    private static final String CMN_MSG_ID = "h_cmnMsg";
    private final String errMsgFile = HybsSystem.sys("ERR_MSG_FILENAME");
    private final int maxRowCount = HybsSystem.sysInt("DB_MAX_ROW_COUNT");
    private transient ErrorMessage errMessage;
    private String command;
    private boolean msgClear;
    private String viewType = "TITLE";
    private String displayMsg = "MSG0059";
    private String warningMsg = "ERR0020";
    private boolean useSLabel;

    @Override
    public int doStartTag() {
        if (this.msgClear || CMD_NEW.equals(this.command) || CMD_RESET.equals(this.command)) {
            this.removeSessionAttribute(ERR_MSG_ID);
            this.msgClear = true;
        } else {
            this.errMessage = (ErrorMessage)this.getSessionAttribute(ERR_MSG_ID);
            if (this.errMessage == null) {
                this.msgClear = true;
            }
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        Object object = null;
        if (this.errMessage == null) {
            if ((CMD_REVIEW.equals(this.command) || CMD_RENEW.equals(this.command)) && (object = this.getResource().getLabel(this.displayMsg, new String[0])) != null && ((String)object).length() > 0) {
                object = (String)object + BR;
            }
        } else if ("TITLE".equalsIgnoreCase(this.viewType)) {
            object = this.makeTitle();
        } else if ("BODY".equalsIgnoreCase(this.viewType)) {
            object = TaglibUtil.makeHTMLErrorTable(this.errMessage, this.getResource(), this.useSLabel);
        } else {
            String string = "viewType\u5c5e\u6027\u306b TITLE/BODY \u4ee5\u5916\u306e\u9805\u76ee\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002[" + this.viewType + "]";
            throw new HybsSystemException(string);
        }
        String string = (String)this.getContextAttribute(CMN_MSG_ID);
        this.jspPrint("<span class=\"errmsg\">");
        if (object != null && ((String)object).length() > 0) {
            this.jspPrint((String)object);
        }
        if (string != null && string.length() > 0) {
            this.jspPrint(string);
        }
        this.jspPrint("</span>");
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.command = null;
        this.errMessage = null;
        this.msgClear = false;
        this.viewType = "TITLE";
        this.displayMsg = "MSG0059";
        this.warningMsg = "ERR0020";
        this.useSLabel = false;
    }

    private String makeTitle() {
        String string = this.getContextPath() + "/" + this.errMsgFile;
        String string2 = this.warningMsg == null ? "<span class=\"msg_error\">" + this.errMessage.getTitle() + "</span>" + BR : "<span class=\"msg_warning\">" + this.getResource().getLabel(this.warningMsg, new String[0]) + "</span>" + BR;
        String string3 = String.valueOf(this.maxRowCount);
        String string4 = XHTMLTag.urlEncode((String)"pageSize", (String)string3);
        return XHTMLTag.link((Attributes)new Attributes().set("href", string).set("target", "_blank").set("body", string2), (String)string4);
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setClear(String string) {
        this.msgClear = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.msgClear);
    }

    public void setViewType(String string) {
        this.viewType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.viewType);
    }

    public void setDisplayMsg(String string) {
        this.displayMsg = StringUtil.nval((String)this.getRequestParameter(string), (String)this.displayMsg);
    }

    public void setWarningMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.warningMsg = string2;
        }
    }

    public void setUseSLabel(String string) {
        this.useSLabel = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useSLabel);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("errMsgFile", (Object)this.errMsgFile).println("maxRowCount", (Object)this.maxRowCount).println("command", (Object)this.command).println("msgClear", (Object)this.msgClear).println("viewType", (Object)this.viewType).println("displayMsg", (Object)this.displayMsg).println("warningMsg", (Object)this.warningMsg).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

