/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import org.opengion.fukurou.fileexec.XLogger;

public final class MsgUtil {
    private static final XLogger LOGGER = XLogger.getLogger(MsgUtil.class.getSimpleName());
    public static final String OMIT_BASE = "org.opengion.fukurou";
    private static final int BUFFER_MIDDLE = 200;
    private static final int STACKTRACE_COUNT = 5;
    private static final String CR_TAB = "\n\tat ";
    private static final ResourceBundle PARENT = ResourceBundle.getBundle("org.opengion.fukurou.message", Locale.getDefault());
    private static ResourceBundle resource;
    private static String omitName;

    private MsgUtil() {
    }

    public static void setResourceKey(String string) {
        omitName = string;
        resource = ResourceBundle.getBundle(omitName + ".message", Locale.getDefault());
    }

    public static String getMsg(String string, Object ... objectArray) {
        try {
            StringBuilder stringBuilder = new StringBuilder(200).append(string).append(':');
            if (resource != null && resource.containsKey(string)) {
                stringBuilder.append(MessageFormat.format(resource.getString(string), objectArray));
            } else if (PARENT.containsKey(string)) {
                stringBuilder.append(MessageFormat.format(PARENT.getString(string), objectArray));
            } else {
                stringBuilder.append(Arrays.toString(objectArray));
            }
            return stringBuilder.toString();
        }
        catch (RuntimeException runtimeException) {
            String string2 = string + "[" + Arrays.toString(objectArray) + "]";
            LOGGER.warning(runtimeException, () -> "\u3010WARNING\u3011 " + string2);
            return string2;
        }
    }

    public static RuntimeException throwException(String string, Object ... objectArray) {
        return MsgUtil.throwException(null, string, objectArray);
    }

    public static RuntimeException throwException(Throwable throwable, String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder(200).append(MsgUtil.getMsg(string, objectArray));
        if (throwable != null) {
            stringBuilder.append("\n\t").append(throwable.getMessage());
        }
        String string2 = stringBuilder.toString();
        RuntimeException runtimeException = new RuntimeException(string2, throwable);
        LOGGER.warning(runtimeException, () -> "\u3010WARNING\u3011 " + string2);
        return runtimeException;
    }

    public static String errPrintln(String string, Object ... objectArray) {
        return MsgUtil.errPrintln(null, string, objectArray);
    }

    public static String errPrintln(Throwable throwable, String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder(200).append(MsgUtil.getMsg(string, objectArray));
        if (throwable != null) {
            stringBuilder.append("\n\t").append(throwable.getMessage());
            int n = 0;
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string2 = stackTraceElement.getClassName();
                if (string2.contains("MsgUtil") || !string2.contains(OMIT_BASE) && !string2.contains(omitName) && n >= 5) continue;
                String string3 = stackTraceElement.toString();
                if (stringBuilder.indexOf(string3) < 0) {
                    stringBuilder.append(CR_TAB).append(string3);
                } else {
                    stringBuilder.append(CR_TAB).append("\u2026\u2026\u2026");
                }
                ++n;
            }
        }
        LOGGER.warning(() -> "\u3010WARNING\u3011 " + stringBuilder.toString());
        return stringBuilder.toString();
    }

    static {
        omitName = "DummyName";
    }
}

