<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useAjaxSubmit="true" adjustEvent="Gantt" useTbodyMovable="true" />	<!-- ガント処理、上下移動 -->
 <!--<link rel="stylesheet" href="/gf/jsp/common/option/ganttIE.css />-->
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7216"
	title	= "特殊ガント"
	date	= "2012/08/17"
	author	= "S.Li"
	text	= "システム、プログラムＩＤ、処理名、作成日、作成者を修正して下さい。"
	version	= "001">
	adjustGantTable.jsを利用したガント表示です。
	ガントの表示処理をクライアント側で行います。
</og:comment>

<!-- ﾃﾞｰﾀが選ばれていなければｴﾗｰ -->
<og:columnCheck command="{@command}">
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- entryﾀｸﾞのcommandとcolumnSetのｺﾏﾝﾄﾞが同じ場合のみ､動作します｡ -->
<og:entry command="{@command}" />

<og:view
	viewFormType	= "HTMLCustomTable"
	command			= "{@command}"
	useScrollBar	= "false"
	noWritable		= "{@noWritable}"
	columnWritable	= "{@columnWritable}"
	>
	<og:thead rowspan="2">
		<tr>
			<td>[NOORDER]</td>
			<td>[SUORDER]</td>
			<td>[DYORDER]</td>
			<td rowspan="2" class="gantt zoom{@VZOOM}" style="line-height:normal;text-align:left;background-image: url('{@SYS.JSP_IMG}/ganttBG{@VZOOM}.gif');" >
				<div style="position:relative;left:0px;z-index:101; " height="100%" width="100%" >
					<og:ganttHeader
						startDate		= "{@startDate}"
						endDate			= "{@endDate}"
						zoom			= "{@VZOOM}"
						daySpan 		= "{@daySpan}"
						calDB			= "GF13"
						arg1			= "A"
						breakTimes		= "{@breakTimes}"
						breakTimeStyle	= "top:45px; background-color:gray;"
						baseTimes		= "{@baseTimes}"
						baseTimeStyle	= "top:45px; background-color:transparent; border-left:2px dashed red;"
						skipHoliday		= "{@skipHoliday}"
						useMultiClm		= "{@useMultiClm}"
					/>
				</div>
			</td>
		</tr>
		<tr>
			<td colspan="2">[PN]</td>
			<td>[DYNOKI]</td>
		</tr>
	</og:thead>
	<og:tbody rowspan="2" >
		<tr>
			<td>[NOORDER]</td>
			<td>[SUORDER]</td>
			<td>[DYORDER]</td>
			<td rowspan="2" class="gantt zoom{@VZOOM}" style="text-align:left;background-image: url('{@SYS.JSP_IMG}/ganttBG{@VZOOM}.gif');" >
				<og:iGanttBar type="1" id="A_[I]" colorNo="[COLOR]" start="[!DYORDER]" end="[!DYNOKI]" startDateInput="DYORDER__[I]" endDateInput="DYNOKI__[I]" text="[PN]" />
			</td>
		</tr>
		<tr>
			<td colspan="2">[PN]</td>
			<td>[DYNOKI]</td>
		</tr>
	</og:tbody>
</og:view>

<og:iGantt
	margeRows	= "{@MARGEROWS}"
	fixedCols	= "6"
/>

<!-- マウスでの上下移動。スクリプトが複数個のテーブルを作成するので若干工夫が必要
<span class="tbodyMovable" seqclm="DYORDER" noMove="disMovable" noDrag="disDragable" adjustSeq="DYORDER" sync="fixBodyDiv" />
 -->

<og:tbodyMovable seqclm="DYORDER" noMove="disMovable" noDrag="disDragable" adjustSeq="DYORDER" sync="fixBodyDiv" />


<!-- ガント描画の利用方法
	【属性説明】
		type		: ガント要素のタイプ（0:マイルストーン 1:バー ）
		color		: バーの色（マイルストーンの場合は不要）
		src			: マイルストーンのアイコン画像(URIより設定)
		start		: 開始日(YYYYMMDD)、または開始時間(YYYYMMDDHH24MM)
		end			: 終了日(YYYYMMDD)、または終了時間(YYYYMMDDHH24MM)（マイルストーンの場合は不要）
		text		: ガント要素の注釈メッセージ
	【使用例１：バー】
		<og:iGanttBar
			type		= "1"
			color		= "[COLOR]"
			start		= "[DYORDER]"
			end			= "[DYNOKI]"
			text		= "[PN]"
		/>
	【使用例２：バー】
		<og:iGanttBar
			type		= "0"
			src			= "{@SYS.JSP_IMG}/dia_red.gif"
			start		= "[DYORDER]"
			text		= "[PN]"
		/>
-->
<!--ガント全体の属性設定（必須）
	【属性説明】
		margeRows		: 複数行のマージ、前後の行データが一致している場合はマージする。
		fixedCols		: 左の固定列の列数（テーブル２分割機能）
		viewNumberType	: viewタグの出力に番号列が出力されるか(出力されていない場合:delete)
	【使用例】
		<og:iGantt
			margeRows	= "{@MARGEROWS}"
			fixedCols	= "6"
		/>
-->
<!--ガントのマウスによる上下移動
	【属性説明】
		class			: "tbodyMovable" 固定
		seqclm			: シーケンスカラム名(先頭名称で判断:初期値SEQ)
		noMove			: 入替対象でない(入替範囲限定など)カラムをカンマ区切りで指定
		noDrag			: マウスでドラッグできないTOBODYはclassをnoDrag属性でカンマ区切りで指定
		adjustSeq		: 上下移動時に、このカラムの値を、+1,-1 する。カンマ区切りで複数指定可能
		sync			: 複数のtableの移動を同期させる場合には同様にsync属性でクラス/IDを指定
	【使用例】
		<span
			class		= "tbodyMovable"
			seqclm		= "DYORDER"
			noMove		= "disMovable"
			noDrag		= "disDragable"
			adjustSeq	= "DYORDER"
			sync		= "fixBodyDiv"
		/>
-->
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
