/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.common;

import jakarta.servlet.http.HttpSession ;
import jakarta.servlet.http.HttpSessionListener;
import jakarta.servlet.http.HttpSessionEvent;

import jakarta.servlet.annotation.WebListener;				// 6.3.4.0 (2015/08/01)

/**
 * HttpSessionListener を実装した、セッション状態の監視リスナークラスです。
 * これは、セッションの作成/破棄を監視できます。
 * このリスナーは、WEB-INF/web.xml で、組み込みます。
 *
 * 【WEB-INF/web.xml】
 *
 *  &lt;listener&gt;
 *      &lt;listener-class&gt;
 *          org.opengion.hayabusa.common.HybsSessionListener
 *      &lt;/listener-class&gt;
 *  &lt;/listener&gt;
 *
 * @og.group ログイン制御
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
@WebListener
public class HybsSessionListener implements HttpSessionListener {

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public HybsSessionListener() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 *  HttpSessionListener インターフェースの実装
	 *
	 * セッションが作成されたときにリスナーに通知される。
	 * 現段階では、なにもしない。
	 *
	 * @param event セッションイベント
	 */
	@Override
	public void sessionCreated( final HttpSessionEvent event ) {
	// taglib\HeadTag.java に移動
	//	HttpSession session = event.getSession();
	//	SystemManager.addSession( session );
	}

	/**
	 *  HttpSessionListener インターフェースの実装
	 *
	 * セッションが破棄されたときにリスナーに通知される。
	 *
	 * @og.rev 5.5.9.1 (2012/12/07) SystemManager に渡すのは、sessionID ではなく、session オブジェクトとする。
	 *
	 * @param event セッションイベント
	 */
	@Override
	public void sessionDestroyed( final HttpSessionEvent event ) {
		final HttpSession session = event.getSession();
		SystemManager.removeSession( session );		// 5.5.9.1 (2012/12/07)
	}
}
