<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン標準"
	pgid	= "23_FAQRGST"
	title	= "標準(FAQ登録)"
	date	= "2015/10/09"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck command = "{@command}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" dbid="RESOURCE">
	<!-- DB登録時に使用する USRSET カラムを、DBTableModel に設定しておきます。-->
		SELECT	 SEQNO													<!-- 表示順 -->
				,CDBNRUI												<!-- 分類名 -->
				,TITLE													<!-- ﾀｲﾄﾙ -->
				,{@DBF.SUBSTR}(NAIYO,1,100)	GAIYO1						<!-- 概要-->
				,NAIYO													<!-- 内容 -->
				,KNRNGUI												<!-- 関連画面ID -->
				,KBFAQ													<!-- FAQ区分-->
				,SYSTEM_ID												<!-- ｼｽﾃﾑID -->
				,SYSCODE												<!-- ｼｽﾃﾑｺｰﾄﾞ -->
				,FGJ													<!-- 状況 -->
				,UNIQ													<!-- (非表示)ﾕﾆｰｸ -->
				,QANO													<!-- (非表示)質問番号-->
				, '' FILEPATH												<!-- (非表示)ﾌｧｲﾙﾊﾟｽ-->
				, '' FILE1													<!-- (非表示)ﾌｧｲﾙ1-->
				, '' FILE2													<!-- (非表示)ﾌｧｲﾙ2-->
				, '' FILE3													<!-- (非表示)ﾌｧｲﾙ3-->
		FROM	GE80
		WHERE	SYSTEM_ID	IN	('{@SYSTEM_ID}','{@AST}')
		AND		KBFAQ		=	'0'										<!-- GE80》FAQ区分	0:回答	-->
	<og:where startKey="and">
			<og:and value = "FGJ		IN	('0','1')"		/>	<!-- GE80》状態ﾌﾗｸﾞ IN ('0','1')-->
			<og:and value = "SYSCODE	=	'{@SYSCODE}'"	/>	<!-- GE80》ｼｽﾃﾑｺｰﾄﾞ	= 画面》ｼｽﾃﾑｺｰﾄﾞ-->
			<og:and value = "CDBNRUI	like '{@CDBNRUI}%'"	/>
			<og:and value = "QANO		like '{@QANO}'"	/>
			<og:and value = "KNRNGUI	like '{@KNRNGUI}'"	/>
			<og:and value = "(TITLE		LIKE '{@KEYWORD}'	OR
							  NAIYO		LIKE '{@KEYWORD}'	OR
							  TAG		LIKE '{@KEYWORD}')"	/>	<!-- GE81》ﾀｲﾄﾙ､内容､ﾀｸﾞｷｰﾜｰﾄﾞ LIKE %画面》ｷｰﾜｰﾄﾞ%-->
	</og:where>
	<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,SYSCODE,SEQNO" />				<!-- 表示順	-->
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:columnEditor columns="SYSTEM_ID" defaultVal="{@LAST.SYSTEM_ID}" must="true" />
<og:columnEditor columns="SYSCODE,TITLE,CDBNRUI" must="true" />
<og:columnEditor columns="CDBNRUI" renderer="DBMENU" editor="DBMENU"
			param="select CDBNRUI,TITLE from GE80
					WHERE KBFAQ != '0'
					AND   FGJ IN ('0','1')
					AND   SYSTEM_ID='{@SYSTEM_ID}'
					AND ( SYSCODE = '{@SYSCODE}' OR SYSCODE='*' )
					ORDER BY SEQNO"
/>
<og:columnEditor columns="KBFAQ" codeList="0" />

<!-- KBFAQ="1"(分類) の場合、内容と関連画面IDは表示しない。-->
<og:value key="KBFAQ_1" value="NAIYO,KNRNGUI" caseKey="{@KBFAQ}" caseVal="1" />

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT">

	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<!-- ここでは、すべてを、update.jsp に転送している為、command属性を設定しています。-->
	<og:writeCheck>
		<og:submit  action="COPY"	value="update0" noWritable="null" />
		<og:submit  action="MODIFY"	value="update0" noWritable="SYSTEM_ID,SYSCODE,KBFAQ"  />
		<og:submit  action="DELETE"	value="update0" columnWritable="null" />
	<br />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<og:view
		viewFormType = "HTMLTable"
		command		 = "{@command}"
		selectedType = "radio"
		noDisplay	 = "FGJ,NAIYO,FILE1,FILE2,FILE3,FILEPATH,UNIQ,QANO,KBFAQ"
		checked		 = "{@checked}"
		startNo		 = "{@startNo}"
		pageSize	 = "{@pageSize}"
	/>

	<og:hidden name="KBFAQ" value="0" />
	<og:hidden name="noDisplay" value="UNIQ,QANO,KBFAQ" />

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
