/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.DateSet;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.xml.HybsErrorListener;
import org.opengion.fukurou.xml.JspIncludeReader;

public class XSLT {
    public static final String ENCODE = "UTF-8";
    private Transformer transformer;
    private String encode = "UTF-8";
    private String xmlFile;
    private String xslFile;
    private String outFile;
    private Reader xslReader;
    private Writer outWriter;
    private HybsEntry[] paramEntry;
    private boolean isFileInfo;
    private boolean isErrClose = true;
    private boolean isErrXmlIn;
    private boolean isInclude = true;
    private StreamResult result;
    private String realPath;
    private String debugMsg;

    public void setXslFile(String string) {
        this.xslFile = string;
        this.setXslFile(FileUtil.getBufferedReader(new File(this.xslFile), this.encode));
    }

    public void setXslFile(Reader reader) {
        this.transformer = null;
        this.xslReader = reader;
    }

    public void setOutFile(String string, boolean bl) {
        this.outFile = string;
        this.setOutFile(FileUtil.getPrintWriter(new File(this.outFile), this.encode, bl));
    }

    public void setOutFile(Writer writer) {
        Closer.ioClose(this.outWriter);
        this.outWriter = writer;
        this.result = new StreamResult(this.outWriter);
    }

    public void setOutData(String string) {
        if (string != null && string.length() > 0) {
            if (this.outWriter == null) {
                String string2 = "#setOutFile(Writer)\u3092\u5148\u306b\u5b9f\u884c\u3057\u3066\u304a\u3044\u3066\u304f\u3060\u3055\u3044\u3002" + HybsConst.CR + "   outData =" + string + HybsConst.CR;
                throw new OgRuntimeException(string2);
            }
            try {
                this.outWriter.write(string);
                this.outWriter.write(HybsConst.CR);
            }
            catch (IOException iOException) {
                String string3 = "\u30e9\u30a4\u30bf\u30fc\u306b\u30c7\u30fc\u30bf\u767b\u9332\u3092\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + iOException.getMessage();
                this.close();
                throw new OgRuntimeException(string3, iOException);
            }
        }
    }

    public void transform(String string) {
        this.xmlFile = string;
        if (this.xmlFile.endsWith(".jsp") && this.isInclude) {
            JspIncludeReader jspIncludeReader = new JspIncludeReader();
            jspIncludeReader.setRealPath(this.realPath);
            this.debugMsg = jspIncludeReader.getIncludeFiles();
            String string2 = jspIncludeReader.getString(new File(this.xmlFile), this.encode);
            this.transform(new StringReader(string2));
        } else {
            this.transform(FileUtil.getBufferedReader(new File(this.xmlFile), this.encode));
        }
    }

    public void transform(Reader reader) {
        HybsEntry[] hybsEntryArray = null;
        HybsErrorListener hybsErrorListener = new HybsErrorListener();
        try {
            if (this.transformer == null) {
                this.init(hybsErrorListener);
            } else {
                this.transformer.reset();
                this.transformer.setErrorListener(hybsErrorListener);
            }
            if (this.isFileInfo && this.xmlFile != null) {
                hybsEntryArray = this.getXmlParameter(this.xmlFile);
                this.parameterSet(this.transformer, hybsEntryArray);
            }
            this.xmlFile = null;
            StreamSource streamSource = new StreamSource(reader);
            this.transformer.transform(streamSource, this.result);
        }
        catch (TransformerException transformerException) {
            String string = ((Object)hybsErrorListener).toString();
            StringBuilder stringBuilder = new StringBuilder(200).append("=====================================================").append(HybsConst.CR).append("XML-XSLT \u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002").append(HybsConst.CR).append(string);
            if (this.debugMsg != null && this.debugMsg.length() > 0) {
                stringBuilder.append(HybsConst.CR).append(this.debugMsg);
            }
            if (string.indexOf("\u30d7\u30ed\u30ed\u30fc\u30b0\u306b\u306f\u30b3\u30f3\u30c6\u30f3\u30c4\u3092\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093") >= 0) {
                stringBuilder.append(HybsConst.CR).append("\t(UTF-8\u5909\u63db\u6642\u306b\u3001BOM\u304c\u4ed8\u304f\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u51fa\u307e\u3059\u3002BOM\u3092\u5916\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002)");
            }
            if (string.indexOf("\u3067\u7d42\u4e86\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059") >= 0) {
                stringBuilder.append(HybsConst.CR).append("\t(\u4e0d\u6574\u5408\u306f\u3001include\u30d5\u30a1\u30a4\u30eb\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002)");
            }
            stringBuilder.append(HybsConst.CR);
            if (this.isErrXmlIn) {
                this.setOutData(this.toXmlRow(hybsEntryArray, transformerException));
            }
            if (this.isErrClose) {
                this.close();
            }
            throw new OgRuntimeException(stringBuilder.toString(), transformerException);
        }
        finally {
            Closer.ioClose(reader);
        }
    }

    public void setParamEntry(HybsEntry ... hybsEntryArray) {
        if (hybsEntryArray != null && hybsEntryArray.length > 0) {
            this.paramEntry = new HybsEntry[hybsEntryArray.length];
            System.arraycopy(hybsEntryArray, 0, this.paramEntry, 0, hybsEntryArray.length);
        }
    }

    public void errClose(boolean bl) {
        this.isErrClose = bl;
    }

    public void useErrXmlIn(boolean bl) {
        this.isErrXmlIn = bl;
    }

    public void jspInclude(boolean bl) {
        this.isInclude = bl;
    }

    public void setRealPath(String string) {
        this.realPath = string;
    }

    public void close() {
        Closer.ioClose(this.outWriter);
        JspIncludeReader.cacheClear();
    }

    private void init(ErrorListener errorListener) {
        try {
            StreamSource streamSource = new StreamSource(this.xslReader);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setErrorListener(errorListener);
            this.transformer = transformerFactory.newTransformer(streamSource);
            this.transformer.setErrorListener(errorListener);
            this.parameterSet(this.transformer, this.paramEntry);
            JspIncludeReader.cacheClear();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            String string = this.xslFile + "\u30d5\u30a1\u30a4\u30eb\u306e XSLT \u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + errorListener.toString();
            throw new OgRuntimeException(string, transformerConfigurationException);
        }
        finally {
            Closer.ioClose(this.xslReader);
            this.xslReader = null;
        }
    }

    public void useFileInfo(boolean bl) {
        this.isFileInfo = bl;
    }

    public void useEncode(String string) {
        this.encode = string;
    }

    private HybsEntry[] getXmlParameter(String string) {
        HybsEntry[] hybsEntryArray = new HybsEntry[4];
        hybsEntryArray[0] = new HybsEntry("FILEPATH", string);
        File file = new File(string);
        hybsEntryArray[1] = new HybsEntry("FILENAME", file.getName());
        File file2 = file.getParentFile();
        hybsEntryArray[2] = file2 == null ? new HybsEntry("ADDRESS", "") : new HybsEntry("ADDRESS", file2.getName());
        String string2 = DateSet.getDate(file.lastModified(), "yyyyMMddHHmmss");
        hybsEntryArray[3] = new HybsEntry("MODIFIED", string2);
        return hybsEntryArray;
    }

    private void parameterSet(Transformer transformer, HybsEntry ... hybsEntryArray) {
        if (hybsEntryArray != null && hybsEntryArray.length > 0) {
            int n = hybsEntryArray.length;
            for (int i = 0; i < n; ++i) {
                String string = hybsEntryArray[i].getKey();
                String string2 = hybsEntryArray[i].getValue();
                transformer.setParameter(string, string2);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append("XSL File:").append(this.xslFile).append(HybsConst.CR).append("XML File:").append(this.xmlFile).append(HybsConst.CR).append("OUT File:").append(this.outFile).append(HybsConst.CR);
        return stringBuilder.toString();
    }

    private String toXmlRow(HybsEntry[] hybsEntryArray, TransformerException transformerException) {
        String string;
        String string2;
        int n;
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<ROW>").append(HybsConst.CR);
        if (this.paramEntry != null) {
            for (n = 0; n < this.paramEntry.length; ++n) {
                string2 = this.paramEntry[n].getKey();
                string = this.paramEntry[n].getValue();
                stringBuilder.append("  <").append(string2).append('>').append(string).append("</").append(string2).append('>').append(HybsConst.CR);
            }
        }
        if (hybsEntryArray != null) {
            for (n = 0; n < hybsEntryArray.length; ++n) {
                string2 = hybsEntryArray[n].getKey();
                string = hybsEntryArray[n].getValue();
                stringBuilder.append("  <").append(string2).append('>').append(string).append("</").append(string2).append('>').append(HybsConst.CR);
            }
        }
        stringBuilder.append("  <TAGNAME />").append(HybsConst.CR).append("  <MSGCD>XML_ERROR</MSGCD>").append(HybsConst.CR).append("  <MSGTXT>XML-XSLT \u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002</MSGTXT>").append(HybsConst.CR);
        String string3 = StringUtil.htmlFilter(transformerException.getMessage());
        int n2 = string3.lastIndexOf("Exception:");
        if (n2 >= 0) {
            string3 = string3.substring(n2 + "Exception:".length());
        }
        stringBuilder.append("  <TEXT_DATA>").append(string3).append(HybsConst.CR).append(" Location:").append(transformerException.getLocationAsString()).append(HybsConst.CR).append("</TEXT_DATA>").append(HybsConst.CR).append("</ROW>").append(HybsConst.CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 3) {
            LogWriter.log("Usage: java org.opengion.fukurou.xml.XSLT in_xml in_xsl out_xml");
            LogWriter.log("  XML \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306b\u3001XSL \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u3092\u9069\u7528\u3057\u3066\u3001");
            LogWriter.log("  XSLT\u5909\u63db\u3092\u884c\u3044\u307e\u3059\u3002");
            LogWriter.log("  \u7d50\u679c\u306f\u3001XML \u30d5\u30a1\u30a4\u30eb\u306b\u30bb\u30fc\u30d6\u3057\u307e\u3059\u3002");
            LogWriter.log("  out_xml \u306b System.out \u3092\u6307\u5b9a\u3059\u308b\u3068\u6a19\u6e96\u51fa\u529b\u306b\u51fa\u529b\u3057\u307e\u3059\u3002");
            return;
        }
        XSLT xSLT = new XSLT();
        xSLT.setXslFile(stringArray[1]);
        xSLT.setOutFile(stringArray[2], false);
        xSLT.transform(stringArray[0]);
        xSLT.close();
    }
}

