/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsDateUtil;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.SystemParameter;

public class Process_DBFileout
extends AbstractProcess
implements ChainProcess {
    private static final String SELECT_KEY = "select_";
    private static final String CNST_KEY = "const_";
    private static final String ENCODE = "UTF-8";
    private Connection connection;
    private PreparedStatement selPstmt;
    private String dbid;
    private String select;
    private int[] selClmNos;
    private String outFilename;
    private boolean append;
    private String timestamp;
    private int tmstmpClm = -1;
    private String separator = "\t";
    private String addHeader;
    private String addFooter;
    private boolean useLineCR = true;
    private int fetchSize = 1000;
    private boolean display;
    private boolean debug;
    private String[] cnstClm;
    private int[] cnstClmNos;
    private String[] constVal;
    private boolean firstRow = true;
    private int count;
    private static final Map<String, String> MUST_PROPARTY = new LinkedHashMap<String, String>();
    private static final Map<String, String> USABLE_PROPARTY = new LinkedHashMap<String, String>();

    public Process_DBFileout() {
        super("org.opengion.fukurou.process.Process_DBFileout", MUST_PROPARTY, USABLE_PROPARTY);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        this.select = argument.getFileProparty("select", "selectFile", false);
        this.separator = argument.getProparty("sep", this.separator);
        this.outFilename = argument.getProparty("outFile", this.outFilename);
        this.append = argument.getProparty("append", this.append);
        this.addHeader = argument.getProparty("addHeader", this.addHeader);
        this.addFooter = argument.getProparty("addFooter", this.addFooter);
        this.useLineCR = argument.getProparty("useLineCR", this.useLineCR);
        this.timestamp = argument.getProparty("timestamp", this.timestamp);
        this.fetchSize = argument.getProparty("fetchSize", this.fetchSize);
        this.display = argument.getProparty("display", this.display);
        this.debug = argument.getProparty("debug", this.debug);
        this.addHeader = this.addHeader.replaceAll("\\\\t", "\t").replaceAll("\\\\n", "\n");
        this.addFooter = this.addFooter.replaceAll("\\\\t", "\t").replaceAll("\\\\n", "\n");
        this.dbid = argument.getProparty("dbid");
        this.connection = paramProcess.getConnection(this.dbid);
        if (this.select == null) {
            throw new OgRuntimeException("select \u307e\u305f\u306f\u3001selectFile \u306f\u5fc5\u305a\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        HybsEntry[] hybsEntryArray = argument.getEntrys(SELECT_KEY);
        SystemParameter systemParameter = new SystemParameter(this.select);
        this.select = systemParameter.replace(hybsEntryArray);
        HybsEntry[] hybsEntryArray2 = argument.getEntrys(CNST_KEY);
        int n = hybsEntryArray2.length;
        this.cnstClm = new String[n];
        this.constVal = new String[n];
        for (int i = 0; i < n; ++i) {
            this.cnstClm[i] = hybsEntryArray2[i].getKey();
            this.constVal[i] = hybsEntryArray2[i].getValue();
        }
    }

    @Override
    public void end(boolean bl) {
        boolean bl2 = Closer.stmtClose(this.selPstmt);
        this.selPstmt = null;
        if (bl) {
            Closer.commit(this.connection);
        } else {
            Closer.rollback(this.connection);
        }
        ConnectionFactory.remove(this.connection, this.dbid);
        if (!bl2) {
            String string = "select \u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u3092\u30af\u30ed\u30fc\u30ba\u51fa\u6765\u307e\u305b\u3093\u3002" + CR + " select=[" + this.select + "] , commit=[" + bl + "]";
            System.err.println(string);
        }
    }

    @Override
    public LineModel action(LineModel lineModel) {
        ++this.count;
        try {
            Calendar calendar;
            String[][] stringArray;
            Formatter formatter;
            File file;
            File file2;
            int n;
            if (this.firstRow) {
                this.makePrepareStatement(lineModel);
                n = this.cnstClm.length;
                this.cnstClmNos = new int[n];
                for (int i = 0; i < n; ++i) {
                    this.cnstClmNos[i] = lineModel.getColumnNo(this.cnstClm[i]);
                }
                if (this.display) {
                    this.println(lineModel.nameLine());
                }
                if (this.timestamp != null) {
                    this.tmstmpClm = lineModel.getColumnNo(this.timestamp);
                }
                this.firstRow = false;
            }
            for (n = 0; n < this.cnstClmNos.length; ++n) {
                lineModel.setValue(this.cnstClmNos[n], this.constVal[n]);
            }
            if (this.selClmNos != null) {
                for (n = 0; n < this.selClmNos.length; ++n) {
                    this.selPstmt.setObject(n + 1, lineModel.getValue(this.selClmNos[n]));
                }
            }
            if ((file2 = (file = new File((formatter = new Formatter(lineModel, this.outFilename)).getFormatString(0))).getParentFile()) == null || !file2.exists() && !file2.mkdirs()) {
                String string = "\u89aa\u30d5\u30a9\u30eb\u30c0\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + lineModel.getRowNo() + "]\u4ef6\u76ee" + CR + " outFile=[" + formatter.getFormatString(0) + "]" + CR;
                throw new OgRuntimeException(string);
            }
            try (Object object = this.selPstmt.executeQuery();){
                stringArray = DBUtil.resultToArray((ResultSet)object, false);
            }
            if (stringArray.length > 0) {
                object = FileUtil.getPrintWriter(file, ENCODE, this.append);
                try {
                    if (this.addHeader != null) {
                        Formatter formatter2 = new Formatter(lineModel, this.addHeader);
                        String string = formatter2.getFormatString(0);
                        ((PrintWriter)object).print(string);
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        for (int j = 0; j < stringArray[i].length; ++j) {
                            ((PrintWriter)object).print(stringArray[i][j]);
                            ((PrintWriter)object).print(this.separator);
                        }
                        if (!this.useLineCR) continue;
                        ((PrintWriter)object).println();
                    }
                    if (this.addFooter != null) {
                        Formatter formatter3 = new Formatter(lineModel, this.addFooter);
                        String string = formatter3.getFormatString(0);
                        ((PrintWriter)object).print(string);
                    }
                }
                finally {
                    if (object != null) {
                        ((PrintWriter)object).close();
                    }
                }
            }
            if (this.tmstmpClm >= 0 && !file.setLastModified((calendar = HybsDateUtil.getCalendar((String)(object = String.valueOf(lineModel.getValue(this.tmstmpClm))))).getTimeInMillis())) {
                String string = "\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7\u306e\u66f4\u65b0\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + lineModel.getRowNo() + "]\u4ef6\u76ee" + CR + " outFile= [" + file + "]" + CR;
                System.err.println(string);
            }
            if (this.display) {
                this.println(lineModel.dataLine());
            }
        }
        catch (SQLException sQLException) {
            String string = "\u691c\u7d22\u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[" + lineModel.getRowNo() + "]\u4ef6\u76ee" + CR + " select=[" + this.select + "]" + CR + " errCode=[" + sQLException.getErrorCode() + "] State=[" + sQLException.getSQLState() + "]" + CR + " data=[" + lineModel.dataLine() + "]" + CR;
            throw new OgRuntimeException(string, sQLException);
        }
        return lineModel;
    }

    private void makePrepareStatement(LineModel lineModel) {
        Formatter formatter = new Formatter(lineModel, this.select);
        this.select = formatter.getQueryFormatString();
        this.selClmNos = formatter.getClmNos();
        for (int i = 0; i < this.selClmNos.length; ++i) {
            if (this.selClmNos[i] >= 0) continue;
            String string = "\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u306b\u5bfe\u5fdc\u3057\u305f\u30ab\u30e9\u30e0\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" + CR + "select=[" + this.select + "]" + CR + "ClmKey=[" + formatter.getClmKeys()[i] + "]" + CR + "nameLine=[" + lineModel.nameLine() + "]" + CR + "data=[" + lineModel.dataLine() + "]" + CR;
            throw new OgRuntimeException(string);
        }
        try {
            this.selPstmt = this.connection.prepareStatement(this.select);
            this.selPstmt.setFetchSize(this.fetchSize);
        }
        catch (SQLException sQLException) {
            String string = "PreparedStatement \u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "errMsg=[" + sQLException.getMessage() + "]" + CR + "errCode=[" + sQLException.getErrorCode() + "] State=[" + sQLException.getSQLState() + "]" + CR + "select=[" + this.select + "]" + CR + "nameLine=[" + lineModel.nameLine() + "]" + CR + "data=[" + lineModel.dataLine() + "]" + CR;
            throw new OgRuntimeException(string, sQLException);
        }
    }

    @Override
    public String report() {
        return "[" + this.getClass().getName() + "]" + CR + "\tDBID         : " + this.dbid + CR + "\tInput  Count : " + this.count;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder(500).append("Process_DBFileout \u306f\u3001SELECT\u6587 \u3092\u6307\u5b9a\u3057 \u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u5024\u3092\u629c\u304d\u51fa\u3057\u3066\u3001").append(CR).append("\u500b\u3005\u306e\u30d5\u30a1\u30a4\u30eb\u306b\u30bb\u30fc\u30d6\u3059\u308b\u3001ChainProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR).append("\u4e0a\u6d41(\u30d7\u30ed\u30bb\u30b9\u30c1\u30a7\u30a4\u30f3\u306e\u30c7\u30fc\u30bf\u306f\u4e0a\u6d41\u304b\u3089\u4e0b\u6d41\u3078\u3068\u6e21\u3055\u308c\u307e\u3059\u3002)\u304b\u3089").append(CR).append("\u53d7\u3051\u53d6\u3063\u305f LineModel \u3092\u5143\u306b\u3001\uff11\u884c\u5358\u4f4d\u306b\u3001SELECT\u6587\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002").append(CR).append(CR).append("\u4e0a\u6d41\u306e\u30ab\u30e9\u30e0\u3092\u3001[\u30ab\u30e9\u30e0]\u5909\u6570\u3067\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002").append(CR).append("\u307e\u305f\u3001\u30bb\u30fc\u30d6\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u540d\u3001\u66f4\u65b0\u65e5\u4ed8\u7b49\u3082\u3001\u90fd\u5ea6\u3001\u66f4\u65b0\u53ef\u80fd\u3067\u3059\u3002").append(CR).append(CR).append("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a\u5148\u7b49\u306f\u3001ParamProcess \u306e\u30b5\u30d6\u30af\u30e9\u30b9(Process_DBParam)\u306b").append(CR).append("\u8a2d\u5b9a\u3055\u308c\u305f\u63a5\u7d9a(Connection)\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002").append(CR).append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u30b9\u30da\u30fc\u30b9\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u30b9\u30da\u30fc\u30b9\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR).append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR).append(CR).append("SQL\u6587\u306b\u306f\u3001{&#064;DATE.YMDH}\u7b49\u306e\u30b7\u30b9\u30c6\u30e0\u5909\u6570\u304c\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002").append(CR).append(CR).append(CR).append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_DBFileout().usage());
    }

    static {
        USABLE_PROPARTY.put("dbid", "Process_DBParam \u306e -configFile \u3067\u6307\u5b9a\u3059\u308b DBConfig.xml \u30d5\u30a1\u30a4\u30eb\u3067\u898f\u5b9a");
        USABLE_PROPARTY.put("select", "\u691c\u7d22SQL\u6587(select or selectFile \u5fc5\u9808)" + CR + "\u4f8b: \"SELECT * FROM GE41 WHERE SYSTEM_ID = [SYSTEM_ID] AND CLM = [CLM]\"");
        USABLE_PROPARTY.put("selectFile", "\u691c\u7d22SQL\u30d5\u30a1\u30a4\u30eb(select or selectFile \u5fc5\u9808)\u4f8b: select.sql");
        USABLE_PROPARTY.put(SELECT_KEY, "SQL\u6587\u4e2d\u306e{&#064;XXXX}\u6587\u5b57\u5217\u3092\u6307\u5b9a\u306e\u56fa\u5b9a\u5024\u3067\u7f6e\u304d\u63db\u3048\u307e\u3059\u3002" + CR + "WHERE SYSTEM_ID='{&#064;SYSTEM_ID}' \u21d2 WHERE SYSTEM_ID='GE'");
        USABLE_PROPARTY.put(CNST_KEY, "LineModel \u306e\u30ad\u30fc(const_ \u306b\u7d9a\u304f\u6587\u5b57\u5217)\u306e\u5024\u306b\u3001\u56fa\u5b9a\u5024\u3092" + CR + "\u8a2d\u5b9a\u3057\u307e\u3059\u3002\u30ad\u30fc\u304c\u7570\u306a\u308c\u3070\u3001\u8907\u6570\u306e\u30ab\u30e9\u30e0\u540d\u3092\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002" + CR + "\u4f8b: -sql_SYSTEM_ID=GE");
        USABLE_PROPARTY.put("addHeader", "\u30d8\u30c3\u30c0\u30fc");
        USABLE_PROPARTY.put("addFooter", "\u30d5\u30c3\u30bf\u30fc");
        USABLE_PROPARTY.put("outFile", "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u540d \u4f8b: [NAME].sql");
        USABLE_PROPARTY.put("append", "\u51fa\u529b\uff8c\uff67\uff72\uff99\u3092\u3001\u8ffd\u8a18\u3059\u308b(true)\u304b\u65b0\u898f\u4f5c\u6210\u3059\u308b(false)\u304b\u3002");
        USABLE_PROPARTY.put("sep", "\u5404\u30ab\u30e9\u30e0\u3092\u533a\u5207\u308b\u6587\u5b57\u5217(\u521d\u671f\u5024:TAB)");
        USABLE_PROPARTY.put("useLineCR", "\u5404\u884c\u306e\u6700\u5f8c\u306b\u3001\u6539\u884c\u6587\u5b57\u3092\u3064\u304b\u308b\u304b\u3069\u3046\u304b(\u521d\u671f\u5024:true[\u4ed8\u3051\u308b])");
        USABLE_PROPARTY.put("timestamp", "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u66f4\u65b0\u65e5\u4ed8\u4f8b: [LAST_DDL_TIME]");
        USABLE_PROPARTY.put("fetchSize", "\u30d5\u30a7\u30c3\u30c1\u3059\u308b\u884c\u6570 (\u521d\u671f\u5024:1000)");
        USABLE_PROPARTY.put("display", "\u7d50\u679c\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
        USABLE_PROPARTY.put("debug", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

