/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.penguin.math.statistics;

import java.util.Arrays;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.opengion.penguin.math.statistics.HybsRegression;

public class HybsSimpleRegression
implements HybsRegression {
    private final double[] cnst = new double[3];
    private double rsquare;

    public HybsSimpleRegression(double[][] dArray) {
        this.train(dArray);
    }

    private void train(double[][] dArray) {
        SimpleRegression simpleRegression = new SimpleRegression();
        simpleRegression.addData(dArray);
        this.cnst[2] = 0.0;
        this.cnst[1] = simpleRegression.getSlope();
        this.cnst[0] = simpleRegression.getIntercept();
        this.rsquare = simpleRegression.getRSquare();
    }

    @Override
    public double[] getCoefficient() {
        return Arrays.copyOf(this.cnst, this.cnst.length);
    }

    @Override
    public double getRSquare() {
        return this.rsquare;
    }

    @Override
    public double predict(double ... dArray) {
        return this.cnst[1] * dArray[0] + this.cnst[0];
    }

    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{{1.0, 2.3}, {2.0, 3.4}, {3.0, 6.1}, {4.0, 8.2}};
        HybsSimpleRegression hybsSimpleRegression = new HybsSimpleRegression(dArrayArray);
        double[] dArray = hybsSimpleRegression.getCoefficient();
        System.out.println(dArray[2]);
        System.out.println(dArray[1]);
        System.out.println(dArray[0]);
        System.out.println(hybsSimpleRegression.predict(5.0));
    }
}

