<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="query" >
	<script>
		function check(value){
			if(value == "JSP"){
				document.getElementById("JSP_PATH").disabled = false;
				document.getElementById("JSP_DIR" ).disabled = false;
				document.getElementById("SQL_PATH").disabled = true;
				document.getElementById("SQL_DIR" ).disabled = true;
				document.getElementById("maxLevel").value = "2";
			}
			else if(value == "SQL"){
				document.getElementById("JSP_PATH").disabled = true;
				document.getElementById("JSP_DIR" ).disabled = true;
				document.getElementById("SQL_PATH").disabled = false;
				document.getElementById("SQL_DIR" ).disabled = false;
				document.getElementById("maxLevel").value = "2";
			}
			else if(value == "ALLCHECK"){
				document.getElementById("JSP_PATH").disabled = false;
				document.getElementById("JSP_DIR" ).disabled = false;
				document.getElementById("SQL_PATH").disabled = false;
				document.getElementById("SQL_DIR" ).disabled = false;
				document.getElementById("maxLevel").value = "";
			}
		}
	</script>

	<style>
		.word { font-family:'ＭＳ Ｐゴシック','MS PGothic','メイリオ', Meiryo ; }
	</style>
</og:head>

<jsp:directive.include file="/jsp/custom/query_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC23"
	title	= "ｿｰｽGrep検索"
	date	= "2015/07/03"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<form method="GET" action="forward.jsp" target="RESULT" onSubmit="timeSet();">
	<!-- 変更はここから -->
	<table >
		<tr>
			<td><input type="radio" name="CHBOX" value="JSP" checked="checked" onClick="check(value);" />JSP</td>
			<td><og:column name="JSP_PATH" lbl="{@LBL.PATH}" size="80" maxlength="500" defaultVal="{@LAST.JSP_PATH}" useRealTimeCheck="false" /></td>
			<td><og:column name="JSP_DIR"  lbl="DIR" defaultVal="{@LAST.JSP_DIR}" /></td><td> (.jsp|.js UTF-8)</td>
		</tr>
		<tr>
			<td><input type="radio" name="CHBOX" value="SQL" onClick="check(value);" />PL/SQL</td>
			<td><og:column name="SQL_PATH"	disabled="true"	lbl="{@LBL.PATH}" size="80" maxlength="500" defaultVal="{@LAST.SQL_PATH}" useRealTimeCheck="false" /></td>
			<td><og:column name="SQL_DIR"	disabled="true"	lbl="DIR" defaultVal="{@LAST.SQL_DIR}" /></td><td> (.sql Windows-31J)</td>
		</tr>
		<tr>
			<td colspan="4"><input type="radio" name="CHBOX" value="ALLCHECK" onClick="check(value);" />AllCheck JSP ＆ PL/SQL</td>
			<td />
			<og:column name="maxLevel"	editor="NUMMENU"	param="1,5,1"	defaultVal="2"	/>
			<td><og:link href="https://docs.oracle.com/javase/jp/10/docs/api/java/util/regex/Pattern.html#sum"
						useGamenId="false" target="_new" lbl="正規表現" /></td>
		</tr>
	</table>
	<table >
		<tr>
			<og:column name="jspWord" clazz="word" size="150" maxlength="200"
					defaultVal="[^\p{ASCII}　～【】●×■□◆○▲△▼▽→←⇒※：]| {4,}|^ |=.*\./[a-zA-Z]+|USER.IDNO|GEA0|GEA11|BASF0088" />
		</tr>
		<tr>
			<og:column name="sqlWord" size="150" maxlength="200" clazz="word" colspan="4"
				defaultVal="[^\p{Upper}\d\s\p{Punct}　～【】●×■□◆○▲△▼▽→←⇒※：]|.* {4,}|^ |.*GEA03|.*GEA04|.*GEA08|.*GEA11|.*PACKAGE|.*GOTO" />
		</tr>
		<tr>
			<og:column name="OMIT_PG"   lbl="{@LBL.OMIT}PG" size="150"  maxlength="200"
					value="login.jsp|BASV02.sql|BASV03.sql|BASV04.sql|BASP0011.sql|BASP0062.sql|BASS9007A.sql|LNGS0999A.sql|TOPP0002.sql"	/>
		</tr>
		<tr>
			<og:column name="OMIT_WORD" lbl="{@LBL.OMIT}{@LBL.YOYAKU}" size="150"  maxlength="200"
					value="(?!.*CON_NMRTN)(?!.*LOCAL_MSG_RTN)(?!.*BASP0062)(?!.*DBMS_OUTPUT)(?!.*CLIENT,'u=')(?!.*REGEXP)(?!.*\[.+\])"	/>
		</tr>
	</table>

	<og:queryButton type="SELECT" />

	<!-- 拡張検索条件 -->
	<og:hideMenu>
		<table >
			<tr>
				<og:column name="WORK_DIR" lbl="workDir" size="100" maxlength="200" clazz="word" colspan="3"
					defaultVal="{@LAST.WORK_DIR}" />
			</tr>
			<tr>
				<og:column name="CALL_BAT2"	lbl="callBat"  size="30" defaultVal="200_SP_BAT_CALL.bat" />
				<og:column name="CHECK_DIR"	lbl="checkDir" size="30" defaultVal="900_KAKUNIN_FILE" />
			</tr>
		</table>
	</og:hideMenu>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
