<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" >
	<script>
//		window.onload = function(){
		window.addEventListener('load', function(){				// 8.3.0.0 (2022/08/01)
			grepCnt = $("#GREPCNT").val();
			if(grepCnt == 0) {
				$("#GREPFL").css('display','none');
			}
		} );
	</script>
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC33"
	title	= "ｿｰｽGrep"
	date	= "2022/06/03"
	author	= "LEE.M"
	text	= ""
	version	= "001"
/>

<!-- ﾜｰﾆﾝｸﾞﾒｯｾｰｼﾞです｡ここでは､登録完了のﾒｯｾｰｼﾞを表示します｡ -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command		= "{@command}"
/>

<style>
	.MARK { background-color:#ccff00 ;}
	td { white-space:pre; tab-size: 4; }
</style>

<!-- 大文字/小文字の区別 -->
<og:value key="IGNORE1" value="true"  caseKey="{@IGNORE}" caseVal="0" />
<og:value key="IGNORE1" value="false" caseKey="{@IGNORE}" caseVal="1" />

<!-- ﾌｧｲﾙ毎最初のみ表示 -->
<og:value key="USEALLFIND1" value="true"  caseKey="{@USEALLFIND}" caseVal="0" />
<og:value key="USEALLFIND1" value="false" caseKey="{@USEALLFIND}" caseVal="1" />

<!-- 正規表現 -->
<og:value key="USEREGEX1" value="false" caseKey="{@USEREGEX}" caseVal="0" />
<og:value key="USEREGEX1" value="true"  caseKey="{@USEREGEX}" caseVal="1" />

<!-- ﾌｧｲﾙ関連変数 -->
<og:value key="FILEURL"  value="{@GUI.KEY}/{@DATE.yyyyMMdd}" />
<og:value key="FILENAME" value="{@DATE.yyyyMMddHHmmssSSS}.txt" />
<og:value key="NEWFILE"  value="{@FILEURL}/{@FILENAME}" />

<!-- ﾌｧｲﾙが存在するかどうか判定 -->
<og:file action="exists" fileURL="{@PATH}">
	<!-- MSG0087:ﾌｫﾙﾀﾞが存在していません。 -->
	<og:text>{@PATH}</og:text>　<og:message lbl="MSG0087" /><br />
	<!-- MSG0088:ｱｸｾｽ可能か確認してください。 -->
	　<og:message lbl="MSG0088" /><br />
</og:file>

<!-- ﾃﾞｨﾚｸﾄﾘを生成 -->
<og:file action="mkdir" fileURL="{@FILEURL}" >
	<!-- ERR0004.2:管理者に相談して、対応してもらってください。 -->
	<og:message lbl="ERR0004.2" />
</og:file>

<!-- 過去の一時的なﾌｫﾙﾀﾞを削除 -->
<og:fileQuery
	command		= "NEW"
	from		= "{@GUI.KEY}"
	addFrom		= "false"
	fileType	= "DIR"
	maxRowCount	= "0"
	displayMsg	= ""
	notfoundMsg	= ""
	useTimeView	= "false"
>
	<og:fileWhere
		unStartsDir	= "{@DATE.yyyyMMdd}"
	/>
</og:fileQuery>

<og:fileUpdate
	action		= "DELETE"
	command		= "ENTRY"
	selectedAll	= "true"
	displayMsg	= ""
	useTimeView	= "false"
/>

<!-- ﾌｧｲﾙﾀﾞｳﾝﾛｰﾄﾞ -->
<og:link href="{@SYS.JSP}/fileDownload" target="_blank" useGamenId="false" id="GREPFL"
			keys="file,name,useLocal" vals="{@SYS.FILE_URL}/{@NEWFILE},{@FILENAME},true" >
	<img src="{@SYS.JSP_IMG}/floppy.gif" alt="text Open" /> {@FILENAME} <og:message lbl="MSG0056" /><p/>
</og:link>

<pre>
	<!-- jarﾌｧｲﾙ -->
	<og:mainProcess useDisplay="true" >
		<og:process processID="FileSearch">
			<og:param key="start"			value="{@PATH}"			/>			<!-- 開始ﾌｫﾙﾀﾞ			-->
			<og:param key="unpreDir"		value="backup"			/>			<!-- 不接頭辞ﾌｫﾙﾀﾞ		-->
		<!--<og:param key="unFileEquals"	value="{@OMIT_PG}"		/>-->		<!-- 不一致ﾌｧｲﾙ名		-->
			<og:param key="suffix"			value=".jar"			/>			<!-- 接尾辞				-->
			<og:param key="errAbend"		value="false"			/>			<!-- 異常時の処理判定	-->
		</og:process>
		<og:process processID="Grep">
			<og:param key="keyword"			value="{@WORD}"			/>			<!-- ｷｰﾜｰﾄﾞ				-->
			<og:param key="ignoreCase"		value="{@IGNORE1}"		/>			<!-- 大文字小文字		-->
			<og:param key="useAllFind"		value="{@USEALLFIND1}"	/>			<!-- 最後までの検索判定	-->
		<!--<og:param key="useOmitCmnt"		value="{@useOmitCmnt}"	/>-->		<!-- ｺﾒﾝﾄ部分削除		-->
			<og:param key="inEncode"		value="autoEncode"		/>			<!-- 入力ｴﾝｺｰﾄﾞ			-->
		<!--<og:param key="jarPrefix"		value="{@PREFIX}"		/>-->		<!-- 接頭辞				-->
			<og:param key="jarInstr"		value="{@INSTR}"		/>			<!-- 部分文字列			-->
			<og:param key="jarSuffix"		value="{@SUFFIX}"		/>			<!-- 接尾辞				-->
			<og:param key="useRegexp"		value="{@USEREGEX1}"	/>			<!-- 正規表現			-->
			<og:param key="saveFile"		value="{@NEWFILE}"		/>			<!-- 保存ﾌｧｲﾙ			-->
			<og:param key="errAbend"		value="false"			/>			<!-- 異常時の処理判定	-->
		</og:process>
	</og:mainProcess>

	<!-- jarﾌｧｲﾙ以外 -->
	<og:mainProcess useDisplay="true" >
		<og:process processID="FileSearch">
			<og:param key="start"			value="{@PATH}"			/>			<!-- 開始ﾌｫﾙﾀﾞ			-->
			<og:param key="unpreDir"		value="backup"			/>			<!-- 不接頭辞ﾌｫﾙﾀﾞ		-->
		<!--<og:param key="unFileEquals"	value="{@OMIT_PG}"		/>-->		<!-- 不一致ﾌｧｲﾙ名		-->
		<!--<og:param key="prefix"			value="{@PREFIX}"		/>-->		<!-- 接頭辞				-->
			<og:param key="instr"			value="{@INSTR}"		/>			<!-- 部分文字列			-->
			<og:param key="suffix"			value="{@SUFFIX}"		/>			<!-- 接尾辞				-->
			<og:param key="unsuffix"		value=".jar"			/>			<!-- 不接尾辞			-->
			<og:param key="errAbend"		value="false"			/>			<!-- 異常時の処理判定	-->
		</og:process>
		<og:process processID="Grep">
			<og:param key="keyword"			value="{@WORD}"			/>			<!-- ｷｰﾜｰﾄﾞ				-->
			<og:param key="ignoreCase"		value="{@IGNORE1}"		/>			<!-- 大文字小文字		-->
			<og:param key="useAllFind"		value="{@USEALLFIND1}"	/>			<!-- 最後までの検索判定	-->
		<!--<og:param key="useOmitCmnt"		value="{@useOmitCmnt}"	/>-->		<!-- ｺﾒﾝﾄ部分削除		-->
			<og:param key="inEncode"		value="autoEncode"		/>			<!-- 入力ｴﾝｺｰﾄﾞ			-->
			<og:param key="useRegexp"		value="{@USEREGEX1}"	/>			<!-- 正規表現			-->
			<og:param key="saveFile"		value="{@NEWFILE}"		/>			<!-- 保存ﾌｧｲﾙ			-->
			<og:param key="errAbend"		value="false"			/>			<!-- 異常時の処理判定	-->
		</og:process>
	</og:mainProcess>
</pre>

<!-- ﾌｧｲﾙｻｲｽﾞが0Byteの時、ﾌｧｲﾙ削除 -->
<og:file action="existsLength" fileURL="{@NEWFILE}" >
	<og:hidden name="GREPCNT" value="0" />
	<!-- MSG0077:対象ﾃﾞｰﾀはありませんでした。 -->
	<og:message lbl="MSG0077" />
	<og:file action="delete" fileURL="{@NEWFILE}" />
</og:file>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
