/*
 * Copyright (c) 2017 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.fileexec;

import java.nio.file.Path;

import static org.opengion.fukurou.fileexec.AppliExec.GE72.*;		// enum のショートカット

/**
 * RunExec_BAT は、RunExec インターフェースの実装クラスで、ファイルを引数にバッチを呼び出します。
 * 現状、何も処理を入れていません。
 *
 *<pre>
 * GE72.RUNTYPEが、'3' の場合の処理を行います。
 *      0:NONE          // なにもしない
 *      1:DBIN          // DB入力
 *      2:PLSQL         // PL/SQLコール
 *      3:BAT           // BATファイルコール
 *      4:JSP           // JSPファイルコール（URLコネクション）
 *
 * GE72のCLMS(外部ｶﾗﾑ指定)は、使用しません。
 * このカラムは、TABLE_NAME(ﾃｰﾌﾞﾙ名)で指定したﾃｰﾌﾞﾙのカラムと同じである必要があります。
 *
 * PARAMS(ﾊﾟﾗﾒｰﾀ)は、使用しません。
 *
 * RUNPG(実行ﾌﾟﾛｸﾞﾗﾑ)は、実行する バッチファイルです。
 *
 * 引数には、セーブされたファイル名が指定されます。
 * 現状、何も処理を入れていません。
 *</pre>
 *
 * @og.rev 7.2.5.0 (2020/06/01) 新規作成
 *
 * @version  7.2
 * @author   Kazuhiko Hasegawa
 * @since    JDK11
 */
public class RunExec_BAT implements RunExec {

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 7.2.5.0 (2020/06/01) 新規作成
	 */
	public RunExec_BAT() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * 実際に処理を実行するプログラムのメソッド。
	 *
	 * @og.rev 7.2.5.0 (2020/06/01) 新規作成
	 *
	 * @param	path 処理するファイルパス
	 * @param	ge72Data GE72 テーブルデータ
	 * @return	処理件数(正は成功、マイナスは異常時の行番号)
	 */
	@Override	// RunExec
	public int exec( final Path path , final String[] ge72Data ) {
		return 0;
	}

	/**
	 * 追加で呼び出す PL/SQL を実行します。
	 *
	 * これは、取り込み処理の実施結果にかかわらず、必ず呼ばれます。
	 *
	 * @og.rev 7.2.5.0 (2020/06/01) 新規作成
	 *
	 * @param	path 処理するファイルパス
	 * @param	ge72Data GE72 テーブルデータ
	 * @param	fgtkan 取込完了ﾌﾗｸﾞ(0:取込なし , 1:処理中 , 2:済 , 7:ﾃﾞｰﾓﾝｴﾗｰ , 8:ｱﾌﾟﾘｴﾗｰ)
	 * @param	errMsg ｴﾗｰﾒｯｾｰｼﾞ
	 */
	@Override	// RunExec
	public void endExec( final Path path , final String[] ge72Data , final String fgtkan , final String errMsg ) {
//		return ;
	}
}
