/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.opengion.fukurou.fileexec.FileUtil;
import org.opengion.fukurou.fileexec.XLogger;

public final class LineSplitter {
    private static final XLogger LOGGER = XLogger.getLogger(LineSplitter.class.getSimpleName());
    private final Charset chset;
    private String[] clms = new String[0];
    private static final String NAME_KEY = "#NAME";
    private static final int NAME_LEN = "#NAME".length();

    public LineSplitter() {
        this(StandardCharsets.UTF_8, null);
    }

    public LineSplitter(String string, String string2) {
        this(Charset.forName(string), string2);
    }

    public LineSplitter(Charset charset, String string) {
        this.chset = charset;
        if (string != null && !string.isEmpty()) {
            this.clms = string.split(",");
        }
        LOGGER.debug(() -> "[LineSplitter] Charset=" + charset + " , inClms=" + string);
    }

    public String[] getColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.clms) {
            if (string.isEmpty()) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void forEach(Path path, Consumer<List<String>> consumer) {
        FileUtil.lockForEach(path, this.chset, string -> {
            List<String> list = this.split((String)string);
            if (!list.isEmpty()) {
                consumer.accept(list);
            }
        });
    }

    public List<String> split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.cmntCut(string);
        if (string2.isEmpty()) {
            return arrayList;
        }
        int n = string2.length();
        int n2 = 0;
        int n3 = 0;
        while (n2 <= n) {
            String string3;
            int n4;
            int n5;
            boolean bl = false;
            int n6 = n5 = n2;
            char c = '\u0000';
            while (n5 < n) {
                c = string2.charAt(n5);
                if (!bl && (c == ',' || c <= ' ')) break;
                if ('\"' == c) {
                    bl = !bl;
                }
                ++n5;
            }
            if ((n4 = (string3 = string2.substring(n6, n5)).length()) >= 2 && string3.charAt(0) == '\"' && string3.charAt(n4 - 1) == '\"') {
                string3 = string3.substring(1, n4 - 1);
            }
            if ("null".equalsIgnoreCase(string3)) {
                string3 = "";
            }
            if (n3 < this.clms.length && !this.clms[n3].isEmpty()) {
                arrayList.add(string3);
            }
            ++n3;
            while (c <= ' ' && ++n5 < n) {
                c = string2.charAt(n5);
            }
            n2 = c == ',' || n5 == n ? n5 + 1 : n5;
        }
        return arrayList;
    }

    public String cmntCut(String string) {
        boolean bl;
        boolean bl2 = bl = !string.isEmpty() && string.charAt(0) == '#';
        if (bl && this.clms.length == 0 && string.toUpperCase(Locale.JAPAN).startsWith(NAME_KEY)) {
            String string2 = string.substring(NAME_LEN, NAME_LEN + 1);
            this.clms = string.split(string2);
            this.clms[0] = "";
        }
        return bl ? "" : string;
    }
}

