/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;

@WebFilter(filterName="CacheControlFilter", urlPatterns={"/*"})
public final class CacheControlFilter
extends HttpFilter {
    private static final long serialVersionUID = 830020220801L;
    private boolean isDebug;

    public void init(FilterConfig filterConfig) {
        this.isDebug = Boolean.parseBoolean(filterConfig.getInitParameter("debug"));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            int n = this.checkType(httpServletRequest);
            if (n > 0) {
                filterChain.doFilter(servletRequest, servletResponse);
                httpServletResponse.setHeader("Cache-Control", "private,max-age=31536000,immutable");
                if (n == 1) {
                    httpServletResponse.setCharacterEncoding("UTF-8");
                }
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private int checkType(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getRequestURI();
        int n = -1;
        if (string.endsWith(".css") || string.endsWith(".js")) {
            n = 1;
        } else if (string.endsWith(".gif") || string.endsWith(".png")) {
            n = 2;
        }
        if (this.isDebug && n > 0) {
            System.out.println("CacheControlFilter=" + string);
        }
        return n;
    }

    static final class CCFResponseWrapper
    extends HttpServletResponseWrapper {
        protected HttpServletResponse origResponse;

        public CCFResponseWrapper(HttpServletResponse httpServletResponse, int n) {
            super(httpServletResponse);
            this.origResponse = httpServletResponse;
            this.origResponse.setHeader("Cache-Control", "private,max-age=31536000,immutable");
            if (n == 1) {
                this.origResponse.setCharacterEncoding("UTF-8");
            }
        }
    }
}

