/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.resource.GUIData;

final class GUIDataLoader {
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private static final String QUERY1 = "select GUIKEY,GUILVL,LABEL_CLM,ADDRESS,SEQNO,GROUPS,'' as CLASSIFY,ROLES,RWMODE,TARGET,PARAM,KBLINK,DYUPD,SYSTEM_ID,KBSAKU";
    private static final String QUERY2 = "from GEA11 where SYSTEM_ID in (";
    private static final String QUERY3 = ") and FGJ='1' order by KBSAKU,SEQNO,GUIKEY,SYSID_SEQ DESC";
    private final Map<String, GUIData> guiMap = Collections.synchronizedMap(new LinkedHashMap());
    private final String[] SYS_ARRAY;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;

    GUIDataLoader(String[] stringArray) {
        this.SYS_ARRAY = stringArray;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYS_ARRAY[0], HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("GUIDataLoader", null, null);
        } else {
            this.appInfo = null;
        }
        this.loadDBResource();
    }

    private void loadDBResource() {
        int n = this.SYS_ARRAY.length;
        int[] nArray = new int[n];
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder(200);
        StringJoiner stringJoiner = new StringJoiner(",");
        stringBuilder.append(QUERY1).append(",case");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" when '").append(this.SYS_ARRAY[i]).append("' = SYSTEM_ID THEN ").append(i);
            stringJoiner.add("?");
        }
        stringBuilder.append(" else 99 end as SYSID_SEQ ").append(QUERY2).append(stringJoiner.toString()).append(QUERY3);
        String[][] stringArray = DBUtil.dbExecute((String)stringBuilder.toString(), (String[])this.SYS_ARRAY, (ApplicationInfo)this.appInfo, (String)this.DBID);
        int n3 = stringArray.length;
        n2 += n3;
        String string = "";
        for (int i = 0; i < n3; ++i) {
            String[] stringArray2 = stringArray[i];
            int n4 = Integer.parseInt(stringArray2[1]);
            if (n4 == 2) {
                string = stringArray2[0];
            } else if (n4 >= 3) {
                stringArray2[6] = string;
            }
            if ((n4 == 1 || n4 == 2) && StringUtil.isEmpty((CharSequence[])new CharSequence[]{stringArray2[3]})) {
                stringArray2[7] = null;
            }
            this.guiMap.put(stringArray2[0], new GUIData(stringArray2));
        }
        StringBuilder stringBuilder2 = new StringBuilder(200);
        stringBuilder2.append("  ").append(this.SYS_ARRAY[0]).append("  GUIDataLoader [").append(n2).append("] Map=[").append(this.guiMap.size()).append("] ");
        stringBuilder2.append("loaded.");
        System.out.println(stringBuilder2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUIData[] getAllData() {
        Map<String, GUIData> map = this.guiMap;
        synchronized (map) {
            if (this.guiMap.isEmpty()) {
                this.loadDBResource();
            }
            return this.guiMap.values().toArray(new GUIData[this.guiMap.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, GUIData> map = this.guiMap;
        synchronized (map) {
            this.guiMap.clear();
        }
    }
}

