/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ErrMsg;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBColumnConfig;
import org.opengion.hayabusa.resource.CodeData;
import org.opengion.hayabusa.resource.CodeDataLoader;
import org.opengion.hayabusa.resource.ColumnData;
import org.opengion.hayabusa.resource.ColumnDataLoader;
import org.opengion.hayabusa.resource.GUIData;
import org.opengion.hayabusa.resource.GUIDataLoader;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.resource.LabelData;
import org.opengion.hayabusa.resource.LabelDataLoader;
import org.opengion.hayabusa.resource.UserInfo;

public final class ResourceManager {
    private static final String QUERY = "select PARAM from GE12 where SYSTEM_ID=? and FGJ='1' and PARAM_ID='RESOURCE_BASE_SYSTEM_ID'";
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private final ColumnDataLoader columnLoader;
    private final CodeDataLoader codeLoader;
    private final LabelDataLoader labelLoader;
    private final GUIDataLoader guiLoader;
    private final ConcurrentMap<String, DBColumn> columnPool = new ConcurrentHashMap<String, DBColumn>(500);
    private final String lang;

    public ResourceManager(String string, String string2, boolean bl) {
        this.lang = string2;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add(string);
        String[] stringArray = new String[]{string};
        String[][] stringArray2 = DBUtil.dbExecute((String)QUERY, (String[])stringArray, (ApplicationInfo)null, (String)this.DBID);
        if (stringArray2 != null && stringArray2.length > 0 && stringArray2[0].length > 0 && stringArray2[0][0].length() > 0) {
            for (String string3 : stringArray2[0][0].split(",")) {
                String string4 = string3.trim();
                if (string4.isEmpty()) continue;
                linkedHashSet.add(string4);
            }
        }
        linkedHashSet.add("**");
        String[] stringArray3 = linkedHashSet.toArray(new String[linkedHashSet.size()]);
        this.columnLoader = new ColumnDataLoader(stringArray3, bl);
        this.labelLoader = new LabelDataLoader(stringArray3, string2, bl);
        this.codeLoader = new CodeDataLoader(stringArray3, bl, this.labelLoader);
        this.guiLoader = new GUIDataLoader(stringArray3);
    }

    public String getLang() {
        return this.lang;
    }

    public DBColumn getDBColumn(String string) {
        ColumnData columnData;
        if (string == null) {
            throw new HybsSystemException("\u30ab\u30e9\u30e0ID\u306b\u3001NULL \u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        DBColumn dBColumn = (DBColumn)this.columnPool.get(string);
        if (dBColumn == null && (columnData = this.columnLoader.getColumnData(string)) != null) {
            String string2 = columnData.getLabelColumn();
            String string3 = columnData.getCodeColumn();
            dBColumn = new DBColumn(this.lang, columnData, this.labelLoader.getLabelData(string2), this.codeLoader.getCodeData(string3));
            this.columnPool.put(string, dBColumn);
        }
        return dBColumn;
    }

    public DBColumn makeDBColumn(String string) {
        DBColumn dBColumn = this.getDBColumn(string);
        if (dBColumn == null) {
            DBColumnConfig dBColumnConfig = new DBColumnConfig(string);
            dBColumnConfig.setLabelData(this.labelLoader.getLabelData(string));
            dBColumnConfig.setLang(this.lang);
            dBColumn = new DBColumn(dBColumnConfig);
        }
        return dBColumn;
    }

    public DBColumn makeDBColumn(String string, String string2) {
        DBColumnConfig dBColumnConfig;
        if (string2 == null || string2.isEmpty()) {
            return this.makeDBColumn(string);
        }
        DBColumn dBColumn = this.getDBColumn(string);
        if (dBColumn == null) {
            dBColumnConfig = new DBColumnConfig(string);
            dBColumnConfig.setLang(this.lang);
        } else {
            dBColumnConfig = dBColumn.getConfig();
        }
        dBColumnConfig.setLabelData(this.labelLoader.getLabelData(string2));
        return new DBColumn(dBColumnConfig);
    }

    public String getLabel(String string, String ... stringArray) {
        String string2;
        LabelData labelData = this.labelLoader.getLabelData(string);
        if (stringArray == null || stringArray.length == 0) {
            string2 = labelData.getLabel();
        } else {
            String[] stringArray2 = this.makeLabelArray(stringArray);
            string2 = labelData.getMessage(stringArray2);
        }
        return string2 == null ? string : string2;
    }

    private String getExtLabel(String string) {
        String string2;
        int n = string.indexOf(" %");
        if (n < 0) {
            string2 = this.getLabel(string, new String[0]);
        } else if (n + 2 <= string.length()) {
            string2 = this.getLabel(string.substring(0, n), new String[0]);
        } else {
            String string3 = string.substring(0, n);
            switch (string.charAt(n + 2)) {
                case 'C': 
                case 'S': {
                    string2 = this.getShortLabel(string3);
                    break;
                }
                case 'T': {
                    string2 = this.getLongLabel(string3);
                    break;
                }
                case 'D': {
                    string2 = this.getDescription(string3, new String[0]);
                    break;
                }
                case 'R': {
                    string2 = this.getRawShortLabel(string3, true);
                    break;
                }
                default: {
                    string2 = this.getLabel(string3, new String[0]);
                }
            }
        }
        return string2;
    }

    private String[] makeLabelArray(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            stringArray2[i] = StringUtil.startsChar((CharSequence)string2, (char)'#') && string2.length() > 1 ? Stream.of(StringUtil.csv2Array((String)string2.substring(1))).map(string -> this.getExtLabel((String)string)).collect(Collectors.joining(",")) : string2;
        }
        return stringArray2;
    }

    public String getShortLabel(String string) {
        LabelData labelData = this.labelLoader.getLabelData(string);
        String string2 = labelData.getShortLabel();
        return string2 == null ? string : string2;
    }

    public String getLongLabel(String string) {
        LabelData labelData = this.labelLoader.getLabelData(string);
        String string2 = labelData.getLongLabel();
        return string2 == null ? string : string2;
    }

    public String getRawLongLabel(String string) {
        LabelData labelData = this.labelLoader.getLabelData(string);
        return labelData.getRawLongLabel();
    }

    public String getRawShortLabel(String string, boolean bl) {
        LabelData labelData = this.labelLoader.getLabelData(string);
        return labelData.getRawShortLabel(bl ? string : "");
    }

    public String getDescription(String string, String ... stringArray) {
        String string2;
        LabelData labelData = this.labelLoader.getLabelData(string);
        if (stringArray == null || stringArray.length == 0) {
            string2 = labelData.getDescription();
        } else {
            String[] stringArray2 = this.makeLabelArray(stringArray);
            string2 = labelData.getDescription(stringArray2);
        }
        return string2 == null ? string : string2;
    }

    public String getLabel(ErrMsg errMsg) {
        return this.getLabel(errMsg.getId(), errMsg.getArgs());
    }

    public String getShortErrorMsg(ErrMsg errMsg) {
        String string;
        String string2 = errMsg.getId();
        String[] stringArray = errMsg.getArgs();
        LabelData labelData = this.labelLoader.getLabelData(string2);
        if (stringArray == null || stringArray.length == 0) {
            string = labelData.getRawShortLabel();
        } else {
            String[] stringArray2 = this.makeLabelArray(stringArray);
            string = labelData.getShortMessage(stringArray2);
        }
        return string == null ? string2 : string;
    }

    public String getDescription(ErrMsg errMsg) {
        return this.getDescription(errMsg.getId(), errMsg.getArgs());
    }

    public LabelData getLabelData(String string) {
        return this.labelLoader.getLabelData(string);
    }

    public CodeData getCodeData(String string) {
        return this.codeLoader.getCodeData(string);
    }

    public CodeData getCodeData(String string, String string2) {
        return this.codeLoader.getCodeData(string, string2);
    }

    public void makeGUIInfos(UserInfo userInfo) {
        Object object;
        GUIData[] gUIDataArray = this.guiLoader.getAllData();
        HashMap<String, GUIInfo> hashMap = new HashMap<String, GUIInfo>();
        HashSet<String> hashSet = new HashSet<String>();
        for (GUIData object22 : gUIDataArray) {
            Object object2;
            int n = userInfo.getAccessBitMode(object22.getRoleMode());
            if (n > 0) {
                object2 = object22.getGuiKey();
                object = this.labelLoader.getLabelData(object22.getLabelClm());
                hashMap.put((String)object2, new GUIInfo(object22, (LabelData)object, (byte)n));
                continue;
            }
            object2 = object22.getAddress();
            if (((String)object2).indexOf(47) >= 0) continue;
            hashSet.add((String)object2);
        }
        hashMap.forEach((string, gUIInfo) -> hashSet.remove(gUIInfo.getAddress()));
        Object[] objectArray = hashMap.values().toArray(new GUIInfo[hashMap.size()]);
        Arrays.sort(objectArray);
        LinkedHashMap<String, GUIInfo> linkedHashMap = new LinkedHashMap<String, GUIInfo>();
        for (Object object2 : objectArray) {
            object = ((GUIInfo)object2).getKey();
            linkedHashMap.put((String)object, (GUIInfo)object2);
        }
        userInfo.setGUIMap(linkedHashMap, hashSet);
    }

    public Map<String, LabelData> getLabelMap(String string, String string2) {
        return this.labelLoader.getLabelMap(string, string2);
    }

    public void clear(String string) {
        if (string != null) {
            this.columnLoader.clear(string);
            this.codeLoader.clear(string);
            this.labelLoader.clear(string);
            this.columnPool.remove(string);
        }
    }

    public void guiClear() {
        GUIData[] gUIDataArray = this.guiLoader.getAllData();
        for (int i = 0; i < gUIDataArray.length; ++i) {
            String string = gUIDataArray[i].getGuiKey();
            this.labelLoader.clear(string);
        }
        this.codeLoader.clear("CLASSIFY");
        this.guiLoader.clear();
    }

    public void clear() {
        this.columnLoader.clear();
        this.codeLoader.clear();
        this.labelLoader.clear();
        this.guiLoader.clear();
        this.columnPool.clear();
    }
}

