<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
			 omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="TBLSYU"    select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />
  <xsl:param name="DYSET"     select="" />

  <xsl:param name="row_header" >
	<SYSTEM_ID	><xsl:value-of select="$SYSTEM_ID"	/></SYSTEM_ID>
	<TBLSYU		><xsl:value-of select="$TBLSYU"		/></TBLSYU>
	<ADDRESS	><xsl:value-of select="$ADDRESS"	/></ADDRESS>
	<FILENAME	><xsl:value-of select="$FILENAME"	/></FILENAME>
	<FILEPATH	><xsl:value-of select="$FILEPATH"	/></FILEPATH>
	<MODIFIED	><xsl:value-of select="$MODIFIED"	/></MODIFIED>
	<DYSET		><xsl:value-of select="$DYSET"		/></DYSET>
	<PGSET		>DOC18</PGSET>
  </xsl:param>

  <xsl:template match="jsp:root" >
	<xsl:if test="(number(@version) &lt; 2.0)" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >ERROR01</MSGCD>
		<MSGTXT >jsp:root タグのversion属性は、2.0 以上を指定してください。(Tomcat5=2.0,Tomcat6=2.1,Tomcat7=2.2,Tomcat8=2.3,Tomcat9=2.3)</MSGTXT>
		<TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
	</xsl:if>

	<xsl:apply-templates mode="html4" select="//s | //u" />

	<xsl:apply-templates mode="global" select="//*[@contextmenu] | //*[@dropzone]" />

	<xsl:apply-templates mode="event" select="//*[@ondragexit] | //*[@onloadend] | //*[@onmousewheel] | //*[@onshow]" />

	<!-- 8.1.2.1 (2022/03/25) HTML5 で廃止されたﾀｸﾞ -->
	<xsl:apply-templates mode="html5" select="
		//acronym | //applet | //basefont | //bgsound | //big | //blink | //center |
		//dir | //font | //isindex | //marquee | //nobr | //noembed | //strike | //tt | //param
	" />

	<!-- 8.1.2.1 (2022/03/25) HTML5 で廃止された属性 -->
	<!-- 8.4.1.1 (2023/02/17) jaxp0801002 ｴﾗｰになるので、分割する -->
	<xsl:apply-templates mode="html5" select="
		//a[@charset or @shape or @coords or @name or @rev] |
		//area[@nohref] |
		//audio[@mediagroup] |
		//body[@background or @bgcolor or @text or @link or @vlink or @alink] |
		//button[@menu] |
		//br[@clear] |
		//caption[@align] |
		//col[@width or @align or @valign or @char or @charoff] |
		//colgroup[@width or @align or @valign or @char or @charoff] |
		//div[@align] |
		//dl[@compact] |
		//form[@accept] |
		//h1[@align] |
		//h2[@align] |
		//h3[@align] |
		//h4[@align] |
		//h5[@align] |
		//h6[@align] |
		//head[@profile]
	" />

	<!-- 8.4.1.1 (2023/02/17) jaxp0801002 ｴﾗｰになるので、分割する -->
	<xsl:apply-templates mode="html5" select="
		//hr[@size or @width or @align or @noshade] |
		//html[@version] |
		//iframe[@longdesc or @scrolling or @frameborder or @marginwidth or @marginheight or @allowusermedia or @align] |
		//img[@longdesc or @name or @align or @border or @hspace or @vspace] |
		//input[@align or @usemap or @ismap] |
		//legend[@align] |
		//li[@type] |
		//link[@charset or @rev or @target] |
		//menu[@compact] |
		//meta[@scheme] |
		//object[@classid or @codetype or @archive or @codebase or @standby or @declare or @align or @border or @typemustmatch or @usemap or @hspace or @vspace] |
		//ol[@compact] |
		//p[@align] |
		//param[@valuetype or @type] |
		//pre[@width] |
		//script[@ charset or @language] |
		//style[@type] |
		//table[@summary or @width or @frame or @rules or @sortable or @border or @cellspacing or @cellpadding or @align or @bgcolor] |
		//tbody[@align or @valign or @char or @charoff] |
		//td[@align or @valign or @char or @charoff or @abbr or @scope or @axis or @width or @height or @bgcolor or @nowrap] |
		//tfoot[@align or @valign or @char or @charoff] |
		//th[@align or @valign or @char or @charoff or @axis or @sorted or @width or @height or @bgcolor or @nowrap] |
		//thead[@align or @valign or @char or @charoff] |
		//tr[@align or @valign or @char or @charoff or @bgcolor] |
		//ul[@type or @compact] |
		//video[@mediagroup]
	" />
  </xsl:template>

  <xsl:template mode="html4" match="s | u" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >HTML4 WORNING1</MSGCD>
		<MSGTXT >HTML4 非推奨要素</MSGTXT>
		<TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
  </xsl:template>

  <xsl:template mode="global" match="*[@contextmenu] | *[@dropzone]" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >GLOBAL WORNING1</MSGCD>
		<MSGTXT >このグローバル属性は廃止されました。
			<xsl:for-each select="@*">
			 <xsl:if test="( contains('contextmenu,dropzone,', concat(name(),',')) )" >
			  <xsl:value-of select="name()"/>="<xsl:value-of select="."/>"
			 </xsl:if>
			</xsl:for-each>
		</MSGTXT>
		<TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
  </xsl:template>

  <xsl:template mode="event" match="*[@ondragexit] | *[@onloadend] | *[@onmousewheel] | *[@onshow]" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >EVENT WORNING1</MSGCD>
		<MSGTXT >このイベントハンドラ属性は廃止されました。
			<xsl:for-each select="@*">
			 <xsl:if test="( contains('ondragexit,onloadend,onmousewheel,onshow,', concat(name(),',')) )" >
			  <xsl:value-of select="name()"/>="<xsl:value-of select="."/>"
			 </xsl:if>
			</xsl:for-each>
		</MSGTXT>
		<TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
  </xsl:template>

<!-- 8.1.2.1 (2022/03/25) HTML5 で廃止されたﾀｸﾞ -->
  <xsl:template mode="html5" match="
		acronym | applet | basefont | bgsound | big | blink | center |
		dir | font | isindex | marquee | nobr | noembed | strike | tt | param
  " >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >HTML5 WORNING1</MSGCD>
		<MSGTXT >HTML5 廃止要素</MSGTXT>
		<TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
  </xsl:template>

<!-- 8.1.2.1 (2022/03/25) HTML5 で廃止された属性 -->
<!-- 8.4.1.1 (2023/02/17) jaxp0801002 ｴﾗｰになるので、分割する -->
  <xsl:template mode="html5" match="
		a[@charset or @shape or @coords or @name or @rev] |
		area[@nohref] |
		audio[@mediagroup] |
		body[@background or @bgcolor or @text or @link or @vlink or @alink] |
		button[@menu] |
		br[@clear] |
		caption[@align] |
		col[@width or @align or @valign or @char or @charoff] |
		colgroup[@width or @align or @valign or @char or @charoff] |
		div[@align] |
		dl[@compact] |
		form[@accept] |
		h1[@align] |
		h2[@align] |
		h3[@align] |
		h4[@align] |
		h5[@align] |
		h6[@align] |
		head[@profile]
  " >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<xsl:variable name="NAME" select="name()" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >HTML5 WORNING2</MSGCD>
		<!-- 8.4.1.1 (2023/02/17) jaxp0801002 ｴﾗｰになるので、分割する -->
		<MSGTXT >HTML5 で廃止属性
			<xsl:for-each select="@*">
			 <xsl:if test="
	( $NAME='a' and contains('charset,shape,coords,name,rev,', concat(name(),',')) ) or
	( $NAME='area' and contains('nohref,', concat(name(),',')) ) or
	( $NAME='audio' and contains('mediagroup,', concat(name(),',')) ) or
	( $NAME='body' and contains('background,bgcolor,text,link,vlink,alink,', concat(name(),',')) ) or
	( $NAME='button' and contains('menu,', concat(name(),',')) ) or
	( $NAME='br' and contains('clear,', concat(name(),',')) ) or
	( $NAME='caption' and contains('align,', concat(name(),',')) ) or
	( $NAME='col' and contains('width,align,valign,char,charoff,', concat(name(),',')) ) or
	( $NAME='colgroup' and contains('width,align,valign,char,charoff,', concat(name(),',')) ) or
	( $NAME='div' and contains('align,', concat(name(),',')) ) or
	( $NAME='dl' and contains('compact,', concat(name(),',')) ) or
	( $NAME='form' and contains('accept,', concat(name(),',')) ) or
	( $NAME='h1' and contains('align,', concat(name(),',')) ) or
	( $NAME='h2' and contains('align,', concat(name(),',')) ) or
	( $NAME='h3' and contains('align,', concat(name(),',')) ) or
	( $NAME='h4' and contains('align,', concat(name(),',')) ) or
	( $NAME='h5' and contains('align,', concat(name(),',')) ) or
	( $NAME='h6' and contains('align,', concat(name(),',')) ) or
	( $NAME='head' and contains('profile,', concat(name(),',')) )
			" >
			  <xsl:value-of select="name()"/>="<xsl:value-of select="."/>"
			 </xsl:if>
			</xsl:for-each>
		</MSGTXT>
		<TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
  </xsl:template>

<!-- 8.1.2.1 (2022/03/25) HTML5 で廃止された属性 -->
<!-- 8.4.1.1 (2023/02/17) jaxp0801002 ｴﾗｰになるので、分割する -->
  <xsl:template mode="html5" match="
		hr[@size or @width or @align or @noshade] |
		html[@version] |
		iframe[@longdesc or @scrolling or @frameborder or @marginwidth or @marginheight or @allowusermedia or @align] |
		img[@longdesc or @name or @align or @border or @hspace or @vspace] |
		input[@align or @usemap or @ismap] |
		legend[@align] |
		li[@type] |
		link[@charset or @rev or @target] |
		menu[@compact] |
		meta[@scheme] |
		object[@classid or @codetype or @archive or @codebase or @standby or @declare or @align or @border or @typemustmatch or @usemap or @hspace or @vspace] |
		ol[@compact] |
		p[@align] |
		param[@valuetype or @type] |
		pre[@width] |
		script[@ charset or @language] |
		style[@type] |
		table[@summary or @width or @frame or @rules or @sortable or @border or @cellspacing or @cellpadding or @align or @bgcolor] |
		tbody[@align or @valign or @char or @charoff] |
		td[@align or @valign or @char or @charoff or @abbr or @scope or @axis or @width or @height or @bgcolor or @nowrap] |
		tfoot[@align or @valign or @char or @charoff] |
		th[@align or @valign or @char or @charoff or @axis or @sorted or @width or @height or @bgcolor or @nowrap] |
		thead[@align or @valign or @char or @charoff] |
		tr[@align or @valign or @char or @charoff or @bgcolor] |
		ul[@type or @compact] |
		video[@mediagroup]
  " >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<xsl:variable name="NAME" select="name()" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >HTML5 WORNING3</MSGCD>
	<!-- 8.4.1.1 (2023/02/17) jaxp0801002 ｴﾗｰになるので、分割する -->
		<MSGTXT >HTML5 で廃止属性
			<xsl:for-each select="@*">
			 <xsl:if test="
	( $NAME='hr' and contains('size,width,align,noshade,', concat(name(),',')) ) or
	( $NAME='html' and contains('version,', concat(name(),',')) ) or
	( $NAME='iframe' and contains('longdesc,scrolling,frameborder,marginwidth,marginheight,allowusermedia,align,', concat(name(),',')) ) or
	( $NAME='img' and contains('longdesc,name,align,border,hspace,vspace,', concat(name(),',')) ) or
	( $NAME='input' and contains('align,usemap,ismap,', concat(name(),',')) ) or
	( $NAME='legend' and contains('align,', concat(name(),',')) ) or
	( $NAME='li' and contains('type,', concat(name(),',')) ) or
	( $NAME='link' and contains('charset,rev,target,', concat(name(),',')) ) or
	( $NAME='menu' and contains('compact,', concat(name(),',')) ) or
	( $NAME='meta' and contains('scheme,', concat(name(),',')) ) or
	( $NAME='object' and contains('classid,codetype,archive,codebase,standby,declare,align,border,typemustmatch,usemap,hspace,vspace,', concat(name(),',')) ) or
	( $NAME='ol' and contains('compact,', concat(name(),',')) ) or
	( $NAME='p' and contains('align,', concat(name(),',')) ) or
	( $NAME='param' and contains('valuetype,type,', concat(name(),',')) ) or
	( $NAME='pre' and contains('width,', concat(name(),',')) ) or
	( $NAME='script' and contains(' charset,language,', concat(name(),',')) ) or
	( $NAME='style' and contains('type,', concat(name(),',')) ) or
	( $NAME='table' and contains('summary,width,frame,rules,sortable,border,cellspacing,cellpadding,align,bgcolor,', concat(name(),',')) ) or
	( $NAME='tbody' and contains('align,valign,char,charoff,', concat(name(),',')) ) or
	( $NAME='td' and contains('align,valign,char,charoff,abbr,scope,axis,width,height,bgcolor,nowrap,', concat(name(),',')) ) or
	( $NAME='tfoot' and contains('align,valign,char,charoff,', concat(name(),',')) ) or
	( $NAME='th' and contains('align,valign,char,charoff,axis,sorted,width,height,bgcolor,nowrap,', concat(name(),',')) ) or
	( $NAME='thead' and contains('align,valign,char,charoff,', concat(name(),',')) ) or
	( $NAME='tr' and contains('align,valign,char,charoff,bgcolor,', concat(name(),',')) ) or
	( $NAME='ul' and contains('type,compact,', concat(name(),',')) ) or
	( $NAME='video' and contains('mediagroup,', concat(name(),',')) )
			" >
			  <xsl:value-of select="name()"/>="<xsl:value-of select="."/>"
			 </xsl:if>
			</xsl:for-each>
		</MSGTXT>
		<TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
  </xsl:template>

</xsl:stylesheet>
